<?php 

class Consultxp_Custom_Sidebars {
	
	private static $_instance = null;

	public function __construct() {
		add_action( 'admin_menu', array( $this, 'consultxp_addon_admin_menu' ) );	
		add_action( 'wp_ajax_consultxp-custom-sidebar-export', array( $this, 'consultxp_custom_sidebar_export' ) );
	}
	
	public static function consultxp_addon_admin_menu(){
		add_submenu_page( 
			'consultxp-welcome', 
			esc_html__( 'Custom Sidebars', 'consultxp-addon' ),
			esc_html__( 'Custom Sidebars', 'consultxp-addon' ), 
			'manage_options', 
			'consultxp-sidebars', 
			array( 'Consultxp_Custom_Sidebars', 'consultxp_sidebar_admin_page' )
		);
	}
	
	public static function consultxp_sidebar_admin_page(){
		$consultxp_theme = wp_get_theme();
	?>
		<div class="consultxp-settings-wrap">
			<div class="consultxp-header-bar">
				<div class="consultxp-header-left">
					<div class="consultxp-admin-logo-inline">
						<img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/brand-logo.png' ); ?>" alt="consultxp-logo">
					</div><!-- .consultxp-admin-logo-inline -->
					<h2 class="title"><?php esc_html_e( 'Consultxp Custom Sidebars', 'consultxp-addon' ); ?><span class="consultxp-version"><?php echo esc_attr( $consultxp_theme->get( 'Version' ) ); ?></span></h2>
					<div class="nav-theme-options">
						<a href="<?php echo admin_url('admin.php?page=consultxp-options'); ?>"><span class="dashicons dashicons-admin-tools"></span>Theme Options</a>
						<a href="<?php echo admin_url('admin.php?page=consultxp-plugins')?>"><span class="dashicons dashicons-admin-plugins"></span>Plugins</a>
						<div class="support-dropdown">
							<a href="#" class="dropdown-toggle"><span class="dashicons dashicons-buddicons-buddypress-logo"></span>Support</a>
							<div class="dropdown-content">
								<a href="https://zozothemes.com/knowledge-base/" target="_blank"><span class="dashicons dashicons-tickets-alt"></span>Ticket</a>
								<a href="https://zozothemes.com/knowledge-base/" target="_blank"><span class="dashicons dashicons-video-alt3"></span>Video</a>
								<a href="https://docs.zozothemes.com/consultxp/" target="_blank"><span class="dashicons dashicons-text-page"></span>Documentation</a>
								<a href="https://zozothemes.com/knowledge-base/" target="_blank"><span class="dashicons dashicons-book-alt"></span>Knowledge Base</a>
							</div>
						</div>
						<a href="https://zozothemes.com/forum/" target="_blank"><span class="dashicons dashicons-format-chat"></span>Forum</a>
					</div>
				</div><!-- .consultxp-header-left -->
				<div class="consultxp-header-right">
					<a href="<?php echo esc_url( 'https://wordpress.zozothemes.com/consultxp/' ); ?>" target="_blank" class="button consultxp-btn"><?php esc_html_e( 'Live Demo', 'consultxp-addon' ); ?></a>
				</div><!-- .consultxp-header-right -->
			</div><!-- .consultxp-header-bar -->
			
			<div class="consultxp-settings-tabs consultxp-custom-sidebar-wrap">
				<div id="consultxp-general" class="consultxp-settings-tab active">
					<div class="container">
						<div class="row">
							<div class="col-4">
								<div class="media admin-box">
									<div class="admin-box-icon mr-3">
										<span class="dashicons dashicons-welcome-widgets-menus"></span>								
									</div>
									<div class="media-body admin-box-info">
										<h3 class="admin-box-title"><?php esc_html_e( 'Add New Sidebar', 'consultxp-addon' ); ?></h3>
										<div class="admin-box-content">
											<?php esc_html_e( 'You can add new custom sidebar here. Also we give you option to remove or delete custom sidebars.', 'consultxp-addon' ); ?>
										</div>
										<?php
											$sidebars = '';
											$sidebar_opt_name = 'consultxp_custom_sidebars';
											$sidebars = get_option( $sidebar_opt_name );
											
											if ( isset( $_POST['consultxp_custom_sidebar_nonce'] ) && wp_verify_nonce( $_POST['consultxp_custom_sidebar_nonce'], 'consultxp-()@)(*^#@!' ) 
											) {
												if (isset($_POST['consultxp_sidebar_name']) && !empty($_POST['consultxp_sidebar_name'])) {
													$sidebar_name = sanitize_text_field($_POST['consultxp_sidebar_name']); // Sanitize
													$sidebar_slug = sanitize_title($sidebar_name);

													if (!empty($sidebars)) {
														$sidebars[$sidebar_slug] = $sidebar_name;
													}else{
														$sidebars = array( $sidebar_slug => $sidebar_name );
													}	
													update_option( 'consultxp_custom_sidebars', $sidebars );
												}
											}
											
											if ( isset( $_POST['consultxp_custom_sidebar_remove_nonce'] ) && wp_verify_nonce( $_POST['consultxp_custom_sidebar_remove_nonce'], 'consultxp-()I*^*^%@!' ) 
											) {
												$remove_sidebar = isset($_POST['consultxp_sidebar_remove_name']) && !empty($_POST['consultxp_sidebar_remove_name']) ? sanitize_text_field($_POST['consultxp_sidebar_remove_name']) : ''; // Sanitize
												unset($sidebars[$remove_sidebar]);
												update_option('consultxp_custom_sidebars', $sidebars);
												$sidebars = get_option($sidebar_opt_name);
											}
											
										?>
										<form action="" method="post" enctype="multipart/form-data">
											<?php wp_nonce_field( 'consultxp-()@)(*^#@!', 'consultxp_custom_sidebar_nonce' ); ?>
											<input type="input" name="consultxp_sidebar_name" class="custom-sidebar-name" value="" />
										</form>
										<a href="#" class="consultxp-btn btn-default custom-sidebar-create"><?php esc_html_e( 'Add Sidebar', 'consultxp-addon' ); ?></a>
 										<a href="widgets.php" class="consultxp-btn btn-default custom-view-sidebar"><?php esc_html_e( 'View Sidebar', 'consultxp-addon' ); ?></a>
									</div>
								</div>
							</div>
							<div class="col-8">
								<div class="admin-box">
									<h3 class="admin-box-title sidebar-title"><?php esc_html_e( 'Custom Sidebars', 'consultxp-addon' ); ?></h3>
									<?php if( !empty( $sidebars ) ): ?>
									<form action="" method="post" enctype="multipart/form-data">
									<?php wp_nonce_field( 'consultxp-()I*^*^%@!', 'consultxp_custom_sidebar_remove_nonce' ); ?>
									<input type="hidden" name="consultxp_sidebar_remove_name" id="consultxp-sidebar-remove-name" value="" />									
									<table class="consultxp-admin-table consultxp-custom-sidebar-table">
										<thead>
											<tr>
												<td><?php esc_html_e( 'Name', 'consultxp-addon' ); ?></td>
												<td><?php esc_html_e( 'Slug', 'consultxp-addon' ); ?></td>
												<td><?php esc_html_e( 'Delete', 'consultxp-addon' ); ?></td>
											</tr>
										</thead>
										<tbody>
										<?php
											foreach( $sidebars as $sidebar_slug => $sidebar_name ){
											?>
												<tr>
													<td><?php echo esc_html( $sidebar_name ); ?></td>
													<td><?php echo esc_html( $sidebar_slug ); ?></td>
													<td class="text-center"><a href="#" data-sidebar="<?php echo esc_attr( $sidebar_slug ); ?>" class="consultxp-sidebar-remove"><span class="dashicons dashicons-trash"></span></a></td>
												</tr>
											<?php
											}
										?>
										</tbody>
									</table>
									</form>
									<a href="#" class="consultxp-btn btn-default custom-sidebar-export"><?php esc_html_e( 'Export as JSON', 'consultxp-addon' ); ?></a>
									<?php else: ?>
										<p><?php esc_html_e( 'Sorry! No custom sidebars available.', 'consultxp-addon' ); ?></p>
									<?php endif; ?>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			
		</div>
	<?php
	}
		
	public static function rmdir_recurse($path) {
		$path = rtrim($path, '/').'/';
		$handle = opendir($path);
		while(false !== ($file = readdir($handle))) {
			if($file != '.' and $file != '..' ) {
				$fullpath = $path.$file;
				if(is_dir($fullpath)) self::rmdir_recurse($fullpath); else unlink($fullpath);
			}
		}
		closedir($handle);
		rmdir($path);
	}	
	
	public static function consultxp_custom_sidebar_export(){
		$nonce = $_POST['nonce'];  
		if ( ! wp_verify_nonce( $nonce, 'consultxp-()@)(*^#@!' ) )
			wp_die ( esc_html__( 'Not Ok', 'consultxp-addon' ) );
		
		$sidebars = get_option( 'consultxp_custom_sidebars' );
		if( !empty( $sidebars ) ){
			//wp_send_json( $sidebars );
			echo json_encode( $sidebars );
		}else{
			echo '';
		}	
		wp_die();
	}
	
	public static function get_instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}

} Consultxp_Custom_Sidebars::get_instance();