<?php

class Consultxp_Custom_Menu {
	/*--------------------------------------------*
	 * Constructor
	 *--------------------------------------------*/
	/**
	 * Initializes the plugin by setting localization, filters, and administration functions.
	 */
	 
	private $mega_fields;
	 
	function __construct() {
		// load the plugin translation files
		
		add_action( 'admin_enqueue_scripts', array( $this, 'consultxp_menu_enqueue_scripts' ) );
		
		// add custom menu fields to menu
		add_filter( 'wp_setup_nav_menu_item', array( $this, 'consultxp_add_custom_nav_fields' ) );
		// save menu custom fields
		add_action( 'wp_update_nav_menu_item', array( $this, 'consultxp_update_custom_nav_fields'), 10, 3 );
		
		// edit menu walker
		add_filter( 'wp_edit_nav_menu_walker', array( $this, 'consultxp_edit_walker'), 10, 2 );
		
	} // end constructor
	
	
	/**
	 * Register Megamenu stylesheets and scripts		
	 */
	function consultxp_menu_enqueue_scripts( $hook ) {
		// style/scripts
		if ( 'nav-menus.php' == $hook ) {
			wp_enqueue_style( 'magnific-popup', CONSULTXP_ADDON_URL . 'admin/extension/mega-menu/css/magnific-popup.css', '1.1.0');
			wp_enqueue_style( 'consultxp-megamenu', CONSULTXP_ADDON_URL . 'admin/extension/mega-menu/css/megamenu.css', '1.0');
			wp_enqueue_style( 'themify-icons', CONSULTXP_ADDON_URL . 'assets/css/themify-icons.css', '1.0');
			wp_enqueue_script( 'magnific-popup', CONSULTXP_ADDON_URL . 'admin/extension/mega-menu/js/jquery.magnific-popup.min.js' , array( 'jquery' ), '1.1.0', true );
			wp_enqueue_script( 'consultxp-megamenu', CONSULTXP_ADDON_URL . 'admin/extension/mega-menu/js/megamenu.js' , array( 'jquery' ), '1.0', true );

			$menu_icons = $this->consultxp_menu_ti_icons();
			
			wp_localize_script( 'consultxp-megamenu', 'consultxp_object', array( 'icons' => $menu_icons ) );

			do_action( 'consultxp_connect_fonts_css_menu_page' );

			add_action( 'admin_footer', array( $this, 'admin_footer_custom' ), 10 );
		}
	}

	public function admin_footer_custom(){
	?>
	<form id="consultxp-general-settings-form" class="mfp-hide white-popup-block">
		<h1><?php esc_html_e( 'Consultxp General Menu Item Settings', 'consultxp-addon' ); ?></h1>
		<fieldset>			
			<p class="consultxp-menu-icon-wrap">
				<label><?php esc_html_e( 'Choose Menu Item Icon', 'consultxp-addon' ); ?></label>
				<select class="consultxp-menu-icons">
					<option value=""><?php esc_html_e( 'None', 'consultxp-addon' ); ?></option>
				</select>
			</p>
			<p class="consultxp-megamenu-wrap">
				<label><?php esc_html_e( 'Enable Megamenu', 'consultxp-addon' ); ?> <input type="checkbox" class="consultxp-megamenu-option"></label>
			</p>
			<p class="consultxp-megamenu-col-wrap">
				<label><?php esc_html_e( 'Megamenu Column', 'consultxp-addon' ); ?></label>
				<select class="consultxp-megamenu-col">
					<option value="12"><?php esc_html_e( '1/1', 'consultxp-addon' ); ?></option>
					<option value="6"><?php esc_html_e( '1/2', 'consultxp-addon' ); ?></option>
					<option value="4"><?php esc_html_e( '1/3', 'consultxp-addon' ); ?></option>
					<option value="3"><?php esc_html_e( '1/4', 'consultxp-addon' ); ?></option>
					<option value="2"><?php esc_html_e( '1/6', 'consultxp-addon' ); ?></option>
				</select>
			</p>
			<p class="consultxp-megamenu-widget-wrap">
				<label><?php esc_html_e( 'Megamenu Item Widget', 'consultxp-addon' ); ?></label>
				<select class="consultxp-megamenu-widget">
					<option value=""><?php esc_html_e( 'Choose Widget', 'consultxp-addon' ); ?></option>
					<?php foreach ( $GLOBALS['wp_registered_sidebars'] as $sidebar ) { ?>
							<option value="<?php echo ucwords( $sidebar['id'] ); ?>">
							<?php echo ucwords( $sidebar['name'] ); ?>
							</option>
					<?php } ?>
				</select>
			</p>
		</fieldset>
	</form>
	<?php
	}

	public function consultxp_menu_ti_icons(){
		$pattern = '/\.(ti-(?:\w+(?:-)?)+):before\s+{\s*content:\s*"(.+)";\s+}/';
		$icon_css_path = CONSULTXP_ADDON_URL . 'assets/css/themify-icons.css';  
		$file = '';
		$response = wp_remote_get( $icon_css_path );
		if( is_array($response) ) {
			$file = $response['body']; // use the content
		}
		preg_match_all($pattern, $file, $str, PREG_SET_ORDER);
		return $str;
	}
	
	/**
	 * Add custom fields to $item nav object
	 * in order to be used in custom Walker
	 *
	 * @access      public
	 * @since       1.0 
	 * @return      void
	*/
	function consultxp_add_custom_nav_fields( $menu_item ) {
	
		$menu_item->consultxpmenu = get_post_meta( $menu_item->ID, '_menu_item_consultxpmenu', true );	
		$menu_item->megatithide = get_post_meta( $menu_item->ID, '_menu_item_megatithide', true );
		$menu_item->megacategory = get_post_meta( $menu_item->ID, '_menu_item_megacategory', true );
		$menu_item->megarow = get_post_meta( $menu_item->ID, '_menu_item_megarow', true );
	    return $menu_item;
	    
	}
	
	/**
	 * Save menu custom fields
	 *
	 * @access      public
	 * @since       1.0 
	 * @return      void
	*/
	function consultxp_update_custom_nav_fields( $menu_id, $menu_item_db_id, $args ) {
	
	    // Check if element is properly sent
		$opt_value = isset( $_REQUEST['menu-item-consultxpmenu'][$menu_item_db_id] ) ? $_REQUEST['menu-item-consultxpmenu'][$menu_item_db_id] : '' ;
		$hide_title = isset( $_REQUEST['menu-item-megatithide'][$menu_item_db_id] ) ? $_REQUEST['menu-item-megatithide'][$menu_item_db_id] : '';
		$megamenu_category = isset( $_REQUEST['menu-item-megacategory'][$menu_item_db_id] ) ? $_REQUEST['menu-item-megacategory'][$menu_item_db_id] : '' ;
		$megamenu_rows = isset( $_REQUEST['menu-item-megarow'][$menu_item_db_id] ) ? $_REQUEST['menu-item-megarow'][$menu_item_db_id] : '' ;

		update_post_meta( $menu_item_db_id, '_menu_item_consultxpmenu', $opt_value );
		update_post_meta( $menu_item_db_id, '_menu_item_megatithide', $hide_title );
		update_post_meta( $menu_item_db_id, '_menu_item_megacategory', $megamenu_category );
		update_post_meta( $menu_item_db_id, '_menu_item_megarow', $megamenu_rows );
    
	}
	
	/**
	 * Define new Walker edit
	 *
	 * @access      public
	 * @since       1.0 
	 * @return      void
	*/
	function consultxp_edit_walker($walker,$menu_id) {
	
	    require_once ( CONSULTXP_ADDON_DIR . 'admin/extension/mega-menu/class-walker-nav-menu-edit.php' );
		require_once( CONSULTXP_ADDON_DIR . 'admin/extension/mega-menu/filter-walker.php' );
		return 'Consultxp_Walker_Nav_Menu_Edit';
	    
	}
	
}
$consultxp_cm = new Consultxp_Custom_Menu();