(function ($) {

    "use strict";

    $(document).ready(function () {
        $(document).on("click", ".mega-nav-btn", function (e) {
            e.preventDefault();
            console.log("started again for: " + $(this).attr("data-page"));
            if ($(this).hasClass("disabled")) return;

            var button = $(this);
            var category = button.data("category");
            var page = button.attr("data-page");
            var wrapper = button.data("wrapper");
            var container = button.closest(".mega-menu-posts-container");
			var wrapper_container = container.find(".mega-posts-grid." + wrapper);
            var prevBtn = container.find(".mega-prev-btn");
            var nextBtn = container.find(".mega-next-btn");

            $.ajax({
                url: mega_menu_ajax.ajax_url,
                type: "POST",
                data: {
                    action: "load_mega_menu_posts",
                    category_id: category,
                    page: page,
                    wrapper_class: wrapper,
                    nonce: mega_menu_ajax.nonce,
                },
				success: function( response ) {
					wrapper_container.html( response.posts );
					if( response.current_page == 1 ) {
                        prevBtn.addClass("disabled");
                    }
					else {
                        prevBtn.removeClass("disabled");
                        prevBtn.attr('data-page', response.current_page - 1);
                    }
					if( response.current_page == response.total_pages ) {
                        nextBtn.addClass("disabled");
                    } else {
                        nextBtn.removeClass("disabled");
                        nextBtn.attr('data-page', response.current_page + 1);
                    }
				},
				error: function( xhr, status, error ) {
					console.log( xhr );
				}
            });
        });
    });
    
})(jQuery);