<?php

Consultxp_Options::$consultxp_options = get_post_meta( get_the_ID(), 'consultxp_post_meta', true );

// General
Consultxp_Options::consultxp_set_section( array(
	'title'      => esc_html__( 'General', 'consultxp-addon' ),
	'id'         => 'general-tab',
	'config_id'  => '',
) );

Consultxp_Options::consultxp_set_sub_section( array(
	'title'      => esc_html__( 'Site General', 'consultxp-addon' ),
	'id'         => 'site-general',
	'config_id'  => '',
	'fields'	 => array(
		array(
			'id'			=> 'general-chk',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Site General Settings', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Choose custom to edit site general settings options.', 'consultxp-addon' ),
			'choices'		=> array(
				'default'	=> esc_html__( 'Default', 'consultxp-addon' ),
				'custom'	=> esc_html__( 'Custom', 'consultxp-addon' )
			),
			'default'		=> 'default'
		),
		array(
			'id'			=> 'site-layout',
			'type'			=> 'radioimage',
			'title'			=> esc_html__( 'Site Layout', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Choose site layout either wide or boxed.', 'consultxp-addon' ),
			'items'		=> array(
				'wide' => array(
					'title' => esc_html__( 'Wide', 'consultxp-addon' ),
					'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/header/header-wide.png'
				),
				'boxed' => array(
					'title' => esc_html__( 'Boxed', 'consultxp-addon' ),
					'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/header/header-boxed.png'
				),
				'wider' => array(
					'title' => esc_html__( 'Wider', 'consultxp-addon' ),
					'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/header/header-wider.png'
				)
			),
			'default' => 'wide',
			'required'		=> array( 'general-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'content-padding',
			'type'			=> 'dimension',
			'title'			=> esc_html__( 'Content Padding', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Assign content padding. If need no padding means just leave this empty. Example 10 10 10 10', 'consultxp-addon' ),
			'default'		=> '',
			'required'		=> array( 'general-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-slider',
			'type'			=> 'textarea',
			'title'			=> esc_html__( 'Header Slider', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Enter shortcode for header slider.', 'consultxp-addon' ),
			'default'		=> '',
		)		
	)
) );
Consultxp_Options::consultxp_set_sub_section( array(
	'title'      => esc_html__( 'Logo Settings', 'consultxp-addon' ),
	'id'         => 'site-logo',
	'config_id'  => '',
	'fields'	 => array(
		array(
			'id'			=> 'logo-chk',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Site General Settings', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Choose custom to edit site logo settings options.', 'consultxp-addon' ),
			'choices'		=> array(
				'default'	=> esc_html__( 'Default', 'consultxp-addon' ),
				'custom'	=> esc_html__( 'Custom', 'consultxp-addon' )
			),
			'default'		=> 'default'
		),
		array(
			'id'			=> 'logo-settings',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Logo Settings', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is settings for site logo.', 'consultxp-addon' ),
			'seperator'		=> 'after',
			'required'		=> array( 'logo-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'site-logo',
			'type'			=> 'image',
			'title'			=> esc_html__( 'Default Logo', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Choose site logo image.', 'consultxp-addon' ),
			'default'		=> '',
			'required'		=> array( 'logo-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'site-logo-width',
			'type'			=> 'hw',
			'title'			=> esc_html__( 'Site Logo Maximum Width', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is maximum width of logo. if you want original width leave this field empty.', 'consultxp-addon' ),
			'only_dimension' => 'width',
			'required'		=> array( 'logo-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'site-logo-desc',
			'type'			=> 'toggle',
			'title'			=> esc_html__( 'Enable Site Logo Description', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is logo description options for this site. You can enable or disable.', 'consultxp-addon' ),
			'required'		=> array( 'logo-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'sticky-logo',
			'type'			=> 'image',
			'title'			=> esc_html__( 'Sticky Logo', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Choose site sticky logo image.', 'consultxp-addon' ),
			'default'		=> '',
			'required'		=> array( 'logo-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'sticky-logo-width',
			'type'			=> 'hw',
			'title'			=> esc_html__( 'Sticky Logo Maximum Width', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is maximum width of sticky logo. if you want original width leave this field empty.', 'consultxp-addon' ),
			'only_dimension' => 'width',
			'required'		=> array( 'logo-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'mobile-logo',
			'type'			=> 'image',
			'title'			=> esc_html__( 'Mobile Logo', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Choose site mobile logo image.', 'consultxp-addon' ),
			'default'		=> '',
			'required'		=> array( 'logo-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'mobile-logo-width',
			'type'			=> 'hw',
			'title'			=> esc_html__( 'Mobile Logo Maximum Width', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is maximum width of mobile logo. if you want original width leave this field empty.', 'consultxp-addon' ),
			'only_dimension' => 'width',
			'required'		=> array( 'logo-chk', '=', array( 'custom' ) )
		),
	)
) );

Consultxp_Options::consultxp_set_end_section( array(
	'id'		=> 'general-tab-end'	
));

$consultxp_menus = get_terms( 'nav_menu', array( 'hide_empty' => true ) );
$consultxp_nav_menus = array( "none" => esc_html__( "None", "consultxp-addon" ) );
foreach( $consultxp_menus as $menu ){
	$consultxp_nav_menus[$menu->slug] = $menu->name;
}

// Header
Consultxp_Options::consultxp_set_section( array(
	'title'      => esc_html__( 'Site Header', 'consultxp-addon' ),
	'id'         => 'header-tab',
	'config_id'  => '',
) );
Consultxp_Options::consultxp_set_sub_section( array(
	'title'      => esc_html__( 'General', 'consultxp-addon' ),
	'id'         => 'header-general',
	'fields'	 => array(
		array(
			'id'			=> 'header-chk',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Header Settings', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Choose custom to edit header settings options.', 'consultxp-addon' ),
			'choices'		=> array(
				'default'	=> esc_html__( 'Default', 'consultxp-addon' ),
				'custom'	=> esc_html__( 'Custom', 'consultxp-addon' )
			),
			'default'		=> 'default'
		),
		array(
			'id'			=> 'header-one-page-menu',
			'type'			=> 'select',
			'title'			=> esc_html__( 'One Page Menu', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Choose custom to edit header settings options.', 'consultxp-addon' ),
			'choices'		=> $consultxp_nav_menus,
			'default'		=> 'none'
		),
		array(
			'id'			=> 'header-layout',
			'type'			=> 'radioimage',
			'title'			=> esc_html__( 'Header Layout', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Choose header layout either wide or boxed.', 'consultxp-addon' ),
			'items'		=> array(
				'wide' => array(
					'title' => esc_html__( 'Wide', 'consultxp-addon' ),
					'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/header/header-wide.png'
				),
				'wider' => array(
					'title' => esc_html__( 'Wider', 'consultxp-addon' ),
					'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/header/header-wider.png'
				),
				'boxed' => array(
					'title' => esc_html__( 'Boxed', 'consultxp-addon' ),
					'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/header/header-boxed.png'
				)
			),
			'default' => 'wide',
			'required'		=> array( 'header-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-items',
			'type'			=> 'dragdrop',
			'title'			=> esc_html__( 'Header Bars', 'consultxp-addon' ),
			'description'	=> esc_html__( 'These are header items. Drag which items you want to display normal and sticky.', 'consultxp-addon' ),
			'default'		=> array(
				'normal' => array(
					'topbar' => esc_html__( 'Header Top', 'consultxp-addon' ),
					'logobar' => esc_html__( 'Header Middle', 'consultxp-addon' )
				),
				'sticky' => array(
					'navbar' => esc_html__( 'Header Bottom', 'consultxp-addon' )
				),
				'disabled' => array(
				)
			),
			'required'		=> array( 'header-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-absolute',
			'type'			=> 'toggle',
			'title'			=> esc_html__( 'Header Absolute', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Enable/Disable header absolute. Like floating on slider', 'consultxp-addon' ),
			'default'		=> false,
			'required'		=> array( 'header-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'search-type',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Search Toggle Modal', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Slect search box type', 'consultxp-addon' ),
			'choices'		=> array(
				'1'	=> esc_html__( 'Full Screen Search', 'consultxp-addon' ),
				'2' => esc_html__( 'Text Box Toggle Search', 'consultxp-addon' ),
				'3' => esc_html__( 'Full Bar Toggle Search', 'consultxp-addon' ),
				'4' => esc_html__( 'Bottom Seach Box Toggle', 'consultxp-addon' )
			),
			'default'		=> '1',
			'required'		=> array( 'header-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-style-label-field',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Styles', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Here you can set all the type of header styles.', 'consultxp-addon' ),
			'seperator'		=> 'before'
		),
		array(
			'id'			=> 'header-style-chk',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Header Style Settings', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Choose custom to edit header style settings options.', 'consultxp-addon' ),
			'choices'		=> array(
				'default'	=> esc_html__( 'Default', 'consultxp-addon' ),
				'custom'	=> esc_html__( 'Custom', 'consultxp-addon' )
			),
			'default'		=> 'default'
		),
		array(
			'id'			=> 'header-links-color',
			'type'			=> 'link',
			'title'			=> esc_html__( 'Header Link Color', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is link color setting for header', 'consultxp-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-dropdown-links-color',
			'type'			=> 'link',
			'title'			=> esc_html__( 'Header Dropdown Link Color', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is dropdown link color setting for header', 'consultxp-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-dropdown-fixed-links-color',
			'type'			=> 'link',
			'title'			=> esc_html__( 'Header Dropdown Link Color on Sticky', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is dropdown link color setting for header sticky', 'consultxp-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-background',
			'type'			=> 'background',
			'title'			=> esc_html__( 'Header Background Color', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is background setting for header', 'consultxp-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-border',
			'type'			=> 'border',
			'title'			=> esc_html__( 'Header Border', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is border setting for header', 'consultxp-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-padding',
			'type'			=> 'dimension',
			'title'			=> esc_html__( 'Header padding', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is padding setting for header', 'consultxp-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-margin',
			'type'			=> 'dimension',
			'title'			=> esc_html__( 'Header margin', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is margin setting for header', 'consultxp-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-style-chk', '=', array( 'custom' ) )
		)
	)
) );
Consultxp_Options::consultxp_set_sub_section( array(
	'title'      => esc_html__( 'Header Top', 'consultxp-addon' ),
	'id'         => 'header-topbar',
	'config_id'  => '',
	'fields'	 => array(
		array(
			'id'			=> 'header-topbar-chk',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Header Top Settings', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Choose custom to edit header top settings.', 'consultxp-addon' ),
			'choices'		=> array(
				'default'	=> esc_html__( 'Default', 'consultxp-addon' ),
				'custom'	=> esc_html__( 'Custom', 'consultxp-addon' )
			),
			'default'		=> 'default'
		),
		array(
			'id'            => 'topbar-items',
			'type'          => 'dragdrop-editor',
			'items'         => array(
				'custom-text-1' => array(
					'title'       => esc_html__( 'Custom Text 1', 'consultxp-addon' ),
					'fields'      => array(
						array(
							'id'    		=> 'topbar-custom-text-1',
							'type'  		=> 'textarea',
							'title' 		=> esc_html__( 'Custom Text 1', 'consultxp-addon' ),
							'description'	=> esc_html__( 'Add the first custom text field displayed in the top bar of the site.', 'consultxp-addon' ),
						),
					),
					'editable' => true,
				),
				'custom-text-2' => array(
					'title'       => esc_html__( 'Custom Text 2 Editor', 'consultxp-addon' ),
					'fields'      => array(
						array(
							'id'			=> 'topbar-custom-text-2',
							'type'			=> 'textarea',
							'title'			=> esc_html__( 'Custom Text 2', 'consultxp-addon' ),
							'description'	=> esc_html__( 'Add the second custom text field displayed in the top bar of the site.', 'consultxp-addon' ),
							'default'		=> ''
						),
					),
					'editable' => true,
				),
				'topbar-html-1' => array(
					'title'       => esc_html__( 'Html 1 Editor', 'consultxp-addon' ),
					'fields'      => array(
						array(
							'id'    => 'topbar_html_1',
							'type'  => 'textarea',
							'title' => esc_html__( 'Html Code', 'consultxp-addon' ),
							'description' 	=> esc_html__( 'Add custom HTML code to insert content, scripts, or custom elements into the site.', 'consultxp-addon' ),
						),
					),
					'editable' => true,
				),
				'topbar-html-2' => array(
					'title'       => esc_html__( 'Html 2 Editor', 'consultxp-addon' ),
					'fields'      => array(
						array(
							'id'    => 'topbar_html_2',
							'type'  => 'textarea',
							'title' => esc_html__( 'Html Code', 'consultxp-addon' ),
							'description' 	=> esc_html__( 'Add custom HTML code to insert content, scripts, or custom elements into the site.', 'consultxp-addon' ),
						),
					),
					'editable' => true,
				),
				'topbar-html-3' => array(
					'title'       => esc_html__( 'Html 3 Editor', 'consultxp-addon' ),
					'fields'      => array(
						array(
							'id'    => 'topbar_html_3',
							'type'  => 'textarea',
							'title' => esc_html__( 'Html Code', 'consultxp-addon' ),
							'description' 	=> esc_html__( 'Add custom HTML code to insert content, scripts, or custom elements into the site.', 'consultxp-addon' ),
						),
					),
					'editable' => true,
				),
				'topbar-html-4' => array(
					'title'       => esc_html__( 'Html 4 Editor', 'consultxp-addon' ),
					'fields'      => array(
						array(
							'id'    => 'topbar_html_4',
							'type'  => 'textarea',
							'title' => esc_html__( 'Html Code', 'consultxp-addon' ),
							'description' 	=> esc_html__( 'Add custom HTML code to insert content, scripts, or custom elements into the site.', 'consultxp-addon' ),
						),
					),
					'editable' => true,
				),
				'topbar-html-5' => array(
					'title'       => esc_html__( 'Html 5 Editor', 'consultxp-addon' ),
					'fields'      => array(
						array(
							'id'    => 'topbar_html_5',
							'type'  => 'textarea',
							'title' => esc_html__( 'Html Code', 'consultxp-addon' ),
							'description' 	=> esc_html__( 'Add custom HTML code to insert content, scripts, or custom elements into the site.', 'consultxp-addon' ),
						),
					),
					'editable' => true,
				),
				'topbar-spacer-1' => array(
					'title'		 => esc_html__( 'Spacer 1 Editor', 'consultxp-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'topbar_spacer_1_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Spacer width', 'consultxp-addon' ),
							'description' => esc_html__( 'Adjust this value to control the amount of empty space between elements.', 'consultxp-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '40' )
						),
					),	
					'editable' => true,
				),
				'topbar-spacer-2' => array(
					'title'		 => esc_html__( 'Spacer 2 Editor', 'consultxp-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'topbar_spacer_2_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Spacer width', 'consultxp-addon' ),
							'description' => esc_html__( 'Adjust this value to control the amount of empty space between elements.', 'consultxp-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '40' )
						),
					),
					'editable' => true,
				),
				'topbar-spacer-3' => array(
					'title'		 => esc_html__( 'Spacer 3 Editor', 'consultxp-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'topbar_spacer_3_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Spacer width', 'consultxp-addon' ),
							'description' => esc_html__( 'Adjust this value to control the amount of empty space between elements.', 'consultxp-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '40' )
						),
					),	
					'editable' => true,
				),
				'topbar_delimiter1' => array(
					'title'		 => esc_html__( 'Delimiter 1 Editor', 'consultxp-addon'),
					'description' => esc_html__( 'Adds a vertical bar (|) between elements to visually separate them.', 'consultxp-addon' ),
					'fields'	 => array( 
						array(
							'id'		=> 'topbar_delimiter1_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Width', 'consultxp-addon'),
							'description' => esc_html__( 'Defines the thickness of the vertical bar (|) separator.', 'consultxp-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '1' )
						),
						array(
							'id'		=> 'topbar_delimiter1_height',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Height', 'consultxp-addon'),
							'description' => esc_html__( 'Sets the vertical size of the delimiter (|) to control its length.', 'consultxp-addon' ),
							'only_dimension' => 'height',
							'default' 	=> array( 'height' => '100' )
						),
						array( 
							'id'			=> 'topbar_delimiter1_color',
							'type'			=> 'color',
							'title'			=> esc_html__( 'Color', 'consultxp-addon' ),
							'description'   => esc_html__( 'Set the color of the Delimiter.', 'consultxp-addon' ),
							'default'		=> ''
						),
						array(
							'id'			=> 'topbar_delimiter1_margin',
							'type'			=> 'dimension',
							'title'			=> esc_html__( 'Margin', 'consultxp-addon' ),
							'description'   => esc_html__( 'Controls the spacing around the delimiter (|).', 'consultxp-addon' ),
							'default'		=> ''
						),
					),	
					'editable' => true,
				),
				'topbar_delimiter2' => array(
					'title'		 => esc_html__( 'Delimiter 2 Editor', 'consultxp-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'topbar_delimiter2_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Width', 'consultxp-addon'),
							'description' => esc_html__( 'Defines the thickness of the vertical bar (|) separator.', 'consultxp-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '1' )
						),
						array(
							'id'		=> 'topbar_delimiter2_height',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Height', 'consultxp-addon'),
							'description' => esc_html__( 'Sets the vertical size of the delimiter (|) to control its length.', 'consultxp-addon' ),
							'only_dimension' => 'height',
							'default' 	=> array( 'height' => '100' )
						),
						array( 
							'id'			=> 'topbar_delimiter2_color',
							'type'			=> 'color',
							'title'			=> esc_html__( 'Color', 'consultxp-addon' ),
							'description'   => esc_html__( 'Set the color of the Delimiter.', 'consultxp-addon' ),
							'default'		=> ''
						),
						array(
							'id'			=> 'topbar_delimiter2_margin',
							'type'			=> 'dimension',
							'title'			=> esc_html__( 'Margin', 'consultxp-addon' ),
							'description'   => esc_html__( 'Controls the spacing around the delimiter (|).', 'consultxp-addon' ),
							'default'		=> ''
						),
					),	
					'editable' => true,
				),
				'topbar_delimiter3' => array(
					'title'		 => esc_html__( 'Delimiter 3 Editor', 'consultxp-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'topbar_delimiter3_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Width', 'consultxp-addon'),
							'description' => esc_html__( 'Defines the thickness of the vertical bar (|) separator.', 'consultxp-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '1' )
						),
						array(
							'id'		=> 'topbar_delimiter3_height',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Height', 'consultxp-addon'),
							'description' => esc_html__( 'Sets the vertical size of the delimiter (|) to control its length.', 'consultxp-addon' ),
							'only_dimension' => 'height',
							'default' 	=> array( 'height' => '100' )
						),
						array( 
							'id'			=> 'topbar_delimiter3_color',
							'type'			=> 'color',
							'title'			=> esc_html__( 'Color', 'consultxp-addon' ),
							'description'   => esc_html__( 'Set the color of the Delimiter.', 'consultxp-addon' ),
							'default'		=> ''
						),
						array(
							'id'			=> 'topbar_delimiter3_margin',
							'type'			=> 'dimension',
							'title'			=> esc_html__( 'Margin', 'consultxp-addon' ),
							'description'   => esc_html__( 'Controls the spacing around the delimiter (|).', 'consultxp-addon' ),
							'default'		=> ''
						),
					),	
					'editable' => true,
				),
				'signin'	=> array(
					'title'		=> esc_html__( 'Sign in/register', 'consultxp-addon' ),
					'fields'	=> array(
						array(
							'id'	=> 'signin-register-top',
							'type'	=> 'text',
							'title'	=> esc_html__( 'Enter Your shortcode','consultxp-addon' ),
							'description'	=> esc_html__( 'Enter your login/ register shortcode here. Example: [contact-form-7 id="5ecf846" title="Event"].', 'consultxp-addon' ),
						),
						array(
							'id'	=> 'signin-register-text-top',
							'type'	=> 'text',
							'title'	=> esc_html__( 'Sign in/Register Text', 'consultxp-addon' ),
							'description'	=> esc_html__( 'Enter the text displayed for the login/register option on the site. Example: Login or Register.', 'consultxp-addon' ),
						)
					),
					'editable' => true,
				),
			),
			'default'       => array(
				'left' => array(
					'custom-text-1' => esc_html__( 'Custom Text 1', 'consultxp-addon' ),
				),
				'center' => array(
				),
				'right' => array(
				),
				'disabled' => array(
					'search' 		        => esc_html__( 'Search', 'consultxp-addon' ),
					'social'	 			=> esc_html__( 'Social', 'consultxp-addon' ),
					'address' 				=> esc_html__( 'Address', 'consultxp-addon' ),
					'email' 				=> esc_html__( 'Email', 'consultxp-addon' ),
					'signin' 	    		=> esc_html__( 'Signin/Register', 'consultxp-addon' ),
					'custom-text-2'  		=> esc_html__( 'Custom Text 2', 'consultxp-addon' ),
					'top-menu' 				=> esc_html__( 'Top Menu', 'consultxp-addon' ),
					'topbar-spacer-1' 		=> esc_html__( 'Spacer 1', 'consultxp-addon' ),
					'topbar-spacer-2'		=> esc_html__( 'Spacer 2', 'consultxp-addon' ),
					'topbar-spacer-3'		=> esc_html__( 'Spacer 3', 'consultxp-addon' ),
					'topbar-html-1' 		=> esc_html__( 'HTML 1', 'consultxp-addon' ),
					'topbar-html-2'			=> esc_html__( 'HTML 2', 'consultxp-addon' ),
					'topbar-html-3' 		=> esc_html__( 'HTML 3', 'consultxp-addon' ),
					'topbar-html-4' 		=> esc_html__( 'HTML 4', 'consultxp-addon' ),
					'topbar-html-5' 		=> esc_html__( 'HTML 5', 'consultxp-addon' ),
					'topbar_delimiter1' 	=> esc_html__('|', 'consultxp-addon'),
					'topbar_delimiter2' 	=> esc_html__('|', 'consultxp-addon'),
					'topbar_delimiter3' 	=> esc_html__('|', 'consultxp-addon'),
					'wpml_polylang'			=> esc_html__( 'WPML/Polylang', 'consultxp-addon'),
				), 
			),
			'required'		=> array( 'header-topbar-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-topbar-style-label-field',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Header Top Styles', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Here you can set all the type of header top styles.', 'consultxp-addon' ),
			'seperator'		=> 'before'
		),
		array(
			'id'			=> 'header-topbar-style-chk',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Header Top Style Settings', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Choose custom to edit header top style settings.', 'consultxp-addon' ),
			'choices'		=> array(
				'default'	=> esc_html__( 'Default', 'consultxp-addon' ),
				'custom'	=> esc_html__( 'Custom', 'consultxp-addon' )
			),
			'default'		=> 'default'
		),
		array(
			'id'			=> 'header-topbar-height',
			'type'			=> 'hw',
			'title'			=> esc_html__( 'Header Top Height', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is height property of header top.', 'consultxp-addon' ),
			'only_dimension' => 'height',
			'required'		=> array( 'header-topbar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-topbar-sticky-height',
			'type'			=> 'hw',
			'title'			=> esc_html__( 'Header Top Sticky Height', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is height property of header sticky topbar.', 'consultxp-addon' ),
			'only_dimension' => 'height'
		),
		array(
			'id'			=> 'header-topbar-links-color',
			'type'			=> 'link',
			'title'			=> esc_html__( 'Header Top Link Color', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is link color setting for header top', 'consultxp-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-topbar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-topbar-background',
			'type'			=> 'background',
			'title'			=> esc_html__( 'Header Top Background Color', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is background setting for header top', 'consultxp-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-topbar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-topbar-border',
			'type'			=> 'border',
			'title'			=> esc_html__( 'Header Top Border', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is border setting for header top', 'consultxp-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-topbar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-topbar-padding',
			'type'			=> 'dimension',
			'title'			=> esc_html__( 'Header Top padding', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is padding setting for header top', 'consultxp-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-topbar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-topbar-margin',
			'type'			=> 'dimension',
			'title'			=> esc_html__( 'Header Top margin', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is margin setting for header top', 'consultxp-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-topbar-style-chk', '=', array( 'custom' ) )
		),	
		array(
			'id'			=> 'header-topbar-sticky-style-label-field',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Header Top Sticky Styles', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Here you can set all the type of header top sticky styles.', 'consultxp-addon' ),
			'seperator'		=> 'before',
			'required'		=> array( 'header-topbar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-topbar-sticky-links-color',
			'type'			=> 'link',
			'title'			=> esc_html__( 'Header Top Sticky Link Color', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is link color setting for header top on sticky', 'consultxp-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-topbar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-topbar-sticky-background',
			'type'			=> 'background',
			'title'			=> esc_html__( 'Header Top Sticky Background Color', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is background setting for header top on sticky', 'consultxp-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-topbar-style-chk', '=', array( 'custom' ) )
		),	
	)
) );
Consultxp_Options::consultxp_set_sub_section( array(
	'title'      => esc_html__( 'Header Middle', 'consultxp-addon' ),
	'id'         => 'header-logobar',
	'config_id'  => '',
	'fields'	 => array(
		array(
			'id'			=> 'header-logobar-chk',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Header Middle Settings', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Choose custom to edit header middle settings.', 'consultxp-addon' ),
			'choices'		=> array(
				'default'	=> esc_html__( 'Default', 'consultxp-addon' ),
				'custom'	=> esc_html__( 'Custom', 'consultxp-addon' )
			),
			'default'		=> 'default'
		),
		array(
			'id'            => 'logobar-items',
			'type'          => 'dragdrop-editor',
			'items'         => array(
				'custom-text-1' => array(
					'title'       => esc_html__( 'Custom Text 1 Editor', 'consultxp-addon' ),
					'fields'      => array(
						array(
							'id'    => 'logobar-custom-text-1',
							'type'  => 'textarea',
							'title' => esc_html__( 'Custom Text 1', 'consultxp-addon' ),
							'description'	=> esc_html__( 'Add the first custom text field displayed in the Header Middle of the site.', 'consultxp-addon' ),
						),
					),
					'editable' => true,
				),
				'custom-text-2' => array(
					'title'       => esc_html__( 'Custom Text 2 Editor', 'consultxp-addon' ),
					'fields'      => array(
						array(
							'id'			=> 'logobar-custom-text-2',
							'type'			=> 'textarea',
							'title'			=> esc_html__( 'Custom Text 2', 'consultxp-addon' ),
							'description'	=> esc_html__( 'Add the second custom text field displayed in the Header Middle of the site.', 'consultxp-addon' ),
							'default'		=> ''
						),
					),
					'editable' => true,
				),
				'logobar-html-1' => array(
					'title'       => esc_html__( 'Html 1 Editor', 'consultxp-addon' ),
					'fields'      => array(
						array(
							'id'    		=> 'logobar_html_1',
							'type'  		=> 'textarea',
							'title' 		=> esc_html__( 'Html Code', 'consultxp-addon' ),
							'description' 	=> esc_html__( 'Add custom HTML code to insert content, scripts, or custom elements into the site.', 'consultxp-addon' ),
						),
					),
					'editable' => true,
				),
				'logobar-html-2' => array(
					'title'       => esc_html__( 'Html 2 Editor', 'consultxp-addon' ),
					'fields'      => array(
						array(
							'id'    => 'logobar_html_2',
							'type'  => 'textarea',
							'title' => esc_html__( 'Html Code', 'consultxp-addon' ),
							'description' => esc_html__( 'Add custom HTML code to insert content, scripts, or custom elements into the site.', 'consultxp-addon' ),
						),
					),
					'editable' => true,
				),
				'logobar-html-3' => array(
					'title'       => esc_html__( 'Html 3 Editor', 'consultxp-addon' ),
					'fields'      => array(
						array(
							'id'    => 'logobar_html_3',
							'type'  => 'textarea',
							'title' => esc_html__( 'Html Code', 'consultxp-addon' ),
							'description' => esc_html__( 'Add custom HTML code to insert content, scripts, or custom elements into the site.', 'consultxp-addon' ),
						),
					),
					'editable' => true,
				),
				'logobar-html-4' => array(
					'title'       => esc_html__( 'Html 4 Editor', 'consultxp-addon' ),
					'fields'      => array(
						array(
							'id'    => 'logobar_html_4',
							'type'  => 'textarea',
							'title' => esc_html__( 'Html Code', 'consultxp-addon' ),
							'description' => esc_html__( 'Add custom HTML code to insert content, scripts, or custom elements into the site.', 'consultxp-addon' ),
						),
					),
					'editable' => true,
				),
				'logobar-html-5' => array(
					'title'       => esc_html__( 'Html 5 Editor', 'consultxp-addon' ),
					'fields'      => array(
						array(
							'id'    => 'logobar_html_5',
							'type'  => 'textarea',
							'title' => esc_html__( 'Html Code', 'consultxp-addon' ),
							'description' => esc_html__( 'Add custom HTML code to insert content, scripts, or custom elements into the site.', 'consultxp-addon' ),
						),
					),
					'editable' => true,
				),
				'logobar-spacer-1' => array(
					'title'		 => esc_html__( 'Spacer 1 Editor', 'consultxp-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'logobar_spacer_1_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Spacer Width', 'consultxp-addon'),
							'description' => esc_html( 'Set the spacer width to control layout spacing.', 'consultxp-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '40' )
						),
					),	
					'editable' => true,
				),
				'logobar-spacer-2' => array(
					'title'		 => esc_html__( 'Spacer 2 Editor', 'consultxp-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'logobar_spacer_2_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Spacer Width', 'consultxp-addon' ),
							'description' => esc_html__( 'Adjust this value to control the amount of empty space between elements.', 'consultxp-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '40' )
						),
					),	
					'editable' => true,
				),
				'logobar-spacer-3' => array(
					'title'		 => esc_html__( 'Spacer 3 Editor', 'consultxp-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'logobar_spacer_3_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Spacer Width', 'consultxp-addon' ),
							'description' => esc_html__( 'Adjust this value to control the amount of empty space between elements.', 'consultxp-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '40' )
						),
					),	
					'editable' => true,
				),
				'logobar_delimiter1' => array(
					'title'		 => esc_html__( 'Delimiter 1 Editor', 'consultxp-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'logobar_delimiter1_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Width', 'consultxp-addon'),
							'description' => esc_html__( 'Defines the thickness of the vertical bar (|) separator.', 'consultxp-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '1' )
						),
						array(
							'id'		=> 'logobar_delimiter1_height',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Height', 'consultxp-addon'),
							'description' => esc_html__( 'Sets the vertical size of the delimiter (|) to control its length.', 'consultxp-addon' ),
							'only_dimension' => 'height',
							'default' 	=> array( 'height' => '100' )
						),
						array( 
							'id'			=> 'logobar_delimiter1_color',
							'type'			=> 'color',
							'title'			=> esc_html__( 'Color', 'consultxp-addon' ),
							'description' => esc_html__( 'Set the color of the Delimiter.', 'consultxp-addon' ),
							'default'		=> ''
						),
						array(
							'id'			=> 'logobar_delimiter1_margin',
							'type'			=> 'dimension',
							'title'			=> esc_html__( 'Margin', 'consultxp-addon' ),
							'description' => esc_html__( 'Controls the spacing around the delimiter (|).', 'consultxp-addon' ),
							'default'		=> ''
						),
					),	
					'editable' => true,
				),
				'logobar_delimiter2' => array(
					'title'		 => esc_html__( 'Delimiter 2 Editor', 'consultxp-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'logobar_delimiter2_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Width', 'consultxp-addon'),
							'description' => esc_html__( 'Defines the thickness of the vertical bar (|) separator.', 'consultxp-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '1' )
						),
						array(
							'id'		=> 'logobar_delimiter2_height',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Height', 'consultxp-addon'),
							'description' => esc_html__( 'Sets the vertical size of the delimiter (|) to control its length.', 'consultxp-addon' ),
							'only_dimension' => 'height',
							'default' 	=> array( 'height' => '100' )
						),
						array( 
							'id'			=> 'logobar_delimiter2_color',
							'type'			=> 'color',
							'title'			=> esc_html__( 'Color', 'consultxp-addon' ),
							'description' => esc_html__( 'Set the color of the Delimiter.', 'consultxp-addon' ),
							'default'		=> ''
						),
						array(
							'id'			=> 'logobar_delimiter2_margin',
							'type'			=> 'dimension',
							'title'			=> esc_html__( 'Margin', 'consultxp-addon' ),
							'description' => esc_html__( 'Controls the spacing around the delimiter (|).', 'consultxp-addon' ),
							'default'		=> ''
						),
					),	
					'editable' => true,
				),
				'logobar_delimiter3' => array(
					'title'		 => esc_html__( 'Delimiter 3 Editor', 'consultxp-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'logobar_delimiter3_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Width', 'consultxp-addon'),
							'description' => esc_html__( 'Defines the thickness of the vertical bar (|) separator.', 'consultxp-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '1' )
						),
						array(
							'id'		=> 'logobar_delimiter3_height',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Height', 'consultxp-addon'),
							'description' => esc_html__( 'Sets the vertical size of the delimiter (|) to control its length.', 'consultxp-addon' ),
							'only_dimension' => 'height',
							'default' 	=> array( 'height' => '100' )
						),
						array( 
							'id'			=> 'logobar_delimiter3_color',
							'type'			=> 'color',
							'title'			=> esc_html__( 'Color', 'consultxp-addon' ),
							'description' => esc_html__( 'Set the color of the Delimiter.', 'consultxp-addon' ),
							'default'		=> ''
						),
						array(
							'id'			=> 'logobar_delimiter3_margin',
							'type'			=> 'dimension',
							'title'			=> esc_html__( 'Margin', 'consultxp-addon' ),
							'description' => esc_html__( 'Controls the spacing around the delimiter (|).', 'consultxp-addon' ),
							'default'		=> ''
						),
					),	
					'editable' => true,
				),
				'signin'	=> array(
					'title'		=> esc_html__( 'Sign in/register', 'consultxp-addon' ),
					'fields'	=> array(
						array(
							'id'	=> 'signin-register-logo',
							'type'	=> 'text',
							'title'	=> esc_html__( 'Enter Your shortcode','consultxp-addon' ),
							'description'	=> esc_html__( 'Enter your login/ register shortcode here. Example: [contact-form-7 id="5ecf846" title="Event"].', 'consultxp-addon' ),
						),
						array(
							'id'	=> 'signin-register-text-logo',
							'type'	=> 'text',
							'title'	=> esc_html__( 'Sign in/Register Text', 'consultxp-addon' ),
							'description'	=> esc_html__( 'Enter the text displayed for the login/register option on the site. Example: Login or Register.', 'consultxp-addon' ),
						)
					),
					'editable' => true,
				),
			),
			'default'       => array(
				'right' => array(
					'custom-text-1' => esc_html__( 'Custom Text 1', 'consultxp-addon' ),
				),
				'center' => array(
				),
				'left' => array(
				),
				'disabled' => array(
					'logo' 					=> esc_html__( 'Logo', 'consultxp-addon' ),
					'search'				=> esc_html__( 'Search', 'consultxp-addon' ),
					'social'	 			=> esc_html__( 'Social', 'consultxp-addon' ),
					'address' 				=> esc_html__( 'Address', 'consultxp-addon' ),
					'email' 				=> esc_html__( 'Email', 'consultxp-addon' ),
					'secondary-bar' 		=> esc_html__( 'Secondary Bar', 'consultxp-addon' ),
					'signin' 				=> esc_html__( 'Signin/Register', 'consultxp-addon' ),
					'custom-text-2'			=> esc_html__( 'Custom Text 2', 'consultxp-addon' ),
					'primary-menu' 			=> esc_html__( 'Primary Menu', 'consultxp-addon' ),
					'logobar-spacer-1' 		=> esc_html__( 'Spacer 1', 'consultxp-addon' ),
					'logobar-spacer-2'		=> esc_html__( 'Spacer 2', 'consultxp-addon' ),
					'logobar-spacer-3'		=> esc_html__( 'Spacer 3', 'consultxp-addon' ),
					'logobar-html-1' 		=> esc_html__( 'HTML 1', 'consultxp-addon' ),
					'logobar-html-2'		=> esc_html__( 'HTML 2', 'consultxp-addon' ),
					'logobar-html-3' 		=> esc_html__( 'HTML 3', 'consultxp-addon' ),
					'logobar-html-4' 		=> esc_html__( 'HTML 4', 'consultxp-addon' ),
					'logobar-html-5' 		=> esc_html__( 'HTML 5', 'consultxp-addon' ),
					'logobar_delimiter1' 	=> esc_html__( '|', 'consultxp-addon'),
					'logobar_delimiter2' 	=> esc_html__( '|', 'consultxp-addon'),
					'logobar_delimiter3' 	=> esc_html__( '|', 'consultxp-addon'),
					'wpml_polylang'			=> esc_html__( 'WPML/Polylang', 'consultxp-addon'),
				),
			),
			'required'		=> array( 'header-logobar-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-logobar-style-label-field',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Header Middle Styles', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Here you can set all the type of header middle styles.', 'consultxp-addon' ),
			'seperator'		=> 'before'
		),
		array(
			'id'			=> 'header-logobar-style-chk',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Header Middle Style Settings', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Choose custom to edit header middle bar style settings.', 'consultxp-addon' ),
			'choices'		=> array(
				'default'	=> esc_html__( 'Default', 'consultxp-addon' ),
				'custom'	=> esc_html__( 'Custom', 'consultxp-addon' )
			),
			'default'		=> 'default'
		),
		array(
			'id'			=> 'header-logobar-height',
			'type'			=> 'hw',
			'title'			=> esc_html__( 'Header Middle Height', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is height property of header middle.', 'consultxp-addon' ),
			'only_dimension' => 'height',
			'required'		=> array( 'header-logobar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-logobar-sticky-height',
			'type'			=> 'hw',
			'title'			=> esc_html__( 'Header Middle Sticky Height', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is height property of header sticky logobar.', 'consultxp-addon' ),
			'only_dimension' => 'height'
		),
		array(
			'id'			=> 'header-logobar-links-color',
			'type'			=> 'link',
			'title'			=> esc_html__( 'Header Middle Link Color', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is link color setting for header middle', 'consultxp-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-logobar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-logobar-background',
			'type'			=> 'background',
			'title'			=> esc_html__( 'Header Background Color', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is background setting for header middle', 'consultxp-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-logobar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-logobar-border',
			'type'			=> 'border',
			'title'			=> esc_html__( 'Header Middle Border', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is border setting for header middle', 'consultxp-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-logobar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-logobar-padding',
			'type'			=> 'dimension',
			'title'			=> esc_html__( 'Header Middle padding', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is padding setting for header middle', 'consultxp-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-logobar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-logobar-margin',
			'type'			=> 'dimension',
			'title'			=> esc_html__( 'Header Middle margin', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is margin setting for header middle', 'consultxp-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-logobar-style-chk', '=', array( 'custom' ) )
		),	
		array(
			'id'			=> 'header-logobar-sticky-style-label-field',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Header Middle Sticky Styles', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Here you can set all the type of header middle sticky styles.', 'consultxp-addon' ),
			'seperator'		=> 'before',
			'required'		=> array( 'header-logobar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-logobar-sticky-links-color',
			'type'			=> 'link',
			'title'			=> esc_html__( 'Header Middle Sticky Link Color', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is link color setting for header middle on sticky', 'consultxp-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-logobar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-logobar-sticky-background',
			'type'			=> 'background',
			'title'			=> esc_html__( 'Header Middle Sticky Background Color', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is background setting for header middle on sticky', 'consultxp-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-logobar-style-chk', '=', array( 'custom' ) )
		),
	)
) );
Consultxp_Options::consultxp_set_sub_section( array(
	'title'      => esc_html__( 'Header Bottom', 'consultxp-addon' ),
	'id'         => 'header-navbar',
	'config_id'  => '',
	'fields'	 => array(
		array(
			'id'			=> 'header-navbar-chk',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Header Bottom Settings', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Choose custom to edit header navbar settings.', 'consultxp-addon' ),
			'choices'		=> array(
				'default'	=> esc_html__( 'Default', 'consultxp-addon' ),
				'custom'	=> esc_html__( 'Custom', 'consultxp-addon' )
			),
			'default'		=> 'default'
		),
		array(
			'id'            => 'navbar-items',
			'type'          => 'dragdrop-editor',
			'items'         => array(
				'custom-text-1' => array(
					'title'       => esc_html__('Custom Text 1 Editor', 'consultxp-addon'),
					'fields'      => array(
						array(
							'id'    => 'navbar-custom-text-1',
							'type'  => 'textarea',
							'title' => esc_html__('Custom Text 1', 'consultxp-addon'),
							'description'	=> esc_html__( 'Add the first custom text field displayed in the nav bar of the site.', 'consultxp-addon' ),
						),
					),
					'editable' => true,
				),
				'custom-text-2' => array(
					'title'       => esc_html__( 'Custom Text 2 Editor', 'consultxp-addon' ),
					'fields'      => array(
						array(
							'id'			=> 'navbar-custom-text-2',
							'type'			=> 'textarea',
							'title'			=> esc_html__( 'Custom Text 2', 'consultxp-addon' ),
							'description'	=> esc_html__( 'Add the second custom text field displayed in the nav bar of the site.', 'consultxp-addon' ),
							'default'		=> ''
						),
					),
					'editable' => true,
				),
				'navbar-html-1' => array(
					'title'       => esc_html__( 'Html 1 Editor', 'consultxp-addon' ),
					'fields'      => array(
						array(
							'id'    => 'navbar_html_1',
							'type'  => 'textarea',
							'title' => esc_html__( 'Html Code', 'consultxp-addon' ),
							'description' 	=> esc_html__( 'Add custom HTML code to insert content, scripts, or custom elements into the site.', 'consultxp-addon' ),
						),
					),
					'editable' => true,
				),
				'navbar-html-2' => array(
					'title'       => esc_html__( 'Html 2 Editor', 'consultxp-addon' ),
					'fields'      => array(
						array(
							'id'    => 'navbar_html_2',
							'type'  => 'textarea',
							'title' => esc_html__( 'Html Code', 'consultxp-addon' ),
							'description' 	=> esc_html__( 'Add custom HTML code to insert content, scripts, or custom elements into the site.', 'consultxp-addon' ),
						),
					),
					'editable' => true,
				),
				'navbar-html-3' => array(
					'title'       => esc_html__( 'Html 3 Editor', 'consultxp-addon' ),
					'fields'      => array(
						array(
							'id'    => 'navbar_html_3',
							'type'  => 'textarea',
							'title' => esc_html__( 'Html Code', 'consultxp-addon' ),
							'description' 	=> esc_html__( 'Add custom HTML code to insert content, scripts, or custom elements into the site.', 'consultxp-addon' ),
						),
					),
					'editable' => true,
				),
				'navbar-html-4' => array(
					'title'       => esc_html__( 'Html 4 Editor', 'consultxp-addon' ),
					'fields'      => array(
						array(
							'id'    => 'navbar_html_4',
							'type'  => 'textarea',
							'title' => esc_html__( 'Html Code', 'consultxp-addon' ),
							'description' 	=> esc_html__( 'Add custom HTML code to insert content, scripts, or custom elements into the site.', 'consultxp-addon' ),
						),
					),
					'editable' => true,
				),
				'navbar-html-5' => array(
					'title'       => esc_html__( 'Html 5 Editor', 'consultxp-addon' ),
					'fields'      => array(
						array(
							'id'    => 'navbar_html_5',
							'type'  => 'textarea',
							'title' => esc_html__( 'Html Code', 'consultxp-addon' ),
							'description' 	=> esc_html__( 'Add custom HTML code to insert content, scripts, or custom elements into the site.', 'consultxp-addon' ),
						),
					),
					'editable' => true,
				),
				'navbar-spacer-1' => array(
					'title'		 => esc_html__( 'Spacer 1 Editor', 'consultxp-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'navbar_spacer_1_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Spacer Width', 'consultxp-addon'),
							'description' => esc_html__( 'Adjust this value to control the amount of empty space between elements.', 'consultxp-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '40' )
						),
					),	
					'editable' => true,
				),
				'navbar-spacer-2' => array(
					'title'		 => esc_html__( 'Spacer 2 Editor', 'consultxp-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'navbar_spacer_2_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Spacer Width', 'consultxp-addon' ),
							'description' => esc_html__( 'Adjust this value to control the amount of empty space between elements.', 'consultxp-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '40' )
						),
					),	
					'editable' => true,
				),
				'navbar-spacer-3' => array(
					'title'		 => esc_html__( 'Spacer 3 Editor', 'consultxp-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'navbar_spacer_3_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Spacer Width', 'consultxp-addon' ),
							'description' => esc_html__( 'Adjust this value to control the amount of empty space between elements.', 'consultxp-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '40' )
						),
					),	
					'editable' => true,
				),
				'navbar_delimiter1' => array(
					'title'		 => esc_html__( 'Delimiter 1 Editor', 'consultxp-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'navbar_delimiter1_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Width', 'consultxp-addon'),
							'description' => esc_html__( 'Defines the thickness of the vertical bar (|) separator.', 'consultxp-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '1' )
						),
						array(
							'id'		=> 'navbar_delimiter1_height',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Height', 'consultxp-addon'),
							'description' => esc_html__( 'Sets the vertical size of the delimiter (|) to control its length.', 'consultxp-addon' ),
							'only_dimension' => 'height',
							'default' 	=> array( 'height' => '100' )
						),
						array( 
							'id'			=> 'navbar_delimiter1_color',
							'type'			=> 'color',
							'title'			=> esc_html__( 'Color', 'consultxp-addon' ),
							'description' => esc_html__( 'Set the color of the Delimiter.', 'consultxp-addon' ),
							'default'		=> ''
						),
						array(
							'id'			=> 'navbar_delimiter1_margin',
							'type'			=> 'dimension',
							'title'			=> esc_html__( 'Margin', 'consultxp-addon' ),
							'description' => esc_html__( 'Controls the spacing around the delimiter (|).', 'consultxp-addon' ),
							'default'		=> ''
						),
					),	
					'editable' => true,
				),
				'navbar_delimiter2' => array(
					'title'		 => esc_html__( 'Delimiter 2 Editor', 'consultxp-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'navbar_delimiter2_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Width', 'consultxp-addon'),
							'description' => esc_html__( 'Defines the thickness of the vertical bar (|) separator.', 'consultxp-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '1' )
						),
						array(
							'id'		=> 'navbar_delimiter2_height',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Height', 'consultxp-addon'),
							'description' => esc_html__( 'Sets the vertical size of the delimiter (|) to control its length.', 'consultxp-addon' ),
							'only_dimension' => 'height',
							'default' 	=> array( 'height' => '100' )
						),
						array( 
							'id'			=> 'navbar_delimiter2_color',
							'type'			=> 'color',
							'title'			=> esc_html__( 'Color', 'consultxp-addon' ),
							'description' => esc_html__( 'Set the color of the Delimiter.', 'consultxp-addon' ),
							'default'		=> ''
						),
						array(
							'id'			=> 'navbar_delimiter2_margin',
							'type'			=> 'dimension',
							'title'			=> esc_html__( 'Margin', 'consultxp-addon' ),
							'description' => esc_html__( 'Controls the spacing around the delimiter (|).', 'consultxp-addon' ),
							'default'		=> ''
						),
					),	
					'editable' => true,
				),
				'navbar_delimiter3' => array(
					'title'		 => esc_html__( 'Delimiter 3 Editor', 'consultxp-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'navbar_delimiter3_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Width', 'consultxp-addon'),
							'description' => esc_html__( 'Defines the thickness of the vertical bar (|) separator.', 'consultxp-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '1' )
						),
						array(
							'id'		=> 'navbar_delimiter3_height',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Height', 'consultxp-addon'),
							'description' => esc_html__( 'Sets the vertical size of the delimiter (|) to control its length.', 'consultxp-addon' ),
							'only_dimension' => 'height',
							'default' 	=> array( 'height' => '100' )
						),
						array( 
							'id'			=> 'navbar_delimiter3_color',
							'type'			=> 'color',
							'title'			=> esc_html__( 'Color', 'consultxp-addon' ),
							'description' => esc_html__( 'Set the color of the Delimiter.', 'consultxp-addon' ),
							'default'		=> ''
						),
						array(
							'id'			=> 'navbar_delimiter3_margin',
							'type'			=> 'dimension',
							'title'			=> esc_html__( 'Margin', 'consultxp-addon' ),
							'description' => esc_html__( 'Controls the spacing around the delimiter (|).', 'consultxp-addon' ),
							'default'		=> ''
						),
					),	
					'editable' => true,
				),
				'signin'	=> array(
					'title'		=> esc_html__( 'Sign in/register', 'consultxp-addon' ),
					'fields'	=> array(
						array(
							'id'	=> 'signin-register-nav',
							'type'	=> 'text',
							'title'	=> esc_html__( 'Enter Your shortcode','consultxp-addon' ),
							'description'	=> esc_html__( 'Enter your login/ register shortcode here. Example: [contact-form-7 id="5ecf846" title="Event"].', 'consultxp-addon' ),
						),
						array(
							'id'	=> 'signin-register-text-nav',
							'type'	=> 'text',
							'title'	=> esc_html__( 'Sign in/Register Text', 'consultxp-addon' ),
							'description'	=> esc_html__( 'Enter the text displayed for the login/register option on the site. Example: Login or Register.', 'consultxp-addon' ),
						)
					),
					'editable' => true,
				),
			),
			'default'       => array(
				'left' => array(
					'custom-text-1' => esc_html__( 'Custom Text 1', 'consultxp-addon' ),
				),
				'center' => array(
				),
				'right' => array(
				),
				'disabled' => array(
					'logo' => esc_html__( 'Logo', 'consultxp-addon' ),
					'search' => esc_html__( 'Search', 'consultxp-addon' ),
					'social'	 	=> esc_html__( 'Social', 'consultxp-addon' ),
					'address' 		=> esc_html__( 'Address', 'consultxp-addon' ),
					'email' 		=> esc_html__( 'Email', 'consultxp-addon' ),
					'secondary-bar' => esc_html__( 'Secondary Bar', 'consultxp-addon' ),
					'signin' 		=> esc_html__( 'Signin/Register', 'consultxp-addon' ),
					'custom-text-2' => esc_html__( 'Custom Text 2', 'consultxp-addon' ),
					'primary-menu' 			=> esc_html__( 'Primary Menu', 'consultxp-addon' ),
					'navbar-spacer-1' 		=> esc_html__( 'Spacer 1', 'consultxp-addon' ),
					'navbar-spacer-2'		=> esc_html__( 'Spacer 2', 'consultxp-addon' ),
					'navbar-spacer-3'		=> esc_html__( 'Spacer 3', 'consultxp-addon' ),
					'navbar-html-1' 		=> esc_html__( 'HTML 1', 'consultxp-addon' ),
					'navbar-html-2'			=> esc_html__( 'HTML 2', 'consultxp-addon' ),
					'navbar-html-3' 		=> esc_html__( 'HTML 3', 'consultxp-addon' ),
					'navbar-html-4' 		=> esc_html__( 'HTML 4', 'consultxp-addon' ),
					'navbar-html-5' 		=> esc_html__( 'HTML 5', 'consultxp-addon' ),
					'navbar_delimiter1' 	=> esc_html__('|', 'consultxp-addon'),
					'navbar_delimiter2' 	=> esc_html__('|', 'consultxp-addon'),
					'navbar_delimiter3' 	=> esc_html__('|', 'consultxp-addon'),
					'wpml_polylang'			=> esc_html__( 'WPML/Polylang', 'consultxp-addon'),
				),
			),
			'required'		=> array( 'header-navbar-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-navbar-style-label-field',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Header Bottom Styles', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Here you can set all the type of header navbar styles.', 'consultxp-addon' ),
			'seperator'		=> 'before'
		),
		array(
			'id'			=> 'header-navbar-style-chk',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Header Bottom Style Settings', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Choose custom to edit Header Middle style settings.', 'consultxp-addon' ),
			'choices'		=> array(
				'default'	=> esc_html__( 'Default', 'consultxp-addon' ),
				'custom'	=> esc_html__( 'Custom', 'consultxp-addon' )
			),
			'default'		=> 'default'
		),
		array(
			'id'			=> 'header-navbar-height',
			'type'			=> 'hw',
			'title'			=> esc_html__( 'Header Bottom Height', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is height property of header navbar.', 'consultxp-addon' ),
			'only_dimension' => 'height',
			'required'		=> array( 'header-navbar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-navbar-sticky-height',
			'type'			=> 'hw',
			'title'			=> esc_html__( 'Header Bottom Sticky Height', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is height property of header sticky navbar.', 'consultxp-addon' ),
			'only_dimension' => 'height'
		),
		array(
			'id'			=> 'header-navbar-links-color',
			'type'			=> 'link',
			'title'			=> esc_html__( 'Header Bottom Link Color', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is link color setting for header navbar', 'consultxp-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-navbar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-navbar-background',
			'type'			=> 'background',
			'title'			=> esc_html__( 'Header Background Color', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is background setting for header navbar', 'consultxp-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-navbar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-navbar-border',
			'type'			=> 'border',
			'title'			=> esc_html__( 'Header Bottom Border', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is border setting for header navbar', 'consultxp-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-navbar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-navbar-padding',
			'type'			=> 'dimension',
			'title'			=> esc_html__( 'Header Bottom padding', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is padding setting for header navbar', 'consultxp-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-navbar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-navbar-margin',
			'type'			=> 'dimension',
			'title'			=> esc_html__( 'Header Bottom margin', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is margin setting for header navbar', 'consultxp-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-navbar-style-chk', '=', array( 'custom' ) )
		),	
		array(
			'id'			=> 'header-navbar-sticky-style-label-field',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Header Bottom Sticky Styles', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Here you can set all the type of header navbar sticky styles.', 'consultxp-addon' ),
			'seperator'		=> 'before',
			'required'		=> array( 'header-navbar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-navbar-sticky-links-color',
			'type'			=> 'link',
			'title'			=> esc_html__( 'Header Bottom Sticky Link Color', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is link color setting for header navbar on sticky', 'consultxp-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-navbar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-navbar-sticky-background',
			'type'			=> 'background',
			'title'			=> esc_html__( 'Header Bottom Sticky Background Color', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is background setting for header navbar on sticky', 'consultxp-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-navbar-style-chk', '=', array( 'custom' ) )
		),
	)
) );
Consultxp_Options::consultxp_set_sub_section( array(
	'title'		=> esc_html__( 'Mobile Header', 'consultxp-addon' ),
	'id'		=> 'header-mobile',
	'config_id'	=> '',
	'fields'	=> array(
		array(
			'id'			=> 'header-mobile-chk',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Mobile Header Settings', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Choose custom to edit mobile header settings.', 'consultxp-addon' ),
			'choices'		=> array(
				'default'	=> esc_html__( 'Default', 'consultxp-addon' ),
				'custom'	=> esc_html__( 'Custom', 'consultxp-addon' )
			),
			'default'		=> 'default'
		),
		array(
            'id'            => 'mobilebar-items',
            'type'          => 'dragdrop-editor',
            'title'         => esc_html__( 'Mobile Header Items', 'consultxp-addon' ),
            'description'   => esc_html__( 'Arrange and customize the elements in the mobile header section using a drag-and-drop interface.', 'consultxp-addon' ),
			'items'			=> array(
				'mobile-menu-custom-text-1'  => array(
					'title'       => esc_html__( 'Custom Text 1 Editor', 'consultxp-addon' ),
					'fields'      => array(
						array(
							'id'			=> 'mobile-menu-custom-text-1',
							'type'			=> 'textarea',
							'title'			=> esc_html__( 'Mobile menu Custom Text 1', 'consultxp-addon' ),
							'description'	=> esc_html__( 'Add the first custom text field displayed in the mobile menu.', 'consultxp-addon' ),
							'default'		=> ''
						),
					),
					'editable'	=> true
				),
				'mobile-menu-custom-text-2'  => array(
					'title'       => esc_html__( 'Custom Text 2 Editor', 'consultxp-addon' ),
					'fields'      => array(
						array(
							'id'			=> 'mobile-menu-custom-text-2',
							'type'			=> 'textarea',
							'title'			=> esc_html__( 'Mobile menu Custom Text 2', 'consultxp-addon' ),
							'description'	=> esc_html__( 'Add the second custom text field displayed in the mobile menu.', 'consultxp-addon' ),
							'default'		=> ''
						),
					),
					'editable'	=> true
				),
				'mobilebar-spacer-1' 	=> array(
					'title'			=> esc_html__( 'Spacer 1 Editor', 'consultxp-addon' ),
					'fields'		=>  array(
						array(
							'id'		=> 'mobilebar_spacer_1',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Spacer 1', 'consultxp-addon'),
							'description' => esc_html__( 'Adjust this value to control the amount of empty space between elements.', 'consultxp-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '40' )
						),
					),
					'editable'	=> true
				),
				'mobilebar-spacer-2' 	=> array(
					'title'			=> esc_html__( 'Spacer 2 Editor', 'consultxp-addon' ),
					'fields'		=>  array(
						array(
							'id'		=> 'mobilebar_spacer_2',
							'type'          => 'hw',
							'title'         => esc_html__( 'Spacer 2', 'consultxp-addon' ),
							'description' => esc_html__( 'Adjust this value to control the amount of empty space between elements.', 'consultxp-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '40' )
						),
					),
					'editable'	=> true
				),
				'mobilebar-spacer-3' 	=> array(
					'title'			=> esc_html__( 'Spacer 3 Editor', 'consultxp-addon' ),
					'fields'		=>  array(
						array(
							'id'		=> 'mobilebar_spacer_3',
							'type'          => 'hw',
							'title'         => esc_html__( 'Spacer 3', 'consultxp-addon' ),
							'description' => esc_html__( 'Adjust this value to control the amount of empty space between elements.', 'consultxp-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '40' )
						),
					),
					'editable'	=> true
				),
				'mobilebar-html-1' => array(
					'title'       => esc_html__( 'HTML 1 Editor', 'consultxp-addon' ),
					'fields'      => array(
						array(
							'id'    => 'mobilebar-html-1',
							'type'  => 'textarea',
							'title' => esc_html__( 'Html Code', 'consultxp-addon' ),
							'description' 	=> esc_html__( 'Add custom HTML code to insert content, scripts, or custom elements into the site.', 'consultxp-addon' ),
						),
					),
					'editable'	=> true
				),
				'mobilebar-html-2' => array(
					'title'       => esc_html__( 'HTML 2 Editor', 'consultxp-addon' ),
					'fields'      => array(
						array(
							'id'    => 'mobilebar-html-2',
							'type'  => 'textarea',
							'title' => esc_html__( 'Html Code', 'consultxp-addon' ),
							'description' 	=> esc_html__( 'Add custom HTML code to insert content, scripts, or custom elements into the site.', 'consultxp-addon' ),
						),
					),
					'editable'	=> true
				),
				'mobilebar-html-3' => array(
					'title'       => esc_html__( 'HTML 3 Editor', 'consultxp-addon' ),
					'fields'      => array(
						array(
							'id'    => 'mobilebar-html-3',
							'type'  => 'textarea',
							'title' => esc_html__( 'Html Code', 'consultxp-addon' ),
							'description' 	=> esc_html__( 'Add custom HTML code to insert content, scripts, or custom elements into the site.', 'consultxp-addon' ),
						),
					),
					'editable'	=> true
				),
				'mobilebar_delimiter1' => array(
					'title'		 => esc_html__( 'Delimiter 1', 'consultxp-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'mobilebar_delimiter1_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Width', 'consultxp-addon'),
							'description' => esc_html__( 'Defines the thickness of the horizontal bar (|) separator.', 'consultxp-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '1' )
						),
						array(
							'id'		=> 'mobilebar_delimiter1_height',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Height', 'consultxp-addon'),
							'description' => esc_html__( 'Sets the vertical size of the delimiter (|) to control its length.', 'consultxp-addon' ),
							'only_dimension' => 'height',
							'default' 	=> array( 'height' => '100' )
						),
						array( 
							'id'			=> 'mobilebar_delimiter1_color',
							'type'			=> 'color',
							'title'			=> esc_html__( 'Color', 'consultxp-addon' ),
							'description' => esc_html__( 'Set the color of the Delimiter.', 'consultxp-addon' ),
							'default'		=> ''
						),
						array(
							'id'			=> 'mobilebar_delimiter1_margin',
							'type'			=> 'dimension',
							'title'			=> esc_html__( 'Margin', 'consultxp-addon' ),
							'description' => esc_html__( 'Controls the spacing around the delimiter (|).', 'consultxp-addon' ),
							'default'		=> ''
						),
					),	
					'editable'	=> true
				),
				'mobilebar_delimiter2' => array(
					'title'		 => esc_html__( 'Delimiter 2', 'consultxp-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'mobilebar_delimiter2_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Width', 'consultxp-addon'),
							'description' => esc_html__( 'Defines the thickness of the horizontal bar (|) separator.', 'consultxp-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '1' )
						),
						array(
							'id'		=> 'mobilebar_delimiter2_height',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Height', 'consultxp-addon'),
							'description' => esc_html__( 'Sets the vertical size of the delimiter (|) to control its length.', 'consultxp-addon' ),
							'only_dimension' => 'height',
							'default' 	=> array( 'height' => '100' )
						),
						array( 
							'id'			=> 'mobilebar_delimiter2_color',
							'type'			=> 'color',
							'title'			=> esc_html__( 'Color', 'consultxp-addon' ),
							'description' => esc_html__( 'Set the color of the Delimiter.', 'consultxp-addon' ),
							'default'		=> ''
						),
						array(
							'id'			=> 'mobilebar_delimiter2_margin',
							'type'			=> 'dimension',
							'title'			=> esc_html__( 'Margin', 'consultxp-addon' ),
							'description' => esc_html__( 'Controls the spacing around the delimiter (|).', 'consultxp-addon' ),
							'default'		=> ''
						),
					),	
					'editable'	=> true
				),
				'mobilebar_delimiter3' => array(
					'title'		 => esc_html__( 'Delimiter 3', 'consultxp-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'mobilebar_delimiter3_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Width', 'consultxp-addon'),
							'description' => esc_html__( 'Defines the thickness of the horizontal bar (|) separator.', 'consultxp-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '1' )
						),
						array(
							'id'		=> 'mobilebar_delimiter3_height',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Height', 'consultxp-addon'),
							'description' => esc_html__( 'Sets the vertical size of the delimiter (|) to control its length.', 'consultxp-addon' ),
							'only_dimension' => 'height',
							'default' 	=> array( 'height' => '100' )
						),
						array( 
							'id'			=> 'mobilebar_delimiter3_color',
							'type'			=> 'color',
							'title'			=> esc_html__( 'Color', 'consultxp-addon' ),
							'description' => esc_html__( 'Set the color of the Delimiter.', 'consultxp-addon' ),
							'default'		=> ''
						),
						array(
							'id'			=> 'mobilebar_delimiter3_margin',
							'type'			=> 'dimension',
							'title'			=> esc_html__( 'Margin', 'consultxp-addon' ),
							'description' => esc_html__( 'Controls the spacing around the delimiter (|).', 'consultxp-addon' ),
							'default'		=> ''
						),
					),	
					'editable'	=> true
				),
			),
            'default'       => array(
                'left' => array(
                    'menu-toggle' => esc_html__( 'Mobile Menu Trigger', 'consultxp-addon' ),                    
                ),
                'center' => array(        
                    'logo' => esc_html__( 'Logo', 'consultxp-addon' ),
                ),
                'right' => array(    
                    'search' => esc_html__( 'Search Trigger', 'consultxp-addon' ),
                ),
                'disabled' => array(
                	'mobile-menu-custom-text-1' => esc_html__( 'Mobile menu Custom Text 1', 'consultxp-addon' ),
					'mobile-menu-custom-text-2' => esc_html__( 'Mobile menu Custom Text 2', 'consultxp-addon' ),
					'mobile-icons-fields'				=> esc_html__( 'Mobile Phone Number', 'consultxp-addon' ),
					'mobilebar-spacer-1'		=> esc_html__( 'Spacer 1', 'consultxp-addon' ),
					'mobilebar-spacer-2'		=> esc_html__( 'Spacer 2', 'consultxp-addon' ),
					'mobilebar-spacer-3'		=> esc_html__( 'Spacer 3', 'consultxp-addon' ),
					'mobilebar-html-1' 			=> esc_html__( 'HTML 1', 'consultxp-addon' ),
					'mobilebar-html-2'			=> esc_html__( 'HTML 2', 'consultxp-addon' ),
					'mobilebar-html-3' 			=> esc_html__( 'HTML 3', 'consultxp-addon' ),
					'mobilebar_delimiter1' 		=> esc_html__('|', 'consultxp-addon'),
					'mobilebar_delimiter2' 		=> esc_html__('|', 'consultxp-addon'),
					'mobilebar_delimiter3' 		=> esc_html__('|', 'consultxp-addon'),
					'mobile-icon-email'			=> esc_html__( 'Mobile Email','consultxp-addon' ),
					'wpml_polylang'			=> esc_html__( 'WPML/Polylang', 'consultxp-addon'),
                )
			),
			'required'		=> array( 'header-mobile-chk', '=', array( 'custom' ) )
        ),
		array(
			'id'			=> 'mobile-style-chk',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Mobile Header Styles', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Choose custom to edit mobile header styles.', 'consultxp-addon' ),
			'choices'		=> array(
				'default'	=> esc_html__( 'Default', 'consultxp-addon' ),
				'custom'	=> esc_html__( 'Custom', 'consultxp-addon' )
			),
			'default'		=> 'default'
		),
		array(
			'id'            => 'mobilebar-responsive',
			'type'          => 'number',
			'title'         => esc_html__( 'Mobile Bar From', 'consultxp-addon' ),
			'description'   => esc_html__( 'Set the width from which the Mobile Bar should be appear. Example 767', 'consultxp-addon' ),
			'default'       => '767',
			'required'		=> array( 'mobile-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'            => 'mobilebar-sticky',
			'type'          => 'select',
			'title'         => esc_html__( 'Choose Mobile Bar Sticky', 'consultxp-addon' ),
			'description'   => esc_html__( 'Select the sticky on or off to fixed at the top while scrolling.', 'consultxp-addon' ),
			'choices'       => array(
				'off'       => 'Off',
				'on'        => 'On',
				'on_scrollup' => 'On Scroll Up'
			),
			'default'       => 'off',
			'required'		=> array( 'mobile-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'            => 'mobilebar-height',
			'type'          => 'number',
			'title'         => esc_html__( 'Mobilebar Height ', 'consultxp-addon' ),
			'description'   => esc_html__( 'Set the height of the mobile bar for optimal visibility and usability. Example 767', 'consultxp-addon' ),
			'default'       => '100',
			'required'		=> array( 'mobile-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'            => 'header-mobilebar-color',
			'type'          => 'color',
			'title'         => esc_html__( 'Header Mobilebar Background Color', 'consultxp-addon' ),
			'description'   => esc_html__( 'Set the background color of the mobile bar in the header. Selected color will work in few places of the website. you can update to leave it as empty.', 'consultxp-addon' ),
			'alpha'         => false,
			'default'       => '#000',
			'required'		=> array( 'mobile-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'            => 'header-mobilebar-item-color',
			'type'          => 'color',
			'title'         => esc_html__( 'Header Mobilebar Items Color', 'consultxp-addon' ),
			'description'   => esc_html__( 'Set the color of the mobile bar items in the header. Selected color will work in few places of the website. you can update to leave it as empty.', 'consultxp-addon' ),
			'alpha'         => false,
			'default'       => '#939393',
			'required'		=> array( 'mobile-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'mobile-bar-chk',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Mobile Menu Items Settings', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Choose custom to edit mobilemenu items settings.', 'consultxp-addon' ),
			'choices'		=> array(
				'default'	=> esc_html__( 'Default', 'consultxp-addon' ),
				'custom'	=> esc_html__( 'Custom', 'consultxp-addon' )
			),
			'default'		=> 'default'
		),
		array(
            'id'            => 'mobilebar-menu-items',
            'type'          => 'dragdrop-editor',
            'title'         => esc_html__( 'Mobile Menu Part Items', 'consultxp-addon' ),
            'description'   => esc_html__( 'Arrange and customize the elements in the mobile menu part section using a drag-and-drop interface.', 'consultxp-addon' ),
			'items'			=> array(
				'mobilebar-menu-custom-text-1'  => array(
					'title'       => esc_html__( 'Custom Text 1 Editor', 'consultxp-addon' ),
					'fields'      => array(
						array(
							'id'			=> 'mobilebar-menu-custom-text-1',
							'type'			=> 'textarea',
							'title'			=> esc_html__( 'Mobile menu Custom Text 1', 'consultxp-addon' ),
							'description'   => esc_html__( 'Add the second custom text field displayed in the mobile menu.', 'consultxp-addon' ),
							'default'		=> ''
						),
					),
					'editable'	=> true
				),
				'mobilebar-menu-custom-text-2'  => array(
					'title'       => esc_html__( 'Custom Text 2 Editor', 'consultxp-addon' ),
					'fields'      => array(
						array(
							'id'			=> 'mobilebar-menu-custom-text-2',
							'type'			=> 'textarea',
							'title'			=> esc_html__( 'Mobile menu Custom Text 2', 'consultxp-addon' ),
							'description'   => esc_html__( 'Add the second custom text field displayed in the mobile menu.', 'consultxp-addon' ),
							'default'		=> ''
						),
					),
					'editable'	=> true
				),
				'spacer-mobile-1'    		=> array(
					'title'			=> esc_html__( 'Spacer 1', 'consultxp-addon' ),
					'fields'		=>  array(
						array(
							'id'		=> 'mobile-spacer-1',
							'type'          => 'hw',
							'title'		=> esc_html__( 'Spacer 1', 'consultxp-addon'),
							'description' => esc_html__( 'Adjust this value to control the amount of empty space between elements.', 'consultxp-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '40' )
						),
					),
					'editable'	=> true
				),
				'spacer-mobile-2'    		=> array(
					'title'			=> esc_html__( 'Spacer 2', 'consultxp-addon' ),
					'fields'		=>  array(
						array(
							'id'		=> 'mobile-spacer-2',
							'type'          => 'hw',
							'title'         => esc_html__( 'Spacer 2', 'consultxp-addon' ),
							'description' => esc_html__( 'Adjust this value to control the amount of empty space between elements.', 'consultxp-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '40' )
						),
					),
					'editable'	=> true
				),
				'spacer-mobile-3'    		=> array(
					'title'			=> esc_html__( 'Spacer 3', 'consultxp-addon' ),
					'fields'		=>  array(
						array(
							'id'		=> 'mobile-spacer-3',
							'type'          => 'hw',
							'title'         => esc_html__( 'Spacer 3', 'consultxp-addon' ),
							'description' => esc_html__( 'Adjust this value to control the amount of empty space between elements.', 'consultxp-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '40' )
						),
					),
					'editable'	=> true
				),
				'delimiter-mobile-1'         => array(
					'title'			=> esc_html__( 'Delimiter 1', 'consultxp-addon'),
					'fields'		=> array( 
						array(
							'id'		=> 'mobile-delimiter-1-width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Width', 'consultxp-addon'),
							'description' => esc_html__( 'Defines the thickness of the vertical bar (|) separator.', 'consultxp-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '100' )
						),
						array(
							'id'		=> 'mobile-delimiter-1-height',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Height', 'consultxp-addon'),
							'description' => esc_html__( 'Sets the vertical size of the delimiter (|) to control its length.', 'consultxp-addon' ),
							'only_dimension' => 'height',
							'default' 	=> array( 'height' => '1' )
						),
						array( 
							'id'			=> 'mobile-delimiter-1-color',
							'type'			=> 'color',
							'title'			=> esc_html__( 'Color', 'consultxp-addon' ),
							'description' => esc_html__( 'Set the color of the Delimiter.', 'consultxp-addon' ),
							'default'		=> ''
						),
						array(
							'id'			=> 'mobile-delimiter-1-margin',
							'type'			=> 'dimension',
							'title'			=> esc_html__( 'Margin', 'consultxp-addon' ),
							'description' => esc_html__( 'Controls the spacing around the delimiter (|).', 'consultxp-addon' ),
							'default'		=> ''
						),
					),
					'editable'	=> true
				),
				'delimiter-mobile-2'         => array(
					'title'			=> esc_html__( 'Delimiter 2', 'consultxp-addon'),
					'fields'		=> array( 
						array(
							'id'		=> 'mobile-delimiter-2-width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Width', 'consultxp-addon'),
							'description' => esc_html__( 'Defines the thickness of the vertical bar (|) separator.', 'consultxp-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '100' )
						),
						array(
							'id'		=> 'mobile-delimiter-2-height',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Height', 'consultxp-addon'),
							'description' => esc_html__( 'Sets the vertical size of the delimiter (|) to control its length.', 'consultxp-addon' ),
							'only_dimension' => 'height',
							'default' 	=> array( 'height' => '1' )
						),
						array( 
							'id'			=> 'mobile-delimiter-2-color',
							'type'			=> 'color',
							'title'			=> esc_html__( 'Color', 'consultxp-addon' ),
							'description' => esc_html__( 'Set the color of the Delimiter.', 'consultxp-addon' ),
							'default'		=> ''
						),
						array(
							'id'			=> 'mobile-delimiter-2-margin',
							'type'			=> 'dimension',
							'title'			=> esc_html__( 'Margin', 'consultxp-addon' ),
							'description' => esc_html__( 'Controls the spacing around the delimiter (|).', 'consultxp-addon' ),
							'default'		=> ''
						),
					),
					'editable'	=> true
				),
				'delimiter-mobile-3'         => array(
					'title'			=> esc_html__( 'Delimiter 3', 'consultxp-addon'),
					'fields'		=> array( 
						array(
							'id'		=> 'mobile-delimiter-3-width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Width', 'consultxp-addon'),
							'description' => esc_html__( 'Defines the thickness of the vertical bar (|) separator.', 'consultxp-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '100' )
						),
						array(
							'id'		=> 'mobile-delimiter-3-height',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Height', 'consultxp-addon'),
							'description' => esc_html__( 'Sets the vertical size of the delimiter (|) to control its length.', 'consultxp-addon' ),
							'only_dimension' => 'height',
							'default' 	=> array( 'height' => '1' )
						),
						array( 
							'id'			=> 'mobile-delimiter-3-color',
							'type'			=> 'color',
							'title'			=> esc_html__( 'Color', 'consultxp-addon' ),
							'description' => esc_html__( 'Set the color of the Delimiter.', 'consultxp-addon' ),
							'default'		=> ''
						),
						array(
							'id'			=> 'mobile-delimiter-3-margin',
							'type'			=> 'dimension',
							'title'			=> esc_html__( 'Margin', 'consultxp-addon' ),
							'description' => esc_html__( 'Controls the spacing around the delimiter (|).', 'consultxp-addon' ),
							'default'		=> ''
						),
					),
					'editable'	=> true
				),
			),
            'default'       => array(
                'enabled' => array(                    
                    'logo' => esc_html__( 'Logo', 'consultxp-addon' ),
                    'menu' => esc_html__( 'Mobile Menu', 'consultxp-addon' )
                ),
                'disabled' => array(
                    'search' => esc_html__( 'Search', 'consultxp-addon' ),
                    'social' => esc_html__( 'Social Links', 'consultxp-addon' ),
                    'mobilebar-menu-custom-text-1' => esc_html__( 'Mobile Bar Menu Custom Text 1', 'consultxp-addon' ),
                    'mobilebar-menu-custom-text-2' => esc_html__( 'Mobile Bar Menu Custom Text 2', 'consultxp-addon' ),
					'wpml_polylang'			=> esc_html__( 'WPML/Polylang', 'consultxp-addon'),
					'spacer-mobile-1'		=> esc_html__( 'Spacer 1', 'consultxp-addon' ),
					'spacer-mobile-2'		=> esc_html__( 'Spacer 2', 'consultxp-addon' ),
					'spacer-mobile-3'		=> esc_html__( 'Spacer 3', 'consultxp-addon' ),
					'delimiter-mobile-1'	=> esc_html__('_', 'consultxp-addon'),
					'delimiter-mobile-2'	=> esc_html__('_', 'consultxp-addon'),
					'delimiter-mobile-3'	=> esc_html__('_', 'consultxp-addon'),
                )
			),
			'required'		=> array( 'mobile-bar-chk', '=', array( 'custom' ) )	
		),
		array(
			'id'			=> 'mobile-menu-style-chk',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Mobile Menu Styles', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Choose custom to edit mobile menu styles.', 'consultxp-addon' ),
			'choices'		=> array(
				'default'	=> esc_html__( 'Default', 'consultxp-addon' ),
				'custom'	=> esc_html__( 'Custom', 'consultxp-addon' )
			),
			'default'		=> 'default'
		),
		array(
			'id'            => 'mobile-menu-color',
			'type'          => 'color',
			'title'         => esc_html__( 'Mobile Menu Background Color', 'consultxp-addon' ),
			'description'   => esc_html__( 'Set the background color for the Mobile Menu. Selected color will work in few places of the website. you can update to leave it as empty.', 'consultxp-addon' ),
			'alpha'         => false,
			'default'       => '#fff',
			'required'		=> array( 'mobile-menu-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'            => 'mobile-menu-item-color',
			'type'          => 'color',
			'title'         => esc_html__( 'Mobile Menu Items Color', 'consultxp-addon' ),
			'description'   => esc_html__( 'Set the color for the Mobile Menu Items. Selected color will work in few places of the website. you can update to leave it as empty.', 'consultxp-addon' ),
			'alpha'         => false,
			'default'       => '#000',
			'required'		=> array( 'mobile-menu-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'            => 'mobile-sidebar-width',
			'type'          => 'hw',
			'title'         => esc_html__( 'Mobile Menu Maximum Width', 'consultxp-addon' ),
			'description'   => esc_html__( 'Set the maximum width of the logo. If you want the original width, leave this field empty.', 'consultxp-addon' ),
			'only_dimension' => 'width',
			'default'		=> array( 'width' => '300' ),
			'required'		=> array( 'mobile-menu-style-chk', '=', array( 'custom' ) )
		),
	)
) );
Consultxp_Options::consultxp_set_end_section( array(
	'id'		=> 'header-tab-end'	
));

//Layout Settings
Consultxp_Options::consultxp_set_section( array(
	'title'      => esc_html__( 'Layout', 'consultxp-addon' ),
	'id'         => 'post-layout',
	'config_id'  => '',
) );
Consultxp_Options::consultxp_set_sub_section( array(
	'title'      => esc_html__( 'Page Title', 'consultxp-addon' ),
	'id'         => 'page-title-options',
	'config_id'  => '',
	'fields'	 => array(
		array(
			'id'			=> 'page-title-chk',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Page Title', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Choose custom to edit page title options.', 'consultxp-addon' ),
			'choices'		=> array(
				'default'	=> esc_html__( 'Default', 'consultxp-addon' ),
				'custom'	=> esc_html__( 'Custom', 'consultxp-addon' )
			),
			'default'		=> 'default'
		),
		array(
			'id'			=> 'page-title',
			'type'			=> 'toggle',
			'title'			=> esc_html__( 'Enable/Disable Page Title', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Enable or disable blog page title section', 'consultxp-addon' ),
			'default'		=> true,
			'required'		=> array( 'page-title-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'page-title-items',
			'type'			=> 'dragdrop',
			'title'			=> esc_html__( 'Blog Page Title Elements', 'consultxp-addon' ),
			'description'	=> esc_html__( 'These are blog page title elements. Drag which items you want to display left, center and right part.', 'consultxp-addon' ),
			'default'		=> array(
				'left' => array(
				),
				'center' => array(
					'title' => esc_html__( 'Title', 'consultxp-addon' ),
					'breadcrumb' => esc_html__( 'Breadcrumb', 'consultxp-addon' )
				),
				'right' => array(
				),
				'disabled' => array(
					'description' => esc_html__( 'Description', 'consultxp-addon' )
				)
			),
			'required'		=> array( 'page-title', '=', array( 'true' ) )
		),
		array(
			'id'			=> 'page-title-bg',
			'type'			=> 'background',
			'title'			=> esc_html__( 'Page Title Background', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is background settings of page title.', 'consultxp-addon' ),
			'required'		=> array( 'page-title', '=', array( 'true' ) )
		),
		array(
			'id'			=> 'page-title-overlaycolor',
			'type'			=> 'color',
			'alpha'			=> true,
			'title'			=> esc_html__( 'Page Title Overlay Color', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This color will be displayed as in Page title overlaycolor. Choose light colors to make it displayed over the image.', 'consultxp-addon' ),
			'required'		=> array( 'page-title', '=', array( 'true' ) )
		),
		array(
			'id'			=> 'page-title-custom-class',
			'type'			=> 'text',
			'title'			=> esc_html__( 'Page Title Custom Class', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is setting for add custom class name to page title wrapper.', 'consultxp-addon' ),
			'required'		=> array( 'page-title', '=', array( 'true' ) )
		),
	)
) );
Consultxp_Options::consultxp_set_sub_section( array(
	'title'      => esc_html__( 'Sidebar Layout', 'consultxp-addon' ),
	'id'         => 'sidebar-layout-options',
	'config_id'  => '',
	'fields'	 => array(
		array(
			'id'			=> 'sidebar-chk',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Sidebar', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Choose custom to edit sidebar layout options.', 'consultxp-addon' ),
			'choices'		=> array(
				'default'	=> esc_html__( 'Default', 'consultxp-addon' ),
				'custom'	=> esc_html__( 'Custom', 'consultxp-addon' )
			),
			'default'		=> 'default'
		),
		array(
			'id'			=> 'sidebar-layout',
			'type'			=> 'radioimage',
			'title'			=> esc_html__( 'Sidebar Layout', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Choose sidebar layout.', 'consultxp-addon' ),
			'items'		=> array(
				'right-sidebar' => array(
					'title' => esc_html__( 'Right Sidebar', 'consultxp-addon' ),
					'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-right.png'
				),
				'left-sidebar' => array(
					'title' => esc_html__( 'Left Sidebar', 'consultxp-addon' ),
					'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-left.png'
				),
				'both-sidebar' => array(
					'title' => esc_html__( 'Both Sidebar', 'consultxp-addon' ),
					'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-both.png'
				),
				'no-sidebar' => array(
					'title' => esc_html__( 'No Sidebar', 'consultxp-addon' ),
					'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/no-sidebar.png'
				)
			),
			'default' => 'right-sidebar',
			'required'		=> array( 'sidebar-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'right-sidebar',
			'type'			=> 'sidebars',
			'title'			=> esc_html__( 'Right Widgets Area', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Choose widget for right widget area', 'consultxp-addon' ),
			'default'		=> '',
			'required'		=> array( 'sidebar-layout', '=', array( 'right-sidebar', 'both-sidebar' ) )
		),
		array(
			'id'			=> 'left-sidebar',
			'type'			=> 'sidebars',
			'title'			=> esc_html__( 'Left Widgets Area', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Choose widget for left widget area', 'consultxp-addon' ),
			'default'		=> '',
			'required'		=> array( 'sidebar-layout', '=', array( 'left-sidebar', 'both-sidebar' ) )
		)
	)
) );
Consultxp_Options::consultxp_set_end_section( array(
	'id'		=> 'post-layout-end'	
));

// Footer
Consultxp_Options::consultxp_set_section( array(
	'title'      => esc_html__( 'Site Footer', 'consultxp-addon' ),
	'id'         => 'footer-tab',
	'config_id'  => '',
) );
Consultxp_Options::consultxp_set_sub_section( array(
	'title'      => esc_html__( 'General', 'consultxp-addon' ),
	'id'         => 'footer-general',
	'config_id'  => '',
	'fields'	 => array(
		array(
			'id'			=> 'footer-chk',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Footer Settings', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Choose custom to edit footer settings options.', 'consultxp-addon' ),
			'choices'		=> array(
				'default'	=> esc_html__( 'Default', 'consultxp-addon' ),
				'custom'	=> esc_html__( 'Custom', 'consultxp-addon' )
			),
			'default'		=> 'default'
		),
		array(
			'id'			=> 'footer-layout',
			'type'			=> 'radioimage',
			'title'			=> esc_html__( 'Footer Layout', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Choose footer layout either wide or boxed.', 'consultxp-addon' ),
			'items'		=> array(
				'wide' => array(
					'title' => esc_html__( 'Wide', 'consultxp-addon' ),
					'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/footer-wide.png'
				),
				'boxed' => array(
					'title' => esc_html__( 'Boxed', 'consultxp-addon' ),
					'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/footer-boxed.png'
				)
			),
			'default' => 'wide',
			'required'		=> array( 'footer-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'footer-items',
			'type'			=> 'dragdrop',
			'title'			=> esc_html__( 'Footer Items', 'consultxp-addon' ),
			'description'	=> esc_html__( 'These are footer items. Drag which items you want to display Enabled and Disabled.', 'consultxp-addon' ),
			'default'		=> array(
				'enabled' => array(
					'footer-middle' => esc_html__( 'Footer Widgets', 'consultxp-addon' ),
					'footer-bottom' => esc_html__( 'Copyright Section', 'consultxp-addon' )
				),
				'disabled' => array(
					'footer-top' => esc_html__( 'Footer Top', 'consultxp-addon' ),
				)
			),
			'required'		=> array( 'footer-chk', '=', array( 'custom' ) )
		),
	)
) );
Consultxp_Options::consultxp_set_sub_section( array(
	'title'      => esc_html__( 'Footer Top', 'consultxp-addon' ),
	'id'         => 'footer-insta',
	'config_id'  => '',
	'fields'	 => array(
		array(
			'id'			=> 'insta-footer-chk',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Footer Top Settings', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Choose custom to edit insta footer settings options.', 'consultxp-addon' ),
			'choices'		=> array(
				'default'	=> esc_html__( 'Default', 'consultxp-addon' ),
				'custom'	=> esc_html__( 'Custom', 'consultxp-addon' )
			),
			'default'		=> 'default'
		),
		array(
			'id'			=> 'insta-footer-layout',
			'type'			=> 'radioimage',
			'title'			=> esc_html__( 'Footer Top Layout', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Choose insta footer layout either wide or boxed.', 'consultxp-addon' ),
			'items'		=> array(
				'wide' => array(
					'title' => esc_html__( 'Wide', 'consultxp-addon' ),
					'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/footer-wide.png'
				),
				'boxed' => array(
					'title' => esc_html__( 'Boxed', 'consultxp-addon' ),
					'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/footer-boxed.png'
				)
			),
			'default' => 'wide',
			'required'		=> array( 'insta-footer-chk', '=', array( 'custom' ) )
		),
	)
) );
Consultxp_Options::consultxp_set_sub_section( array(
	'title'      => esc_html__( 'Footer Widgets', 'consultxp-addon' ),
	'id'         => 'footer-widgets',
	'config_id'  => '',
	'fields'	 => array(
		array(
			'id'			=> 'footer-middle-chk',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Footer Widgets Settings', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Choose custom to edit footer middle settings options.', 'consultxp-addon' ),
			'choices'		=> array(
				'default'	=> esc_html__( 'Default', 'consultxp-addon' ),
				'custom'	=> esc_html__( 'Custom', 'consultxp-addon' )
			),
			'default'		=> 'default'
		),
		array(
			'id'			=> 'widgets-footer-layout',
			'type'			=> 'radioimage',
			'title'			=> esc_html__( 'Widgets Footer Layout', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Choose widgets footer layout either wide or boxed.', 'consultxp-addon' ),
			'items'		=> array(
				'wide' => array(
					'title' => esc_html__( 'Wide', 'consultxp-addon' ),
					'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/footer-wide.png'
				),
				'boxed' => array(
					'title' => esc_html__( 'Boxed', 'consultxp-addon' ),
					'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/footer-boxed.png'
				)
			),
			'default' => 'boxed',
			'required'		=> array( 'footer-middle-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'footer-widgets-layout',
			'type'			=> 'radioimage',
			'title'			=> esc_html__( 'Footer Widgets Layout', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Choose footer widgets layout.', 'consultxp-addon' ),
			'items'		=> array(
				'3-3-3-3' => array(
					'title' => esc_html__( 'Column 3/3/3/3', 'consultxp-addon' ),
					'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/widget-3-3-3-3.png'
				),
				'3-3-6' => array(
					'title' => esc_html__( 'Column 3/3/6', 'consultxp-addon' ),
					'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/widget-3-3-6.png'
				),
				'12' => array(
					'title' => esc_html__( 'Column 12', 'consultxp-addon' ),
					'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/widget-12.png'
				),
				'4-4-4' => array(
					'title' => esc_html__( 'Column 4/4/4', 'consultxp-addon' ),
					'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/widget-4-4-4.png'
				),
				'4-8' => array(
					'title' => esc_html__( 'Column4/8', 'consultxp-addon' ),
					'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/widget-4-8.png'
				),
				'6-3-3' => array(
					'title' => esc_html__( 'Column 6/3/3', 'consultxp-addon' ),
					'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/widget-6-3-3.png'
				),
				'8-4' => array(
					'title' => esc_html__( 'Column 8/4', 'consultxp-addon' ),
					'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/widget-8-4.png'
				)
			),
			'default' => '12',
			'required'		=> array( 'footer-middle-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'footer-widget-1',
			'type'			=> 'sidebars',
			'title'			=> esc_html__( 'Footer Widgets Area 1', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Choose widget for footer widget area 1', 'consultxp-addon' ),
			'default'		=> '',
			'required'		=> array( 'footer-middle-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'footer-widget-2',
			'type'			=> 'sidebars',
			'title'			=> esc_html__( 'Footer Widgets Area 2', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Choose widget for footer widget area 2', 'consultxp-addon' ),
			'default'		=> '',
			'required'		=> array( 'footer-widgets-layout', '!=', array( '12' ) )
		),
		array(
			'id'			=> 'footer-widget-3',
			'type'			=> 'sidebars',
			'title'			=> esc_html__( 'Footer Widgets Area 3', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Choose widget for footer widget area 3', 'consultxp-addon' ),
			'default'		=> '',
			'required'		=> array( 'footer-widgets-layout', '=', array( '3-3-3-3', '3-3-6', '4-4-4', '6-3-3' ) )
		),
		array(
			'id'			=> 'footer-widget-4',
			'type'			=> 'sidebars',
			'title'			=> esc_html__( 'Footer Widgets Area 4', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Choose widget for footer widget area 4', 'consultxp-addon' ),
			'default'		=> '',
			'required'		=> array( 'footer-widgets-layout', '=', array( '3-3-3-3' ) )
		),
	)
) );
Consultxp_Options::consultxp_set_sub_section( array(
	'title'      => esc_html__( 'Copyright Section', 'consultxp-addon' ),
	'id'         => 'copyright-section',
	'config_id'  => '',
	'fields'	 => array(
		array(
			'id'			=> 'footer-bottom-chk',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Footer Widgets Settings', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Choose custom to edit footer middle settings options.', 'consultxp-addon' ),
			'choices'		=> array(
				'default'	=> esc_html__( 'Default', 'consultxp-addon' ),
				'custom'	=> esc_html__( 'Custom', 'consultxp-addon' )
			),
			'default'		=> 'default'
		),
		array(
			'id'			=> 'footer-bottom-layout',
			'type'			=> 'radioimage',
			'title'			=> esc_html__( 'Footer Bottom Layout', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Choose footer bottom layout either wide or boxed.', 'consultxp-addon' ),
			'items'		=> array(
				'wide' => array(
					'title' => esc_html__( 'Wide', 'consultxp-addon' ),
					'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/footer-wide.png'
				),
				'boxed' => array(
					'title' => esc_html__( 'Boxed', 'consultxp-addon' ),
					'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/footer-boxed.png'
				)
			),
			'default' => 'boxed',
			'required'		=> array( 'footer-bottom-chk', '=', array( 'custom' ) )
		),
	)
) );
Consultxp_Options::consultxp_set_end_section( array(
	'id'		=> 'footer-end'	
));


/*
//All Fields
Consultxp_Options::consultxp_set_section( array(
	'title'      => esc_html__( 'All Fields', 'consultxp-addon' ),
	'id'         => 'all-fields'
) );
Consultxp_Options::consultxp_set_sub_section( array(
	'title'      => esc_html__( 'Fields', 'consultxp-addon' ),
	'id'         => 'un-fields-tab',
	'fields'	 => array(
		array(
			'id'			=> 'test_text_field',
			'type'			=> 'text',
			'title'			=> esc_html__( 'Text Field', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is text field', 'consultxp-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'test_textarea_field',
			'type'			=> 'textarea',
			'title'			=> esc_html__( 'Textarea Field', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is textarea field', 'consultxp-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'test_select_field',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Select Field', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is select field', 'consultxp-addon' ),
			'choices'		=> array(
				'1'	=> 'One',
				'2'	=> 'Two',
				'3'	=> 'Three'
			),
			'default'		=> '2'
		),
		array(
			'id'			=> 'test_color_field',
			'type'			=> 'color',
			'title'			=> esc_html__( 'Color Field', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is color field', 'consultxp-addon' ),
			'alpha'			=> false,
			'default'		=> '#111111'
		),
		array(
			'id'			=> 'test_link_field',
			'type'			=> 'link',
			'title'			=> esc_html__( 'Link Field', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is link field', 'consultxp-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'ajax-trigger-fonts-test',
			'type'			=> 'fonts',
			'title'			=> esc_html__( 'Google Fonts Field', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is fonts field', 'consultxp-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'background_test',
			'type'			=> 'background',
			'title'			=> esc_html__( 'Background Field', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is background field', 'consultxp-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'image_test',
			'type'			=> 'image',
			'title'			=> esc_html__( 'Image Field', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is image field', 'consultxp-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'border_test',
			'type'			=> 'border',
			'title'			=> esc_html__( 'Border Field', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is border field', 'consultxp-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'dimension_test',
			'type'			=> 'dimension',
			'title'			=> esc_html__( 'Dimension Field', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is dimension field', 'consultxp-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'hw_test',
			'type'			=> 'hw',
			'title'			=> esc_html__( 'Width/Height Field', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is width height field', 'consultxp-addon' ),
			'only_dimension' => 'both'
		),
		array(
			'id'			=> 'toggle_test',
			'type'			=> 'toggle',
			'title'			=> esc_html__( 'Toggle Field', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is toggle field', 'consultxp-addon' )
		),
		array(
			'id'			=> 'sidebars_test',
			'type'			=> 'sidebars',
			'title'			=> esc_html__( 'Sidebars Field', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is sidebars field', 'consultxp-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'pages_test',
			'type'			=> 'pages',
			'title'			=> esc_html__( 'Pages Field', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is pages field', 'consultxp-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'multicheck_test',
			'type'			=> 'multicheck',
			'title'			=> esc_html__( 'Multi Check Field', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is multi check box field', 'consultxp-addon' ),
			'items'		=> array(
				'one' => esc_html__( 'One', 'consultxp-addon' ),
				'two' => esc_html__( 'Two', 'consultxp-addon' ),
				'three' => esc_html__( 'Three', 'consultxp-addon' ),
				'four' => esc_html__( 'Four', 'consultxp-addon' ),
				'five' => esc_html__( 'Five', 'consultxp-addon' )
			)
		),
		array(
			'id'			=> 'radioimage_test',
			'type'			=> 'radioimage',
			'title'			=> esc_html__( 'Radio Image Field', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is radio image field', 'consultxp-addon' ),
			'items'		=> array(
				'right-sidebar' => array(
					'title' => esc_html__( 'Right Sidebar', 'consultxp-addon' ),
					'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-right.png'
				),
				'left-sidebar' => array(
					'title' => esc_html__( 'Left Sidebar', 'consultxp-addon' ),
					'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-left.png'
				),
				'both-sidebar' => array(
					'title' => esc_html__( 'Both Sidebar', 'consultxp-addon' ),
					'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-both.png'
				),
				'no-sidebar' => array(
					'title' => esc_html__( 'No Sidebar', 'consultxp-addon' ),
					'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/no-sidebar.png'
				)
			),
			'default' => 'left-sidebar'
		),
		array(
			'id'			=> 'dragdrop_test',
			'type'			=> 'dragdrop',
			'title'			=> esc_html__( 'Drag Drop Field', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is drag and drop field', 'consultxp-addon' ),
			'default'		=> array(
				'enabled' => array(
					'one' => esc_html__( 'One', 'consultxp-addon' ),
					'two' => esc_html__( 'Two', 'consultxp-addon' )
				),
				'disabled' => array(
					'three' => esc_html__( 'Three', 'consultxp-addon' ),
					'four' => esc_html__( 'Four', 'consultxp-addon' ),
					'five' => esc_html__( 'Five', 'consultxp-addon' )
				)
			)
		),
		array(
			'id'			=> 'test_label_field',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Label Field', 'consultxp-addon' ),
			'description'	=> esc_html__( 'This is label field', 'consultxp-addon' ),
			'seperator'		=> 'after'
		),
	)
) );
Consultxp_Options::consultxp_set_end_section( array(
	'id'		=> 'all-fields-end'	
));*/