<?php 

//CEA Templates Fields
Consultxp_Options::consultxp_set_section( array(
	'title'      => esc_html__( 'CEA Templates', 'consultxp-addon' ),
	'id'         => 'cea-templates',
	'config_id'  => 'customizer_settings_cea_templates',
) );
Consultxp_Options::consultxp_set_sub_section( array(
	'title'      => esc_html__( 'CEA Service', 'consultxp-addon' ),
	'id'         => 'cea-service-single-tab',
	'config_id'  => 'customizer_settings_cea_templates',
	'fields'	 => array(
		array(
			'id'			=> 'cea-service-pt-settings',
			'type'			=> 'label',
			'title'			=> esc_html__( 'CEA Service Page Title Settings', 'consultxp-addon' ),
			'desc'	=> esc_html__( 'This is settings for CEA service title.', 'consultxp-addon' ),
			'seperator'		=> 'after'
		),
		array(
			'id'			=> 'cea-service-title',
			'type'			=> 'toggle',
			'title'			=> esc_html__( 'Enable/Disable Page Title', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Toggle to display the page title in the CEA service title section.', 'consultxp-addon' ),
			'default'		=> true
		),
		array(
			'id'			=> 'cea-service-settings',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Cea Service Layout Settings', 'consultxp-addon' ),
			'desc'	=> esc_html__( 'Here you can control all Services Layout settings.', 'consultxp-addon' ),
			'seperator'		=> 'before',
			'show_edit_icon' => true,
			'fields'		=> array(
				array(
					'id'			=> 'cea-service-sidebar-layout',
					'type'			=> 'radioimage',
					'title'			=> esc_html__( 'CEA Service Sidebar Layout', 'consultxp-addon' ),
					'description'	=> esc_html__( 'Choose the position of the CEA service sidebar, such as left, right, both or no-sidebar (full-width).', 'consultxp-addon' ),
					'items'		=> array(
						'right-sidebar' => array(
							'title' => esc_html__( 'Right Sidebar', 'consultxp-addon' ),
							'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-right.png'
						),
						'left-sidebar' => array(
							'title' => esc_html__( 'Left Sidebar', 'consultxp-addon' ),
							'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-left.png'
						),
						'both-sidebar' => array(
							'title' => esc_html__( 'Both Sidebar', 'consultxp-addon' ),
							'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-both.png'
						),
						'no-sidebar' => array(
							'title' => esc_html__( 'No Sidebar', 'consultxp-addon' ),
							'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/no-sidebar.png'
						)
					),
					'default' => 'right-sidebar'
				),
				array(
					'id'			=> 'cea-service-right-sidebar',
					'type'			=> 'sidebars',
					'title'			=> esc_html__( 'Right Widgets Area', 'consultxp-addon' ),
					'description'	=> esc_html__( 'Select and add widget to the right sidebar area of the CEA Service.', 'consultxp-addon' ),
					'default'		=> '',
					'required'		=> array( 'cea-service-sidebar-layout', '=', array( 'right-sidebar', 'both-sidebar' ) )
				),
				array(
					'id'			=> 'cea-service-left-sidebar',
					'type'			=> 'sidebars',
					'title'			=> esc_html__( 'Left Widgets Area', 'consultxp-addon' ),
					'description'	=> esc_html__( 'Select and add widget to the laft sidebar area of the CEA Service.', 'consultxp-addon' ),
					'default'		=> '',
					'required'		=> array( 'cea-service-sidebar-layout', '=', array( 'left-sidebar', 'both-sidebar' ) )
				),
				array(
					'id'			=> 'cea-service-title-color',
					'type'			=> 'color',
					'title'			=> esc_html__( 'CEA Service Title Color', 'consultxp-addon' ),
					'description'	=> esc_html__( 'Set the color for the title of the CEA service.', 'consultxp-addon' ),
					'required'		=> array( 'cea-service-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'cea-service-title-desc-color',
					'type'			=> 'color',
					'title'			=> esc_html__( 'CEA Service Title Description Color', 'consultxp-addon' ),
					'description'	=> esc_html__( 'Set the color for the description of the CEA Service Title.', 'consultxp-addon' ),
					'required'		=> array( 'cea-service-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'cea-service-title-link-color',
					'type'			=> 'link',
					'title'			=> esc_html__( 'CEA Service Title Link Color', 'consultxp-addon' ),
					'description'	=> esc_html__( 'Set the color for the hyperlinks of the CEA Service title. Like breadcrumbs color.', 'consultxp-addon' ),
					'default'		=> '',
					'required'		=> array( 'cea-service-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'cea-service-title-padding',
					'type'			=> 'dimension',
					'title'			=> esc_html__( 'CEA Service Title Padding', 'consultxp-addon' ),
					'description'	=> esc_html__( 'Adjust the padding (inner spacing) around the CEA Service Title section.', 'consultxp-addon' ),
					'default'		=> '',
					'required'		=> array( 'cea-service-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'cea-service-title-bg',
					'type'			=> 'background',
					'title'			=> esc_html__( 'CEA Service Page Title Background Options', 'consultxp-addon' ),
					'description'	=> esc_html__( 'Choose background settings for the CEA Service Title section, including color, image, size, etc.', 'consultxp-addon' ),
					'required'		=> array( 'cea-service-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'cea-service-overlaycolor',
					'type'			=> 'color',
					'alpha'			=> true,
					'title'			=> esc_html__( 'Service Page Title Overlay Color', 'consultxp-addon' ),
					'description'	=> esc_html__( 'Set the overlay color for the CEA Service title background. Choose light colors to make it displayed over the image.', 'consultxp-addon' ),
					'required'		=> array( 'cea-service-title', '=', array( 'true' ) )
				),
			),
		),
		array(
			'id'			=> 'cea-service-title-items',
			'type'			=> 'dragdrop-editor',
			'title'			=> esc_html__( 'CEA Service Page Title Elements', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Arrange and customize the elements in the CEA Service Page Title section using a drag-and-drop interface.', 'consultxp-addon' ),
			'default'		=> array(
				'left' => array(
				),
				'center' => array(
					'title' => esc_html__( 'Title', 'consultxp-addon' ),
					'breadcrumb' => esc_html__( 'Breadcrumb', 'consultxp-addon' )
				),
				'right' => array(
				),
				'disabled' => array(
					'description' => esc_html__( 'Description', 'consultxp-addon' )
				)
			),
		),
	)
) );
Consultxp_Options::consultxp_set_sub_section( array(
	'title'      => esc_html__( 'CEA Team', 'consultxp-addon' ),
	'id'         => 'cea-team-single-tab',
	'config_id'  => 'customizer_settings_cea_templates',
	'fields'	 => array(
		array(
			'id'			=> 'cea-team-pt-settings',
			'type'			=> 'label',
			'title'			=> esc_html__( 'CEA Team Page Title Settings', 'consultxp-addon' ),
			'desc'	=> esc_html__( 'This is settings for CEA team page title.', 'consultxp-addon' ),
			'seperator'		=> 'after'
		),
		array(
			'id'			=> 'cea-team-title',
			'type'			=> 'toggle',
			'title'			=> esc_html__( 'Enable/Disable Page Title', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Toggle to display the page title in the CEA Team title section.', 'consultxp-addon' ),
			'default'		=> true
		),
		array(
			'id'			=> 'cea-team-settings',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Cea Team Layout Settings', 'consultxp-addon' ),
			'desc'	=> esc_html__( 'Here you can control all Team Layout settings.', 'consultxp-addon' ),
			'seperator'		=> 'before',
			'show_edit_icon' => true,
			'fields'		=> array(
				array(
					'id'			=> 'cea-team-sidebar-layout',
					'type'			=> 'radioimage',
					'title'			=> esc_html__( 'CEA Team Sidebar Layout', 'consultxp-addon' ),
					'description'	=> esc_html__( 'Choose the position of the CEA Team sidebar, such as left, right, both or no-sidebar (full-width).', 'consultxp-addon' ),
					'items'		=> array(
						'right-sidebar' => array(
							'title' => esc_html__( 'Right Sidebar', 'consultxp-addon' ),
							'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-right.png'
						),
						'left-sidebar' => array(
							'title' => esc_html__( 'Left Sidebar', 'consultxp-addon' ),
							'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-left.png'
						),
						'both-sidebar' => array(
							'title' => esc_html__( 'Both Sidebar', 'consultxp-addon' ),
							'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-both.png'
						),
						'no-sidebar' => array(
							'title' => esc_html__( 'No Sidebar', 'consultxp-addon' ),
							'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/no-sidebar.png'
						)
					),
					'default' => 'right-sidebar'
				),
				array(
					'id'			=> 'cea-team-right-sidebar',
					'type'			=> 'sidebars',
					'title'			=> esc_html__( 'Right Widgets Area', 'consultxp-addon' ),
					'description'	=> esc_html__( 'Select and add widget to the right sidebar area of the CEA Team.', 'consultxp-addon' ),
					'default'		=> '',
					'required'		=> array( 'cea-team-sidebar-layout', '=', array( 'right-sidebar', 'both-sidebar' ) )
				),
				array(
					'id'			=> 'cea-team-left-sidebar',
					'type'			=> 'sidebars',
					'title'			=> esc_html__( 'Left Widgets Area', 'consultxp-addon' ),
					'description'	=> esc_html__( 'Select and add widget to the left sidebar area of the CEA Team.', 'consultxp-addon' ),
					'default'		=> '',
					'required'		=> array( 'cea-team-sidebar-layout', '=', array( 'left-sidebar', 'both-sidebar' ) )
				),
				array(
					'id'			=> 'cea-team-title-color',
					'type'			=> 'color',
					'title'			=> esc_html__( 'CEA Team Title Color', 'consultxp-addon' ),
					'description'	=> esc_html__( 'Set the color for the title of the CEA Team.', 'consultxp-addon' ),
					'required'		=> array( 'cea-team-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'cea-team-title-desc-color',
					'type'			=> 'color',
					'title'			=> esc_html__( 'CEA Team Title Description Color', 'consultxp-addon' ),
					'description'	=> esc_html__( 'Set the color for the description of the CEA Team Title.', 'consultxp-addon' ),
					'required'		=> array( 'cea-team-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'cea-team-title-link-color',
					'type'			=> 'link',
					'title'			=> esc_html__( 'CEA Team Title Link Color', 'consultxp-addon' ),
					'description'	=> esc_html__( 'Set the color for the hyperlinks of the CEA Team title. Like breadcrumbs color.', 'consultxp-addon' ),
					'default'		=> '',
					'required'		=> array( 'cea-team-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'cea-team-title-padding',
					'type'			=> 'dimension',
					'title'			=> esc_html__( 'CEA Team Title Padding', 'consultxp-addon' ),
					'description'	=> esc_html__( 'Adjust the padding (inner spacing) around the CEA Team Title section.', 'consultxp-addon' ),
					'default'		=> '',
					'required'		=> array( 'cea-team-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'cea-team-title-bg',
					'type'			=> 'background',
					'title'			=> esc_html__( 'CEA Team Page Title Background Options', 'consultxp-addon' ),
					'description'	=> esc_html__( 'Choose background settings for the CEA Team Title section, including color, image, size, etc.', 'consultxp-addon' ),
					'required'		=> array( 'cea-team-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'cea-team-overlaycolor',
					'type'			=> 'color',
					'alpha'			=> true,
					'title'			=> esc_html__( 'Team Page Title Overlay Color', 'consultxp-addon' ),
					'description'	=> esc_html__( 'Set the overlay color for the CEA Team title background. Choose light colors to make it displayed over the image.', 'consultxp-addon' ),
					'required'		=> array( 'cea-team-title', '=', array( 'true' ) )
				),
			),
		),
		array(
			'id'			=> 'cea-team-title-items',
			'type'			=> 'dragdrop-editor',
			'title'			=> esc_html__( 'CEA Team Page Title Elements', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Arrange and customize the elements in the CEA Team Page Title section using a drag-and-drop interface.', 'consultxp-addon' ),
			'default'		=> array(
				'left' => array(
				),
				'center' => array(
					'title' => esc_html__( 'Title', 'consultxp-addon' ),
					'breadcrumb' => esc_html__( 'Breadcrumb', 'consultxp-addon' )
				),
				'right' => array(
				),
				'disabled' => array(
					'description' => esc_html__( 'Description', 'consultxp-addon' )
				)
			),
		),
	)
) );
Consultxp_Options::consultxp_set_sub_section( array(
	'title'      => esc_html__( 'CEA Testimonial', 'consultxp-addon' ),
	'id'         => 'cea-testimonial-single-tab',
	'config_id'  => 'customizer_settings_cea_templates',
	'fields'	 => array(
		array(
			'id'			=> 'cea-testimonial-pt-settings',
			'type'			=> 'label',
			'title'			=> esc_html__( 'CEA Testimonial Page Title Settings', 'consultxp-addon' ),
			'desc'	=> esc_html__( 'This is settings for CEA testimonial page title.', 'consultxp-addon' ),
			'seperator'		=> 'after'
		),
		array(
			'id'			=> 'cea-testimonial-title',
			'type'			=> 'toggle',
			'title'			=> esc_html__( 'Enable/Disable Page Title', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Toggle to display the page title in the CEA Testimonial title section.', 'consultxp-addon' ),
			'default'		=> true
		),
		array(
			'id'			=> 'cea-testimonial-settings',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Cea Testimonial Layout Settings', 'consultxp-addon' ),
			'desc'	=> esc_html__( 'Here you can control all Testimonial Layout settings.', 'consultxp-addon' ),
			'seperator'		=> 'before',
			'show_edit_icon' => true,
			'fields'		=> array(
				array(
					'id'			=> 'cea-testimonial-title-color',
					'type'			=> 'color',
					'title'			=> esc_html__( 'CEA Testimonial Title Color', 'consultxp-addon' ),
					'description'	=> esc_html__( 'Set the color for the title of the CEA Testimonial.', 'consultxp-addon' ),
					'required'		=> array( 'cea-testimonial-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'cea-testimonial-title-desc-color',
					'type'			=> 'color',
					'title'			=> esc_html__( 'CEA Testimonial Title Description Color', 'consultxp-addon' ),
					'description'	=> esc_html__( 'Set the color for the description of the CEA Testimonial Title.', 'consultxp-addon' ),
					'required'		=> array( 'cea-testimonial-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'cea-testimonial-title-link-color',
					'type'			=> 'link',
					'title'			=> esc_html__( 'CEA Testimonial Title Link Color', 'consultxp-addon' ),
					'description'	=> esc_html__( 'Set the color for the hyperlinks of the CEA Testimonial title. Like breadcrumbs color.', 'consultxp-addon' ),
					'default'		=> '',
					'required'		=> array( 'cea-testimonial-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'cea-testimonial-title-padding',
					'type'			=> 'dimension',
					'title'			=> esc_html__( 'CEA Testimonial Title Padding', 'consultxp-addon' ),
					'description'	=> esc_html__( 'Adjust the padding (inner spacing) around the CEA Testimonial Title section.', 'consultxp-addon' ),
					'default'		=> '',
					'required'		=> array( 'cea-testimonial-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'cea-testimonial-title-bg',
					'type'			=> 'background',
					'title'			=> esc_html__( 'CEA Testimonial Page Title Background Options', 'consultxp-addon' ),
					'description'	=> esc_html__( 'Choose background settings for the CEA Testimonial Title section, including color, image, size, etc.', 'consultxp-addon' ),
					'required'		=> array( 'cea-testimonial-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'cea-testimonial-overlaycolor',
					'type'			=> 'color',
					'alpha'			=> true,
					'title'			=> esc_html__( 'Testimonial Page Title Overlay Color', 'consultxp-addon' ),
					'description'	=> esc_html__( 'Set the overlay color for the CEA Testimonial title background. Choose light colors to make it displayed over the image.', 'consultxp-addon' ),
					'required'		=> array( 'cea-testimonial-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'cea-testimonial-sidebar-layout',
					'type'			=> 'radioimage',
					'title'			=> esc_html__( 'CEA Testimonial Sidebar Layout', 'consultxp-addon' ),
					'description'	=> esc_html__( 'Choose the position of the CEA Testimonial sidebar, such as left, right, both or no-sidebar (full-width).', 'consultxp-addon' ),
					'items'		=> array(
						'right-sidebar' => array(
							'title' => esc_html__( 'Right Sidebar', 'consultxp-addon' ),
							'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-right.png'
						),
						'left-sidebar' => array(
							'title' => esc_html__( 'Left Sidebar', 'consultxp-addon' ),
							'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-left.png'
						),
						'both-sidebar' => array(
							'title' => esc_html__( 'Both Sidebar', 'consultxp-addon' ),
							'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-both.png'
						),
						'no-sidebar' => array(
							'title' => esc_html__( 'No Sidebar', 'consultxp-addon' ),
							'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/no-sidebar.png'
						)
					),
					'default' => 'right-sidebar'
				),
				array(
					'id'			=> 'cea-testimonial-right-sidebar',
					'type'			=> 'sidebars',
					'title'			=> esc_html__( 'Right Widgets Area', 'consultxp-addon' ),
					'description'	=> esc_html__( 'Select and add widget to the right sidebar area of the CEA Testimonial.', 'consultxp-addon' ),
					'default'		=> '',
					'required'		=> array( 'cea-testimonial-sidebar-layout', '=', array( 'right-sidebar', 'both-sidebar' ) )
				),
				array(
					'id'			=> 'cea-testimonial-left-sidebar',
					'type'			=> 'sidebars',
					'title'			=> esc_html__( 'Left Widgets Area', 'consultxp-addon' ),
					'description'	=> esc_html__( 'Select and add widget to the left sidebar area of the CEA Testimonial.', 'consultxp-addon' ),
					'default'		=> '',
					'required'		=> array( 'cea-testimonial-sidebar-layout', '=', array( 'left-sidebar', 'both-sidebar' ) )
				),
			),
		),
		array(
			'id'			=> 'cea-testimonial-title-items',
			'type'			=> 'dragdrop-editor',
			'title'			=> esc_html__( 'CEA Testimonial Page Title Elements', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Arrange and customize the elements in the CEA Testimonial Page Title section using a drag-and-drop interface.', 'consultxp-addon' ),
			'default'		=> array(
				'left' => array(
				),
				'center' => array(
					'title' => esc_html__( 'Title', 'consultxp-addon' ),
					'breadcrumb' => esc_html__( 'Breadcrumb', 'consultxp-addon' )
				),
				'right' => array(
				),
				'disabled' => array(
					'description' => esc_html__( 'Description', 'consultxp-addon' )
				)
			),
		),
	)
) );
Consultxp_Options::consultxp_set_sub_section( array(
	'title'      => esc_html__( 'CEA Portfolio', 'consultxp-addon' ),
	'id'         => 'cea-portfolio-single-tab',
	'config_id'  => 'customizer_settings_cea_templates',
	'fields'	 => array(
		array(
			'id'			=> 'cea-portfolio-pt-settings',
			'type'			=> 'label',
			'title'			=> esc_html__( 'CEA Portfolio Page Title Settings', 'consultxp-addon' ),
			'desc'	=> esc_html__( 'This is settings for CEA portfolio page title.', 'consultxp-addon' ),
			'seperator'		=> 'after'
		),
		array(
			'id'			=> 'cea-portfolio-title',
			'type'			=> 'toggle',
			'title'			=> esc_html__( 'Enable/Disable Page Title', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Toggle to display the page title in the CEA Portfolio title section.', 'consultxp-addon' ),
			'default'		=> true
		),
		array(
			'id'			=> 'cea-portfolio-settings',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Cea Portfolio Layout Settings', 'consultxp-addon' ),
			'desc'	=> esc_html__( 'Here you can control all Portfolio Layout settings.', 'consultxp-addon' ),
			'seperator'		=> 'before',
			'show_edit_icon' => true,
			'fields'		=> array(
				array(
					'id'			=> 'cea-portfolio-title-color',
					'type'			=> 'color',
					'title'			=> esc_html__( 'CEA Portfolio Title Color', 'consultxp-addon' ),
					'description'	=> esc_html__( 'Set the color for the title of the CEA Portfolio.', 'consultxp-addon' ),
					'required'		=> array( 'cea-portfolio-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'cea-portfolio-title-desc-color',
					'type'			=> 'color',
					'title'			=> esc_html__( 'CEA Portfolio Title Description Color', 'consultxp-addon' ),
					'description'	=> esc_html__( 'Set the color for the description of the CEA Portfolio Title.', 'consultxp-addon' ),
					'required'		=> array( 'cea-portfolio-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'cea-portfolio-title-link-color',
					'type'			=> 'link',
					'title'			=> esc_html__( 'CEA Portfolio Title Link Color', 'consultxp-addon' ),
					'description'	=> esc_html__( 'Set the color for the hyperlinks of the CEA Portfolio title. Like breadcrumbs color.', 'consultxp-addon' ),
					'default'		=> '',
					'required'		=> array( 'cea-portfolio-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'cea-portfolio-title-padding',
					'type'			=> 'dimension',
					'title'			=> esc_html__( 'CEA Portfolio Title Padding', 'consultxp-addon' ),
					'description'	=> esc_html__( 'Adjust the padding (inner spacing) around the CEA Portfolio Title section.', 'consultxp-addon' ),
					'default'		=> '',
					'required'		=> array( 'cea-portfolio-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'cea-portfolio-title-bg',
					'type'			=> 'background',
					'title'			=> esc_html__( 'CEA Portfolio Page Title Background Options', 'consultxp-addon' ),
					'description'	=> esc_html__( 'Choose background settings for the CEA Portfolio Title section, including color, image, size, etc.', 'consultxp-addon' ),
					'required'		=> array( 'cea-portfolio-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'cea-portfolio-overlaycolor',
					'type'			=> 'color',
					'alpha'			=> true,
					'title'			=> esc_html__( 'Portfolio Page Title Overlay Color', 'consultxp-addon' ),
					'description'	=> esc_html__( 'Set the overlay color for the CEA Portfolio title background. Choose light colors to make it displayed over the image.', 'consultxp-addon' ),
					'required'		=> array( 'cea-portfolio-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'cea-portfolio-sidebar-layout',
					'type'			=> 'radioimage',
					'title'			=> esc_html__( 'CEA Portfolio Sidebar Layout', 'consultxp-addon' ),
					'description'	=> esc_html__( 'Choose the position of the CEA Portfolio sidebar, such as left, right, both or no-sidebar (full-width).', 'consultxp-addon' ),
					'items'		=> array(
						'right-sidebar' => array(
							'title' => esc_html__( 'Right Sidebar', 'consultxp-addon' ),
							'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-right.png'
						),
						'left-sidebar' => array(
							'title' => esc_html__( 'Left Sidebar', 'consultxp-addon' ),
							'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-left.png'
						),
						'both-sidebar' => array(
							'title' => esc_html__( 'Both Sidebar', 'consultxp-addon' ),
							'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-both.png'
						),
						'no-sidebar' => array(
							'title' => esc_html__( 'No Sidebar', 'consultxp-addon' ),
							'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/no-sidebar.png'
						)
					),
					'default' => 'right-sidebar'
				),
				array(
					'id'			=> 'cea-portfolio-right-sidebar',
					'type'			=> 'sidebars',
					'title'			=> esc_html__( 'Right Widgets Area', 'consultxp-addon' ),
					'description'	=> esc_html__( 'Select and add widget to the right sidebar area of the CEA Portfolio.', 'consultxp-addon' ),
					'default'		=> '',
					'required'		=> array( 'cea-portfolio-sidebar-layout', '=', array( 'right-sidebar', 'both-sidebar' ) )
				),
				array(
					'id'			=> 'cea-portfolio-left-sidebar',
					'type'			=> 'sidebars',
					'title'			=> esc_html__( 'Left Widgets Area', 'consultxp-addon' ),
					'description'	=> esc_html__( 'Select and add widget to the left sidebar area of the CEA Portfolio.', 'consultxp-addon' ),
					'default'		=> '',
					'required'		=> array( 'cea-portfolio-sidebar-layout', '=', array( 'left-sidebar', 'both-sidebar' ) )
				),
			),
		),
		array(
			'id'			=> 'cea-portfolio-title-items',
			'type'			=> 'dragdrop-editor',
			'title'			=> esc_html__( 'CEA Portfolio Page Title Elements', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Arrange and customize the elements in the CEA Portfolio Page Title section using a drag-and-drop interface.', 'consultxp-addon' ),
			'default'		=> array(
				'left' => array(
				),
				'center' => array(
					'title' => esc_html__( 'Title', 'consultxp-addon' ),
					'breadcrumb' => esc_html__( 'Breadcrumb', 'consultxp-addon' )
				),
				'right' => array(
				),
				'disabled' => array(
					'description' => esc_html__( 'Description', 'consultxp-addon' )
				)
			),
		),
	)
) );
Consultxp_Options::consultxp_set_sub_section( array(
	'title'      => esc_html__( 'CEA Event', 'consultxp-addon' ),
	'id'         => 'cea-event-single-tab',
	'config_id'  => 'customizer_settings_cea_templates',
	'fields'	 => array(
		array(
			'id'			=> 'cea-event-pt-settings',
			'type'			=> 'label',
			'title'			=> esc_html__( 'CEA Event Page Title Settings', 'consultxp-addon' ),
			'desc'	=> esc_html__( 'This is settings for CEA event page title.', 'consultxp-addon' ),
			'seperator'		=> 'after'
		),
		array(
			'id'			=> 'cea-event-title',
			'type'			=> 'toggle',
			'title'			=> esc_html__( 'Enable/Disable Page Title', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Toggle to display the page title in the CEA Event title section.', 'consultxp-addon' ),
			'default'		=> true
		),
		array(
			'id'			=> 'cea-event-settings',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Cea Event Layout Settings', 'consultxp-addon' ),
			'desc'	=> esc_html__( 'Here you can control all Event Layout settings.', 'consultxp-addon' ),
			'seperator'		=> 'before',
			'show_edit_icon' => true,
			'fields'		=> array(
				array(
					'id'			=> 'cea-event-title-color',
					'type'			=> 'color',
					'title'			=> esc_html__( 'CEA Event Title Color', 'consultxp-addon' ),
					'description'	=> esc_html__( 'Set the color for the title of the CEA Event.', 'consultxp-addon' ),
					'required'		=> array( 'cea-event-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'cea-event-title-desc-color',
					'type'			=> 'color',
					'title'			=> esc_html__( 'CEA Event Title Description Color', 'consultxp-addon' ),
					'description'	=> esc_html__( 'Set the color for the description of the CEA Event Title.', 'consultxp-addon' ),
					'required'		=> array( 'cea-event-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'cea-event-title-link-color',
					'type'			=> 'link',
					'title'			=> esc_html__( 'CEA Event Title Link Color', 'consultxp-addon' ),
					'description'	=> esc_html__( 'Set the color for the hyperlinks of the CEA Event title. Like breadcrumbs color.', 'consultxp-addon' ),
					'default'		=> '',
					'required'		=> array( 'cea-event-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'cea-event-title-padding',
					'type'			=> 'dimension',
					'title'			=> esc_html__( 'Custom Single Title Padding', 'consultxp-addon' ),
					'description'	=> esc_html__( 'Adjust the padding (inner spacing) around the CEA Event Title section.', 'consultxp-addon' ),
					'default'		=> '',
					'required'		=> array( 'cea-event-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'cea-event-title-bg',
					'type'			=> 'background',
					'title'			=> esc_html__( 'CEA Event Page Title Background Options', 'consultxp-addon' ),
					'description'	=> esc_html__( 'Choose background settings for the CEA Event Title section, including color, image, size, etc.', 'consultxp-addon' ),
					'required'		=> array( 'cea-event-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'cea-event-overlaycolor',
					'type'			=> 'color',
					'alpha'			=> true,
					'title'			=> esc_html__( 'Event Page Title Overlay Color', 'consultxp-addon' ),
					'description'	=> esc_html__( 'Set the overlay color for the CEA Event title background. Choose light colors to make it displayed over the image.', 'consultxp-addon' ),
					'required'		=> array( 'cea-event-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'cea-event-sidebar-layout',
					'type'			=> 'radioimage',
					'title'			=> esc_html__( 'CEA Event Sidebar Layout', 'consultxp-addon' ),
					'description'	=> esc_html__( 'Choose the position of the CEA Event sidebar, such as left, right, both or no-sidebar (full-width).', 'consultxp-addon' ),
					'items'		=> array(
						'right-sidebar' => array(
							'title' => esc_html__( 'Right Sidebar', 'consultxp-addon' ),
							'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-right.png'
						),
						'left-sidebar' => array(
							'title' => esc_html__( 'Left Sidebar', 'consultxp-addon' ),
							'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-left.png'
						),
						'both-sidebar' => array(
							'title' => esc_html__( 'Both Sidebar', 'consultxp-addon' ),
							'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-both.png'
						),
						'no-sidebar' => array(
							'title' => esc_html__( 'No Sidebar', 'consultxp-addon' ),
							'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/no-sidebar.png'
						)
					),
					'default' => 'right-sidebar'
				),
				array(
					'id'			=> 'cea-event-right-sidebar',
					'type'			=> 'sidebars',
					'title'			=> esc_html__( 'Right Widgets Area', 'consultxp-addon' ),
					'description'	=> esc_html__( 'Select and add widget to the right sidebar area of the CEA Event.', 'consultxp-addon' ),
					'default'		=> '',
					'required'		=> array( 'cea-event-sidebar-layout', '=', array( 'right-sidebar', 'both-sidebar' ) )
				),
				array(
					'id'			=> 'cea-event-left-sidebar',
					'type'			=> 'sidebars',
					'title'			=> esc_html__( 'Left Widgets Area', 'consultxp-addon' ),
					'description'	=> esc_html__( 'Select and add widget to the left sidebar area of the CEA Event.', 'consultxp-addon' ),
					'default'		=> '',
					'required'		=> array( 'cea-event-sidebar-layout', '=', array( 'left-sidebar', 'both-sidebar' ) )
				),
			),
		),
		array(
			'id'			=> 'cea-event-title-items',
			'type'			=> 'dragdrop-editor',
			'title'			=> esc_html__( 'CEA Event Page Title Elements', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Arrange and customize the elements in the CEA Event Page Title section using a drag-and-drop interface.', 'consultxp-addon' ),
			'default'		=> array(
				'left' => array(
				),
				'center' => array(
					'title' => esc_html__( 'Title', 'consultxp-addon' ),
					'breadcrumb' => esc_html__( 'Breadcrumb', 'consultxp-addon' )
				),
				'right' => array(
				),
				'disabled' => array(
					'description' => esc_html__( 'Description', 'consultxp-addon' )
				)
			),
		),
	)
) );
Consultxp_Options::consultxp_set_end_section( array(
	'id'		=> 'cea-templates-tab-end'	
));