<?php
class Consultxp_Theme_Styles {
   
   	public $consultxp_options;
	private $exists_fonts = array();
	public static $consultxp_gf_array = array();
   
    function __construct() {
		$this->consultxp_options = get_option( 'consultxp_options' );
    }

	function consultxp_get_option($field){
		$consultxp_options = $this->consultxp_options;
		return isset( $consultxp_options[$field] ) && $consultxp_options[$field] != '' ? $consultxp_options[$field] : '';
	}
	
	function consultxp_dimension_settings($field, $property = 'width'){
		$consultxp_options = $this->consultxp_options;
		$units = 'px'; $dimension = '';
		if( isset( $consultxp_options[$field] ) ){
			$units = isset( $consultxp_options[$field]['units'] ) ? $consultxp_options[$field]['units'] : $units;
			$dimension = isset( $consultxp_options[$field][$property] ) && $consultxp_options[$field][$property] != '' ? absint( $consultxp_options[$field][$property] ) . $units : '';
		}
		return $dimension;
	}

	function consultxp_image_settings($field){
		$consultxp_options = $this->consultxp_options;
		$img_arr = array(
			'id' => null,
			'url' => null
		);
		$image = isset( $consultxp_options[$field] ) && isset( $consultxp_options[$field]['image'] ) ? $consultxp_options[$field]['image'] : '';
		if( !empty( $image ) ){
			$img_arr['id'] = isset( $image['id'] ) ? $image['id'] : null;
			$img_arr['url'] = isset( $image['url'] ) ? $image['url'] : null;
		}
		return $img_arr;
	}
	
	function consultxp_border_settings($field, $class_names = null){
		$consultxp_options = $this->consultxp_options;

		if( isset( $consultxp_options[$field] ) ):

			$stat = false;
			$position = array( 'top', 'right', 'bottom', 'left' );
			foreach( $position as $key ){
				if( isset( $consultxp_options[$field][$key] ) && $consultxp_options[$field][$key] != NULL && !$stat ) $stat = true;
			}
		
			$boder_style = isset( $consultxp_options[$field]['style'] ) && $consultxp_options[$field]['style'] != '' ? $consultxp_options[$field]['style'] : '';
			$border_color = isset( $consultxp_options[$field]['color'] ) && $consultxp_options[$field]['color'] != '' ? $consultxp_options[$field]['color'] : '';

			if( $class_names && $stat ) echo $class_names . ' {';
			
			if( isset( $consultxp_options[$field]['top'] ) && $consultxp_options[$field]['top'] != NULL ):
				echo 'border-top-width: '. $consultxp_options[$field]['top'] .'px;';
				if( $boder_style ) echo 'border-top-style: '. $boder_style .';';
				if( $border_color ) echo 'border-top-color: '. $border_color .';';
			endif;
			
			if( isset( $consultxp_options[$field]['right'] ) && $consultxp_options[$field]['right'] != NULL ):
				echo 'border-right-width: '. $consultxp_options[$field]['right'] .'px;';
				if( $boder_style ) echo 'border-right-style: '. $boder_style .';';
				if( $border_color ) echo 'border-right-color: '. $border_color .';';
			endif;
			
			if( isset( $consultxp_options[$field]['bottom'] ) && $consultxp_options[$field]['bottom'] != NULL ):
				echo 'border-bottom-width: '. $consultxp_options[$field]['bottom'] .'px;';
				if( $boder_style ) echo 'border-bottom-style: '. $boder_style .';';
				if( $border_color ) echo 'border-bottom-color: '. $border_color .';';
			endif;
			
			if( isset( $consultxp_options[$field]['left'] ) && $consultxp_options[$field]['left'] != NULL ):
				echo 'border-left-width: '. $consultxp_options[$field]['left'] .'px;';
				if( $boder_style ) echo 'border-left-style: '. $boder_style .';';
				if( $border_color ) echo 'border-left-color: '. $border_color .';';
			endif;

			if( $class_names && $stat ) echo '}';
			
		endif;
	}
	
	function consultxp_padding_settings($field, $class_names = null){
		$consultxp_options = $this->consultxp_options;
		$stat = false;
		$position = array( 'top', 'right', 'bottom', 'left' );
		foreach( $position as $key ){
			if( isset( $consultxp_options[$field][$key] ) && $consultxp_options[$field][$key] != NULL && !$stat ) $stat = true;
		}
		if( isset( $consultxp_options[$field] ) ):
			if( $class_names && $stat ) echo $class_names . ' {';	
			echo isset( $consultxp_options[$field]['top'] ) && $consultxp_options[$field]['top'] != NULL ? 'padding-top: '. $consultxp_options[$field]['top'] .'px;' : '';
			echo isset( $consultxp_options[$field]['right'] ) && $consultxp_options[$field]['right'] != NULL ? 'padding-right: '. $consultxp_options[$field]['right'] .'px;' : '';
			echo isset( $consultxp_options[$field]['bottom'] ) && $consultxp_options[$field]['bottom'] != NULL ? 'padding-bottom: '. $consultxp_options[$field]['bottom'] .'px;' : '';
			echo isset( $consultxp_options[$field]['left'] ) && $consultxp_options[$field]['left'] != NULL ? 'padding-left: '. $consultxp_options[$field]['left'] .'px;' : '';
			if( $class_names && $stat ) echo '}';
		endif;
	}
	
	function consultxp_margin_settings($field, $class_names = null){
		$consultxp_options = $this->consultxp_options;
		$stat = false;
		$position = array( 'top', 'right', 'bottom', 'left' );
		foreach( $position as $key ){
			if( isset( $consultxp_options[$field][$key] ) && $consultxp_options[$field][$key] != NULL && !$stat ) $stat = true;
		}
		if( isset( $consultxp_options[$field] ) ):	
			if( $class_names && $stat ) echo $class_names . ' {';	
			echo isset( $consultxp_options[$field]['top'] ) && $consultxp_options[$field]['top'] != NULL ? 'margin-top: '. $consultxp_options[$field]['top'] .'px;' : '';
			echo isset( $consultxp_options[$field]['right'] ) && $consultxp_options[$field]['right'] != NULL ? 'margin-right: '. $consultxp_options[$field]['right'] .'px;' : '';
			echo isset( $consultxp_options[$field]['bottom'] ) && $consultxp_options[$field]['bottom'] != NULL ? 'margin-bottom: '. $consultxp_options[$field]['bottom'] .'px;' : '';
			echo isset( $consultxp_options[$field]['left'] ) && $consultxp_options[$field]['left'] != NULL ? 'margin-left: '. $consultxp_options[$field]['left'] .'px;' : '';
			if( $class_names && $stat ) echo '}';
		endif;
	}

	function consultxp_color($field, $class_names = null){
		$consultxp_options = $this->consultxp_options;
		if( isset( $consultxp_options[$field] ) && $consultxp_options[$field] != '' ) {
			if( $class_names ) echo $class_names . '{';
			echo 'color: '. $consultxp_options[$field] .';';
			if( $class_names ) echo '}';
		}
	}
	
	function consultxp_link_color($field, $fun, $class_names = null){
		$consultxp_options = $this->consultxp_options;
		if( isset( $consultxp_options[$field][$fun] ) && $consultxp_options[$field][$fun] != '' ) {
			if( $class_names ) echo $class_names . '{';
			echo 'color: '. $consultxp_options[$field][$fun] .';';
			if( $class_names ) echo '}';
		}
	}
	
	function consultxp_button_color($field, $fun, $class_names = null){
		$consultxp_options = $this->consultxp_options;
		if( isset( $consultxp_options[$field][$fun] ) && $consultxp_options[$field][$fun] != '' ) {
			if( $class_names ) echo $class_names . '{';
				switch( $fun ){
					case "hfore":
					case "fore":
						echo 'color: '. $consultxp_options[$field][$fun] .';';
					break;
					case "hbg":
					case "bg":
						echo 'background-color: '. $consultxp_options[$field][$fun] .';';
					break;
					case "hborder":
					case "border":
						echo 'border-color: '. $consultxp_options[$field][$fun] .';';
					break;
				}
			if( $class_names ) echo '}';
		}
	}
		
	function consultxp_bg_settings($field, $class_names = null){
		$consultxp_options = $this->consultxp_options;
		if( isset( $consultxp_options[$field] ) ):

			$stat = false;
			$keys = array( 'bg_color', 'bg_repeat', 'bg_position', 'bg_size', 'bg_attachment' );
			foreach( $keys as $key ){
				if( isset( $consultxp_options[$field][$key] ) && !empty( $consultxp_options[$field][$key] ) && !$stat ) $stat = true;
			}
			if( isset( $consultxp_options[$field]['image']['url'] ) && !empty( $consultxp_options[$field]['image']['url'] ) && !$stat ) $stat = true;

			if( $class_names && $stat ) echo $class_names . '{';
			echo '
			'. ( isset( $consultxp_options[$field]['bg_color'] ) && !empty( $consultxp_options[$field]['bg_color'] ) ?  'background-color: '. $consultxp_options[$field]['bg_color'] .';' : '' ) .'
			'. ( isset( $consultxp_options[$field]['image']['url'] ) && !empty( $consultxp_options[$field]['image']['url'] ) ?  'background-image: url('. $consultxp_options[$field]['image']['url'] .');' : '' ) .'
			'. ( isset( $consultxp_options[$field]['bg_repeat'] ) && !empty( $consultxp_options[$field]['bg_repeat'] ) ?  'background-repeat: '. $consultxp_options[$field]['bg_repeat'] .';' : '' ) .'
			'. ( isset( $consultxp_options[$field]['bg_position'] ) && !empty( $consultxp_options[$field]['bg_position'] ) ?  'background-position: '. $consultxp_options[$field]['bg_position'] .';' : '' ) .'
			'. ( isset( $consultxp_options[$field]['bg_size'] ) && !empty( $consultxp_options[$field]['bg_size'] ) ?  'background-size: '. $consultxp_options[$field]['bg_size'] .';' : '' ) .'
			'. ( isset( $consultxp_options[$field]['bg_attachment'] ) && !empty( $consultxp_options[$field]['bg_attachment'] ) ?  'background-attachment: '. $consultxp_options[$field]['bg_attachment'] .';' : '' ) .'
			';
			if( $class_names && $stat ) echo '}';
		endif;
	}
	
	function consultxp_custom_font_face_create( $font_family, $font_slug, $cf_names ){	
		$upload_dir = wp_upload_dir();
		$f_type = array('eot', 'otf', 'svg', 'ttf', 'woff');		
		$font_path = $upload_dir['baseurl'] . '/custom-fonts/' . str_replace( "'", "", $font_family .'/'. $font_slug );
		echo ' @font-face { font-family: '. $font_family .';';
		echo " src: url('". esc_url( $font_path ) .".eot') format('embedded-opentype'), url('". esc_url( $font_path ) .".woff2') format('woff2'), url('". esc_url( $font_path ) .".woff') format('woff'), url('". esc_url( $font_path ) .".ttf')  format('truetype'), url('". esc_url( $font_path ) .".svg') format('svg');}";		
	}
	
	function consultxp_custom_font_check($field){
		$consultxp_options = $this->consultxp_options;
		$cf_names = get_option( 'consultxp_custom_fonts' );
		$font_family = isset( $consultxp_options[$field]['font_family'] ) ? $consultxp_options[$field]['font_family'] : '';
		$font_slug = $font_family ? sanitize_title( $font_family ) : '';
		if ( !empty( $cf_names ) && is_array( $cf_names ) && array_key_exists( $font_slug, $cf_names ) ){	
			if ( !empty( $cf_names ) && !in_array( $font_slug, $this->exists_fonts ) ){
				$this->consultxp_custom_font_face_create( $font_family, $font_slug, $cf_names );
				array_push( $this->exists_fonts, $font_family );
				return 1;
			}
		}
		return 0;
	}
	
	function consultxp_get_custom_google_font_frame( $font_family ){	
		$family = isset( $font_family['family'] ) ? $font_family['family'] : '';
		$weight = isset( $font_family['weight'] ) ? $font_family['weight'] : '';
		$subset = isset( $font_family['subset'] ) ? $font_family['subset'] : '';		
		if( !empty( $family ) ){
			if( isset( self::$consultxp_gf_array[$family] ) ){
				array_push( self::$consultxp_gf_array[$family]['weight'], $weight );
				array_push( self::$consultxp_gf_array[$family]['subset'], $subset );
			}else{
				self::$consultxp_gf_array[$family] = array( 'weight' => array( $weight ), 'subset' => array( $subset ) );
			}
		}
	}
	
	function consultxp_typo_generate($field){
		$consultxp_options = $this->consultxp_options;
		$font_family = isset( $consultxp_options[$field]['font_family'] ) ? $consultxp_options[$field]['font_family'] : '';
		$standard_fonts = Consultxp_Google_Fonts_Function::$_standard_fonts;
		if( !array_key_exists( $font_family, $standard_fonts ) ){			
			$font_weight = isset( $consultxp_options[$field]['font_weight'] ) && $consultxp_options[$field]['font_weight'] != '' ? $consultxp_options[$field]['font_weight'] : '';
			$font_sub = isset( $consultxp_options[$field]['font_sub'] ) && $consultxp_options[$field]['font_sub'] != '' ? $consultxp_options[$field]['font_sub'] : '';
			$gf_arr = array( 'family' => $font_family, 'weight' => $font_weight, 'subset' => $font_sub );	
			$this->consultxp_get_custom_google_font_frame( $gf_arr );
		}
	}
	
	function consultxp_typo_settings($field, $class_names = null){
		
		//Custom font check and google font generate
		$cf_stat = $this->consultxp_custom_font_check($field);
		if( !$cf_stat ) $this->consultxp_typo_generate($field);		
		$consultxp_options = $this->consultxp_options;
		if( isset( $consultxp_options[$field] ) ):

			$stat = false;
			$keys = array( 'font_color', 'font_family', 'font_weight', 'font_style', 'font_size', 'line_height', 'letter_spacing', 'text_align', 'text_transform' );
			foreach( $keys as $key ){
				if( isset( $consultxp_options[$field][$key] ) && !empty( $consultxp_options[$field][$key] ) && !$stat ) $stat = true;
			}
			echo $class_names && $stat ? esc_attr( $class_names ) . '{' : '';
			
			$font_weight = isset( $consultxp_options[$field]['font_weight'] ) ? $consultxp_options[$field]['font_weight'] : '';
			$font_style = '';
			if( !empty( $font_weight ) && strpos( $font_weight, 'italic' ) ){
				$font_style = 'italic';
				$font_weight = str_replace( 'italic', '', $font_weight );
			}

			echo '
			'. ( isset( $consultxp_options[$field]['font_color'] ) && $consultxp_options[$field]['font_color'] != '' ?  'color: '. $consultxp_options[$field]['font_color'] .';' : '' ) .'
			'. ( isset( $consultxp_options[$field]['font_family'] ) && $consultxp_options[$field]['font_family'] != '' ?  'font-family: '. stripslashes_deep( $consultxp_options[$field]['font_family'] ) .';' : '' ) .'
			'. ( $font_weight ?  'font-weight: '. $font_weight .';' : '' ) .'
			'. ( $font_style ?  'font-style: '. $font_style .';' : '' ) .'
			'. ( isset( $consultxp_options[$field]['font_size'] ) && $consultxp_options[$field]['font_size'] != '' ?  'font-size: '. $consultxp_options[$field]['font_size'] .'px;' : '' ) .'
			'. ( isset( $consultxp_options[$field]['line_height'] ) && $consultxp_options[$field]['line_height'] != '' ?  'line-height: '. $consultxp_options[$field]['line_height'] .'px;' : '' ) .'
			'. ( isset( $consultxp_options[$field]['letter_spacing'] ) && $consultxp_options[$field]['letter_spacing'] != '' ?  'letter-spacing: '. $consultxp_options[$field]['letter_spacing'] .'px;' : '' ) .'
			'. ( isset( $consultxp_options[$field]['text_align'] ) && $consultxp_options[$field]['text_align'] != '' ?  'text-align: '. $consultxp_options[$field]['text_align'] .';' : '' ) .'
			'. ( isset( $consultxp_options[$field]['text_transform'] ) && $consultxp_options[$field]['text_transform'] != '' ?  'text-transform: '. $consultxp_options[$field]['text_transform'] .';' : '' ) .'
			';
		endif;
		echo $class_names && $stat ? '}' : '';
	}
	
	function consultxp_hex2rgba($color, $opacity = 1) {
	 
		$default = '';
		//Return default if no color provided
		if(empty($color))
			  return $default; 
		//Sanitize $color if "#" is provided 
			if ($color[0] == '#' ) {
				$color = substr( $color, 1 );
			}
			//Check if color has 6 or 3 characters and get values
			if (strlen($color) == 6) {
					$hex = array( $color[0] . $color[1], $color[2] . $color[3], $color[4] . $color[5] );
			} elseif ( strlen( $color ) == 3 ) {
					$hex = array( $color[0] . $color[0], $color[1] . $color[1], $color[2] . $color[2] );
			} else {
					return $default;
			}
			//Convert hexadec to rgb
			$rgb =  array_map('hexdec', $hex);
	 
			//Check if opacity is set(rgba or rgb)
			if( $opacity == 'none' ){
				$output = implode(",",$rgb);
			}elseif( $opacity ){
				if(abs($opacity) > 1)
					$opacity = 1.0;
				$output = 'rgba('.implode(",",$rgb).','.$opacity.')';
			}else {
				$output = 'rgb('.implode(",",$rgb).')';
			}
			//Return rgb(a) color string
			return $output;
	}

}