<?php

/**
 * Consultxp Theme Options
 * @since 1.0.0
 */
final class Consultxp_Plugin_Options { //consultxp_admin_menu_out
	
	private static $_instance = null;
	
	public function __construct() {	
		add_action( 'admin_menu', array( $this, 'consultxp_addon_options_menu' ) );
		add_action( 'admin_enqueue_scripts', array( $this, 'consultxp_framework_admin_scripts' ) );
		$this->init();

		//import
		add_action( 'wp_ajax_bridddge-theme-option-import', array( $this, 'consultxp_redux_themeopt_import' ) );

		//export
		add_action('wp_ajax_consultxp-theme-options-export', array( $this, 'consultxp_theme_options_export' ) );
		
	}
	
	public static function consultxp_addon_options_menu(){
		add_submenu_page( 
			'consultxp-welcome', 
			esc_html__( 'Theme Options', 'consultxp-addon' ),
			esc_html__( 'Theme Options', 'consultxp-addon' ), 
			'manage_options', 
			'consultxp-options', 
			array( 'Consultxp_Plugin_Options', 'consultxp_options_admin_page' )
		);
	}
	
	public static function consultxp_framework_admin_scripts(){
		if( isset( $_GET['page'] ) && $_GET['page'] == 'consultxp-options' ){
			wp_enqueue_style( 'font-awesome', CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/css/font-awesome.min.css', array(), '4.7.0', 'all' );			
			wp_enqueue_style( 'bootstrap-icons', CONSULTXP_URI . '/assets/css/bootstrap-icons.css', array(), '1.9.1', 'all' );
			
			wp_enqueue_media();
			wp_enqueue_style( 'consultxp_theme_options_css', CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/css/theme-options.css', array(), '1.0', 'all' );
			wp_enqueue_style( 'wp-color-picker');
			wp_enqueue_script( 'wp-color-picker-alpha', CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/js/wp-color-picker-alpha.min.js', array( 'jquery', 'wp-color-picker' ), '3.0.0' );
			wp_enqueue_script( 'consultxp_theme_options_js', CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/js/theme-options.js', array( 'jquery' ), '1.0', true );

			wp_localize_script( 'consultxp_theme_options_js', 'consultxp_ajax_object',
				array(
					'import_nonce' => wp_create_nonce( 'consultxp-import-*&^F&' ),
					'export_nonce' => wp_create_nonce( 'consultxp-export-&^%$)' ),
				)
			);

			require_once CONSULTXP_ADDON_DIR . 'admin/extension/theme-options/googlefonts.php';
			$google_fonts = Consultxp_Google_Fonts_Function::$_google_fonts;
			$google_fonts_arr = json_decode( $google_fonts, true );
			
			$extra_gf = array(
				"Spartan" => array(
					"variants" => array(
						array( "id" => "400", "name" => "Thin 100" ),
						array( "id" => "400", "name" => "Extra-light 200" ),
						array( "id" => "400", "name" => "Light 300" ),
						array( "id" => "400", "name" => "Regular 400" ),
						array( "id" => "400", "name" => "Medium 500" ),
						array( "id" => "400", "name" => "Semi-bold 600" ),
						array( "id" => "400", "name" => "Bold 700" ),
						array( "id" => "400", "name" => "Extra-bold 800" ),
						array( "id" => "400", "name" => "Black 900" )
					)
				)
			);
			if( is_array( $extra_gf ) && !empty( $extra_gf ) ){
				foreach( $extra_gf as $font => $details ) $google_fonts_arr[$font] = $details;
			}
			
			$google_fonts = json_encode( $google_fonts_arr );
			$google_fonts_vars = array(
				'google_fonts' => $google_fonts,
				'standard_font_variants' => Consultxp_Google_Fonts_Function::$_standard_font_variants,
				'font_variants_default' => esc_html__( 'Font Weight &amp; Style', 'consultxp-addon' ),
				'font_sub_default' => esc_html__( 'Font Subsets', 'consultxp-addon' )
			);
			wp_localize_script( 'consultxp_theme_options_js', 'google_fonts_vars', $google_fonts_vars );
			
		}
	}
	
	public function init() {
		require_once( CONSULTXP_ADDON_DIR . 'admin/extension/theme-options/framework.php' );
		Consultxp_Options::$opt_name = 'consultxp_options';
	}
		
	public static function consultxp_options_admin_page(){	
		$consultxp_theme = wp_get_theme(); ?>	
		<form method="post" action="#" enctype="multipart/form-data" id="consultxp-plugin-form-wrapper">
			<div class="consultxp-settings-wrap">
			<div class="consultxp-header-bar">
				<div class="consultxp-header-left">
					<div class="consultxp-admin-logo-inline">
						<img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/brand-logo.png' ); ?>" alt="consultxp-logo">
					</div><!-- .consultxp-admin-logo-inline -->
					<h2 class="title"><?php esc_html_e( 'Consultxp Options', 'consultxp-addon' ); ?><span class="consultxp-version"><?php echo esc_attr( $consultxp_theme->get( 'Version' ) ); ?></span></h2>
					<div class="nav-theme-options">
						<?php
						include_once(ABSPATH . 'wp-admin/includes/plugin.php');
						$is_consultxp_addon_active = is_plugin_active('consultxp-addon/consultxp-addon.php');
						$current_theme = wp_get_theme();
						$is_theme_active = ($current_theme->get('Name') === 'Consultxp');
						$verfied_stat = get_option('verified_purchase_status');

						if ($is_consultxp_addon_active) {
							echo '<a href="' . admin_url('admin.php?page=consultxp-options') . '" class="active-page"><span class="dashicons dashicons-admin-tools"></span>Theme Options</a>';
						} else {
							echo '<a href="#" class="theme-options not-clickable" data-popup-message="Please install and activate the Consultxp Addon plugin."><span class="dashicons dashicons-admin-tools"></span>Theme Options</a>';
						}
						if ($verfied_stat) {
							echo '<a href="' . admin_url('admin.php?page=consultxp-plugins') . '"><span class="dashicons dashicons-admin-plugins"></span>Plugins</a>';
						} else {
							echo '<a href="#" class="not-clickable" data-popup-message="Please activate the Consultxp theme."><span class="dashicons dashicons-admin-plugins"></span>Plugins</a>';
						}
						?>
						<div class="support-dropdown">
							<a href="#" class="dropdown-toggle"><span class="dashicons dashicons-buddicons-buddypress-logo"></span>Support</a>
							<div class="dropdown-content">
								<a href="https://zozothemes.com/knowledge-base/" target="_blank"><span class="dashicons dashicons-tickets-alt"></span>Ticket</a>
								<a href="https://zozothemes.com/knowledge-base/" target="_blank"><span class="dashicons dashicons-video-alt3"></span>Video</a>
								<a href="https://docs.zozothemes.com/consultxp/" target="_blank"><span class="dashicons dashicons-text-page"></span>Documentation</a>
								<a href="https://zozothemes.com/knowledge-base/" target="_blank"><span class="dashicons dashicons-book-alt"></span>Knowledge Base</a>
							</div>
						</div>
						<a href="https://zozothemes.com/forum/" target="_blank"><span class="dashicons dashicons-format-chat"></span>Forum</a>
					</div>
				</div><!-- .consultxp-header-left -->
				<div class="consultxp-header-right">
					<button type="submit" class="button consultxp-btn"><?php esc_html_e( 'Save Settings', 'consultxp-addon' ); ?></button>
				</div><!-- .consultxp-header-right -->
			</div><!-- .consultxp-header-bar -->	
				
				<div class="consultxp-inner-wrap">
						
					<?php
						if ( isset( $_POST['save_consultxp_theme_options'] ) && wp_verify_nonce( $_POST['save_consultxp_theme_options'], 'consultxp_theme_options*&^&*$' ) ) {
							update_option( 'consultxp_options', $_POST['consultxp_options'] );
							require_once ( CONSULTXP_ADDON_DIR . 'admin/extension/theme-options/theme-options-css.php' );
						}
						//Get updated theme option
						Consultxp_Options::$consultxp_options = get_option('consultxp_options');
						
						if( class_exists( 'Classic_Elementor_Addon' ) ){
							add_action( 'consultxp_custom_template_options', function(){
								require_once CONSULTXP_ADDON_DIR . 'admin/extension/theme-options/cea-config.php';
							});
						}
						//Theme config
						require_once CONSULTXP_ADDON_DIR . 'admin/extension/theme-options/config.php';
					?>
					<div class="consultxp-admin-content-wrap">
						<?php wp_nonce_field( 'consultxp_theme_options*&^&*$', 'save_consultxp_theme_options' ); ?>
						<div class="consultxp-tab">
							<div class="consultxp-tab-list">
								<ul class="tablinks-list">
									<?php Consultxp_Options::consultxp_put_section(); 
										if (is_plugin_active('classic-elementor-addons-pro/index.php')): ?>
											<div class="consultxp-navigation-buttons">
												<a href="<?php echo admin_url('admin.php?page=classic-addons'); ?>" target="_blank" class="button consultxp-btn"><i class="fa fa-caret-square-o-left" aria-hidden="true"></i><?php esc_html_e('CEA Plugin Options', 'consultxp'); ?></a>
											</div>
										<?php endif; 
									?>
								</ul>
							</div><!-- .consultxp-tab-list -->
							<div class="consultxp-tab-contents">
								
							<!-- <a href="https://docs.zozothemes.com/consultxp/" target="_blank" class="docs-tooltip" title="Documentation"><span class="dashicons dashicons-editor-help theme-info"></span></a> -->
								<?php Consultxp_Options::consultxp_put_field(); ?>
							</div><!-- .consultxp-tab-contents -->
						</div><!-- .consultxp-tab -->					
					</div><!-- .consultxp-admin-content-wrap -->					
				</div><!-- .consultxp-inner-wrap -->
			</div><!-- .consultxp-settings-wrap -->
			<div class="consultxp-db-footer">
					<div class="consultxp-db-footer-top">
						<nav class="consultxp-db-footer-menu">
						<div class="copyright-text-wrap">Copyrights  © <script>document.write(new Date().getFullYear())</script> Designed by 
						<a href="https://zozothemes.com/" class="theme-color" target="_blank">Zozothemes <span class="heart-color">♥</span></a></div>
							<ul>
								<li>
									<a href="https://docs.zozothemes.com/consultxp/" target="_blank" rel="noopener noreferrer"><?php esc_html_e( 'Documentation', 'consultxp-addon' ); ?></a>
								</li>
								<li>
									<a href="https://zozothemes.com/knowledge-base/" target="_blank" rel="noopener noreferrer"><?php esc_html_e( 'Video Tutorials', 'consultxp--addon' ); ?></a>
								</li>
								<li>
									<a href="https://zozothemes.com/knowledge-base/" target="_blank" rel="noopener noreferrer"><?php esc_html_e( 'Submit A Ticket', 'consultxp--addon' ); ?></a>
								</li>
							</ul>
						</nav>
					</div>
			</div>
		</form>	
	<?php
	}

	public static function consultxp_theme_options_export(){
		$nonce = isset( $_POST['nonce'] ) ? sanitize_text_field( $_POST['nonce'] ) : '';
		if ( ! wp_verify_nonce( $nonce, 'consultxp-export-&^%$)' ) )
			die ( esc_html__( 'Busted!', 'consultxp-addon' ) );
		
		$consultxp_options = get_option( 'consultxp_options');
		$consultxp_options = is_array( $consultxp_options ) ? array_map( 'stripslashes_deep', $consultxp_options ) : stripslashes( $consultxp_options );
		echo json_encode( $consultxp_options );
		
		exit;
	}

	public static function consultxp_redux_themeopt_import(){
		$nonce = isset( $_POST['nonce'] ) ? sanitize_text_field( $_POST['nonce'] ) : ''; //Sanitize
		if ( ! wp_verify_nonce( $nonce, 'consultxp-import-*&^F&' ) )
			die ( esc_html__( 'Busted', 'consultxp-addon' ) );
		
		$json_data = isset( $_POST['json_data'] ) ? stripslashes( urldecode( $_POST['json_data'] ) ) : '';
		$theme_opt_arr = json_decode( $json_data, true );
		if( !empty( $theme_opt_arr ) ){
			update_option( 'consultxp_options', $theme_opt_arr );
		}
		
		wp_die('success');
	}
	
	public static function instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}

}

Consultxp_Plugin_Options::instance();