<?php

/**
 * Consultxp Post Options CSS
 */

require_once ( CONSULTXP_ADDON_DIR . 'admin/extension/theme-options/class.options-style.php' );
$consultxp_styles = new Consultxp_Theme_Styles;

$post_id = get_the_ID();
$consultxp_options = $_POST['consultxp_options'];//get_post_meta( $post_id, 'consultxp_options', true );
$consultxp_styles->consultxp_options = $consultxp_options;

ob_start();

echo "\n/* Consultxp Post Options Styles */";
$consultxp_styles->consultxp_padding_settings( 'content-padding', '.consultxp-content-wrap' );

$consultxp_styles->consultxp_bg_settings( 'page-title-bg', 'body.page .consultxp-page-header' );

$page_title_overlay = $consultxp_styles->consultxp_get_option( 'page-title-overlaycolor' );
echo '.page .consultxp-page-header:after, .error404 .consultxp-page-header:after{
	background-color: ' . esc_attr($page_title_overlay) . ';
}';

//logo styles
$logo_chk = $consultxp_styles->consultxp_get_option('logo-chk');
if( $logo_chk == 'custom' ){
	$site_logo_width = $consultxp_styles->consultxp_get_option('site-logo-width');
	if( !empty( $site_logo_width ) && isset( $site_logo_width['width'] ) && !empty( $site_logo_width['width'] ) ){
		echo 'img.site-logo { max-width: '. esc_attr( $site_logo_width['width'] ) .'px; }';
	}
	$sticky_logo_width = $consultxp_styles->consultxp_get_option('sticky-logo-width');
	if( !empty( $sticky_logo_width ) && isset( $sticky_logo_width['width'] ) && !empty( $sticky_logo_width['width'] ) ){
		echo 'img.sticky-logo { max-width: '. esc_attr( $sticky_logo_width['width'] ) .'px; }';
	}
	$mobile_logo_width = $consultxp_styles->consultxp_get_option('mobile-logo-width');
	if( !empty( $mobile_logo_width ) && isset( $mobile_logo_width['width'] ) && !empty( $mobile_logo_width['width'] ) ){
		echo 'img.mobile-logo { max-width: '. esc_attr( $mobile_logo_width['width'] ) .'px; }';
	}
}

//header styles
$header_style_chk = $consultxp_styles->consultxp_get_option('header-style-chk');
if( $header_style_chk == 'custom' ){
	$consultxp_styles->consultxp_link_color( 'header-links-color', 'regular', '.site-header a' );
	$consultxp_styles->consultxp_link_color( 'header-links-color', 'hover', '.site-header a:hover' );
	$consultxp_styles->consultxp_link_color( 'header-links-color', 'active', '.site-header a:active, .site-header ul.nav.wp-menu > li.menu-item-has-children.current-menu-ancestor > a, .site-header ul.nav.wp-menu > li.current-menu-item > a' );
	
	$consultxp_styles->consultxp_link_color( 'header-dropdown-links-color', 'regular', '.site-header .primary-menu .menu-item-has-children ul.sub-menu li a' );
	$consultxp_styles->consultxp_link_color( 'header-dropdown-links-color', 'hover', '.site-header .primary-menu .menu-item-has-children ul.sub-menu li a:hover' );
	$consultxp_styles->consultxp_link_color( 'header-dropdown-links-color', 'active', '.site-header .primary-menu li.current-menu-parent > ul.sub-menu > li.current-menu-item > a, .site-header ul.wp-menu ul.sub-menu li.menu-item.current-menu-ancestor.menu-item-has-children > a' );

	$consultxp_styles->consultxp_link_color( 'header-dropdown-fixed-links-color', 'regular', '.site-header .sticky-head.header-sticky .primary-menu .menu-item-has-children ul.sub-menu li a' );
	$consultxp_styles->consultxp_link_color( 'header-dropdown-fixed-links-color', 'hover', '.site-header .sticky-head.header-sticky .primary-menu .menu-item-has-children ul.sub-menu li a:hover' );
	$consultxp_styles->consultxp_link_color( 'header-dropdown-fixed-links-color', 'active', '.site-header .sticky-head.header-sticky .primary-menu li.current-menu-parent > ul.sub-menu > li.current-menu-item > a, .site-header sticky-head.header-sticky ul.wp-menu ul.sub-menu li.menu-item.current-menu-ancestor.menu-item-has-children > a' );

	$consultxp_styles->consultxp_bg_settings( 'header-background', '.site-header' );
	$consultxp_styles->consultxp_padding_settings( 'header-padding', '.site-header' );
	$consultxp_styles->consultxp_margin_settings( 'header-margin', '.site-header' );
	$consultxp_styles->consultxp_border_settings( 'header-border', '.site-header' );
}

//header topbar styles & link color
$topbar_style_chk = $consultxp_styles->consultxp_get_option('header-topbar-style-chk');
if( $topbar_style_chk == 'custom' ){
	$topbar_height = $consultxp_styles->consultxp_get_option('header-topbar-height');
	if( !empty( $topbar_height ) && isset( $topbar_height['height'] ) && !empty( $topbar_height['height'] ) ){
		echo '.header-topbar {';
			echo 'line-height: '. esc_attr( $topbar_height['height'] ) .'px;';
		echo '}';
	}
	
	$topbar_sticky_height = $consultxp_styles->consultxp_get_option('header-topbar-sticky-height');
	if( !empty( $topbar_sticky_height ) && isset( $topbar_sticky_height['height'] ) && !empty( $topbar_sticky_height['height'] ) ){
		echo '.header-sticky .header-topbar {';
			echo 'line-height: '. esc_attr( $topbar_sticky_height['height'] ) .'px;';
		echo '}';
	}
	
	$consultxp_styles->consultxp_bg_settings( 'header-topbar-background', '.header-topbar' );
	$consultxp_styles->consultxp_padding_settings( 'header-topbar-padding', '.header-topbar' );
	$consultxp_styles->consultxp_margin_settings( 'header-topbar-margin', '.header-topbar' );
	$consultxp_styles->consultxp_border_settings( 'header-topbar-border', '.header-topbar' );
	$consultxp_styles->consultxp_link_color( 'header-topbar-links-color', 'regular', '.header-topbar a' );
	$consultxp_styles->consultxp_link_color( 'header-topbar-links-color', 'hover', '.header-topbar a:hover' );
	$consultxp_styles->consultxp_link_color( 'header-topbar-links-color', 'active', '.header-topbar a:active,.header-topbar ul.nav.wp-menu > li.menu-item-has-children.current-menu-ancestor > a' );

	//topbar on sticky style
	$consultxp_styles->consultxp_bg_settings( 'header-topbar-sticky-background', '.sticky-head.header-sticky .header-topbar' );
	$consultxp_styles->consultxp_link_color( 'header-topbar-sticky-links-color', 'regular', '.sticky-head.header-sticky .header-topbar a' );
	$consultxp_styles->consultxp_link_color( 'header-topbar-sticky-links-color', 'hover', '.sticky-head.header-sticky .header-topbar a:hover' );
	$consultxp_styles->consultxp_link_color( 'header-topbar-sticky-links-color', 'active', '.sticky-head.header-sticky .header-topbar a:active, .sticky-head.header-sticky .header-topbar ul.nav.wp-menu > li.menu-item-has-children.current-menu-ancestor > a' );
}

$logobar_style_chk = $consultxp_styles->consultxp_get_option('header-logobar-style-chk');
if( $logobar_style_chk == 'custom' ){
	//header logobar styles & link color
	$logobar_height = $consultxp_styles->consultxp_get_option('header-logobar-height');
	if( !empty( $logobar_height ) && isset( $logobar_height['height'] ) && !empty( $logobar_height['height'] ) ){
		echo '.header-logobar {';
			echo 'line-height: '. esc_attr( $logobar_height['height'] ) .'px;';
		echo '}';
	}
	
	$logobar_sticky_height = $consultxp_styles->consultxp_get_option('header-logobar-sticky-height');
	if( !empty( $logobar_sticky_height ) && isset( $logobar_sticky_height['height'] ) && !empty( $logobar_sticky_height['height'] ) ){
		echo '.header-sticky .header-logobar {';
			echo 'line-height: '. esc_attr( $logobar_sticky_height['height'] ) .'px;';
		echo '}';
	}
	
	$consultxp_styles->consultxp_bg_settings( 'header-logobar-background', '.header-logobar' );
	$consultxp_styles->consultxp_padding_settings( 'header-logobar-padding', '.header-logobar' );
	$consultxp_styles->consultxp_margin_settings( 'header-logobar-margin', '.header-logobar' );
	$consultxp_styles->consultxp_border_settings( 'header-logobar-border', '.header-logobar' ); 
	$consultxp_styles->consultxp_link_color( 'header-logobar-links-color', 'regular', '.header-logobar a, .header-logobar .primary-menu ul li a' );
	$consultxp_styles->consultxp_link_color( 'header-logobar-links-color', 'hover', '.header-logobar a:hover,.header-logobar .primary-menu ul li a:hover' );
	$consultxp_styles->consultxp_link_color( 'header-logobar-links-color', 'active', '.header-logobar a:active, .header-logobar ul.nav.wp-menu > li.menu-item-has-children.current-menu-ancestor > a' );

	//logobar on sticky style
	$consultxp_styles->consultxp_bg_settings( 'header-logobar-sticky-background', '.sticky-head.header-sticky .header-logobar' );
	$consultxp_styles->consultxp_link_color( 'header-logobar-sticky-links-color', 'regular', '.sticky-head.header-sticky .header-logobar a, .sticky-head.header-sticky .header-logobar .primary-menu .menu-item-has-children ul.sub-menu li a' );
	$consultxp_styles->consultxp_link_color( 'header-logobar-sticky-links-color', 'hover', '.sticky-head.header-sticky .header-logobar a:hover, .sticky-head.header-sticky .header-logobar .primary-menu .menu-item-has-children ul.sub-menu li a:hover' );
	$consultxp_styles->consultxp_link_color( 'header-logobar-sticky-links-color', 'active', '.sticky-head.header-sticky .header-logobar a:active,.sticky-head.header-sticky .header-logobar ul.nav.wp-menu > li.menu-item-has-children.current-menu-ancestor > a,.sticky-head.header-sticky .header-logobar .primary-menu li.current-menu-parent > ul.sub-menu > li.current-menu-item > a, .sticky-head.header-sticky .header-logobar ul.wp-menu ul.sub-menu li.menu-item.current-menu-ancestor.menu-item-has-children > a' );
}

$navbar_style_chk = $consultxp_styles->consultxp_get_option('header-navbar-style-chk');
if( $navbar_style_chk == 'custom' ){
	//header navbar styles & link color
	$navbar_height = $consultxp_styles->consultxp_get_option('header-navbar-height');
	if( !empty( $navbar_height ) && isset( $navbar_height['height'] ) && !empty( $navbar_height['height'] ) ){
		echo '.header-navbar {';
			echo 'line-height: '. esc_attr( $navbar_height['height'] ) .'px;';
		echo '}';
	}
	
	$navbar_sticky_height = $consultxp_styles->consultxp_get_option('header-navbar-sticky-height');
	if( !empty( $navbar_sticky_height ) && isset( $navbar_sticky_height['height'] ) && !empty( $navbar_sticky_height['height'] ) ){
		echo '.header-sticky .header-navbar {';
			echo 'line-height: '. esc_attr( $navbar_sticky_height['height'] ) .'px;';
		echo '}';
	}
	
	$consultxp_styles->consultxp_bg_settings( 'header-navbar-background', '.header-navbar' );
	$consultxp_styles->consultxp_padding_settings( 'header-navbar-padding', '.header-navbar' );
	$consultxp_styles->consultxp_margin_settings( 'header-navbar-margin', '.header-navbar' );
	$consultxp_styles->consultxp_border_settings( 'header-navbar-border', '.header-navbar' );
	
	$consultxp_styles->consultxp_link_color( 'header-navbar-links-color', 'regular', '.header-navbar a, .header-navbar .primary-menu ul li a' );
	$consultxp_styles->consultxp_link_color( 'header-navbar-links-color', 'hover', '.header-navbar a:hover, .header-navbar .primary-menu ul li a:hover' );
	$consultxp_styles->consultxp_link_color( 'header-navbar-links-color', 'active', '.header-navbar a:active, .header-navbar ul.nav.wp-menu > li.menu-item-has-children.current-menu-ancestor > a' );

	//navbar on sticky style
	$consultxp_styles->consultxp_bg_settings( 'header-navbar-sticky-background', '.sticky-head.header-sticky .header-navbar' );
	$consultxp_styles->consultxp_link_color( 'header-navbar-sticky-links-color', 'regular', '.sticky-head.header-sticky .header-navbar a, .sticky-head.header-sticky .header-navbar .primary-menu .menu-item-has-children ul.sub-menu li a' );
	$consultxp_styles->consultxp_link_color( 'header-navbar-sticky-links-color', 'hover', '.sticky-head.header-sticky .header-navbar a:hover, .sticky-head.header-sticky .header-navbar .primary-menu .menu-item-has-children ul.sub-menu li a:hover' );
	$consultxp_styles->consultxp_link_color( 'header-navbar-sticky-links-color', 'active', '.sticky-head.header-sticky .header-navbar a:active, .sticky-head.header-sticky .header-navbar ul.nav.wp-menu > li.menu-item-has-children.current-menu-ancestor > a,.sticky-head.header-sticky .header-navbar .primary-menu li.current-menu-parent > ul.sub-menu > li.current-menu-item > a, .sticky-head.header-sticky .header-navbar ul.wp-menu ul.sub-menu li.menu-item.current-menu-ancestor.menu-item-has-children > a' );

}
$mobile_style_chk = $consultxp_styles->consultxp_get_option('mobile-style-chk');
if ( $mobile_style_chk == 'custom' ) {
	$mobilebar_from = $consultxp_styles->consultxp_get_option('mobilebar-responsive');
	$mobilebar_from = $mobilebar_from ? absint($mobilebar_from) : 767;
	$mobile_height = $consultxp_styles->consultxp_get_option( 'mobilebar-height');
	$mobilebar_color = $consultxp_styles->consultxp_get_option( 'header-mobilebar-color' );
	$mobilebar_item_color = $consultxp_styles->consultxp_get_option( 'header-mobilebar-item-color' );
	// This will hide the mobile header till the point reaches
	// echo '@media only screen and (min-width: ' . esc_attr($mobilebar_from) . 'px) {';
	// 	echo '.header-mobilebar { display: none; }';
	// 	echo '.site-header { display: block; }';
	// echo '}';
	echo '@media only screen and (max-width: ' . esc_attr($mobilebar_from) . 'px) {';
		echo '.header-mobilebar { display: flex; }';
    	echo '.site-header { display: none; }';
		echo '.header-mobilebar.navbar *{
			color: '. esc_attr( $mobilebar_item_color ) .' !important;
		}';
		echo '.header-mobilebar.navbar {
			background-color: '. esc_attr( $mobilebar_color ) .' !important;
			height: '. esc_attr($mobile_height ) . 'px;
		}';
	echo '}';
}

$mobile_menu_styles_chk = $consultxp_styles->consultxp_get_option('mobile-menu-style-chk');
if ( $mobile_menu_styles_chk == 'custom' ) {
	$mobilemenu_color = $consultxp_styles->consultxp_get_option( 'mobile-menu-color' );
	$mobilemenu_item_color = $consultxp_styles->consultxp_get_option( 'mobile-menu-item-color' ); 
	$mobile_sidebar_width = $consultxp_styles->consultxp_get_option('mobile-sidebar-width');
	$mobilebar_from = $consultxp_styles->consultxp_get_option('mobilebar-responsive');
	$mobilebar_from = $mobilebar_from ? absint($mobilebar_from) : 767;

	echo '@media only screen and (max-width: ' . esc_attr($mobilebar_from) . 'px) {';
	echo '.mobile-menu-active .mobile-menu-floating {
		background-color: '.esc_attr( $mobilemenu_color ).' !important;
	}';	
	echo '.mobile-menu-active .mobile-menu-floating * {
		color: '.esc_attr( $mobilemenu_item_color ).';
	}';	
	echo '}';

	if( !empty( $mobile_sidebar_width ) && isset( $mobile_sidebar_width['width'] ) && !empty( $mobile_sidebar_width['width'] ) ){
		echo '@media only screen and (max-width: ' . esc_attr($mobilebar_from) . 'px) {';
    	echo '.mobile-menu-active .mobile-menu-floating {
			max-width: '. esc_attr( $mobile_sidebar_width['width'] ) .'px; 
		}';
		echo '}';
	}
}

//Style end

$styles = ob_get_clean();
update_post_meta( $post_id, 'consultxp_post_custom_styles', wp_slash( $styles ) );