<?php

/**
 * Consultxp Theme Options CSS
 */

require_once ( CONSULTXP_ADDON_DIR . 'admin/extension/theme-options/class.options-style.php' );
$consultxp_styles = new Consultxp_Theme_Styles;

ob_start();

echo "\n/* Consultxp Theme Options CSS */";

echo "\n/* General Styles */\n";

//site width
$site_width = $consultxp_styles->consultxp_dimension_settings( 'site-width', 'width' );
if( $site_width ){
	echo '@media (min-width: 1300px){
		.container, .container-lg, .container-md, .container-sm, .container-xl, .container-xxl {
			max-width: '. esc_attr( $site_width ) .';
		}
	}';
}

//primary color
$primary_color = $consultxp_styles->consultxp_get_option( 'primary-color' );
$rgb = $consultxp_styles->consultxp_hex2rgba( $primary_color, 'none' );

/*
 * Theme Color -> $primary-color
 * Secondary Color -> $secondary_color
 * Theme RGBA -> $rgb example -> echo 'body{ background: rgba('. esc_attr( $rgb ) .', 0.5); }';
 * Theme Secondary RGBA -> $rgb example -> echo 'body{ background: rgba('. esc_attr( $secondary_rgb ) .', 0.5); }';
 */

if( $primary_color ){
	echo '.primary-color, .theme-color, a:focus, a:hover, a:active {
		color: '. esc_attr( $primary_color ) .';
	}';
	echo '.primary-bg, .theme-bg  {
		background-color: '. esc_attr( $primary_color ) .';
	}';
	echo '.border-shape-top:before, .border-shape-top-left:before {
		background: linear-gradient(to bottom, '. esc_attr( $primary_color ) .' -24%, rgb(58 123 213 / 0%));
	}';
	echo '.border-shape-top:after, .border-shape-top-left:after {
		background: linear-gradient(to top, '. esc_attr( $primary_color ) .' 0%, rgb(58 123 213 / 0%));
	}';	
	
	echo '.footer-widget.contact-widget:before {
		background: linear-gradient(to right, '. esc_attr( $primary_color ) .' 0%, rgb(184 151 128 / 6%));
	}';
	echo '.section-title-wrapper span.elementor-divider-separator {
		border-image: linear-gradient(to right, '. esc_attr( $primary_color ) .', rgb(58 123 213 / 0%));
    	border-image-slice: 1;
	}';
	echo '.rtl .section-title-wrapper span.elementor-divider-separator {
		border-image: linear-gradient(to left, '. esc_attr( $primary_color ) .', rgb(58 123 213 / 0%));
    	border-image-slice: 1;
	}';
	echo '.team-wrapper.team-style-default .team-inner .post-thumb:before {
		background: linear-gradient(to top, '. esc_attr( $primary_color ) .' -152%, 255,255,255, 0%));
	}';	
	echo '.bookly-progress-tracker .step {
		background-color: rgba('. esc_attr( $rgb ) .', 0.25);
	}';
	echo '.calendar_wrap th, tfoot td, ul.nav.wp-menu > li > a:before, ul[id^="nv-primary-navigation"] li.button.button-primary > a, .menu li.button.button-primary > a, span.animate-bubble-box:after, span.animate-bubble-box:before, ::selection, .owl-carousel button.owl-dot.active, .content-widgets .widget .menu-service-sidebar-menu-container ul > li > a:after, .comments-pagination.pagination .page-numbers.current, .portfolio-meta ul.nav.social-icons > li > a:hover, span.cea-popup-modal-dismiss.ti-close, blockquote:after,
.wp-block-quote.is-large:after, .wp-block-quote.is-style-large:after, .wp-block-quote.is-style-large:not(.is-style-plain):after,.wp-block-quote.has-text-align-right:after, .wp-block-quote:after, p.quote-author::before, nav.post-nav-links .post-page-numbers.current, blockquote cite::before, .single-post .comments-wrapper.section-inner input.submit,
.page .comments-wrapper.section-inner input.submit, .widget-area-right .widget p.wp-block-tag-cloud a.tag-cloud-link:hover, .widget .tagcloud > a:hover, .widget .tagcloud > a:focus, .widget .tagcloud > a:active, .section-title-wrapper.title-theme .title-wrap > *.sub-title:after, .cea-tab-elementor-widget.tab-style-2.cea-vertical-tab a.nav-item.nav-link:before, .portfolio-single .portfolio-video.post-video-wrap .video-play-icon, .portfolio-wrapper.portfolio-style-default .isotope-filter ul.nav li a:before, .isotope-filter ul.nav.m-auto.d-block li.active a, .call-us-team a.cea-button-link:hover, .call-us-team a.cea-button-link span.cea-button-num, .header-navbar .cea-button-link, .elementor-widget-ceaposts .blog-style-classic-pro .blog-inner .post-date a, .widget-area-left .contact-widget-info > p > span.bi, .widget-area-right .contact-widget-info > p > span.bi, .portfolio-style-default .portfolio-inner .post-thumb:before, .portfolio-single .portfolio-sub-title, .testimonial-wrapper.testimonial-style-default .owl-item .testimonial-inner:hover:before, .timeline > li > .timeline-sep-title:before, .feature-box-style-5 .feature-box-wrapper .fbox-number, .header-navbar a.h-phone:before, .portfolio-style-classic .post-thumb.post-overlay-active:before, .bottom-meta .post-more:before, .blog-style-classic-pro .blog-inner ul.nav.top-meta-list li:before, .wp-block-file__button.wp-element-button, p.wp-block-tag-cloud a.tag-cloud-link:hover, .event-inner ul.nav.top-meta-list .post-date:before, a.consultxp-toggle > span:first-child:before,
a.consultxp-toggle > span:last-child:before, .team-wrapper.team-style-classic .team-inner:after, .cea-tab-elementor-widget .cea-tabs > a .cea-tab-title:before, .event-style-default .event-inner .event-address, .event-info-wrap h4, .charitable-donation-form .donation-amounts .donation-amount.selected label, .owl-dots button.owl-dot, .single-post ul.nav.post-meta > li.post-category:before, .team-wrapper.team-style-classic .team-inner:before, .portfolio-style-classic .post-thumb.post-overlay-active:after, .elementor-widget-ceaposts .blog-inner .read-more:before, .bottom-meta .post-more .read-more:before, .portfolio-style-classic .portfolio-inner .post-overlay-items .post-icons a, .blog .consultxp-masonry .post-meta .post-more a:before, .consultxp-masonry .bottom-meta-wrap .post-meta .post-more a:before, .wp-block-columns.footer-call-to-action,
.feature-box-default .cea-button-wrapper .cea-button-link:before, .portfolio-style-classic .portfolio-inner .post-title-head .post-title:before, .portfolio-style-classic-pro .portfolio-inner .post-overlay-items .post-icons a, .portfolio-style-modern .portfolio-inner .post-overlay-items .post-icons a, .cus-box-1 .feature-box-classic-pro .feature-box-inner .cea-button-content-wrapper .cea-button-text:before, .portfolio-style-default .portfolio-inner .post-overlay-items .post-icons a, .portfolio-style-default .portfolio-inner .post-category a, .btn-black .cea-button-wrapper .cea-button-link:hover:after, .comment-body .reply a.comment-reply-link:hover,.blog-style-modern.blog-normal-model .blog-inner .top-meta .post-date, .team-style-default .team-inner:hover .post-overlay-items > .team-social-wrap,
.team-style-default .team-inner:hover .post-overlay-items > .team-social-wrap > ul, .content-widgets-wrapper .widget_categories ul li a:before, .content-widgets-wrapper .widget_archive ul li a:before, .footer-widgets-wrap .widget_archive ul li a:before, .footer-widgets-wrap .widget_categories ul li a:before, .woocommerce ul.products li.product .onsale, .woocommerce span.onsale, .woocommerce ul.products li.product a.added_to_cart.wc-forward:hover, .woocommerce ul.products li.product .button, .woocommerce div.product .woocommerce-tabs ul.tabs li a, .woocommerce #content input.button, .woocommerce button.button.alt, .woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button, .woocommerce-page #content input.button, .woocommerce-page #respond input#submit, .woocommerce-page a.button, .woocommerce-page button.button, .woocommerce-page input.button, .woocommerce input.button.alt, .woocommerce input.button.disabled, .woocommerce input.button:disabled[disabled], .cart_totals .wc-proceed-to-checkout a.checkout-button, .single-product.woocommerce .restaurt_ajax_add_to_cart, :where(body:not(.woocommerce-block-theme-has-button-styles)) .woocommerce button.button.alt.disabled, .woocommerce-MyAccount-navigation > ul li a:hover, .woocommerce-account .woocommerce-MyAccount-navigation > ul li.is-active a, .wp-block-woocommerce-customer-account a .wc-block-customer-account__account-icon, .wc-block-mini-cart__badge, .content-widgets-outer-wrapper .wc-block-grid .wc-block-grid__product-onsale, .single.single-cea-service aside.content-widgets-outer-wrapper .widget-content .menu .menu-item a:hover, .input.wpcf7-form-control.wpcf7-submit.has-spinner, .secondary-menu-toggle.consultxp-toggle span:first-child, .secondary-menu-toggle.consultxp-toggle span:nth-child(2), .contact-form-wrapper input.wpcf7-form-control.wpcf7-submit, .button.input-group-addon.zozo-mc.btn.btn-default, .portfolio-meta ul.nav.social-icons > li > a, .single ul.portfolio-meta-list span.portfolio-meta-icon, .portfolio-inner .post-overlay-items .post-date a, .team-style-default .team-inner .post-overlay-items .post-designation-head, .cus-num-bg-wrap .feature-box-default .fbox-number, .team-style-default .team-inner .post-overlay-items > .team-social-wrap:after, .single .top-meta-wrap ul.nav.post-meta > li.post-category:before, .single.single-cea-service aside.content-widgets-outer-wrapper .widget-content .menu .menu-item.current-menu-item a, .testimonial-style-list .testimonial-style-list-item .testimonial-thumb:before, .single-cea-testimonial .testimonial-info .testimonial-img:before, .single ul.nav.post-meta > li.post-tag > a:hover, .service-wrapper.service-style-classic-pro .service-inner .post-thumb:before, .secondary-bar-wrapper .wpcf7 input.wpcf7-submit, .secondary-menu-toggle.consultxp-toggle span:nth-child(3), .secondary-menu-toggle.consultxp-toggle span:nth-child(4), .sticky-head.header-sticky .header-navbar .close, .sticky-head.header-sticky .header-navbar .secondary-toggle-wrapper a.consultxp-toggle:before, .custom-post-nav .prev-nav-link, .custom-post-nav .next-nav-link, .pagination-single-inner > h6.pagination-next, .pagination-single-inner > h6.pagination-prev, .blog-wrapper.blog-style-default .blog-inner .top-meta, .single .row.team  {
		background-color: '. esc_attr( $primary_color ) .';
	}';
	echo '.theme-color-bg, .icon-theme-color-bg, .flip-box-wrapper:hover .icon-theme-hcolor-bg, .contact-info-style-classic-pro .contact-info-title, .contact-info-wrapper.contact-info-style-classic:before, .testimonial-wrapper.testimonial-style-modern .testimonial-inner:after, .isotope-filter ul.nav li.active a:after, .isotope-filter ul.nav li a:after, .blog-wrapper .post-overlay-items .post-date a, .event-style-classic .top-meta .post-date, .blog-layouts-wrapper .post-overlay-items .post-date a, .portfolio-content-wrap .portfolio-title h3, .back-to-top:after, span.zozo-product-favoured, .charitable-donation-form .custom-donation-amount-wrapper label, .campaign-progress-bar .bar, .donate-button, .charitable-donation-amount-form .donation-amount.selected, .campaign-progress-bar .bar, .donate-button, .charitable-donation-amount-form .donation-amount.selected, .blog .consultxp-masonry .post-meta .post-more a:hover:before, .consultxp-masonry .bottom-meta-wrap .post-meta .post-more a:hover:before, .wp-block-quote.is-large:before, .pagination-single-inner > h6.pagination-prev .title-inner:before {
		background-color: '. esc_attr( $primary_color ) .' !important;
	}';
	echo '.full-search-wrapper .search-form .input-group .btn:hover, .team-details-icon,ul.nav.post-meta > li span,
.comment-metadata time, .comments-wrap span:before, .comment-body .reply a.comment-reply-link, .blog .consultxp-masonry .post-meta .post-more a, .consultxp-masonry > article .top-meta-wrap a:hover, h2.entry-title a:hover, .woocommerce-message::before,
.woocommerce div.product p.price, .woocommerce div.product span.price,ul.pricing-features-list.list-group li:before, .doc-icon, .sidebar-broucher .icon-box a:hover, p.quote-author, .feature-box-wrapper .fbox-content a:hover, blockquote cite, .wp-block-quote cite, .wp-block-quote footer, .bottom-meta-wrap ul.nav.post-meta > li.post-date a:hover,
.single-post .top-meta-wrap ul.nav.post-meta li a:hover, .cus-img-menu .menu-item .widget .wp-block-image:hover figcaption a, .single-post blockquote cite, .single-post blockquote cite a, .content-widgets-wrapper .widget_categories ul li a:before, .content-widgets-wrapper .widget_archive ul li a:before, .content-widgets-wrapper .wp-block-categories li a:before, .cus-contact a:first-child, .pagination-single-inner > h6 > a:hover span.title, .post-share-wrap ul.social-share > li > a:hover > i, .team-style-classic-pro .team-designation, .consultxp-masonry .bottom-meta-wrap .post-meta .post-more a:hover, .widget-content-bx a i, .widget-area-left .contact-widget-info > p a:hover, .widget-area-right .contact-widget-info > p a:hover, .testimonial-style-default .testimonial-inner::after, i.breadcrumb-delimiter, .sticky-head.header-sticky .header-navbar a.h-phone:hover, .contact-widget-info > p > span.bi, .pricing-style-classic.pricing-table-wrapper:hover ul li:before, .top-meta-wrap ul.nav.post-meta li a:hover, .widget-area-right, .secondary-bar-inner .input-group-addon.zozo-mc.btn.btn-default, .blog-style-classic-pro .post-author a:hover > span.author-name, .contact-widget-info > p a:hover, .insta-footer-wrap .sub-title, .mobile-menu-floating ul.wp-menu ul.sub-menu li.menu-item.current-menu-ancestor.menu-item-has-children .sub-menu li.current-menu-item a, .widget-content-bx.w-address .bi, .campaign-loop.campaign-grid.campaign-grid-3 li.campaign a:hover h3, .blog-layouts-wrapper .blog-multi-layout-1 .cea-block-secondary .top-meta a i, .blog-layouts-wrapper .blog-multi-layout-1 .cea-block-primary .top-meta a i, .widget-area-right .wp-block-group__inner-container h1:after, .widget-area-right .wp-block-group__inner-container h2:after, .widget-area-right .wp-block-group__inner-container h3:after, .widget-area-right .wp-block-group__inner-container h4:after, .widget-area-right .wp-block-group__inner-container h5:after, .widget-area-right .wp-block-group__inner-container h6:after, .widget-area-left .widget .widget-title:after, aside.footer-widget-2 h5:after, .widget .widgettitle:after, .widget .widget-title:after,
.wp-block-quote.is-large:before,
.sticky-head.header-sticky .header-navbar .header-titles > *.site-title a:hover, .single-cea-team .team-social-wrap ul.social-icons > li > a i, .portfolio-style-classic .owl-carousel .owl-item:hover:before, .flip-box-inner .cea-button-link.elementor-size-sm .cea-button-icon, .feature-box-inner .cea-button-link.elementor-size-sm .cea-button-icon, 
.elementor-widget-ceaposts .blog-style-list .blog-inner .post-date a i, .blog-style-default .blog-inner .author-name:hover, .feature-box-wrapper.feature-box-modern .fbox-content a:hover, .feature-box-wrapper.feature-box-classic .fbox-content a:hover, .single aside.content-widgets-outer-wrapper .widget-content .menu-service-sidebar-menu-container li.current-menu-item a, .woocommerce div ul.products li.product .price, .shop_table.cart td.product-price .amount, .shop_table.cart td.product-subtotal .amount, .woocommerce table.shop_table td.product-name, .woocommerce-info::before, .shop_table tfoot td, .woocommerce table.shop_table td, .woocommerce:where(body:not(.woocommerce-uses-block-theme)) .woocommerce-breadcrumb a, .wp-block-woocommerce-customer-account a:hover, .wc-block-grid__product .wc-block-grid__product-price ins .woocommerce-Price-amount.amount, .wc-block-grid__product .wc-block-grid__product-title:hover, .wc-block-grid__product .wc-block-grid__product-price, .woocommerce .widget_block .wc-block-active-filters .wc-block-active-filters__clear-all, .wc-block-price-filter .wc-block-components-filter-reset-button, .footer-cta .footer-widget .title, .site-footer, .secondary-menu-toggle.consultxp-toggle span:nth-child(4):before,  .consultxp-masonry > article .top-meta-wrap li.post-category a,
.consultxp-content-wrap .post-category a, .consultxp-content-wrap .post-inner .top-meta-wrap ul.nav.post-meta, .bottom-meta-wrap .post-tag span.bi.bi-tag, .consultxp-content-wrap aside.content-widgets-outer-wrapper .widget-title:before,
.consultxp-content-wrap .widget.widget_block .wp-block-group .wp-block-heading::before, .top-meta-wrap ul.nav.post-meta, .cus-blog-style-wrap .blog-layouts-wrapper .blog-multi-layout-1 .cea-block-secondary .post-category span.before-icon.ti-folder, .cus-titles-style-wrap a, .blockquote .quote-author, .h4.wp-block-heading.has-text-align-left,h3.wp-block-heading.has-text-align-center, .widget-content .sidebar-broucher .media .doc-icon, .widget-content .sidebar-broucher .icon-box a, .single.single-cea-team .team-other-details .team-details-icon, .h4.wp-block-heading.has-text-align-center, .elementor-progress-percentage, .consultxp-masonry .top-meta-wrap ul.nav.post-meta > li a:hover, .single .top-meta-wrap ul.nav.post-meta > li a:hover, aside.footer-widget-2 h5:before, .widget .widgettitle:before,	.widget .widget-title:before, .widget-area-right .wp-block-group__inner-container h1:before, .widget-area-right .wp-block-group__inner-container h2:before, .widget-area-right .wp-block-group__inner-container h3:before, .widget-area-right .wp-block-group__inner-container h4:before, .widget-area-right .wp-block-group__inner-container h5:before, .widget-area-right .wp-block-group__inner-container h6:before, .widget-area-left .widget .widget-title:before, blockquote:before, .wp-block-quote.is-large:before, .wp-block-quote.is-style-large:before, .wp-block-quote.is-style-large:not(.is-style-plain):before, .wp-block-quote.has-text-align-right:before, .wp-block-quote:before, .footer-widget .title, blockquote::before, .wp-block-quote.is-large::before, .wp-block-quote.is-style-large::before, .wp-block-quote.is-style-large:not(.is-style-plain)::before, .wp-block-quote.has-text-align-right::before, .wp-block-quote::before, .widget-area .widget .titles, .elementor-element .section-title-wrapper .title-wrap > * .subtitle-dots:before, .elementor-element .section-title-wrapper .title-wrap > * .subtitle-dots:before, .elementor-element .section-title-wrapper .title-wrap > * .subtitle-dots:after, .woocommerce .consultxp-content-wrap aside.content-widgets-outer-wrapper .widget-title:before, .woocommerce .consultxp-content-wrap .widget.widget_block .wp-block-heading:before, .secondary-menu-toggle.consultxp-toggle span:nth-child(2):before, .single.single-cea-team .team-other-details .team-details-icon:hover, .back-to-top i.bi-caret-up-fill::before, header.site-header ul.nav.wp-menu li > ul.sub-menu li a:before, .secondary-bar-inner:before, .site-header .header-navbar .cea-button-link.cea-button i, .cea-button-link.cea-button .cea-button-icon i, .blog-style-default .post-author a > span.author-name, .single ul.nav.post-meta > li.post-tag > a, .pagination-single-inner > h6 > a span.arrow, .pagination-single-inner > h6 > a span.arrow, .zozo_social_widget ul.nav.social-icons > li > a:hover i, .single.single-cea-service aside.content-widgets-outer-wrapper .widget-content .menu .menu-item a, .widget-content .social-bg-dark i, .single.single-cea-service aside.content-widgets-outer-wrapper .widget-content .menu .menu-item a:before,  .blog-style-classic .blog-inner .post-thumb .post-image-link img, ul.nav.pagination.post-pagination > li > a, ul.nav.pagination.post-pagination > li > span,
 .blog-style-classic .blog-inner .post-thumb, .blog-wrapper.blog-style-classic .owl-carousel-item .blog-inner, .blog-wrapper.blog-style-modern .blog-inner .top-meta .post-category a,
.blog-wrapper.blog-style-modern .blog-inner .top-meta .post-category, .single-cea-team .team-social-wrap ul.social-icons > li > a:hover, .consultxp-content-wrap aside.content-widgets-outer-wrapper .widget_search label.wp-block-search__label  {
		color: '. esc_attr( $primary_color ) .';
	}';
	echo '.consultxp-masonry .bottom-meta-wrap .post-meta li.post-share-wrap .social-share a:hover, .single-post ul.social-share > li > a:hover, .post-share-wrap ul.social-share > li > a, .wp-block-button.is-style-outline a.wp-block-button__link, .cea-tab-elementor-widget .cea-tabs > a.active .cea-tab-title, .woocommerce-page .theme-color, .consultxp-masonry .bottom-meta-wrap .post-meta .post-more a, .feature-box-default .fbox-content a:hover, .cea-button-link.cea-button:hover .cea-button-text i:before, .cea-button-wrapper .cea-button-link:hover .cea-button-icon i:before, .cea-button-link:hover .cea-button-content-wrapper .cea-button-icon i:before, .footer-widgets-wrap .footer-widget h4 a:hover,.widget-content .wp-block-categories-list a:hover, .widget-content .widget-icon-wrapper.text-center:after, .testimonial-style-default .owl-carousel .owl-nav .owl-prev:hover:before, .wp-block-search__button, .bottom-search-wrap .search-form input.search-submit, .error404-content .search-form .search-submit  {
	color: '. esc_attr( $primary_color ) .' !important;
}';
echo '.wp-block-woocommerce-mini-cart .wc-block-mini-cart__button:hover .wc-block-mini-cart__icon {
	color: '. esc_attr( $primary_color ) .';
	fill: '. esc_attr( $primary_color ) .';
}';

	echo 'blockquote,
.wp-block-quote.is-large, .wp-block-quote.is-style-large, .wp-block-quote.is-style-large:not(.is-style-plain),.wp-block-quote.has-text-align-right, .wp-block-quote,.woocommerce-message,
.woocommerce #content div.product .woocommerce-tabs ul.tabs, .woocommerce div.product .woocommerce-tabs ul.tabs, .woocommerce-page #content div.product .woocommerce-tabs ul.tabs, .woocommerce-page div.product .woocommerce-tabs ul.tabs, .contact-form-wrapper span.wpcf7-form-control-wrap input:focus, .contact-form-wrapper span.wpcf7-form-control-wrap select:focus, .contact-form-wrapper span.wpcf7-form-control-wrap textarea:focus, .single-post .comments-wrapper.section-inner input:focus, .single-post .comments-wrapper.section-inner textarea:focus, .modal-popup-body input.wpcf7-form-control:focus, 
.modal-popup-body textarea.wpcf7-form-control:focus, .wp-block-search__input:focus, .mailchimp-wrapper .input-group input#zozo-mc-email:focus, .single-cea-testimonial .testimonial-info img, .cus-float-img .float-parallax img, .comments-wrapper.section-inner input:focus, .comments-wrapper.section-inner textarea:focus, .team-wrapper.team-style-default .team-inner > .post-thumb img.img-fluid.rounded-circle, .testimonial-wrapper.testimonial-style-list .post-thumb img, .timeline > li:hover .timeline-panel, nav.post-nav-links .post-page-numbers, .first-widget-abt, .zozo-booking-form-wrap .bookly-form select:focus, .zozo-booking-form-wrap .bookly-form input[type="text"]:focus, .zozo-booking-form-wrap .bookly-form input[type="number"]:focus, .zozo-booking-form-wrap .bookly-form input[type="password"]:focus, .zozo-booking-form-wrap .bookly-form textarea:focus, .wp-block-button.is-style-outline a.wp-block-button__link, form.post-password-form input:focus, .elementor-element.border-left-cls:before, form.form-inline.search-form .input-group > *.form-control:focus, .team-wrapper.team-style-default .team-inner:after, .charitable-form-fields input:focus, .single .content-widgets-wrapper .wp-block-search__input:focus, .single-cea-team .team-social-wrap ul.social-icons > li > a, .mobile-menu-floating .search-form .search-field:focus, .widget.widget_search .search-form .search-field:focus, .woocommerce nav.woocommerce-pagination ul li a, .woocommerce nav.woocommerce-pagination ul li span, .woocommerce div.product div.images.woocommerce-product-gallery, .woocommerce div.product div.images .flex-control-thumbs li, .form-control:focus, .woocommerce form .form-row input.input-text:focus, .woocommerce form .form-row textarea:focus, .woocommerce form .form-row .input-text:focus, .woocommerce-page form .form-row .input-text:focus, .select2-container--default.select2-container--open.select2-container--below .select2-selection--single, .secondary-bar-inner .feature-box-custom .cea-featured-image, .testimonial-style-default.testimonial-wrapper .owl-carousel .owl-dots, .error404-content .search-form .search-field:focus, .elementor-element.border-left-cls:before, .full-search-wrapper .search-form .search-field:focus, .sticky-head.header-sticky .header-navbar .close, .consultxp-content-wrap .top-meta-wrap ul.nav.post-meta > li span {
		border-color: '. esc_attr( $primary_color ) .';
	}';
	echo '.charitable-donation-form .donation-amount.selected, .charitable-donation-form .donation-amount.selected, .charitable-donation-amount-form .donation-amount.selected, .charitable-notice, .charitable-drag-drop-images li:hover a.remove-image, .supports-drag-drop .charitable-drag-drop-dropzone.drag-over, .cea-mailchimp-style-default input.form-control:focus, .cea-mailchimp-style-inline input.form-control:focus, .woocommerce-cart table.cart td.actions .coupon .input-text:focus, .woocommerce .wc-block-components-price-slider__range-input::-webkit-slider-thumb, .secondary-bar-inner .feature-box-custom.cea-featured-image, .wp-block-columns.cus-cta-widget .wp-block-button a.wp-block-button__link, .secondary-bar-wrapper .secondary-bar-inner input.wpcf7-form-control:focus, .secondary-bar-wrapper .secondary-bar-inner textarea.wpcf7-form-control:focus {
		border-color: '. esc_attr( $primary_color ) .' !important;
	}';		
	echo '.testimonial-wrapper.testimonial-style-default .owl-item .testimonial-inner,
	.full-search-wrapper form.form-inline.search-form .form-control:focus, textarea.wpcf7-form-control:focus {
		border-bottom-color: '. esc_attr( $primary_color ) .';
	}';
	echo '.team-wrapper.team-style-default .team-inner .post-thumb:before, .woocommerce-info, .secondary-menu-toggle.consultxp-toggle span:first-child {
		border-top-color: '. esc_attr( $primary_color ) .';
	}';
	echo '.cea-counter-wrapper.cea-counter-style-modern .counter-value > *,
	.portfolio-style-classic .owl-carousel .owl-item:hover:before {
		-webkit-text-stroke: 1px '. esc_attr( $primary_color ) .';
	}';		
}

//secondary color
$secondary_color = $consultxp_styles->consultxp_get_option( 'secondary-color' );
if( $secondary_color ){
	echo '.secondary-color, .widget-area-right,.consultxp-masonry .bottom-meta-wrap .post-meta .post-more a,  .woocommerce:where(body:not(.woocommerce-uses-block-theme)) .woocommerce-breadcrumb a:hover, .woocommerce .widget_block .wc-block-active-filters .wc-block-active-filters__clear-all:hover, .wc-block-price-filter .wc-block-components-filter-reset-button:hover, .elementor .portfolio-wrapper.portfolio-style-classic .portfolio-inner .post-overlay-items .post-icons a, .custom-post-nav .prev-nav-link a, .custom-post-nav .next-nav-link a, .theme-sec-color, .footer-widget .phone-num a:hover, .footer-widget .footer-email:hover, .testimonial-style-list .testimonial-inner .media-body:after  {
		color: '. esc_attr( $secondary_color ) .';
	}';
	echo '.secondary-bg, .service-style-default .service-inner .post-thumb:hover a:before, .portfolio-style-classic .portfolio-inner .post-overlay-items .post-icons a:hover,
	.single-cea-team .team-social-wrap ul.social-icons > li > a, .header ul.nav.wp-menu li > ul.sub-menu li:hover, .wp-block-columns.secondary-bottom-cols.wp-block-columns-is-layout-flex, .secondary-bar-wrapper .wpcf7 input.wpcf7-submit:hover {
		background-color: '. esc_attr( $secondary_color ) .';
	}';
	echo 'header.consultxp-page-header:after {
		background-color: rgba('. esc_attr( $secondary_rgb ) .', 0.77);
	}';	
	echo '.close:hover, header a.btn.btn-primary:hover, .search-form .input-group .btn:hover, .full-search-wrapper,
.elementor-widget-ceaposts .blog-style-classic-pro .blog-inner .post-date a:hover, .bottom-meta .post-more:hover:before, .blog .consultxp-masonry .post-meta .post-more a:hover:before, 
.consultxp-masonry .bottom-meta-wrap .post-meta .post-more a:hover:before, .woocommerce ul.products li.product .button:hover, .woocommerce div.product .woocommerce-tabs ul.tabs li.active a, .woocommerce div.product .woocommerce-tabs ul.tabs li a:hover, .woocommerce #content input.button:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover, .woocommerce-page #content input.button:hover, .woocommerce-page a.button:hover, .woocommerce-page button.button:hover, .woocommerce-page input.button:hover, .woocommerce input.button.alt:hover, .woocommerce input.button.disabled:hover, .woocommerce input.button:disabled[disabled]:hover, .cart_totals .wc-proceed, .wp-block-columns.secondary-bottom-cols.wp-block-columns-is-layout-flex, .blog-wrapper.blog-style-modern .blog-inner .top-meta .post-category, .single.single-cea-team .team-other-details .team-details-icon:hover, .pagination-single-inner > h6 > a:hover span.arrow, .team-style-default .team-social-wrap ul > li > a, .team-style-classic-pro .team-inner .post-details-outer, .list-icon .elementor-icon-list-items li.elementor-icon-list-item span i:after, .cea-feature-box-img:before, .contact-icon .feature-box-default .media-icon-part .cea-featured-icon:before, .blog-style-default .post-author a > span.author-name, .consultxp-masonry > article .top-meta-wrap li.post-category a, .consultxp-content-wrap .post-category a, .single ul.nav.post-meta > li.post-tag > a, .zozo_social_widget ul.nav.social-icons > li > a:hover i,  .blog-style-classic .blog-inner .post-thumb .post-image-link img, ul.nav.pagination.post-pagination > li > a, ul.nav.pagination.post-pagination > li > span, .blog-style-classic .blog-inner .post-thumb, .blog-wrapper.blog-style-classic .owl-carousel-item .blog-inner, .slider-service-default .service-wrapper .service-inner .service-icon-img-wrap:before, .service-style-modern.service-normal-model .service-inner .service-icon-img-wrap, .service-style-modern .cea-carousel.owl-carousel .service-inner .service-icon-img-wrap, .post-share-wrap ul.social-share > li > a {
		background-color: '. esc_attr( $secondary_color ) .';
	}';	
		echo '.team-style-default .team-social-wrap ul > li > a {
		border-color: '. esc_attr( $secondary_color ) .' !important;
	}';

echo '.zozo-booking-form-wrap .bookly-form select, select,
.cf-style-modern span.wpcf7-form-control-wrap select {
	background-image: url('. esc_url( get_template_directory_uri() . '/assets/images/icon-select.png' ) .'); 
	
}';
echo '.cus-testimonial-default .testimonial-wrapper.testimonial-style-default .testimonial-inner:before, 
.cus-testimonial-page .testimonial-wrapper.testimonial-style-default .testimonial-inner:before  {
	background-image: url('. esc_url( get_template_directory_uri() . '/assets/images/quote-icon.png' ) .'); 
}';
echo '.elementor-element.border-points:before {
	background-image: url('. esc_url( get_template_directory_uri() . '/assets/images/arrow-step.png' ) .'); 
}';
echo '.elementor-element.border-points:after {
	background-image: url('. esc_url( get_template_directory_uri() . '/assets/images/arrow-step-after.png' ) .'); 
}';
echo '.wp-block-columns.cus-cta-widget:before {
	background-image: url('. esc_url( get_template_directory_uri() . '/assets/images/cta-bg.jpg' ) .'); 
}';
echo '.blog-style-modern .blog-inner .post-thumb:before {
	background-image: url('. esc_url( get_template_directory_uri() . '/assets/images/pattern-chart-img.png' ) .'); 
}';
echo '.content-carousel-wrapper.cea-carousel-style-default .owl-stage .owl-slide-item:before {
	background-image: url('. esc_url( get_template_directory_uri() . '/assets/images/up-arrow.png' ) .'); 
}';
}
//body background if boxed
$consultxp_styles->consultxp_bg_settings( 'site-bg', 'body' );

//button color keys -> fore, bg, border, hfore, hbg, hborder
echo '.btn, button, .back-to-top,.header-navbar a.btn.btn-primary, .widget_search .search-form .input-group .btn,button.wp-block-search__button,.btn.bordered:hover,.close,
button.wp-block-search__button,ul.nav.pagination.post-pagination > li > span,.comment-respond input[type="submit"],.wp-block-button__link,.button.button-primary, input[type=button], input[type="submit"], header .mini-cart-dropdown ul.cart-dropdown-menu > li.mini-view-cart a, .woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt,a.zozo-woo-compare-ajax.zozo-btn, .mini-view-wishlist a, .mini-view-cart a,.woocommerce .woocommerce-error .button, .woocommerce .woocommerce-info .button, .woocommerce .woocommerce-message .button, .woocommerce-page .woocommerce-error .button, .woocommerce-page .woocommerce-info .button, .woocommerce-page .woocommerce-message .button, a.zozo-compare-close, a.zozo-sticky-cart-close, a.zozo-sticky-wishlist-close  {';
	$consultxp_styles->consultxp_button_color( 'button-color', 'fore' );
	$consultxp_styles->consultxp_button_color( 'button-color', 'bg' );
	$consultxp_styles->consultxp_button_color( 'button-color', 'border' );
echo '}';
echo '.btn:hover, button:hover, .back-to-top:hover, .header-navbar a.btn.btn-primary:hover, .widget_search .search-form .input-group .btn:hover, button.wp-block-search__button:hover, .btn:focus, button:focus, .back-to-top:focus,.header-navbar a.btn.btn-primary:focus, .widget_search .search-form .input-group .btn:focus, button.wp-block-search__button:focus, .btn:active, button:active, .back-to-top:active,.header-navbar a.btn.btn-primary:active, .widget_search .search-form .input-group .btn:active, button.wp-block-search__button:active,.contact-form-wrapper input.wpcf7-form-control.wpcf7-submit:hover, input[type="submit"]:hover, header .mini-cart-dropdown ul.cart-dropdown-menu > li.mini-view-cart a:hover,nav.post-nav-links .post-page-numbers:hover, .wp-block-button__link:hover,.wp-block-button.is-style-outline a.wp-block-button__link:hover, ul.nav.pagination.post-pagination > li > a:hover, .woocommerce #respond input#submit.alt:hover, .woocommerce a.button.alt:hover, .woocommerce button.button.alt:hover, .woocommerce input.button.alt:hover,a.zozo-woo-compare-ajax.zozo-btn:hover, .mini-view-wishlist a:hover, .mini-view-cart a:hover,.woocommerce .woocommerce-error .button:hover, .woocommerce .woocommerce-info .button:hover, .woocommerce .woocommerce-message .button:hover, .woocommerce-page .woocommerce-error .button:hover, .woocommerce-page .woocommerce-info .button:hover, .woocommerce-page .woocommerce-message .button:hover, a.zozo-compare-close:hover, a.zozo-sticky-cart-close:hover, a.zozo-sticky-wishlist-close:hover {';
	$consultxp_styles->consultxp_button_color( 'button-color', 'hfore' );
	$consultxp_styles->consultxp_button_color( 'button-color', 'hbg' ) ;
	$consultxp_styles->consultxp_button_color( 'button-color', 'hborder' );
echo '}';

//site link color
$consultxp_styles->consultxp_link_color( 'link-color', 'regular', '.header-topbar a' );
$consultxp_styles->consultxp_link_color( 'link-color', 'hover', '.header-topbar a:hover' );
$consultxp_styles->consultxp_link_color( 'link-color', 'active', '.header-topbar a:active, .header-topbar a:focus' );

//site padding
$consultxp_styles->consultxp_padding_settings( 'site-padding', '.consultxp-content-wrap' );

// Menu spacing on Desktop
$consultxp_styles->consultxp_padding_settings( 'header-menu-spacing', 'ul.nav.wp-menu > li');
// mobile header style
$mobilebar_from = $consultxp_styles->consultxp_get_option('mobilebar-responsive');
$mobilebar_from = $mobilebar_from ? absint($mobilebar_from) : 767;
$mobile_height = $consultxp_styles->consultxp_get_option( 'mobilebar-height');
//Apply mobile header bar color
$mobilebar_color = $consultxp_styles->consultxp_get_option( 'header-mobilebar-color' );
$mobilebar_item_color = $consultxp_styles->consultxp_get_option( 'header-mobilebar-item-color' );
//Apply mobile menu color
$mobilemenu_color = $consultxp_styles->consultxp_get_option( 'mobile-menu-color' );
$mobilemenu_item_color = $consultxp_styles->consultxp_get_option( 'mobile-menu-item-color' );
//Apply mobile sidebar width 
$mobile_sidebar_width = $consultxp_styles->consultxp_get_option('mobile-sidebar-width');

echo '@media only screen and (max-width: ' . esc_attr($mobilebar_from) . 'px) {';
    echo '.header-mobilebar { display: flex; }';
    echo '.site-header { display: none; }';
	echo '.header-mobilebar.navbar *{
		color: '. esc_attr( $mobilebar_item_color ) .' !important;
	}';
	echo '.header-mobilebar.navbar {
		background-color: '. esc_attr( $mobilebar_color ) .' !important;
		height: '. esc_attr($mobile_height ) . 'px;
	}';    
	echo '.mobile-menu-active .mobile-menu-floating {
		background-color: '.esc_attr( $mobilemenu_color ).' !important;
	}';    
	echo '.mobile-menu-active .mobile-menu-floating * {
		color: '.esc_attr( $mobilemenu_item_color ).';
	}';    
	echo '.mobile-menu-floating i.close-icon:after, .mobile-menu-floating i.close-icon:before{
		border-bottom-color: '.esc_attr( $mobilemenu_item_color ).';
	}';
echo '}';

echo '@media only screen and (min-width: ' . esc_attr($mobilebar_from + 1) . 'px) {';
    echo '.site-header { display: block; }';
    echo '.header-mobilebar { display: none; }';
	echo '.header-mobilebar.navbar * {
		color: '. esc_attr( $mobilebar_item_color ) .' !important;
	}';
	echo '.header-mobilebar.navbar {
		background-color: '. esc_attr( $mobilebar_color ) .' !important;
	}';	
	echo '.mobile-menu-active .mobile-menu-floating {
		background-color: '. esc_attr( $mobilemenu_color ) .' !important;
	}';	
	echo '.mobile-menu-active .mobile-menu-floating * {
		color: '.esc_attr( $mobilemenu_item_color ).';
	}';	
	echo '.mobile-menu-floating i.close-icon:after, .mobile-menu-floating i.close-icon:before{
		border-bottom-color: '.esc_attr( $mobilemenu_item_color ).' !important;
	}';
echo '}';

if( !empty( $mobile_sidebar_width ) && isset( $mobile_sidebar_width['width'] ) && !empty( $mobile_sidebar_width['width'] ) ){
	echo '@media only screen and (max-width: ' . esc_attr($mobilebar_from) . 'px) {';
    echo '.mobile-menu-active .mobile-menu-floating {
		max-width: '. esc_attr( $mobile_sidebar_width['width'] ) .'px; 
	}';
	echo '}';
}

//page loader
$page_loader = $consultxp_styles->consultxp_image_settings('page_loader');
if( isset( $page_loader['url'] ) && !empty( $page_loader['url'] ) ){
	echo '.page-loader { background-image: url('. esc_url( $page_loader['url']  ) .'); }';
}

//body typo styles
$consultxp_styles->consultxp_typo_settings( 'content-typography', 'body' );

//lead typo styles
$consultxp_styles->consultxp_typo_settings( 'lead-typography', '.lead' );

//h1 typo styles
$consultxp_styles->consultxp_typo_settings( 'h1-typography', 'h1, .h1' );

//h2 typo styles
$consultxp_styles->consultxp_typo_settings( 'h2-typography', 'h2, .h2' );

//h3 typo styles
$consultxp_styles->consultxp_typo_settings( 'h3-typography', 'h3, .h3' );

//h4 typo styles
$consultxp_styles->consultxp_typo_settings( 'h4-typography', 'h4, .h4' );

//h5 typo styles
$consultxp_styles->consultxp_typo_settings( 'h5-typography', 'h5, .h5' );

//h6 typo styles
$consultxp_styles->consultxp_typo_settings( 'h6-typography', 'h6, .h6' );

// Heading Mobile View Typography
echo '@media only screen and (max-width: 767px){';
	
//h1 typo styles
$consultxp_styles->consultxp_typo_settings( 'h1-mobile-typography', 'h1, .h1' );

//h2 typo styles
$consultxp_styles->consultxp_typo_settings( 'h2-mobile-typography', 'h2, .h2' );

//h3 typo styles
$consultxp_styles->consultxp_typo_settings( 'h3-mobile-typography', 'h3, .h3' );

//h4 typo styles
$consultxp_styles->consultxp_typo_settings( 'h4-mobile-typography', 'h4, .h4' );

//h5 typo styles
$consultxp_styles->consultxp_typo_settings( 'h5-mobile-typography', 'h5, .h5' );

//h6 typo styles
$consultxp_styles->consultxp_typo_settings( 'h6-mobile-typography', 'h6, .h6' );

echo '}';

//header typo styles & link color
$consultxp_styles->consultxp_typo_settings( 'header-typography', '.site-header' );
$consultxp_styles->consultxp_link_color( 'header-links-color', 'regular', '.site-header a' );
$consultxp_styles->consultxp_link_color( 'header-links-color', 'hover', '.site-header a:hover' );
$consultxp_styles->consultxp_link_color( 'header-links-color', 'active', '.site-header a:active' );
$consultxp_styles->consultxp_bg_settings( 'header-background', '.site-header' );
$consultxp_styles->consultxp_padding_settings( 'header-padding', '.site-header' );
$consultxp_styles->consultxp_margin_settings( 'header-margin', '.site-header' );
$consultxp_styles->consultxp_border_settings( 'header-border', '.site-header' );

//dropdown style
$consultxp_styles->consultxp_bg_settings( 'dropdown-background', '.primary-menu .menu-item-has-children ul.sub-menu' );
$consultxp_styles->consultxp_link_color( 'dropdown-links-color', 'regular', '.primary-menu .menu-item-has-children ul.sub-menu li a' );
$consultxp_styles->consultxp_link_color( 'dropdown-links-color', 'hover', '.primary-menu .menu-item-has-children ul.sub-menu li a:hover' );
$consultxp_styles->consultxp_link_color( 'dropdown-links-color', 'active', '.primary-menu .menu-item-has-children ul.sub-menu li a:active, .primary-menu li.current-menu-parent > ul.sub-menu > li.current-menu-item > a,
.primary-menu li.current-menu-parent > ul.sub-menu > li.current-menu-ancestor.current-menu-item > a, ul.wp-menu ul.sub-menu li.menu-item.current-menu-ancestor.menu-item-has-children > a' );



//dropdown on sticky style
$consultxp_styles->consultxp_bg_settings( 'dropdown-sticky-background', '.sticky-head.header-sticky .primary-menu .menu-item-has-children ul.sub-menu li' );
$consultxp_styles->consultxp_link_color( 'dropdown-sticky-links-color', 'regular', '.sticky-head.header-sticky .primary-menu .menu-item-has-children ul.sub-menu li a' );
$consultxp_styles->consultxp_link_color( 'dropdown-sticky-links-color', 'hover', '.sticky-head.header-sticky .primary-menu .menu-item-has-children ul.sub-menu li a:hover' );
$consultxp_styles->consultxp_link_color( 'dropdown-sticky-links-color', 'active', '.sticky-head.header-sticky .primary-menu .menu-item-has-children ul.sub-menu li a:active, .sticky-head.header-sticky .primary-menu li.current-menu-parent > ul.sub-menu > li.current-menu-item > a, .sticky-head.header-sticky .primary-menu li.current-menu-parent > ul.sub-menu > li.current-menu-ancestor.current-menu-item > a,.sticky-head.header-sticky ul.wp-menu ul.sub-menu li.menu-item.current-menu-ancestor.menu-item-has-children > a' );

//header topbar typo styles
$consultxp_styles->consultxp_typo_settings( 'header-topbar-typography', '.header-topbar' );

//header topbar styles & link color
$topbar_height = $consultxp_styles->consultxp_get_option('header-topbar-height');
if( !empty( $topbar_height ) && isset( $topbar_height['height'] ) && !empty( $topbar_height['height'] ) ){
	echo '.header-topbar {';
		echo 'line-height: '. esc_attr( $topbar_height['height'] ) .'px;';
	echo '}';
}

$topbar_sticky_height = $consultxp_styles->consultxp_get_option('header-topbar-sticky-height');
if( !empty( $topbar_sticky_height ) && isset( $topbar_sticky_height['height'] ) && !empty( $topbar_sticky_height['height'] ) ){
	echo '.header-sticky .header-topbar {';
		echo 'line-height: '. esc_attr( $topbar_sticky_height['height'] ) .'px;';
	echo '}';
}

$consultxp_styles->consultxp_bg_settings( 'header-topbar-background', '.header-topbar' );
$consultxp_styles->consultxp_padding_settings( 'header-topbar-padding', '.header-topbar' );
$consultxp_styles->consultxp_margin_settings( 'header-topbar-margin', '.header-topbar' );
$consultxp_styles->consultxp_border_settings( 'header-topbar-border', '.header-topbar' );
$consultxp_styles->consultxp_link_color( 'header-topbar-links-color', 'regular', '.header-topbar a' );
$consultxp_styles->consultxp_link_color( 'header-topbar-links-color', 'hover', '.header-topbar a:hover' );
$consultxp_styles->consultxp_link_color( 'header-topbar-links-color', 'active', '.header-topbar a:active, .header-topbar ul.wp-menu > li.current-menu-item > a,.header-topbar ul.nav.wp-menu > li.menu-item-has-children.current_page_parent > a, .header-topbar ul.nav.wp-menu > li.menu-item-has-children.current-menu-ancestor > a' );

//topbar on sticky style
$consultxp_styles->consultxp_bg_settings( 'header-topbar-sticky-background', '.sticky-head.header-sticky .header-topbar' );
$consultxp_styles->consultxp_link_color( 'header-topbar-sticky-links-color', 'regular', '.sticky-head.header-sticky .header-topbar a' );
$consultxp_styles->consultxp_link_color( 'header-topbar-sticky-links-color', 'hover', '.sticky-head.header-sticky .header-topbar a:hover' );
$consultxp_styles->consultxp_link_color( 'header-topbar-sticky-links-color', 'active', '.sticky-head.header-sticky .header-topbar a:active, .sticky-head.header-sticky .header-topbar ul.wp-menu > li.current-menu-item > a, .sticky-head.header-sticky .header-topbar ul.nav.wp-menu > li.menu-item-has-children.current_page_parent > a,.sticky-head.header-sticky .header-topbar ul.nav.wp-menu > li.menu-item-has-children.current-menu-ancestor > a'  );

//header logobar typo styles
$consultxp_styles->consultxp_typo_settings( 'header-logobar-typography', '.header-logobar' );

//header logobar styles & link color
$logobar_height = $consultxp_styles->consultxp_get_option('header-logobar-height');
if( !empty( $logobar_height ) && isset( $logobar_height['height'] ) && !empty( $logobar_height['height'] ) ){
	echo '.header-logobar {';
		echo 'line-height: '. esc_attr( $logobar_height['height'] ) .'px;';
	echo '}';
}

$logobar_sticky_height = $consultxp_styles->consultxp_get_option('header-logobar-sticky-height');
if( !empty( $logobar_sticky_height ) && isset( $logobar_sticky_height['height'] ) && !empty( $logobar_sticky_height['height'] ) ){
	echo '.header-sticky .header-logobar {';
		echo 'line-height: '. esc_attr( $logobar_sticky_height['height'] ) .'px;';
	echo '}';
}

$consultxp_styles->consultxp_bg_settings( 'header-logobar-background', '.header-logobar' );
$consultxp_styles->consultxp_padding_settings( 'header-logobar-padding', '.header-logobar' );
$consultxp_styles->consultxp_margin_settings( 'header-logobar-margin', '.header-logobar' );
$consultxp_styles->consultxp_border_settings( 'header-logobar-border', '.header-logobar' ); 
$consultxp_styles->consultxp_link_color( 'header-logobar-links-color', 'regular', '.header-logobar a' );
$consultxp_styles->consultxp_link_color( 'header-logobar-links-color', 'hover', '.header-logobar a:hover' );
$consultxp_styles->consultxp_link_color( 'header-logobar-links-color', 'active', '.header-logobar a:active, .header-logobar ul.wp-menu > li.current-menu-item > a,.header-logobar ul.nav.wp-menu > li.menu-item-has-children.current_page_parent > a, .header-logobar ul.nav.wp-menu > li.menu-item-has-children.current-menu-ancestor > a' );

//logobar on sticky style
$consultxp_styles->consultxp_bg_settings( 'header-logobar-sticky-background', '.sticky-head.header-sticky .header-logobar' );
$consultxp_styles->consultxp_link_color( 'header-logobar-sticky-links-color', 'regular', '.sticky-head.header-sticky .header-logobar a' );
$consultxp_styles->consultxp_link_color( 'header-logobar-sticky-links-color', 'hover', '.sticky-head.header-sticky .header-logobar a:hover' );
$consultxp_styles->consultxp_link_color( 'header-logobar-sticky-links-color', 'active', '.sticky-head.header-sticky .header-logobar a:active, .sticky-head.header-sticky .header-logobar ul.wp-menu > li.current-menu-item > a, .sticky-head.header-sticky .header-logobar ul.nav.wp-menu > li.menu-item-has-children.current_page_parent > a,.sticky-head.header-sticky .header-logobar ul.nav.wp-menu > li.menu-item-has-children.current-menu-ancestor > a' );

//header navbar typo styles
$consultxp_styles->consultxp_typo_settings( 'header-navbar-typography', '.header-navbar' );

//header navbar styles & link color
$navbar_height = $consultxp_styles->consultxp_get_option('header-navbar-height');
if( !empty( $navbar_height ) && isset( $navbar_height['height'] ) && !empty( $navbar_height['height'] ) ){
	echo '.header-navbar {';
		echo 'line-height: '. esc_attr( $navbar_height['height'] ) .'px;';
	echo '}';
}

$navbar_sticky_height = $consultxp_styles->consultxp_get_option('header-navbar-sticky-height');
if( !empty( $navbar_sticky_height ) && isset( $navbar_sticky_height['height'] ) && !empty( $navbar_sticky_height['height'] ) ){
	echo '.header-sticky .header-navbar {';
		echo 'line-height: '. esc_attr( $navbar_sticky_height['height'] ) .'px;';
	echo '}';
}

$consultxp_styles->consultxp_bg_settings( 'header-navbar-background', '.header-navbar' );
$consultxp_styles->consultxp_padding_settings( 'header-navbar-padding', '.header-navbar' );
$consultxp_styles->consultxp_margin_settings( 'header-navbar-margin', '.header-navbar' );
$consultxp_styles->consultxp_border_settings( 'header-navbar-border', '.header-navbar' );
$consultxp_styles->consultxp_link_color( 'header-navbar-links-color', 'regular', '.header-navbar a' );
$consultxp_styles->consultxp_link_color( 'header-navbar-links-color', 'hover', '.header-navbar a:hover' );
$consultxp_styles->consultxp_link_color( 'header-navbar-links-color', 'active', '.header-navbar a:active, .header-navbar ul.wp-menu > li.current-menu-item > a, .header-navbar ul.nav.wp-menu > li.menu-item-has-children.current-menu-ancestor > a' );

//navbar on sticky style
$consultxp_styles->consultxp_bg_settings( 'header-navbar-sticky-background', '.sticky-head.header-sticky .header-navbar' );
$consultxp_styles->consultxp_link_color( 'header-navbar-sticky-links-color', 'regular', '.sticky-head.header-sticky .header-navbar a' );
$consultxp_styles->consultxp_link_color( 'header-navbar-sticky-links-color', 'hover', '.sticky-head.header-sticky .header-navbar a:hover' );
$consultxp_styles->consultxp_link_color( 'header-navbar-sticky-links-color', 'active', '.sticky-head.header-sticky .header-navbar a:active, .sticky-head.header-sticky .header-navbar ul.wp-menu > li.current-menu-item > a, .sticky-head.header-sticky .header-navbar ul.nav.wp-menu > li.menu-item-has-children.current-menu-ancestor > a, .sticky-head.header-sticky .header-navbar a.active' );

//logo styles
$site_logo_width = $consultxp_styles->consultxp_get_option('site-logo-width');
if( !empty( $site_logo_width ) && isset( $site_logo_width['width'] ) && !empty( $site_logo_width['width'] ) ){
	echo 'img.site-logo { max-width: '. esc_attr( $site_logo_width['width'] ) .'px; }';
}
$sticky_logo_width = $consultxp_styles->consultxp_get_option('sticky-logo-width');
if( !empty( $sticky_logo_width ) && isset( $sticky_logo_width['width'] ) && !empty( $sticky_logo_width['width'] ) ){
	echo 'img.sticky-logo { max-width: '. esc_attr( $sticky_logo_width['width'] ) .'px; }';
}
$mobile_logo_width = $consultxp_styles->consultxp_get_option('mobile-logo-width');
if( !empty( $mobile_logo_width ) && isset( $mobile_logo_width['width'] ) && !empty( $mobile_logo_width['width'] ) ){
	echo 'img.mobile-logo { max-width: '. esc_attr( $mobile_logo_width['width'] ) .'px; }';
}


//blog page title settings
$consultxp_styles->consultxp_color( 'blog-title-color', '.blog .page-title-wrap .page-title, .blog .page-title-wrap .breadcrumb li' );
$consultxp_styles->consultxp_color( 'blog-title-desc-color', '.blog .page-title-wrap .page-subtitle' );
$consultxp_styles->consultxp_link_color( 'blog-title-link-color', 'regular', '.blog .page-title-wrap .breadcrumb a' );
$consultxp_styles->consultxp_link_color( 'blog-title-link-color', 'hover', '.blog .page-title-wrap .breadcrumb a:hover' );
$consultxp_styles->consultxp_link_color( 'blog-title-link-color', 'active', '.blog .page-title-wrap .breadcrumb a:active' );
$consultxp_styles->consultxp_bg_settings( 'blog-title-bg', '.blog .consultxp-page-header' );
$consultxp_styles->consultxp_padding_settings( 'blog-title-padding', '.blog .page-title-wrap' );
$consultxp_styles->consultxp_bg_settings( 'blog-title-overlaycolor', '.blog .consultxp-page-header:after' );
$blog_overlay = $consultxp_styles->consultxp_get_option( 'blog-title-overlaycolor' );
echo '.blog .consultxp-page-header:after {
    background-color: ' . esc_attr( $blog_overlay ) . ';
}';

//archive page title settings
$consultxp_styles->consultxp_color( 'archive-title-color', '.archive .page-title-wrap .page-title, .archive .page-title-wrap .breadcrumb li, .search .page-title-wrap .page-title, .search .page-title-wrap .breadcrumb li' );
$consultxp_styles->consultxp_color( 'archive-title-desc-color', '.archive .page-title-wrap .page-subtitle, .search .page-title-wrap .page-subtitle' );
$consultxp_styles->consultxp_link_color( 'archive-title-link-color', 'regular', '.archive .page-title-wrap .breadcrumb a, .search .page-title-wrap .breadcrumb a' );
$consultxp_styles->consultxp_link_color( 'archive-title-link-color', 'hover', '.archive .page-title-wrap .breadcrumb a:hover, .search .page-title-wrap .breadcrumb a:hover' );
$consultxp_styles->consultxp_link_color( 'archive-title-link-color', 'active', '.archive .page-title-wrap .breadcrumb a:active, .search .page-title-wrap .breadcrumb a:active' );
$consultxp_styles->consultxp_bg_settings( 'archive-title-bg', '.archive .consultxp-page-header, .search .consultxp-page-header' );
$consultxp_styles->consultxp_padding_settings( 'archive-title-padding', '.archive .page-title-wrap, .search .page-title-wrap' );
$consultxp_styles->consultxp_bg_settings( 'archive-title-overlaycolor', '.archive .consultxp-page-header:after, .search .consultxp-page-header:after' );
$archive_overlay = $consultxp_styles->consultxp_get_option( 'archive-title-overlaycolor' );
echo '.archive .consultxp-page-header:after, .search .consultxp-page-header:after {
    background-color: ' . esc_attr( $archive_overlay ) . ';
}';

//single post page title settings
$consultxp_styles->consultxp_color( 'single-title-color', '.single-post .page-title-wrap .page-title, .single-post .page-title-wrap .breadcrumb li, .single-product .page-title-wrap .page-title, .single-product .page-title-wrap .breadcrumb li, .single-campaign .page-title-wrap .page-title, .single-campaign .page-title-wrap .breadcrumb li' );
$consultxp_styles->consultxp_color( 'single-title-desc-color', '.single-post .page-title-wrap .page-subtitle, .single-product .page-title-wrap .page-subtitle, .single-campaign .page-title-wrap .page-subtitle' );
$consultxp_styles->consultxp_link_color( 'single-title-link-color', 'regular', '.single-post .page-title-wrap .breadcrumb a, .single-product .page-title-wrap .breadcrumb a, .single-campaign .page-title-wrap .breadcrumb a' );
$consultxp_styles->consultxp_link_color( 'single-title-link-color', 'hover', '.single-post .page-title-wrap .breadcrumb a:hover, .single-product .page-title-wrap .breadcrumb a:hover, .single-campaign .page-title-wrap .breadcrumb a:hover' );
$consultxp_styles->consultxp_link_color( 'single-title-link-color', 'active', '.single-post .page-title-wrap .breadcrumb a:active, .single-product .page-title-wrap .breadcrumb a:active, .single-campaign .page-title-wrap .breadcrumb a:active' );
$consultxp_styles->consultxp_bg_settings( 'single-title-bg', '.single-post .consultxp-page-header, .single-product .consultxp-page-header, .single-campaign .consultxp-page-header' );
$consultxp_styles->consultxp_padding_settings( 'single-title-padding', '.single-post .page-title-wrap, .single-product .page-title-wrap, .single-campaign .page-title-wrap' );
$consultxp_styles->consultxp_bg_settings( 'single-title-overlaycolor', '.single-post .consultxp-page-header:after, .single-product .consultxp-page-header:after, .single-product .consultxp-page-header:after, body.single-doctors-directory.doctors-directory-template-default .consultxp-page-header:after' );
$single_overlay = $consultxp_styles->consultxp_get_option( 'single-title-overlaycolor' );
echo '.single-post .consultxp-page-header:after, .single-product .consultxp-page-header:after, .single-product .consultxp-page-header:after, body.single-doctors-directory.doctors-directory-template-default .consultxp-page-header:after {
    background-color: ' . esc_attr( $single_overlay ) . ';
}';

//page title settings
$consultxp_styles->consultxp_color( 'page-title-color', '.page .page-title-wrap .page-title, .page .page-title-wrap .breadcrumb li, .error404 .page-title-wrap .page-title, .error404 .page-title-wrap .breadcrumb li' );
$consultxp_styles->consultxp_color( 'page-title-desc-color', '.page .page-title-wrap .page-subtitle, .error404 .page-title-wrap .page-subtitle' );
$consultxp_styles->consultxp_link_color( 'page-title-link-color', 'regular', '.page .page-title-wrap .breadcrumb a, .error404 .page-title-wrap .breadcrumb a' );
$consultxp_styles->consultxp_link_color( 'page-title-link-color', 'hover', '.page .page-title-wrap .breadcrumb a:hover, .error404 .page-title-wrap .breadcrumb a:hover' );
$consultxp_styles->consultxp_link_color( 'page-title-link-color', 'active', '.page .page-title-wrap .breadcrumb a:active, .error404 .page-title-wrap .breadcrumb a:active' );
$consultxp_styles->consultxp_bg_settings( 'page-title-bg', '.page .consultxp-page-header, .error404 .consultxp-page-header' );
$consultxp_styles->consultxp_padding_settings( 'page-title-padding', '.page .page-title-wrap, .error404 .page-title-wrap' );
$consultxp_styles->consultxp_bg_settings( 'page-title-overlaycolor','.page .consultxp-page-header:after, .error404 .consultxp-page-header:after');
$page_title_overlay = $consultxp_styles->consultxp_get_option( 'page-title-overlaycolor' );
echo '.page .consultxp-page-header:after, .error404 .consultxp-page-header:after{
	background-color: ' . esc_attr($page_title_overlay) . ';
}';

//Custom Post Single title settings
$consultxp_styles->consultxp_color( 'custom-single-title-color', '.single[class*="single-cea-"] .page-title-wrap .page-title, .single[class*="single-cea-"] .page-title-wrap .breadcrumb li' );
$consultxp_styles->consultxp_color( 'custom-single-title-desc-color', '.single[class*="single-cea-"] .page-title-wrap .page-subtitle' );
$consultxp_styles->consultxp_link_color( 'custom-single-title-link-color', 'regular', '.single[class*="single-cea-"] .page-title-wrap .breadcrumb a' );
$consultxp_styles->consultxp_link_color( 'custom-single-title-link-color', 'hover', '.single[class*="single-cea-"] .page-title-wrap .breadcrumb a:hover' );
$consultxp_styles->consultxp_link_color( 'custom-single-title-link-color', 'active', '.single[class*="single-cea-"] .page-title-wrap .breadcrumb a:active' );
$consultxp_styles->consultxp_bg_settings( 'custom-single-title-bg', '.single[class*="single-cea-"] .consultxp-page-header' );
$consultxp_styles->consultxp_padding_settings( 'custom-single-title-padding', '.single[class*="single-cea-"] .page-title-wrap' );
$consultxp_styles->consultxp_bg_settings( 'custom-single-title-overlaycolor','.single[class*="single-cea-"] .consultxp-page-header:after');
$custom_single_overlay = $consultxp_styles->consultxp_get_option( 'custom-single-title-overlaycolor' );
echo '.single[class*="single-cea-"] .consultxp-page-header:after {
	background-color: ' . esc_attr($custom_single_overlay) . ';
}';


//Custom Post Service Single title settings
$consultxp_styles->consultxp_color( 'cea-service-title-color', '.single.single-cea-service .page-title-wrap .page-title, .single-cea-service .page-title-wrap .breadcrumb li' );
$consultxp_styles->consultxp_color( 'cea-service-title-desc-color', '.single.single-cea-service .page-title-wrap .page-subtitle' );
$consultxp_styles->consultxp_link_color( 'cea-service-title-link-color', 'regular', '.single.single-cea-service .page-title-wrap .breadcrumb a' );
$consultxp_styles->consultxp_link_color( 'cea-service-title-link-color', 'hover', '.single.single-cea-service .page-title-wrap .breadcrumb a:hover' );
$consultxp_styles->consultxp_link_color( 'cea-service-title-link-color', 'active', '.single.single-cea-service .page-title-wrap .breadcrumb a:active' );
$consultxp_styles->consultxp_bg_settings( 'cea-service-title-bg', '.single.single-cea-service .consultxp-page-header' );
$consultxp_styles->consultxp_padding_settings( 'cea-service-title-padding', '.single.single-cea-service .page-title-wrap' );
$consultxp_styles->consultxp_bg_settings( 'cea-service-overlaycolor','.single.single-cea-service .consultxp-page-header:after');
$service_overlay = $consultxp_styles->consultxp_get_option( 'cea-service-overlaycolor' );
echo '.single.single-cea-service .consultxp-page-header:after {
	background-color: ' . esc_attr($service_overlay) . ';
}';


//Custom Post Team Single title settings
$consultxp_styles->consultxp_color( 'cea-team-title-color', '.single.single-cea-team .page-title-wrap .page-title, .single-cea-team .page-title-wrap .breadcrumb li' );
$consultxp_styles->consultxp_color( 'cea-team-title-desc-color', '.single.single-cea-team .page-title-wrap .page-subtitle' );
$consultxp_styles->consultxp_link_color( 'cea-team-title-link-color', 'regular', '.single.single-cea-team .page-title-wrap .breadcrumb a' );
$consultxp_styles->consultxp_link_color( 'cea-team-title-link-color', 'hover', '.single.single-cea-team .page-title-wrap .breadcrumb a:hover' );
$consultxp_styles->consultxp_link_color( 'cea-team-title-link-color', 'active', '.single.single-cea-team .page-title-wrap .breadcrumb a:active' );
$consultxp_styles->consultxp_bg_settings( 'cea-team-title-bg', '.single.single-cea-team .consultxp-page-header' );
$consultxp_styles->consultxp_padding_settings( 'cea-team-title-padding', '.single.single-cea-team .page-title-wrap' );
$consultxp_styles->consultxp_bg_settings( 'cea-team-overlaycolor','.single.single-cea-team .consultxp-page-header:after');
$team_overlay = $consultxp_styles->consultxp_get_option( 'cea-team-overlaycolor' );
echo '.single.single-cea-team .consultxp-page-header:after {
	background-color: ' . esc_attr($team_overlay) . ';
}';


//Custom Post Testimonial Single title settings
$consultxp_styles->consultxp_color( 'cea-testimonial-title-color', '.single.single-cea-testimonial .page-title-wrap .page-title, .single-cea-testimonial .page-title-wrap .breadcrumb li' );
$consultxp_styles->consultxp_color( 'cea-testimonial-title-desc-color', '.single.single-cea-testimonial .page-title-wrap .page-subtitle' );
$consultxp_styles->consultxp_link_color( 'cea-testimonial-title-link-color', 'regular', '.single.single-cea-testimonial .page-title-wrap .breadcrumb a' );
$consultxp_styles->consultxp_link_color( 'cea-testimonial-title-link-color', 'hover', '.single.single-cea-testimonial .page-title-wrap .breadcrumb a:hover' );
$consultxp_styles->consultxp_link_color( 'cea-testimonial-title-link-color', 'active', '.single.single-cea-testimonial .page-title-wrap .breadcrumb a:active' );
$consultxp_styles->consultxp_bg_settings( 'cea-testimonial-title-bg', '.single.single-cea-testimonial .consultxp-page-header' );
$consultxp_styles->consultxp_padding_settings( 'cea-testimonial-title-padding', '.single.single-cea-testimonial .page-title-wrap' );
$consultxp_styles->consultxp_bg_settings( 'cea-testimonial-overlaycolor','.single.single-cea-testimonial .consultxp-page-header:after');
$testimonial_overlay = $consultxp_styles->consultxp_get_option( 'cea-testimonial-overlaycolor' );
echo '.single.single-cea-testimonial .consultxp-page-header:after {
	background-color: ' . esc_attr($testimonial_overlay) . ';
}';


//Custom Post Portfolio Single title settings
$consultxp_styles->consultxp_color( 'cea-portfolio-title-color', '.single.single-cea-portfolio .page-title-wrap .page-title, .single-cea-portfolio .page-title-wrap .breadcrumb li' );
$consultxp_styles->consultxp_color( 'cea-portfolio-title-desc-color', '.single.single-cea-portfolio .page-title-wrap .page-subtitle' );
$consultxp_styles->consultxp_link_color( 'cea-portfolio-title-link-color', 'regular', '.single.single-cea-portfolio .page-title-wrap .breadcrumb a' );
$consultxp_styles->consultxp_link_color( 'cea-portfolio-title-link-color', 'hover', '.single.single-cea-portfolio .page-title-wrap .breadcrumb a:hover' );
$consultxp_styles->consultxp_link_color( 'cea-portfolio-title-link-color', 'active', '.single.single-cea-portfolio .page-title-wrap .breadcrumb a:active' );
$consultxp_styles->consultxp_bg_settings( 'cea-portfolio-title-bg', '.single.single-cea-portfolio .consultxp-page-header' );
$consultxp_styles->consultxp_padding_settings( 'cea-portfolio-title-padding', '.single.single-cea-portfolio .page-title-wrap' );
$consultxp_styles->consultxp_bg_settings( 'cea-portfolio-overlaycolor','.single.single-cea-portfolio .consultxp-page-header:after');
$portfolio_overlay = $consultxp_styles->consultxp_get_option( 'cea-portfolio-overlaycolor' );
echo '.single.single-cea-portfolio .consultxp-page-header:after {
	background-color: ' . esc_attr($portfolio_overlay) . ';
}';

//Custom Post Event Single title settings
$consultxp_styles->consultxp_color( 'cea-event-title-color', '.single.single-cea-event .page-title-wrap .page-title, .single-cea-event .page-title-wrap .breadcrumb li' );
$consultxp_styles->consultxp_color( 'cea-event-title-desc-color', '.single.single-cea-event .page-title-wrap .page-subtitle' );
$consultxp_styles->consultxp_link_color( 'cea-event-title-link-color', 'regular', '.single.single-cea-event .page-title-wrap .breadcrumb a' );
$consultxp_styles->consultxp_link_color( 'cea-event-title-link-color', 'hover', '.single.single-cea-event .page-title-wrap .breadcrumb a:hover' );
$consultxp_styles->consultxp_link_color( 'cea-event-title-link-color', 'active', '.single.single-cea-event .page-title-wrap .breadcrumb a:active' );
$consultxp_styles->consultxp_bg_settings( 'cea-event-title-bg', '.single.single-cea-event .consultxp-page-header' );
$consultxp_styles->consultxp_padding_settings( 'cea-event-title-padding', '.single.single-cea-event .page-title-wrap' );
$consultxp_styles->consultxp_bg_settings( 'cea-event-overlaycolor','.single.single-cea-event .consultxp-page-header:after');
$portfolio_overlay = $consultxp_styles->consultxp_get_option( 'cea-event-overlaycolor' );
echo '.single.single-cea-event .consultxp-page-header:after {
	background-color: ' . esc_attr($portfolio_overlay) . ';
}';


//shop page title settings
$consultxp_styles->consultxp_color( 'shop-title-color', '.woocommerce-shop .page-title-wrap .page-title, .woocommerce-shop .page-title-wrap .breadcrumb li' );
$consultxp_styles->consultxp_color( 'shop-title-desc-color', '.woocommerce-shop .page-title-wrap .page-subtitle' );
$consultxp_styles->consultxp_link_color( 'shop-title-link-color', 'regular', '.woocommerce-shop .page-title-wrap .breadcrumb a' );
$consultxp_styles->consultxp_link_color( 'shop-title-link-color', 'hover', '.woocommerce-shop .page-title-wrap .breadcrumb a:hover' );
$consultxp_styles->consultxp_link_color( 'shop-title-link-color', 'active', '.woocommerce-shop .page-title-wrap .breadcrumb a:active' );
$consultxp_styles->consultxp_bg_settings( 'shop-title-bg', '.woocommerce-shop .consultxp-page-header' );
$consultxp_styles->consultxp_padding_settings( 'shop-title-padding', '.woocommerce-shop .page-title-wrap' );
$consultxp_styles->consultxp_bg_settings( 'shop-title-overlaycolor', '.woocommerce-shop .consultxp-page-header:after' );

//woocommerce product page title settings
$consultxp_styles->consultxp_color( 'product-title-color', '.woocommerce-product .page-title-wrap .page-title, .woocommerce-product .page-title-wrap .breadcrumb li' );
$consultxp_styles->consultxp_color( 'product-title-desc-color', '.woocommerce-product .page-title-wrap .page-subtitle' );
$consultxp_styles->consultxp_link_color( 'product-title-link-color', 'regular', '.woocommerce-product .page-title-wrap .breadcrumb a' );
$consultxp_styles->consultxp_link_color( 'product-title-link-color', 'hover', '.woocommerce-product .page-title-wrap .breadcrumb a:hover' );
$consultxp_styles->consultxp_link_color( 'product-title-link-color', 'active', '.woocommerce-product .page-title-wrap .breadcrumb a:active' );
$consultxp_styles->consultxp_bg_settings( 'product-title-bg', '.woocommerce-page .consultxp-page-header' );
$consultxp_styles->consultxp_padding_settings( 'product-title-padding', '.woocommerce-product .page-title-wrap' );
$consultxp_styles->consultxp_bg_settings( 'product-title-overlaycolor', '.woocommerce-shop .consultxp-page-header:after' );

//woocommerce product category page title settings
$consultxp_styles->consultxp_color( 'shop-title-color', '.consultxp-woo-category .page-title-wrap .page-title, .consultxp-woo-category .page-title-wrap .breadcrumb li' );
$consultxp_styles->consultxp_color( 'shop-title-desc-color', '.consultxp-woo-category .page-title-wrap .page-subtitle' );
$consultxp_styles->consultxp_link_color( 'shop-title-link-color', 'regular', '.consultxp-woo-category .page-title-wrap .breadcrumb a' );
$consultxp_styles->consultxp_link_color( 'shop-title-link-color', 'hover', '.consultxp-woo-category .page-title-wrap .breadcrumb a:hover' );
$consultxp_styles->consultxp_link_color( 'shop-title-link-color', 'active', '.consultxp-woo-category .page-title-wrap .breadcrumb a:active' );
$consultxp_styles->consultxp_bg_settings( 'shop-title-bg', '.consultxp-woo-category .consultxp-page-header' );
$consultxp_styles->consultxp_padding_settings( 'shop-title-padding', '.consultxp-woo-category .page-title-wrap' );
$consultxp_styles->consultxp_bg_settings( 'shop-title-overlaycolor', '.consultxp-woo-category .consultxp-page-header:after' );

//footer styles and link color
$consultxp_styles->consultxp_typo_settings( 'footer-typography', '.site-footer' );
$consultxp_styles->consultxp_bg_settings( 'footer-background', '.site-footer' );
$consultxp_styles->consultxp_padding_settings( 'footer-padding', '.site-footer' );
$consultxp_styles->consultxp_margin_settings( 'footer-margin', '.site-footer' );
$consultxp_styles->consultxp_border_settings( 'footer-border', '.site-footer' );
$consultxp_styles->consultxp_link_color( 'footer-links-color', 'regular', '.site-footer a' );
$consultxp_styles->consultxp_link_color( 'footer-links-color', 'hover', '.site-footer a:hover' );
$consultxp_styles->consultxp_link_color( 'footer-links-color', 'active', '.site-footer a:active' );

//footer top styles and link color
$consultxp_styles->consultxp_typo_settings( 'insta-footer-typography', '.insta-footer-wrap' );
$consultxp_styles->consultxp_bg_settings( 'insta-footer-background', '.insta-footer-wrap' );
$consultxp_styles->consultxp_padding_settings( 'insta-footer-padding', '.insta-footer-wrap' );
$consultxp_styles->consultxp_margin_settings( 'insta-footer-margin', '.insta-footer-wrap' );
$consultxp_styles->consultxp_border_settings( 'insta-footer-border', '.insta-footer-wrap' );
$consultxp_styles->consultxp_link_color( 'insta-footer-links-color', 'regular', '.insta-footer-wrap a' );
$consultxp_styles->consultxp_link_color( 'insta-footer-links-color', 'hover', '.insta-footer-wrap a:hover' );
$consultxp_styles->consultxp_link_color( 'insta-footer-links-color', 'active', '.insta-footer-wrap a:active' );

//footer widgets part styles and link color
$consultxp_styles->consultxp_typo_settings( 'footer-widgets-typography', '.footer-widgets-wrap' );
$consultxp_styles->consultxp_bg_settings( 'footer-widgets-background', '.footer-widgets-wrap' );
$consultxp_styles->consultxp_padding_settings( 'footer-widgets-padding', '.footer-widgets-wrap' );
$consultxp_styles->consultxp_margin_settings( 'footer-widgets-margin', '.footer-widgets-wrap' );
$consultxp_styles->consultxp_border_settings( 'footer-widgets-border', '.footer-widgets-wrap' );
$consultxp_styles->consultxp_link_color( 'footer-widgets-links-color', 'regular', '.footer-widgets-wrap a' );
$consultxp_styles->consultxp_link_color( 'footer-widgets-links-color', 'hover', '.footer-widgets-wrap a:hover' );
$consultxp_styles->consultxp_link_color( 'footer-widgets-links-color', 'active', '.footer-widgets-wrap a:active' );

//footer bottom styles and link color
$consultxp_styles->consultxp_typo_settings( 'copyright-section-typography', '.footer-bottom-wrap' );
$consultxp_styles->consultxp_bg_settings( 'copyright-section-background', '.footer-bottom-wrap' );
$consultxp_styles->consultxp_padding_settings( 'copyright-section-padding', '.footer-bottom-wrap' );
$consultxp_styles->consultxp_margin_settings( 'copyright-section-margin', '.footer-bottom-wrap' );
$consultxp_styles->consultxp_border_settings( 'copyright-section-border', '.footer-bottom-wrap' );
$consultxp_styles->consultxp_link_color( 'copyright-section-links-color', 'regular', '.footer-bottom-wrap a' );
$consultxp_styles->consultxp_link_color( 'copyright-section-links-color', 'hover', '.footer-bottom-wrap a:hover' );
$consultxp_styles->consultxp_link_color( 'copyright-section-links-color', 'active', '.footer-bottom-wrap a:active' );

//secondary bar styles
if( $primary_color && $secondary_color ){
	echo '.secondary-bar-wrapper { background: linear-gradient(90deg, '. esc_attr( $primary_color ) .' 0%, '. esc_attr( $secondary_color ) .' 100%); }';
	
	
	echo '.page-load-initiate .page-loader:before, .page-load-end .page-loader:before, .page-load-initiate .page-loader:after, .page-load-end .page-loader:after { 
		background: linear-gradient(90deg, '. esc_attr( $primary_color ) .' 0%, '. esc_attr( $secondary_color ) .' 100%);
		background: -webkit-gradient(linear, left top, right top, from('. esc_attr( $secondary_color ) .'), to('. esc_attr( $primary_color ) .'));
		background: -webkit-linear-gradient(left, '. esc_attr( $secondary_color ) .' 0%, '. esc_attr( $primary_color ) .' 100%);
		background: -o-linear-gradient(left, '. esc_attr( $secondary_color ) .' 0%, '. esc_attr( $primary_color ) .' 100%);
		background: linear-gradient(to right, '. esc_attr( $secondary_color ) .' 0%, '. esc_attr( $primary_color ) .' 100%);
	}';
}
$secondary_sidebar_width = $consultxp_styles->consultxp_dimension_settings( 'secondary-sidebar-width', 'width' );
$consultxp_styles->consultxp_padding_settings( 'secondary-sidebar-padding', '.secondary-bar-inner' );
$consultxp_styles->consultxp_margin_settings( 'secondary-sidebar-margin', '.secondary-bar-inner' );
if( $secondary_sidebar_width ){
	echo '.secondary-bar-inner {
		width: '. esc_attr( $secondary_sidebar_width ) .';
	}';
	echo '.secondary-bar-wrapper.from-left .secondary-bar-inner {
		left: -'. esc_attr( $secondary_sidebar_width ) .';
	}';
	echo '.secondary-bar-wrapper.from-right .secondary-bar-inner {
		right: -'. esc_attr( $secondary_sidebar_width ) .';
	}';
	echo '.secondary-bar-wrapper.from-top .secondary-bar-inner {
		width: '. esc_attr( $secondary_sidebar_width ) .';
	}';
}

// Background Color and Image
$consultxp_styles->consultxp_bg_settings('secondary-sidebar-bg-color', 'body.secondary-bar-active .secondary-bar-wrapper, body .secondary-bar-wrapper');

//End style

$styles = ob_get_clean();

$gf_arr = Consultxp_Theme_Styles::$consultxp_gf_array;
update_option( 'consultxp_google_fonts_list', $gf_arr );
update_option( 'consultxp_custom_styles', wp_slash( $styles ) );