<?php

// Woocommerce
Consultxp_Options::consultxp_set_section( array(
	'title'      => esc_html__( 'Woocommerce', 'consultxp-addon' ),
	'id'         => 'woocommerce-tab',
	'config_id'  => '',
) );

Consultxp_Options::consultxp_set_sub_section( array(
	'title'      => esc_html__( 'Shop', 'consultxp-addon' ),
	'id'         => 'shop-tab',
	'config_id'  => '',
	'fields'	 => array(
		array(
			'id'			=> 'shop-settings',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Shop Page Title Settings', 'consultxp-addon' ),
			'desc'	=> esc_html__( 'This is settings for shop page title.', 'consultxp-addon' ),
			'seperator'		=> 'after'
		),
		array(
			'id'			=> 'shop-title',
			'type'			=> 'toggle',
			'title'			=> esc_html__( 'Enable/Disable Shop Page Title', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Toggle to display the page title in the Shop Page title section.', 'consultxp-addon' ),
			'default'		=> true
		),
		array(
			'id'			=> 'shop-title-items',
			'type'			=> 'dragdrop',
			'title'			=> esc_html__( 'Shop Page Title Elements', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Arrange and customize the elements in the Shop Page Title section using a drag-and-drop interface.', 'consultxp-addon' ),
			'default'		=> array(
				'left' => array(
				),
				'center' => array(
					'title' => esc_html__( 'Title', 'consultxp-addon' ),
					'breadcrumb' => esc_html__( 'Breadcrumb', 'consultxp-addon' )
				),
				'right' => array(
				),
				'disabled' => array(
					'description' => esc_html__( 'Description', 'consultxp-addon' )
				)
			),
		),
		array(
			'id'			=> 'shop-title-color',
			'type'			=> 'color',
			'title'			=> esc_html__( 'Shop Page Title Color', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Set the color for the title of the shop page.', 'consultxp-addon' ),
			'required'		=> array( 'shop-title', '=', array( 'true' ) )
		),
		array(
			'id'			=> 'shop-title-desc-color',
			'type'			=> 'color',
			'title'			=> esc_html__( 'Shop Page Title Description Color', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Set the color for the description of the shop page.', 'consultxp-addon' ),
			'required'		=> array( 'shop-title', '=', array( 'true' ) )
		),
		array(
			'id'			=> 'shop-title-link-color',
			'type'			=> 'link',
			'title'			=> esc_html__( 'Shop Page Title Link Color', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Set the color for the hyperlinks of the shop page title. Like breadcrumbs color.', 'consultxp-addon' ),
			'default'		=> '',
			'required'		=> array( 'shop-title', '=', array( 'true' ) )
		),
		array(
			'id'			=> 'shop-title-padding',
			'type'			=> 'dimension',
			'title'			=> esc_html__( 'Shop Page Title Padding', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Adjust the padding (inner spacing) around the shop page Title section.', 'consultxp-addon' ),
			'default'		=> '',
			'required'		=> array( 'shop-title', '=', array( 'true' ) )
		),
		array(
			'id'			=> 'shop-title-bg',
			'type'			=> 'background',
			'title'			=> esc_html__( 'Shop Page Title Background Options', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Choose background settings for the Shop Page Title section, including color, image, size, etc.', 'consultxp-addon' ),
			'required'		=> array( 'shop-title', '=', array( 'true' ) )
		),
		array(
			'id'			=> 'shop-title-overlaycolor',
			'type'			=> 'color',
			'alpha'			=> true,
			'title'			=> esc_html__( 'Shop Page Title Overlay Color', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Set the overlay color for the shop title background. Choose light colors to make it displayed over the image.', 'consultxp-addon' ),
			'required'		=> array( 'shop-title', '=', array( 'true' ) )
		),
		array(
			'id'			=> 'shop-pl-settings',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Shop Page Layout Settings', 'consultxp-addon' ),
			'desc'	=> esc_html__( 'This is settings for shop page layout.', 'consultxp-addon' ),
			'seperator'		=> 'after'
		),
		array(
			'id'			=> 'shop-sidebar-layout',
			'type'			=> 'radioimage',
			'title'			=> esc_html__( 'Shop Single Post Sidebar Layout', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Choose the position of the shop page sidebar, such as left, right, both or no-sidebar (full-width).', 'consultxp-addon' ),
			'items'		=> array(
				'right-sidebar' => array(
					'title' => esc_html__( 'Right Sidebar', 'consultxp-addon' ),
					'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-right.png'
				),
				'left-sidebar' => array(
					'title' => esc_html__( 'Left Sidebar', 'consultxp-addon' ),
					'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-left.png'
				),
				'both-sidebar' => array(
					'title' => esc_html__( 'Both Sidebar', 'consultxp-addon' ),
					'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-both.png'
				),
				'no-sidebar' => array(
					'title' => esc_html__( 'No Sidebar', 'consultxp-addon' ),
					'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/no-sidebar.png'
				)
			),
			'default' => 'right-sidebar'
		),
		array(
			'id'			=> 'shop-right-sidebar',
			'type'			=> 'sidebars',
			'title'			=> esc_html__( 'Shop Page Right Widgets Area', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Select and add widget to the right sidebar area of the shop page.', 'consultxp-addon' ),
			'default'		=> '',
			'required'		=> array( 'shop-sidebar-layout', '=', array( 'right-sidebar', 'both-sidebar' ) )
		),
		array(
			'id'			=> 'shop-left-sidebar',
			'type'			=> 'sidebars',
			'title'			=> esc_html__( 'Shop Page Left Widgets Area', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Select and add widget to the left sidebar area of the shop page.', 'consultxp-addon' ),
			'default'		=> '',
			'required'		=> array( 'shop-sidebar-layout', '=', array( 'left-sidebar', 'both-sidebar' ) )
		),
		array(
			'id'			=> 'shop-right-sidebar-cols',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Shop Sidebar Columns', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Select .', 'consultxp-addon' ),
			'choices' 		=> array(
					'10x2'		=> esc_html__( '10 x 2 Columns', 'consultxp-addon'),
					'9x3' 		=> esc_html__( '9 x 3 Columns', 'consultxp-addon'),
					'8x4' 		=> esc_html__( '8 x 4 Columns', 'consultxp-addon'),
					'7x5' 		=> esc_html__( '7 x 5 Columns', 'consultxp-addon'),
			),
			'default'		=> '8x4',
			'required'		=> array( 'shop-sidebar-layout', '=', array( 'right-sidebar' ) )
		),
		array(
			'id'			=> 'shop-left-sidebar-cols',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Shop Sidebar Columns', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Select .', 'consultxp-addon' ),
			'choices' 		=> array(
					'2x10'		=> esc_html__( '2 x 10 Columns', 'consultxp-addon'),
					'3x9' 		=> esc_html__( '3 x 9 Columns', 'consultxp-addon'),
					'4x8' 		=> esc_html__( '4 x 8 Columns', 'consultxp-addon'),
					'5x7' 		=> esc_html__( '5 x 7 Columns', 'consultxp-addon'),
			),
			'default'		=> '4x8',
			'required'		=> array( 'shop-sidebar-layout', '=', array( 'left-sidebar' ) )
		),
		array(
			'id'			=> 'shop-both-sidebar-cols',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Shop Sidebar Columns', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Select .', 'consultxp-addon' ),
			'choices' 		=> array(
					'1x10x1'		=> esc_html__( '1 x 10 x 1 Columns', 'consultxp-addon'),
					'2x8x2' 		=> esc_html__( '2 x 8 x 2 Columns', 'consultxp-addon'),
					'3x6x3' 		=> esc_html__( '3 x 6 x 3 Columns', 'consultxp-addon'),
					'4x4x4' 		=> esc_html__( '4 x 4 x 4 Columns', 'consultxp-addon'),
			),
			'default'		=> '3x6x3',
			'required'		=> array( 'shop-sidebar-layout', '=', array( 'both-sidebar' ) )
		),
	)
) );

Consultxp_Options::consultxp_set_sub_section( array(
	'title'      => esc_html__( 'Product', 'consultxp-addon' ),
	'id'         => 'product-tab',
	'config_id'  => '',
	'fields'	 => array(
		array(
			'id'			=> 'product-settings',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Product Page Title Settings', 'consultxp-addon' ),
			'desc'	=> esc_html__( 'This is settings for product page title.', 'consultxp-addon' ),
			'seperator'		=> 'after'
		),
		array(
			'id'			=> 'product-title',
			'type'			=> 'toggle',
			'title'			=> esc_html__( 'Enable/Disable Product Page Title', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Toggle to display the page title in the Product Page title section.', 'consultxp-addon' ),
			'default'		=> true
		),
		array(
			'id'			=> 'product-title-items',
			'type'			=> 'dragdrop',
			'title'			=> esc_html__( 'Product Page Title Elements', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Arrange and customize the elements in the Product Page Title section using a drag-and-drop interface.', 'consultxp-addon' ),
			'default'		=> array(
				'left' => array(
				),
				'center' => array(
					'title' => esc_html__( 'Title', 'consultxp-addon' ),
					'breadcrumb' => esc_html__( 'Breadcrumb', 'consultxp-addon' )
				),
				'right' => array(
				),
				'disabled' => array(
					'description' => esc_html__( 'Description', 'consultxp-addon' )
				)
			),
		),
		array(
			'id'			=> 'product-title-color',
			'type'			=> 'color',
			'title'			=> esc_html__( 'Product Page Title Color', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Set the color for the title of the Product page.', 'consultxp-addon' ),
			'required'		=> array( 'product-title', '=', array( 'true' ) )
		),
		array(
			'id'			=> 'product-title-desc-color',
			'type'			=> 'color',
			'title'			=> esc_html__( 'Product Page Title Description Color', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Set the color for the description of the Product page.', 'consultxp-addon' ),
			'required'		=> array( 'product-title', '=', array( 'true' ) )
		),
		array(
			'id'			=> 'product-title-link-color',
			'type'			=> 'link',
			'title'			=> esc_html__( 'Product Page Title Link Color', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Set the color for the hyperlinks of the Product page title. Like breadcrumbs color.', 'consultxp-addon' ),
			'default'		=> '',
			'required'		=> array( 'product-title', '=', array( 'true' ) )
		),
		array(
			'id'			=> 'product-title-padding',
			'type'			=> 'dimension',
			'title'			=> esc_html__( 'Product Page Title Padding', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Adjust the padding (inner spacing) around the product page Title section.', 'consultxp-addon' ),
			'default'		=> '',
			'required'		=> array( 'product-title', '=', array( 'true' ) )
		),
		array(
			'id'			=> 'product-title-bg',
			'type'			=> 'background',
			'title'			=> esc_html__( 'Product Page Title Background', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Choose background settings for the Product Page Title section, including color, image, size, etc.', 'consultxp-addon' ),
			'required'		=> array( 'product-title', '=', array( 'true' ) )
		),
		array(
			'id'			=> 'product-title-overlaycolor',
			'type'			=> 'color',
			'alpha'			=> true,
			'title'			=> esc_html__( 'Product Page Title Overlay Color', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Set the overlay color for the Product title background. Choose light colors to make it displayed over the image.', 'consultxp-addon' ),
			'required'		=> array( 'product-title', '=', array( 'true' ) )
		),
		array(
			'id'			=> 'product-pl-settings',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Product Page Layout Settings', 'consultxp-addon' ),
			'desc'	=> esc_html__( 'This is settings for product page layout.', 'consultxp-addon' ),
			'seperator'		=> 'after'
		),
		array(
			'id'			=> 'product-sidebar-layout',
			'type'			=> 'radioimage',
			'title'			=> esc_html__( 'Product Single Post Sidebar Layout', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Choose the position of the product page sidebar, such as left, right, both or no-sidebar (full-width).', 'consultxp-addon' ),
			'items'		=> array(
				'right-sidebar' => array(
					'title' => esc_html__( 'Right Sidebar', 'consultxp-addon' ),
					'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-right.png'
				),
				'left-sidebar' => array(
					'title' => esc_html__( 'Left Sidebar', 'consultxp-addon' ),
					'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-left.png'
				),
				'both-sidebar' => array(
					'title' => esc_html__( 'Both Sidebar', 'consultxp-addon' ),
					'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-both.png'
				),
				'no-sidebar' => array(
					'title' => esc_html__( 'No Sidebar', 'consultxp-addon' ),
					'url' => CONSULTXP_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/no-sidebar.png'
				)
			),
			'default' => 'right-sidebar'
		),
		array(
			'id'			=> 'product-right-sidebar',
			'type'			=> 'sidebars',
			'title'			=> esc_html__( 'Product Page Right Widgets Area', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Select and add widget to the right sidebar area of the product page.', 'consultxp-addon' ),
			'default'		=> '',
			'required'		=> array( 'product-sidebar-layout', '=', array( 'right-sidebar', 'both-sidebar' ) )
		),
		array(
			'id'			=> 'product-left-sidebar',
			'type'			=> 'sidebars',
			'title'			=> esc_html__( 'Product Page Left Widgets Area', 'consultxp-addon' ),
			'description'	=> esc_html__( 'Select and add widget to the left sidebar area of the product page.', 'consultxp-addon' ),
			'default'		=> '',
			'required'		=> array( 'product-sidebar-layout', '=', array( 'left-sidebar', 'both-sidebar' ) )
		)
	)
) );

Consultxp_Options::consultxp_set_end_section( array(
	'id'		=> 'woocommerce-end'	
));