<?php 

class Consultxp_Mega_Menu {
	
	private static $_instance = null;
	
	public static $megamenu_stat = 0;

	public function __construct() {

		add_filter( 'nav_menu_item_title', array( $this, 'nav_menu_item_custom_title' ), 10, 4 );

        add_filter( 'nav_menu_css_class', array( $this, 'nav_menu_css_custom_class' ), 10, 4 );

        add_filter( 'nav_menu_submenu_css_class', array( $this, 'nav_menu_submenu_css_custom_class' ), 10, 3 );

        add_filter( 'walker_nav_menu_start_el', array( $this, 'walker_nav_menu_custom_start_el' ), 10, 4 );

        add_action( 'wp_ajax_load_mega_menu_posts', array( $this, 'load_mega_menu_posts' ) );
        add_action( 'wp_ajax_nopriv_load_mega_menu_posts', array( $this, 'load_mega_menu_posts' ) );

        add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_mega_menu_scripts' ) );
		
	}
	
	public function nav_menu_item_custom_title( $title, $item, $args, $depth ){
        $t = get_post_meta( $item->ID, '_menu_item_consultxpmenu', true ); $t = json_decode( $t, true );
        $menu_icon = isset( $t['icon'] ) ? $t['icon'] : '';
        if( $menu_icon ) return '<span class="menu-item-icon '. esc_attr( $menu_icon ) .'"></span>'. $title;
        return $title;
    }
    
    public function nav_menu_css_custom_class( $classes, $item, $args, $depth ){
        if ( 'mobile' !== $args->theme_location ) {
            $t = get_post_meta( $item->ID, '_menu_item_consultxpmenu', true ); $t = json_decode( $t, true );
            if( $depth === 0 ){
                $megamenu = isset( $t['megamenu'] ) ? $t['megamenu'] : false;
                if( $megamenu ){
                    self::$megamenu_stat = 1;
                    $classes[] = 'menu-item-has-mega-children';
                }else{
                    self::$megamenu_stat = 0;
                }
            }if( $depth === 1 && self::$megamenu_stat == true ){
                $classes[] = isset( $t['megamenucol'] ) ? 'mega-menu-col col-' . $t['megamenucol'] : 'mega-menu-col col-12';
            }
        }
        return $classes;
    }
    
    public function nav_menu_submenu_css_custom_class( $classes, $args, $depth ){
        if ( 'mobile' !== $args->theme_location ) {
            if( $depth === 0 && self::$megamenu_stat == true ){
                $classes[] = 'mega-menu';
            }
        }	
        return $classes;
    }

    public function walker_nav_menu_custom_start_el( $item_output, $item, $depth, $args ){
        if ( 'mobile' !== $args->theme_location ) {
            if( $depth === 2 && self::$megamenu_stat == true ){
                $t = get_post_meta( $item->ID, '_menu_item_consultxpmenu', true ); $t = json_decode( $t, true );
                $mega_widget = isset( $t['megamenuwidget'] ) ? $t['megamenuwidget'] : '';
                if( $mega_widget ){
                    ob_start();
                    dynamic_sidebar( $mega_widget );
                    $sidebar = ob_get_clean();
                    $item_output  = $args->before;
                    $item_output .= $sidebar;
                    $item_output .= $args->after;
                }
            }
        }
        $megamenu_category = get_post_meta( $item->ID, '_menu_item_megacategory', true );

            if( !empty($megamenu_category) && $depth === 1 ){
                $mega_posts_wrapper = '';

                $megamenu_thide = get_post_meta( $item->ID, '_menu_item_megatithide', true );
                $megamenu_rows = get_post_meta( $item->ID, '_menu_item_megarow', true );

                if( $megamenu_thide == 'on' && !empty($item_output) ) {
                    $item->title = '';
                }

                if ( $megamenu_rows == 'on' && 'mobile' !== $args->theme_location ) {
                    $mega_posts_wrapper .= 'post-row-grid ';
                }

                if ( 'mobile' == $args->theme_location ) {
                    $mega_posts_wrapper .= 'mobile-mega-post ';
                }

                $category = get_category($megamenu_category);
                $query_args = array(
                    'post_type' => 'post',
                    'posts_per_page' => 4,
                    'cat' => intval($megamenu_category) 
                );
                $posts_query = new WP_Query($query_args);
                if($posts_query->have_posts()){

                    $mega_posts = '<div class="mega-menu-posts-container">';
                    $mega_posts .= '<div class="mega-posts-grid '. esc_attr( $mega_posts_wrapper ) . '">';
                    while($posts_query->have_posts()) : $posts_query->the_post();
                        $mega_posts .= '<div class="mega-post-item">';
        
                        if(has_post_thumbnail()){
                            $mega_posts .= '<a href="' . get_permalink() . '">';
                            $mega_posts .= '<div class="mega-post-thumb">';
                            $mega_posts .= get_the_post_thumbnail(get_the_ID(), 'medium', array('class' => 'img-fluid'));
                            $mega_posts .= '</div>';
                        }
                        
                        $mega_posts .= '<div class="mega-post-content">';
                        $mega_posts .= get_the_title();
                        $mega_posts .= '</div>';
                        
                        $mega_posts .= '</a>';
                        $mega_posts .= '</div>';
                    endwhile;
                    
                    $mega_posts .= '</div>';
                    $mega_posts .= '<div class="mega-menu-pagination">';
                    
                    // Calculate total pages
                    $total_pages = $posts_query->max_num_pages;
                    $current_page = 1;
                    
                    if($total_pages > 1) {
                        $mega_posts .= '<ul class="mega-nav-buttons">';
                        $mega_posts .= '<li><a href="#" class="mega-nav-btn btn mega-prev-btn disabled" data-category="' . esc_attr($megamenu_category) . '" data-page="0" data-wrapper="' . esc_attr($mega_posts_wrapper) . '"><i class="fa fa-chevron-left"></i> Prev</a></li>';
                        $mega_posts .= '<li><a href="#" class="mega-nav-btn btn mega-next-btn" data-category="' . esc_attr($megamenu_category) . '" data-page="2" data-wrapper="' . esc_attr($mega_posts_wrapper) . '">Next <i class="fa fa-chevron-right"></i></a></li>';
                        $mega_posts .= '</ul>';
                    }
                    
                    $mega_posts .= '</div>';
                    $mega_posts .= '</div>';
                    
                    wp_reset_postdata();
                    
                    $item_output = $args->before;
                    $item_output .= '<a href="' . get_category_link($megamenu_category) . '">' . $item->title . '</a>';
                    $item_output .= $mega_posts;
                    $item_output .= $args->after;
                }
            }
        return $item_output;
    }
	
    public function load_mega_menu_posts() {
        $category_id = intval($_POST['category_id']);
        $page = intval($_POST['page']);
        $wrapper_class = sanitize_text_field($_POST['wrapper_class']);
        
        $query_args = array(
            'post_type' => 'post',
            'posts_per_page' => 4,
            'cat' => $category_id,
            'paged' => $page
        );
        
        $posts_query = new WP_Query($query_args);
        $response = array();
        
        if($posts_query->have_posts()){
            $mega_posts = '';
            while($posts_query->have_posts()) : $posts_query->the_post();
                $mega_posts .= '<div class="mega-post-item">';
                if(has_post_thumbnail()){
                    $mega_posts .= '<a href="' . get_permalink() . '">';
                    $mega_posts .= '<div class="mega-post-thumb">';
                    $mega_posts .= get_the_post_thumbnail(get_the_ID(), 'medium', array('class' => 'img-fluid'));
                    $mega_posts .= '</div>';
                }
                $mega_posts .= '<div class="mega-post-content">';
                $mega_posts .= get_the_title();
                $mega_posts .= '</div>';
                $mega_posts .= '</a>';
                $mega_posts .= '</div>';
            endwhile;
            
            $response['posts'] = $mega_posts;
            $response['current_page'] = $page;
            $response['total_pages'] = $posts_query->max_num_pages;
            $response['has_prev'] = ($page > 1);
            $response['has_next'] = ($page < $posts_query->max_num_pages);
        }
        
        wp_reset_postdata();
        wp_send_json($response);
    }

    public function enqueue_mega_menu_scripts() {
        wp_enqueue_script( 'consultxp-megamenu', CONSULTXP_ADDON_URL . 'admin/extension/mega-menu/js/megamenu-post.js' , array( 'jquery' ), '1.0', true );
        wp_localize_script( 'consultxp-megamenu', 'mega_menu_ajax', array(
            'ajax_url' => admin_url( 'admin-ajax.php' ),
            'nonce' => wp_create_nonce( 'mega-menu-nonce' )
        ) );
    }

	/**
	 * Creates and returns an instance of the class
	 * @since 1.0.0
	 * @access public
	 * return object
	 */
	public static function get_instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}

} Consultxp_Mega_Menu::get_instance();


