/*
 * Consultxp Theme Js 
 */ 

(function( $ ) {

	"use strict";

	/* Document ready event */
	$( document ).ready(function() {

		if( $(".cea-button").length ) {
			var $extra_class = consultxp_ajax_var.extra_button;
			if ( $extra_class != '' && $extra_class != 'none' ) {
				$(".cea-button").each(function() {
					$(this).addClass($extra_class);
				});
			}
		}
		
		var win_width = $(window).width();
		
		/* Escape events */
		document.onkeydown = function(evt) {
		    evt = evt || window.event;
		    if (evt.keyCode == 27) {
				if( $(".full-search-toggle").length ){
		        	$('.full-search-wrapper').removeClass("search-wrapper-opened");
		        }
		    }
		};	
		
		/* Search forms */
		if( $( ".full-search-toggle" ).length ){
			$( document ).on( "click", ".full-search-toggle", function() {
				$('.full-search-wrapper').toggleClass("search-wrapper-opened");
				setTimeout(function(){
					var search_in = $('.full-search-wrapper').find("input.form-control");
					search_in.focus();	
				}, 300 );
				return false;
			});
		}
		if( $( ".textbox-search-toggle" ).length ){
			$( document ).on('click', '.textbox-search-toggle', function(){
				$(this).prev('.textbox-search-wrap').toggleClass('active');
				setTimeout(function(){
					var search_in = $('.textbox-search-wrap').find("input.form-control");
					search_in.focus();
				}, 500 );	
				return false;
			});
		}else if( $( ".full-bar-search-toggle" ).length ){
			$( document ).on('click', '.full-bar-search-toggle', function(){
				$('.full-bar-search-wrap').toggleClass('active');
				setTimeout(function(){
					var search_in = $('.full-bar-search-wrap').find("input.form-control");
					search_in.focus();
				}, 300 );
				return false;
			});
		}else if( $( ".bottom-search-toggle" ).length ){
			$( document ).on('click', '.bottom-search-toggle', function(){
				$(this).next('.bottom-search-wrap').toggleClass('active');
				setTimeout(function(){
					var search_in = $('.bottom-search-wrap').find("input.form-control");
					search_in.focus();
				}, 300 );
				return false;
			});
		}
		
		if( $( ".mobile-menu-toggle" ).length ){
			$( ".mobile-menu-toggle" ).on( "click", function(e) {
				$("body").toggleClass("mobile-menu-active");
				e.stopPropagation();
				return false;
			});
			// Close the menu if outside the menu-wrapper is clicked
			$(document).on("click", function(e) {
        		if( $("body").hasClass("mobile-menu-active") && !$(e.target).closest(".mobile-menu-floating, .mobile-menu-toggle").length ) {
            		$("body").removeClass("mobile-menu-active");
        		}
    		});
		}
		
		if( $( ".secondary-toggle-wrapper" ).length ){
			$( ".secondary-menu-toggle" ).on( "click", function() {
				$("body").toggleClass("secondary-bar-active");
				$(".secondary-menu-toggle").toggleClass("active");
				return false;
			});
		}
		
		if( $( "ul.mobile-menu" ).length ){
			//$( "ul.mobile-menu li.menu-item-has-children" ).append('<span class="down-arrow"></span>');
			
			$( "ul.mobile-menu").find('li.menu-item > ul.sub-menu').each(function() {
				$(this).parent("li").append( '<span class="down-arrow"></span>' );				
			});
			
			$( document ).on( "click", "ul.mobile-menu span.down-arrow", function() {
				var parent_li = $(this).parent("li.menu-item");
				var sibling_li = $(parent_li).siblings("li.menu-item");
				$(sibling_li).find("span.up-arrow").removeClass("up-arrow").addClass("down-arrow");
				$(sibling_li).find("ul.sub-menu").slideUp(350);
				
				$(this).removeClass("down-arrow").addClass("up-arrow");
				$(this).prev("ul.sub-menu").slideDown(350);
				return false;
			});	
			$( document ).on( "click", "ul.mobile-menu span.up-arrow", function() {
				var parent_li = $(this).parent("li.menu-item");
				$(parent_li).find("span.up-arrow").removeClass("up-arrow").addClass("down-arrow");
				$(parent_li).find("ul.sub-menu").slideUp(350);
				return false;
			});				
		}
		
		if( $( "ul.nav.social-share" ).length ){
			$( "ul.nav.social-share a" ).each(function() {
				$( this ).attr( "href", $( this ).data("href") );
			});
		}
		
		/* Menu Scroll */
		var cur_offset = 0;		
		var o_stat = 0; // One Page Menu Status
		$( '.primary-menu li.menu-item, .mobile-menu li.menu-item' ).each(function( index ) {
			var cur_item = this;
			var target = $(cur_item).children("a").attr("href");
			if( target && target.indexOf("#section-") != -1 ){
				o_stat = 1;
				var res = target.split("#");
				if( res.length == 2 ){
					$(cur_item).children("a").attr("data-target", res[0]);
					$(cur_item).children("a").attr("href", "#"+res[1]);
				}	
			}
		});
		
		if( o_stat ){
		
			if( $('.primary-menu .menu-item').find('a[href="#section-top"]').length ){
				$("body").attr("id","section-top");
			}
			
			$( '.primary-menu li.menu-item, .mobile-menu li.menu-item' ).removeClass("current-menu-item");
			
			var header_offset = consultxp_ajax_var.header_offset;
			var mheader_offset = consultxp_ajax_var.mheader_offset;
			var res_width = consultxp_ajax_var.res_width;
			
			$(window).on('scroll', function () {
				
				var minus_height = $("#wpadminbar").length ? $("#wpadminbar").outerHeight() : 0;
				minus_height += win_width >= res_width ? parseInt( header_offset ) + 1 : parseInt( mheader_offset );
				$('div[id*="section-"], body').each(function () {
					var anchored = $(this).attr("id"),
						targetOffset = $(this).offset().top - minus_height;
						
					if ($(window).scrollTop() > targetOffset) {
						$('.primary-menu .menu-item').find("a").removeClass("active");
						$('.primary-menu .menu-item').find('a[href="#'+ anchored +'"]').addClass("active");
						
						//Mobile menu scroll spy active
						$('.mobile-menu .menu-item').find("a").removeClass("active");
						$('.mobile-menu .menu-item').find('a[href="#'+ anchored +'"]').addClass("active");
					}
				});
			});
			
			$( '.primary-menu .menu-item > a[href^="#section-"], .mobile-menu .menu-item > a[href^="#section-"]' ).on('click',function (e) {
				
				var cur_item = this;
				var target = $(cur_item).attr("href");
				
				if( $("body.mobile-menu-active").length ) {
					$("body").removeClass("mobile-menu-active");
				}
				
				var target_id = target.slice( target.indexOf("#"), ( target.length ) );
				var cur_url = location.protocol + '//' + location.host + location.pathname; //window.location.href;
				var data_targ = $(cur_item).attr("data-target");
				var another_page = false;
				if( target_id == '#section-top' && data_targ != '' ){
					if( cur_url != data_targ ){
						another_page = true;
					}
				}

				if( $( target_id ).length && !another_page ){
					var minus_height = $("#wpadminbar").length ? $("#wpadminbar").outerHeight() : 0;
					minus_height += win_width >= res_width ? parseInt( header_offset ) : parseInt( mheader_offset );
					var offs = $(target_id).offset().top - minus_height;						
					var sec_ani_call = 1;
					if( target_id == '#section-top' ){
						sec_ani_call = 1;
						offs = 0;
					}
					$('html,body').animate({ 'scrollTop': offs }, 0 );
					
					return false;
				}else{
					
					if( target_id == '#section-top' && cur_url == data_targ ){
						$('html,body').animate({ 'scrollTop': 0 }, 0 );
						return false;
					}else{
						if( cur_url != data_targ && target_id != '#' ){
							window.location.href = data_targ + target;
						}else{
							window.location.href = target;
						}
					}

				}
			
			});	
			
		}
		
		/*Back to top*/
		if( $( "a.back-to-top" ).length ){
			$( document ).on('click', 'a.back-to-top', function(){
				$('html,body').animate({ 'scrollTop': 0 }, 0 );
				return false;
			});
			$( document ).scroll(function() {
				var y = $( this ).scrollTop();
				if ( y > 300 )
					$( 'a.back-to-top' ).fadeIn();
				else
					$( 'a.back-to-top' ).fadeOut();
			});
		}
		
		/*Mailchimp Code*/
		if( $('.zozo-mc').length ){
			$('.zozo-mc').on( "click", function () {
				
				var c_btn = $(this);
				var mc_wrap = $( this ).parents('.mailchimp-wrapper');
				var mc_form = $( this ).parents('.zozo-mc-form');
				mc_wrap.find('.mc-notice-msg').removeClass("mc-success mc-failure");
				if( mc_form.find('input[name="zozo_mc_email"]').val() == '' ){
					mc_wrap.find('.mc-notice-msg').text( consultxp_ajax_var.must_fill );
				}else{
					c_btn.attr( "disabled", "disabled" );
					$.ajax({
						type: "POST",
						url: consultxp_ajax_var.ajax_url,
						data: 'action=zozo-mc&nonce='+consultxp_ajax_var.mc_nounce+'&'+mc_form.serialize(),
						success: function (data) {
							//Success
							c_btn.removeAttr( "disabled" );
							if( data == 'success' ){
								mc_wrap.find('.mc-notice-msg').addClass("mc-success");
								mc_wrap.find('.mc-notice-msg').text( mc_wrap.find('.mc-notice-group').attr('data-success') );
							}else{
								mc_wrap.find('.mc-notice-msg').addClass("mc-failure");
								mc_wrap.find('.mc-notice-msg').text( mc_wrap.find('.mc-notice-group').attr('data-fail') );
							}
						},error: function(xhr, status, error) {
							c_btn.removeAttr( "disabled" );
							mc_wrap.find('.mc-notice-msg').text( mc_wrap.find('.mc-notice-group').attr('data-fail') );
						}
					});
				}
			});
		} // if mailchimp exists

	}); // doc ready end	

	/* Window load event */
	$( window ).load(function() {
		
		if( $('.related-product-slider').length ){

			var c_owlCarousel = $('.related-product-slider');
                                    
			// Data Properties
			var loop = c_owlCarousel.data( "loop" );
			var margin = c_owlCarousel.data( "margin" );
			var center = c_owlCarousel.data( "center" );
			var nav = c_owlCarousel.data( "nav" );
			var dots_ = c_owlCarousel.data( "dots" );
			var items = c_owlCarousel.data( "items" );
			var items_tab = c_owlCarousel.data( "items-tab" );
			var items_mob = c_owlCarousel.data( "items-mob" );
			var duration = c_owlCarousel.data( "duration" );
			var smartspeed = c_owlCarousel.data( "smartspeed" );
			var scrollby = c_owlCarousel.data( "scrollby" );
			var autoheight = c_owlCarousel.data( "autoheight" );
			var autoplay = c_owlCarousel.data( "autoplay" );
			var rtl = $( "body.rtl" ).length ? true : false;

			$( c_owlCarousel ).owlCarousel({
				rtl : rtl,
				loop	: loop,
				autoplayTimeout	: duration,
				smartSpeed	: smartspeed,
				center: center,
				margin	: margin,
				nav		: nav,
				dots	: dots_,
				autoplay	: autoplay,
				autoheight	: autoheight,
				slideBy		: scrollby,
				responsive:{
					0:{
						items: items_mob
					},
					544:{
						items: items_tab
					},
					992:{
						items: items
					}
				}
			});	
		}

		//Consultxp masonry
		if ($(".consultxp-masonry").length) {
	    	var masonry_on_time;
	    	var masonry_cols = $(".consultxp-masonry").data("columns");
	    	var masonry_gutter = $(".consultxp-masonry").data("gutter");

	    	// Add CSS to prevent flickering
	    	var style = document.createElement('style');
	    	style.textContent = `
	    	    .consultxp-masonry.masonry-calculating {
	    	        opacity: 1;
	    	    }
	    	    .consultxp-masonry article {
	    	        transition: none !important;
	    	    }
	    	`;
	    	document.head.appendChild(style);

	    	// Initial load
	    	setTimeout(function () {
	    	    $(".consultxp-masonry").rcmasonry({
	    	        columns: masonry_cols,
	    	        gutter: masonry_gutter,
	    	    });
	    	}, 100);

	    	var resizeTimer;
	    	var isResizing = false;

	    	$(window).on("resize orientationchange", function (event) {
	    	    clearTimeout(masonry_on_time);
			
	    	    if (!isResizing) {
	    	        isResizing = true;
	    	    }

	    	    masonry_on_time = setTimeout(function () {
	    	        $(".consultxp-masonry").rcmasonry({
	    	            columns: masonry_cols,
	    	            gutter: masonry_gutter,
	    	        });
				
	    	        // Reset flag after animation
	    	        setTimeout(function() {
	    	            isResizing = false;
	    	        }, 100);
	    	    }, 200);
	    	});
		}

    
    //Elementor RTL issue
    function consultxp_for_elementor_row(){
  		$("body.rtl section.elementor-section-stretched").each(function() {
  			var left_pos = $(this).css( "left" );
			  left_pos = Math.abs( parseFloat(left_pos) );
		  	if( left_pos ) $(this).css( "left", left_pos );
	  	});
  	}
  
		if( $("body.rtl").length && $("section.elementor-section-stretched").length ){
			consultxp_for_elementor_row();
		}
    
    $(window).resize(function(event){
					//Elementor RTL issue
      		if( $("body.rtl").length && $("section.elementor-section-stretched").length ){
      			consultxp_for_elementor_row();
      		}
		});

		//Sticky header
		if( $(".sticky-outer").length ){
			$(".sticky-outer").each(function(){
				var _sticky_ele = $(this);
				_sticky_ele.consultxp_stickypart();
				var sticky_on_time;
				$(window).resize(function(event){
					clearTimeout(sticky_on_time);
					sticky_on_time = setTimeout(function(){ _sticky_ele.consultxp_stickypart(); }, 300);
				});
			});
		}
				
		//Page loader
		if( $("body.page-load-initiate").length ){
			$("body").removeClass("page-load-initiate");
			$("body").addClass("page-load-end");
		}else{
			$(".page-loader").addClass("loaded");
		}
				
		//Dark or Light
		if( $(".dar-light-sticky").length ){
			$(".dar-light-sticky .round-ball-switch").on( "click", function(e){
				e.preventDefault();
				$("body").toggleClass("dark-mode-activated");
			});
		}
		
	}); // window load end	

})( jQuery );


/* Consultxp Masonry */
(function ( $ ) {

	"use strict";
	//Make sticky
	$.fn.consultxp_stickypart = function( options ){

		//Sticky help functions
		var rcstickyhelp = {
			sticky_stat: function( st, header_top, sticky_outer, t_header_h ){
				if( st > lastScrollTop ){
					if( st > header_top ) $(sticky_outer).children('.sticky-head').addClass('header-sticky');
				}else{
					if( st > ( header_top - t_header_h ) ) $(sticky_outer).children('.sticky-head').addClass('header-sticky');
					else $(sticky_outer).children('.sticky-head').removeClass('header-sticky');
				}
			},
			sticky_scroll_stat: function( st, lastScrollTop, header_top, sticky_outer, t_header_h ){
				if( st > lastScrollTop ){
					$(sticky_outer).children('.sticky-head').addClass("hide-up");
				}else{
					if( st > ( header_top - t_header_h ) ){
						if( st > header_top ) $(sticky_outer).children('.sticky-head').addClass('header-sticky').removeClass("hide-up");
					}else{
						$(sticky_outer).children('.sticky-head').removeClass('header-sticky').removeClass("hide-up");					
					}
				}
			}
		}

		var sticky_outer = this;	
		var lastScrollTop = 0;
		var header_top, st = 0;
		var sticky_up = $(sticky_outer).data("stickyup");
		$(sticky_outer).css( 'height', 'auto' );
		$(sticky_outer).children('.sticky-head').removeClass('header-sticky');
		var t_header_h = $(sticky_outer).outerHeight();
		$(sticky_outer).css( 'height', t_header_h );
		header_top = $(sticky_outer).offset().top;
		header_top += t_header_h;	
		var win_width = $(window).width();	
		if( $("#wpadminbar").length && win_width > 600 ){
			t_header_h += $("#wpadminbar").outerHeight();
			$(sticky_outer).children('.sticky-head').css({ "top": $("#wpadminbar").outerHeight() });
		}else{
			$(sticky_outer).children('.sticky-head').css({ "top": 0 });
		}
		if( sticky_up ){ // Sticky on scroll up
			$(window).scroll(function(event){				
				st = $(this).scrollTop();
				rcstickyhelp.sticky_scroll_stat( st, lastScrollTop, header_top, sticky_outer, t_header_h );
				if( st == 0 ){
					$(sticky_outer).children('.sticky-head').removeClass('header-sticky');
				}
				lastScrollTop = st;
			});	
		}else{ // Sticky on scroll
			$(window).scroll(function(event){				
				st = $(this).scrollTop();
				rcstickyhelp.sticky_stat( st, header_top, sticky_outer, t_header_h );
				if( st == 0 ){
					$(sticky_outer).children('.sticky-head').removeClass('header-sticky');
				}
				lastScrollTop = st;
			});	
		}
	};

	$.fn.rcmasonry = function(options) {
    	var settings = $.extend(
    	    {
    	        columns: 3,
    	        gutter: 20,
    	    },
    	    options
    	);

    	var masonry_parent = this;
    	var masonry_item = masonry_parent.children("article");

    	// Store current state to avoid unnecessary recalculation
    	var currentState = masonry_parent.data('masonry-state') || {};
    	var parent_width = masonry_parent.width();
    	var window_width = $(window).width();

    	var responsive_columns = settings.columns;
    	if (window_width < 480) {
    	    responsive_columns = 1;
    	} else if (window_width < 768) {
    	    responsive_columns = 1;
    	} else if (window_width < 1024) {
    	    responsive_columns = settings.columns;
    	}

    	// Check if layout needs recalculation
    	var stateChanged = 
    	    currentState.columns !== responsive_columns ||
    	    currentState.width !== parent_width ||
    	    currentState.itemCount !== masonry_item.length;

    	if (!stateChanged) {
    	    return Promise.resolve(masonry_parent);
    	}

    	function resetMasonry() {
    	    masonry_item.each(function () {
    	        $(this).css({
    	            position: "static",
    	            width: "auto",
    	            left: "auto",
    	            right: "auto",
    	            top: "auto",
    	            "margin-bottom": "0px",
    	            height: "auto",
    	            transform: "none",
    	            visibility: "visible"
    	        }).removeAttr("data-left");
    	    });
		
    	    masonry_parent.css({
    	        height: "auto",
    	        position: "relative",
    	    });
    	}

    	// Add loading class to prevent flickering
    	masonry_parent.addClass('masonry-calculating');

    	return new Promise(function (resolve) {
    	    // Use requestAnimationFrame for smoother rendering
    	    requestAnimationFrame(function() {
    	        resetMasonry();

    	        // Small delay to ensure heights are calculated correctly
    	        setTimeout(function () {
    	            if (responsive_columns === 1) {
    	                masonry_item.css({
    	                    position: "relative",
    	                    width: "100%",
    	                    "margin-bottom": settings.gutter + "px",
    	                    left: "0",
    	                    top: "auto",
    	                    visibility: "visible"
    	                });
    	                masonry_parent.css({ height: "auto" });
					
    	                // Update state
    	                masonry_parent.data('masonry-state', {
    	                    columns: responsive_columns,
    	                    width: parent_width,
    	                    itemCount: masonry_item.length
    	                });
					
    	                masonry_parent.removeClass('masonry-calculating');
    	                resolve();
    	                return;
    	            }

    	            var available_width = parent_width - settings.gutter * (responsive_columns - 1);
    	            var item_width = Math.floor(available_width / responsive_columns);

    	            var column_heights = new Array(responsive_columns).fill(0);
    	            var column_positions = [];

    	            for (var i = 0; i < responsive_columns; i++) {
    	                column_positions[i] = i * (item_width + settings.gutter);
    	            }

    	            masonry_item.each(function (index) {
    	                var $item = $(this);

    	                // Set width first
    	                $item.css({
    	                    width: item_width + "px",
    	                    position: "absolute",
    	                    height: "auto",
    	                    visibility: "visible"
    	                });

    	                // Force reflow to get accurate height
    	                $item[0].offsetHeight;
    	                var item_height = $item.outerHeight(true);

    	                // Find shortest column
    	                var shortest_column = 0;
    	                var shortest_height = column_heights[0];

    	                for (var i = 1; i < responsive_columns; i++) {
    	                    if (column_heights[i] < shortest_height) {
    	                        shortest_height = column_heights[i];
    	                        shortest_column = i;
    	                    }
    	                }

    	                var left_pos = column_positions[shortest_column];
    	                var top_pos = column_heights[shortest_column];

    	                $item.css({
    	                    left: left_pos + "px",
    	                    top: top_pos + "px",
    	                });

    	                // Update column height (subtract gutter from item_height to avoid double-counting)
    	                var actualItemHeight = $item.outerHeight(false);
    	                column_heights[shortest_column] += actualItemHeight + settings.gutter;

    	                $item.attr("data-left", left_pos);
    	            });

    	            // Set parent height (subtract last gutter)
    	            var max_height = Math.max.apply(Math, column_heights) - settings.gutter;
    	            masonry_parent.css({
    	                height: max_height + "px",
    	                position: "relative",
    	            });

    	            // Update state
    	            masonry_parent.data('masonry-state', {
    	                columns: responsive_columns,
    	                width: parent_width,
    	                itemCount: masonry_item.length
    	            });

    	            masonry_parent.removeClass('masonry-calculating');
    	            resolve();
    	        }, 10);
    	    });
    	}).then(function () {
    	    return masonry_parent;
    	});
	};

	jQuery(document).ready(function ($) {
		const $loginButton = $('.login-button');
		const $popup = $('#login-popup');
		const $closePopup = $('.close-popup');

		$loginButton.on('click', function () {
			$popup.css('display', 'flex');
		});

		$closePopup.on('click', function () {
			$popup.css('display', 'none');
		});

		$popup.on('click', function (e) {
			if (e.target === this) {
				$popup.css('display', 'none');
			}
		});
	});

	document.addEventListener("DOMContentLoaded", function() {
		const cartItem = document.querySelector('.woocommerce-cart-item.click-cart');

		if (cartItem) {
			const trigger = cartItem.querySelector('.cart-trigger');
			const dropdown = cartItem.querySelector('.mini-cart-dropdown');

			if (trigger && dropdown) {
				trigger.addEventListener('click', function(e) {
					e.preventDefault();
					dropdown.classList.toggle('show');
				});
				document.addEventListener('click', function(e) {
					if (!dropdown.contains(e.target) && !trigger.contains(e.target)) {
						dropdown.classList.remove('show');
					}
				});
			}
		}
	});

	jQuery(document).ready(function($) {

		// Close button
		$(document).on('click', '.secondary-close', function(e) {
			e.preventDefault();
			$(this).closest('.secondary-bar-wrapper').removeClass('active');
			$("body").removeClass("secondary-bar-active");
			$(".consultxp-toggle").removeClass("active");
		});

		$(document).on('click', '.secondary-bar-wrapper', function(e) {
			e.preventDefault();
			$('.secondary-bar-wrapper').removeClass('active');
			$("body").removeClass("secondary-bar-active");
			$(".consultxp-toggle").removeClass("active");
		});
		
	});
 
}( jQuery ));