<?php
/**
 * Header file for the Consultxp WordPress theme.
 */

?><!DOCTYPE html>

<html class="no-js" <?php language_attributes(); ?>>

	<head>
		<meta charset="<?php bloginfo( 'charset' ); ?>">
		<meta name="viewport" content="width=device-width, initial-scale=1.0" >
		<link rel="profile" href="https://gmpg.org/xfn/11">
		<?php wp_head(); ?>
	</head>

	<body <?php body_class(); ?>>

		<?php wp_body_open(); // For wp wp_body_open action hook ?>

		<?php
			/*
			* Set consultxp page meta
			*/
			if( is_singular() ){
				Consultxp_Wp_Elements::$consultxp_page_options = get_post_meta( get_the_ID(), 'consultxp_post_meta', true );
			}
			$keys = array(
				'chk' => 'general-chk',
				'fields' => array(
					'site_layout' => 'site-layout'
				)			
			);
			$layout = Consultxp_Wp_Elements::consultxp_get_meta_and_option_values( $keys );
			$pageloader_opt = Consultxp_Wp_Elements::consultxp_options('page-loader-option');
			?>
			<div class="consultxp-body-inner<?php 
			    if ($layout['site_layout'] == 'boxed') {
			        echo esc_attr(' container');
			    } elseif ($layout['site_layout'] == 'wider') {
			        echo esc_attr(' container-fluid');
			    } 
			?>">	
			<?php if( $pageloader_opt == '1' ) : ?>
			<div class="page-loader"><span class="page-loader-divider"></span></div>
			<?php endif; ?>	

			<?php
			/*
			 * Consultxp Header Before Action 
			 * 10 - consultxp_mobile_header
			 */
			do_action( 'consultxp_header_before' );
			?>
			
			<?php
			/*
			 * Consultxp Header Action 
			 * 10 - consultxp_desktop_header
			 */
			do_action( 'consultxp_header' );
			?>
			
			<?php
			/*
			 * Consultxp Header After Action 
			 * 10 - consultxp_header_slider
			 */
			do_action( 'consultxp_header_after' );
			?>