<?php
/**
 * Consultxp theme default functions
 */
class ConsultxpTheme_default{

   public static function init(){
      add_action('after_switch_theme', [__CLASS__, 'consultxp_theme_default_setup_options']);
   }
   
   public static function consultxp_theme_default_setup_options(){
      $default_options = self::consultxp_get_default_options();
      update_option( 'consultxp_options', json_decode( $default_options, true ) );
   }

   /**
   * Enqueue Google Web Fonts.
   */
   public static function consultxp_theme_default_fonts_url() {
      $font_url = '';
      /*
      Translators: If there are characters in your language that are not supported 
      by chosen font(s), translate this to 'off'. Do not translate into your own language.
      
      */
      $font_url = add_query_arg( 'family', urlencode( 'Marcellus:ital,wght@0,100..900;1,100..900|DM+Sans:ital,opsz,wght@0,9..40,100..1000;1,9..40,100..1000&subset=latin' ), "//fonts.googleapis.com/css" );

      // https://fonts.googleapis.com/css2?family=sora:ital,wght@0,100..900;1,100..900&display=swap

      return $font_url;
   }

   public static function consultxp_get_default_options(){
      return '{"page-loader-option":"1","page_loader":{"image":{"id":"94979","url":""}},"site-layout":"wide","site-width":{"width":"1320"},"site-padding":{"top":"120","right":"","bottom":"120","left":""},"site-bg":{"bg_color":"eff4f6","bg_repeat":"","bg_size":"","bg_attachment":"","bg_position":"","image":{"id":"","url":""}},"mailchimp-api":"0cd2c1c9563b10138aad6dc95819f038-us17","rtl":"","dark-light":"","favicon-icon":{"image":{"id":"20637","url":""}},"site-logo":{"image":{"id":"3168","url":""}},"site-logo-width":{"width":"178"},"site-logo-desc":"","sticky-logo":{"image":{"id":"12","url":""}},"sticky-logo-width":{"width":"165"},"mobile-logo":{"image":{"id":"12","url":""}},"mobile-logo-width":{"width":"161"},"content-typography":{"font_family":"DM Sans","font_weight":"400","font_sub":"","text_align":"","text_transform":"","font_size":"16","line_height":"30","letter_spacing":"","font_color":"#797979"},"lead-typography":{"font_family":"DM Sans","font_weight":"500","font_sub":"","text_align":"","text_transform":"","font_size":"","line_height":"","letter_spacing":"","font_color":""},"h1-typography":{"font_family":"Marcellus","font_weight":"400","font_sub":"","text_align":"","text_transform":"","font_size":"56","line_height":"66","letter_spacing":"-1","font_color":"#111111"},"h2-typography":{"font_family":"Marcellus","font_weight":"400","font_sub":"","text_align":"","text_transform":"","font_size":"52","line_height":"62","letter_spacing":"-1","font_color":"#111111"},"h3-typography":{"font_family":"Marcellus","font_weight":"400","font_sub":"","text_align":"","text_transform":"","font_size":"42","line_height":"50","letter_spacing":"-1","font_color":"#111111"},"h4-typography":{"font_family":"Marcellus","font_weight":"400","font_sub":"","text_align":"","text_transform":"","font_size":"28","line_height":"36","letter_spacing":"-1","font_color":"#111111"},"h5-typography":{"font_family":"Marcellus","font_weight":"400","font_sub":"","text_align":"","text_transform":"","font_size":"20","line_height":"32","letter_spacing":"-1","font_color":"#111111"},"h6-typography":{"font_family":"Marcellus","font_weight":"400","font_sub":"","text_align":"","text_transform":"","font_size":"18","line_height":"28","letter_spacing":"-1","font_color":"#111111"},"h1-mobile-typography":{"font_family":"","font_weight":"","font_sub":"","text_align":"","text_transform":"","font_size":"","line_height":"","letter_spacing":"","font_color":""},"h2-mobile-typography":{"font_family":"","font_weight":"","font_sub":"","text_align":"","text_transform":"","font_size":"","line_height":"","letter_spacing":"","font_color":""},"h3-mobile-typography":{"font_family":"","font_weight":"","font_sub":"","text_align":"","text_transform":"","font_size":"","line_height":"","letter_spacing":"","font_color":""},"h4-mobile-typography":{"font_family":"","font_weight":"","font_sub":"","text_align":"","text_transform":"","font_size":"","line_height":"","letter_spacing":"","font_color":""},"h5-mobile-typography":{"font_family":"","font_weight":"","font_sub":"","text_align":"","text_transform":"","font_size":"","line_height":"","letter_spacing":"","font_color":""},"h6-mobile-typography":{"font_family":"","font_weight":"","font_sub":"","text_align":"","text_transform":"","font_size":"","line_height":"","letter_spacing":"","font_color":""},"header-typography":{"font_family":"DM Sans","font_weight":"500","font_sub":"","text_align":"","text_transform":"","font_size":"","line_height":"","letter_spacing":"","font_color":""},"header-topbar-typography":{"font_family":"","font_weight":"400","font_sub":"","text_align":"","text_transform":"","font_size":"14","line_height":"","letter_spacing":"","font_color":"#cdcdcd"},"header-logobar-typography":{"font_family":"","font_weight":"","font_sub":"","text_align":"","text_transform":"","font_size":"15","line_height":"","letter_spacing":"","font_color":""},"header-navbar-typography":{"font_family":"DM Sans","font_weight":"","font_sub":"","text_align":"","text_transform":"capitalize","font_size":"16","line_height":"30","letter_spacing":"0","font_color":"#707070"},"footer-typography":{"font_family":"","font_weight":"","font_sub":"","text_align":"","text_transform":"","font_size":"","line_height":"","letter_spacing":"","font_color":"#cdcdcd"},"insta-footer-typography":{"font_family":"","font_weight":"","font_sub":"","text_align":"","text_transform":"","font_size":"","line_height":"","letter_spacing":"","font_color":"#cdcdcd"},"footer-widgets-typography":{"font_family":"","font_weight":"","font_sub":"","text_align":"","text_transform":"","font_size":"16","line_height":"30","letter_spacing":"","font_color":"#cdcdcd"},"copyright-section-typography":{"font_family":"","font_weight":"","font_sub":"","text_align":"","text_transform":"","font_size":"16","line_height":"30","letter_spacing":"","font_color":"#cdcdcd"},"primary-color":"#c19d56","secondary-color":"#86624a","link-color":{"regular":"#86624a","hover":"#c19d56","active":"#c19d56"},"button-color":{"fore":"#ffffff","bg":"#c19d56","border":"rgb(193,157,86)","hfore":"#ffffff","hbg":"#86624a","hborder":"rgb(134,98,74)"},"header-links-color":{"regular":"","hover":"","active":""},"header-background":{"bg_color":"rgba(0,0,0,0)","bg_repeat":"no-repeat","bg_size":"cover","bg_attachment":"fixed","bg_position":"","image":{"id":"","url":""}},"header-border":{"top":"","right":"","bottom":"","left":"","style":"none","color":""},"header-padding":{"top":"","right":"","bottom":"","left":""},"header-margin":{"top":"","right":"","bottom":"","left":""},"header-layout":"wider","header-items":{"sticky":{"navbar":"Header Bottom"},"disabled":{"logobar":"Header Middle","topbar":"Header Top"}},"header-absolute":"1","menu-type":"mega","dropdown-links-color":{"regular":"#0B0B24","hover":"#c19d56","active":"#c19d56"},"dropdown-background":{"bg_color":"rgb(255,255,255)","bg_repeat":"","bg_size":"","bg_attachment":"","bg_position":"","image":{"id":"","url":""}},"dropdown-sticky-links-color":{"regular":"","hover":"#86624a","active":""},"dropdown-sticky-background":{"bg_color":"rgb(255,255,255)","bg_repeat":"no-repeat","bg_size":"","bg_attachment":"","bg_position":"","image":{"id":"","url":""}},"secondary-sidebar":"","secondary-sidebar-from":"right","secondary-sidebar-width":{"width":"500"},"search-type":"1","header-offset":{"height":"79"},"mobile-header-offset":{"height":"59"},"header-topbar-height":{"height":"40"},"header-topbar-sticky-height":{"height":""},"header-topbar-links-color":{"regular":"#cdcdcd","hover":"#c19d56","active":"#c19d56"},"header-topbar-background":{"bg_color":"rgb(18,14,53)","bg_repeat":"","bg_size":"","bg_attachment":"","bg_position":"","image":{"id":"","url":""}},"header-topbar-border":{"top":"","right":"","bottom":"","left":"","style":"none","color":""},"header-topbar-padding":{"top":"","right":"","bottom":"","left":""},"header-topbar-margin":{"top":"","right":"","bottom":"","left":""},"topbar-items":{"disabled":{"search":"Search","custom-text-2":"Custom Text 2","top-menu":"Top Menu","signin":"Signin\/Register","topbar-spacer-1":"Spacer 1","topbar-spacer-2":"Spacer 2","topbar-spacer-3":"Spacer 3","topbar-html-1":"HTML 1","topbar-html-2":"HTML 2","topbar-html-3":"HTML 3","social":"Social","custom-text-1":"Custom Text 1","topbar-html-4":"HTML 4","topbar-html-5":"HTML 5","topbar_delimiter1":"|","topbar_delimiter2":"|","topbar_delimiter3":"|","wpml_polylang":"WPML\/Polylang"}},"topbar-custom-text-1":"<i class=\"bi bi-clock theme-color mr-2\"><\/i>Mon \u2013 Sun: 9.00 am \u2013 5.00pm","topbar-custom-text-2":"","topbar_html_1":"","topbar_html_2":"","topbar_html_3":"","topbar_html_4":"","topbar_html_5":"","topbar_spacer_1_width":{"width":"40"},"topbar_spacer_2_width":{"width":"40"},"topbar_spacer_3_width":{"width":"40"},"topbar_delimiter1_width":{"width":"1"},"topbar_delimiter1_height":{"height":"100"},"topbar_delimiter1_color":"","topbar_delimiter1_margin":{"top":"","right":"","bottom":"","left":""},"topbar_delimiter2_width":{"width":"1"},"topbar_delimiter2_height":{"height":"100"},"topbar_delimiter2_color":"","topbar_delimiter2_margin":{"top":"","right":"","bottom":"","left":""},"topbar_delimiter3_width":{"width":"1"},"topbar_delimiter3_height":{"height":"100"},"topbar_delimiter3_color":"","topbar_delimiter3_margin":{"top":"","right":"","bottom":"","left":""},"signin-register":"","signin-register-text":"","header-logobar-height":{"height":"120"},"header-logobar-sticky-height":{"height":""},"header-logobar-links-color":{"regular":"","hover":"","active":""},"header-logobar-background":{"bg_color":"rgba(255,255,255,0)","bg_repeat":"","bg_size":"","bg_attachment":"","bg_position":"","image":{"id":"","url":""}},"header-logobar-border":{"top":"","right":"","bottom":"","left":"","style":"none","color":""},"header-logobar-padding":{"top":"0","right":"","bottom":"0","left":""},"header-logobar-margin":{"top":"","right":"","bottom":"","left":""},"logobar-items":{"disabled":{"custom-text-2":"Custom Text 2","secondary-bar":"Secondary Bar","custom-text-1":"Custom Text 1","logo":"Logo","social":"Social","signin":"Signin\/Register","logobar-spacer-1":"Spacer 1","search":"Search","logobar-spacer-2":"Spacer 2","logobar-spacer-3":"Spacer 3","logobar-html-1":"HTML 1","logobar-html-2":"HTML 2","primary-menu":"Primary Menu","logobar-html-3":"HTML 3","logobar-html-4":"HTML 4","logobar-html-5":"HTML 5","logobar_delimiter1":"|","logobar_delimiter2":"|","logobar_delimiter3":"|","wpml_polylang":"WPML\/Polylang"}},"logobar-custom-text-1":"","logobar-custom-text-2":"","logobar_html_1":"","logobar_html_2":"","logobar_html_3":"","logobar_html_4":"","logobar_html_5":"","logobar_spacer_1_width":{"width":"40"},"logobar_spacer_2_width":{"width":"40"},"logobar_spacer_3_width":{"width":"40"},"logobar_delimiter1_width":{"width":"1"},"logobar_delimiter1_height":{"height":"100"},"logobar_delimiter1_color":"","logobar_delimiter1_margin":{"top":"","right":"","bottom":"","left":""},"logobar_delimiter2_width":{"width":"1"},"logobar_delimiter2_height":{"height":"100"},"logobar_delimiter2_color":"","logobar_delimiter2_margin":{"top":"","right":"","bottom":"","left":""},"logobar_delimiter3_width":{"width":"1"},"logobar_delimiter3_height":{"height":"100"},"logobar_delimiter3_color":"","logobar_delimiter3_margin":{"top":"","right":"","bottom":"","left":""},"header-navbar-height":{"height":"90"},"header-navbar-sticky-height":{"height":"90"},"header-navbar-links-color":{"regular":"#ffffff","hover":"#c19d56","active":"#c19d56"},"header-navbar-background":{"bg_color":"rgba(255,255,255,0.02)","bg_repeat":"no-repeat","bg_size":"","bg_attachment":"","bg_position":"","image":{"id":"761","url":""}},"header-navbar-border":{"top":"","right":"","bottom":"1","left":"","style":"solid","color":"rgba(255,255,255,0.04)"},"header-navbar-padding":{"top":"","right":"","bottom":"","left":""},"header-navbar-margin":{"top":"","right":"","bottom":"","left":""},"navbar-items":{"left":{"logo":"Logo"},"center":{"primary-menu":"Primary Menu"},"right":{"search":"Search"},"disabled":{"signin":"Signin\/Register","social":"Social","custom-text-2":"Custom Text 2","navbar-spacer-1":"Spacer 1","navbar-spacer-2":"Spacer 2","navbar-spacer-3":"Spacer 3","navbar-html-1":"HTML 1","navbar-html-2":"HTML 2","secondary-bar":"Secondary Bar","custom-text-1":"Custom Text 1","navbar-html-3":"HTML 3","navbar-html-4":"HTML 4","navbar-html-5":"HTML 5","navbar_delimiter1":"|","navbar_delimiter2":"|","navbar_delimiter3":"|","wpml_polylang":"WPML\/Polylang"}},"navbar-custom-text-1":"","navbar-custom-text-2":"<ul class=\"seoinux-header-custom-info\">\r\n   <li class=\"seoinux-header-phone\">\r\n      <div class=\"media\">\r\n         <i class=\"ti-comments\"><\/i>\r\n         <div class=\"media-body\">\r\n            <p class=\"info-text mb-2\">Have any question?<\/p>\r\n            <h6 class=\"mt-0 mb-0\"><a href=\"tel:2324567890\">  (232) 456-7890<\/a><\/h6>\r\n         <\/div>\r\n      <\/div>\r\n   <\/li>\r\n<\/ul>","navbar_html_1":"","navbar_html_2":"","navbar_html_3":"","navbar_html_4":"","navbar_html_5":"","navbar_spacer_1_width":{"width":"40"},"navbar_spacer_2_width":{"width":"40"},"navbar_spacer_3_width":{"width":"40"},"navbar_delimiter1_width":{"width":"1"},"navbar_delimiter1_height":{"height":"100"},"navbar_delimiter1_color":"","navbar_delimiter1_margin":{"top":"","right":"","bottom":"","left":""},"navbar_delimiter2_width":{"width":"1"},"navbar_delimiter2_height":{"height":"100"},"navbar_delimiter2_color":"","navbar_delimiter2_margin":{"top":"","right":"","bottom":"","left":""},"navbar_delimiter3_width":{"width":"1"},"navbar_delimiter3_height":{"height":"100"},"navbar_delimiter3_color":"","navbar_delimiter3_margin":{"top":"","right":"","bottom":"","left":""},"header-sticky":"normal","header-topbar-sticky-links-color":{"regular":"","hover":"","active":""},"header-topbar-sticky-background":{"bg_color":"","bg_repeat":"","bg_size":"","bg_attachment":"","bg_position":"","image":{"id":"","url":""}},"header-logobar-sticky-links-color":{"regular":"","hover":"","active":""},"header-logobar-sticky-background":{"bg_color":"","bg_repeat":"","bg_size":"","bg_attachment":"","bg_position":"","image":{"id":"","url":""}},"header-navbar-sticky-links-color":{"regular":"#0B0B24","hover":"#c19d56","active":"#c19d56"},"header-navbar-sticky-background":{"bg_color":"rgb(255,255,255)","bg_repeat":"no-repeat","bg_size":"","bg_attachment":"","bg_position":"","image":{"id":"","url":""}},"mobilebar-responsive":"1024","mobilebar-sticky":"on","mobilebar-height":"100","header-mobilebar-color":"#ffffff","header-mobilebar-item-color":"#262626","mobilebar-items":{"left":{"menu-toggle":"Mobile Menu Trigger"},"center":{"logo":"Logo"},"right":{"search":"Search Trigger"},"disabled":{"mobile-menu-custom-text-1":"Mobile menu Custom Text 1","mobile-menu-custom-text-2":"Mobile menu Custom Text 2","mobile-icons-fields":"Mobile Phone Number","mobilebar-spacer-1":"Spacer 1","mobilebar-spacer-2":"Spacer 2","mobilebar-spacer-3":"Spacer 3","mobilebar-html-1":"HTML 1","mobilebar-html-2":"HTML 2","mobilebar-html-3":"HTML 3","mobilebar_delimiter1":"|","mobilebar_delimiter2":"|","mobilebar_delimiter3":"|","mobile-icon-email":"Mobile Email","wpml_polylang":"WPML\/Polylang"}},"mobile-menu-custom-text-1":"","mobile-menu-custom-text-2":"","mobilebar-spacer-1":"40","mobilebar-spacer-2":"40","mobilebar-spacer-3":"40","mobilebar-html-1":"","mobilebar-html-2":"","mobilebar-html-3":"","mobilebar_delimiter1_width":{"width":"1"},"mobilebar_delimiter1_height":{"height":"100"},"mobilebar_delimiter1_color":"","mobilebar_delimiter1_margin":{"top":"","right":"","bottom":"","left":""},"mobilebar_delimiter2_width":{"width":"1"},"mobilebar_delimiter2_height":{"height":"100"},"mobilebar_delimiter2_color":"","mobilebar_delimiter2_margin":{"top":"","right":"","bottom":"","left":""},"mobilebar_delimiter3_width":{"width":"1"},"mobilebar_delimiter3_height":{"height":"100"},"mobilebar_delimiter3_color":"","mobilebar_delimiter3_margin":{"top":"","right":"","bottom":"","left":""},"mobile-menu-color":"#fff","mobile-menu-item-color":"#000","mobile-sidebar-width":{"width":"500"},"mobilebar-menu-items":{"enabled":{"logo":"Logo","menu":"Mobile Menu","search":"Search"},"disabled":{"social":"Social Links","mobile-menu-custom-text-1":"Mobile menu Custom Text 1","mobile-menu-custom-text-2":"Mobile menu Custom Text 2","wpml_polylang":"WPML\/Polylang","spacer-mobile-1":"Spacer 1","spacer-mobile-2":"Spacer 2","spacer-mobile-3":"Spacer 3","delimiter-mobile-1":"_","delimiter-mobile-2":"_","delimiter-mobile-3":"_"}},"mobile-spacer-1":"40","mobile-spacer-2":"40","mobile-spacer-3":"40","mobile-delimiter-1-width":{"width":"100"},"mobile-delimiter-1-height":{"height":"1"},"mobile-delimiter-1-color":"","mobile-delimiter-1-margin":{"top":"","right":"","bottom":"","left":""},"mobile-delimiter-2-width":{"width":"100"},"mobile-delimiter-2-height":{"height":"1"},"mobile-delimiter-2-color":"","mobile-delimiter-2-margin":{"top":"","right":"","bottom":"","left":""},"mobile-delimiter-3-width":{"width":"100"},"mobile-delimiter-3-height":{"height":"1"},"mobile-delimiter-3-color":"","mobile-delimiter-3-margin":{"top":"","right":"","bottom":"","left":""},"footer-layout":"wide","footer-links-color":{"regular":"","hover":"","active":""},"footer-background":{"bg_color":"rgba(0,0,0,0.57)","bg_repeat":"no-repeat","bg_size":"cover","bg_attachment":"fixed","bg_position":"center center","image":{"id":"4555","url":""}},"footer-border":{"top":"","right":"","bottom":"","left":"","style":"none","color":""},"footer-padding":{"top":"","right":"","bottom":"","left":""},"footer-margin":{"top":"0","right":"0","bottom":"0","left":"0"},"footer-items":{"enabled":{"footer-middle":"Footer Widgets","footer-bottom":"Copyright Section"},"disabled":{"footer-top":"Footer Top"}},"insta-footer-layout":"boxed","insta-footer-links-color":{"regular":"#cdcdcd","hover":"#c19d56","active":"#c19d56"},"insta-footer-background":{"bg_color":"","bg_repeat":"no-repeat","bg_size":"cover","bg_attachment":"","bg_position":"","image":{"id":"","url":""}},"insta-footer-border":{"top":"","right":"","bottom":"1","left":"","style":"solid","color":"rgba(255,255,255,0.04)"},"insta-footer-padding":{"top":"70","right":"0","bottom":"70","left":"0"},"insta-footer-margin":{"top":"","right":"","bottom":"","left":""},"widgets-footer-layout":"boxed","footer-widgets-layout":"3-3-3-3","footer-widget-1":"footer-1","footer-widget-2":"footer-2","footer-widget-3":"footer-3","footer-widget-4":"footer-4","footer-widgets-links-color":{"regular":"#cdcdcd","hover":"#c19d56","active":"#c19d56"},"footer-widgets-background":{"bg_color":"rgb(16,10,8)","bg_repeat":"no-repeat","bg_size":"cover","bg_attachment":"fixed","bg_position":"center center","image":{"id":"15750","url":""}},"footer-widgets-border":{"top":"","right":"","bottom":"1","left":"","style":"solid","color":"rgba(255,255,255,0.11)"},"footer-widgets-padding":{"top":"100","right":"","bottom":"100","left":""},"footer-widgets-margin":{"top":"","right":"","bottom":"","left":""},"footer-bottom-layout":"boxed","copyright-widget":"","copyright-section-links-color":{"regular":"#c19d56","hover":"#ffffff","active":"#ffffff"},"copyright-section-background":{"bg_color":"rgb(16,10,8)","bg_repeat":"","bg_size":"","bg_attachment":"","bg_position":"","image":{"id":"","url":""}},"copyright-sections-border":{"top":"1","right":"","bottom":"","left":"","style":"solid","color":"rgba(255,255,255,0.03)"},"copyright-section-padding":{"top":"25","right":"","bottom":"25","left":""},"copyright-section-margin":{"top":"0","right":"0","bottom":"0","left":"0"},"copyright-bar-items":{"left":{"copyright-text":"Copyright Text"},"right":{"copyright-widgets":"Custom Widgets"}},"copyright-text":"\u00a9 Copyright [year]. All rights reserved <a href=\"https:\/\/wordpress.zozothemes.com\/consultxp\/\" target=\"_blank\">consultxp<\/a>. Designed by \r\n <a href=\"https:\/\/zozothemes.com\/\"  target=\"_blank\">Zozothemes<\/a>","blog-title":"1","blog-layout":"standard","blog-grid-columns":"2","blog-grid-gutter":"30","blog-title-color":"#ffffff","blog-title-desc-color":"#acb3b3","blog-title-link-color":{"regular":"#c19d56","hover":"#ffffff","active":"#c19d56"},"blog-title-padding":{"top":"230","right":"","bottom":"140","left":""},"blog-title-bg":{"bg_color":"rgba(0,0,0,0.73)","bg_repeat":"no-repeat","bg_size":"cover","bg_attachment":"fixed","bg_position":"center top","image":{"id":"99","url":""}},"blog-title-overlaycolor":"rgba(16,10,8,0.79)","blog-title-items":{"left":{"title":"Title","breadcrumb":"Breadcrumb"},"disabled":{"description":"Description"}},"blog-page-title":"Latest Posts","blog-page-description":"You become sound knowledge by our latest posts.","blog-sidebar-layout":"right-sidebar","blog-right-sidebar":"right-sidebar","blog-left-sidebar":"right-sidebar","blog-top-meta-enable":"1","blog-top-meta-items":{"left":{"author":"Author","date":"Date","category":"Category"},"disabled":{"tag":"Tag","more":"Read More","share":"Social Share"}},"blog-read-more":"Read more","blog-bottom-meta-enable":"1","blog-bottom-meta-items":{"left":{"more":"Read More"},"disabled":{"author":"Author","tag":"Tag","date":"Date","category":"Category","share":"Social Share"}},"blog-post-excerpt-length":"28","404_building_tool":"default","404-page-selector":"","archive-title":"1","archive-title-color":"#ffffff","archive-title-desc-color":"#acb3b3","archive-title-link-color":{"regular":"#c19d56","hover":"#ffffff","active":"#c19d56"},"archive-title-padding":{"top":"230","right":"","bottom":"140","left":""},"archive-title-bg":{"bg_color":"rgba(0,0,0,0.53)","bg_repeat":"no-repeat","bg_size":"cover","bg_attachment":"fixed","bg_position":"center center","image":{"id":"1474","url":""}},"archive-title-overlaycolor":"rgba(16,10,8,0.79)","archive-title-items":{"left":{"title":"Title","breadcrumb":"Breadcrumb"},"disabled":{"description":"Description"}},"archive-sidebar-layout":"right-sidebar","archive-right-sidebar":"right-sidebar","archive-left-sidebar":"","archive-top-meta-enable":"1","archive-top-meta-items":{"left":{"author":"Author","date":"Date","category":"Category"},"disabled":{"tag":"Tag","share":"Social Share"}},"archive-bottom-meta-enable":"1","archive-bottom-meta-items":{"left":{"more":"Read More"},"disabled":{"tag":"Tag","author":"Author","category":"Category","share":"Social Share","date":"Date"}},"search-templates":["post","page"],"single-title":"1","single-title-color":"#ffffff","single-title-desc-color":"#acb3b3","single-title-link-color":{"regular":"#c19d56","hover":"#ffffff","active":"#c19d56"},"single-title-padding":{"top":"230","right":"","bottom":"140","left":""},"single-title-bg":{"bg_color":"rgba(0,0,0,0.13)","bg_repeat":"no-repeat","bg_size":"cover","bg_attachment":"fixed","bg_position":"center center","image":{"id":"1474","url":""}},"single-title-overlaycolor":"rgba(16,10,8,0.79)","single-title-items":{"left":{"title":"Title","breadcrumb":"Breadcrumb"},"disabled":{"description":"Description"}},"single-sidebar-layout":"right-sidebar","single-right-sidebar":"right-sidebar","single-left-sidebar":"","single-top-meta-enable":"1","single-top-meta-items":{"left":{"author":"Author","date":"Date","category":"Category"},"disabled":{"share":"Social Share","tag":"Tag"}},"single-bottom-meta-enable":"1","single-bottom-meta-items":{"left":{"tag":"Tag"},"right":{"share":"Social Share"},"disabled":{"category":"Category","author":"Author","date":"Date"}},"page-title":"1","page-title-color":"#ffffff","page-title-desc-color":"#acb3b3","page-title-link-color":{"regular":"#c19d56","hover":"#ffffff","active":"#c19d56"},"page-title-padding":{"top":"230","right":"","bottom":"140","left":""},"page-title-bg":{"bg_color":"rgba(0,0,0,0.53)","bg_repeat":"no-repeat","bg_size":"cover","bg_attachment":"fixed","bg_position":"center center","image":{"id":"1474","url":""}},"page-title-overlaycolor":"rgba(16,10,8,0.79)","page-title-items":{"left":{"title":"Title","breadcrumb":"Breadcrumb"},"disabled":{"description":"Description"}},"page-sidebar-layout":"no-sidebar","page-right-sidebar":"","page-left-sidebar":"","custom-archive-title":"1","custom-archive-title-color":"#ffffff","custom-archive-title-desc-color":"#acb3b3","custom-archive-title-link-color":{"regular":"#c19d56","hover":"#ffffff","active":"#c19d56"},"custom-archive-title-padding":{"top":"230","right":"","bottom":"130","left":""},"custom-archive-title-bg":{"bg_color":"","bg_repeat":"no-repeat","bg_size":"cover","bg_attachment":"","bg_position":"center top","image":{"id":"1474","url":""}},"custom-archive-title-overlaycolor":"rgba(16,10,8,0.79)","custom-archive-title-items":{"left":{"title":"Title","breadcrumb":"Breadcrumb"},"disabled":{"description":"Description"}},"custom-archive-sidebar-layout":"right-sidebar","custom-archive-right-sidebar":"","custom-archive-left-sidebar":"","custom-single-title":"1","custom-single-title-color":"#ffffff","custom-single-title-desc-color":"#acb3b3","custom-single-title-link-color":{"regular":"#c19d56","hover":"#ffffff","active":"#c19d56"},"custom-single-title-padding":{"top":"230","right":"","bottom":"140","left":""},"custom-single-title-bg":{"bg_color":"","bg_repeat":"no-repeat","bg_size":"cover","bg_attachment":"fixed","bg_position":"center center","image":{"id":"15866","url":""}},"custom-single-title-overlaycolor":"rgba(16,10,8,0.79)","custom-single-title-items":{"left":{"title":"Title","breadcrumb":"Breadcrumb"},"disabled":{"description":"Description"}},"custom-single-sidebar-layout":"right-sidebar","custom-single-right-sidebar":"","custom-single-left-sidebar":"","social-icon-window":"_blank","social-icons-fore":"own","social-icons-fore-custom":"","social-icons-hfore":"h-own","social-icons-hfore-custom":"","social-icons-bg":"bg-own","social-icons-bg-custom":"","social-icons-hbg":"hbg-own","social-icons-hbg-custom":"","social-icons-border-color":"","social-icons-border-width":"0","social-icons-border-radius":"50","social-icons-border-style":"none"}';
   }
}

ConsultxpTheme_default::init();