<?php
/**
 * Displays the menus and widgets at the end of the main element.
 */

$template = Consultxp_Wp_Elements::$template;

$keys = array(
	'chk' => 'sidebar-chk',
	'fields' => array(
		'sidebar_layout' => array( 'sidebar-layout', $template.'-sidebar-layout' ),
		'right_sidebar' => array( 'right-sidebar', $template.'-right-sidebar' ),
		'left_sidebar' => array( 'left-sidebar', $template.'-left-sidebar' )
	)
);
$page_title_values = Consultxp_Wp_Elements::consultxp_get_meta_and_option_values( $keys );
$sidebar_layout = $page_title_values['sidebar_layout'];
if ( function_exists( 'is_shop' ) && is_shop() ) {
	if ( $sidebar_layout == 'right-sidebar' ) {
		$shop_cols = Consultxp_Wp_Elements::consultxp_options('shop-right-sidebar-cols');
		list($content, $sidebar) = explode('x', $shop_cols);
	} elseif( $sidebar_layout == 'left-sidebar' ) {
		$shop_cols = Consultxp_Wp_Elements::consultxp_options('shop-left-sidebar-cols');
		list($sidebar, $content) = explode('x', $shop_cols);
	} elseif ( $sidebar_layout == 'both-sidebar' ) {
		$shop_cols = Consultxp_Wp_Elements::consultxp_options('shop-both-sidebar-cols');
		list( $left, $content, $right ) = explode( 'x', $shop_cols );
	}
}
if( $sidebar_layout != 'no-sidebar' ):
	$col = 0; $sides = array();
	if( $sidebar_layout == 'left-sidebar' ){
		if ( isset( $sidebar ) && $sidebar != '' ) {
			Consultxp_Wp_Elements::consultxp_get_template_sidebars( $page_title_values, 'left', 'col-md-'. esc_attr( $sidebar ) .' order-md-1' );
		} else {
			Consultxp_Wp_Elements::consultxp_get_template_sidebars( $page_title_values, 'left', 'col-md-4 order-md-1' );
		}
	}elseif( $sidebar_layout == 'right-sidebar' ){
		if ( isset( $sidebar ) && $sidebar != '' ) {
			Consultxp_Wp_Elements::consultxp_get_template_sidebars( $page_title_values, 'right', 'col-md-'. esc_attr( $sidebar ) .' order-md-3' );
		} else {
			Consultxp_Wp_Elements::consultxp_get_template_sidebars( $page_title_values, 'right', 'col-md-4 order-md-3' );
		}
	}elseif( $sidebar_layout == 'both-sidebar' ){
		$left_sidebar = $page_title_values['left_sidebar'];
		$right_sidebar = $page_title_values['right_sidebar'];
		
		if ( isset( $left ) && isset( $right ) && $left != '' && $right != '' ) {
			Consultxp_Wp_Elements::consultxp_get_template_sidebars( $page_title_values, 'left', 'col-md-'. esc_attr( $left ) .' order-md-1' );
			Consultxp_Wp_Elements::consultxp_get_template_sidebars( $page_title_values, 'right', 'col-md-'. esc_attr( $right ) .' order-md-3' );
		} else {	
			if( $left_sidebar != 'none' && is_active_sidebar($left_sidebar) && $right_sidebar != 'none' && is_active_sidebar($right_sidebar) )$col = 3;
			else $col = 4;
		
			Consultxp_Wp_Elements::consultxp_get_template_sidebars( $page_title_values, 'left', 'col-md-'. esc_attr( $col ) .' order-md-1' );
			Consultxp_Wp_Elements::consultxp_get_template_sidebars( $page_title_values, 'right', 'col-md-'. esc_attr( $col ) .' order-md-3' );
		}
	}
endif;