<?php
	$class_array = array(
		'left'		=> ' element-left',
		'center'	=> ' pull-center justify-content-center',
		'right'		=> ' pull-right justify-content-end'
	);
	$header_keys = array(
		'chk' => 'header-chk',
		'fields' => array(
			'header_layout' => 'header-layout'
		)			
	);
	$header_values = Consultxp_Wp_Elements::consultxp_get_meta_and_option_values( $header_keys );
	$keys = array(
		'chk' => 'header-navbar-chk',
		'fields' => array(
			'header_navbar_items' => 'navbar-items',
			'header_navbar_text_1' => 'navbar-custom-text-1',
			'header_navbar_text_2' => 'navbar-custom-text-2',
			'header_navbar_html_1' => 'navbar_html_1',
			'header_navbar_html_2' => 'navbar_html_2',
			'header_navbar_html_3' => 'navbar_html_3',
			'header_navbar_html_4' => 'navbar_html_4',
			'header_navbar_html_5' => 'navbar_html_5',
			'header_navbar_spacer_1' => 'navbar_spacer_1_width',
			'header_navbar_spacer_2' => 'navbar_spacer_2_width',
			'header_navbar_spacer_3' => 'navbar_spacer_3_width',
			'header_navbar_delimit_1_width' => 'navbar_delimiter1_width',
			'header_navbar_delimit_1_height' => 'navbar_delimiter1_height',
			'header_navbar_delimit_1_color' => 'navbar_delimiter1_color',
			'header_navbar_delimit_1_margin' => 'navbar_delimiter1_margin',
			'header_navbar_delimit_2_width' => 'navbar_delimiter2_width',
			'header_navbar_delimit_2_height' => 'navbar_delimiter2_height',
			'header_navbar_delimit_2_color' => 'navbar_delimiter2_color',
			'header_navbar_delimit_2_margin' => 'navbar_delimiter2_margin',
			'header_navbar_delimit_3_width' => 'navbar_delimiter3_width',
			'header_navbar_delimit_3_height' => 'navbar_delimiter3_height',
			'header_navbar_delimit_3_color' => 'navbar_delimiter3_color',
			'header_navbar_delimit_3_margin' => 'navbar_delimiter3_margin',
			'header_navbar_sign_in'	=> 'signin-register-nav',
			'header_navbar_sign_in_text' => 'signin-register-text-nav',
		)			
	);
	$navbar_values = Consultxp_Wp_Elements::consultxp_get_meta_and_option_values( $keys );
	$navbar_items = $navbar_values['header_navbar_items'];
	if( !empty( $navbar_items ) ):	
		if( isset( $navbar_items['disabled'] ) ) unset( $navbar_items['disabled'] );
		
		$layout = $header_values['header_layout'];
		$container_class = $layout == 'wider' ? 'container-fluid' : 'container';
?>
		<div class="header-navbar navbar elements-<?php echo esc_attr( count( $navbar_items ) ); ?>">
			<?php
				/*
				 * Consultxp navbar Before Action
				 */
				do_action( 'consultxp_navbar_before' );
			?>
			<div class="<?php echo esc_attr( $container_class ); ?>">
				<?php
				foreach( $navbar_items as $key => $value ){
					$navbar_class = $class_array[$key];
					$navbar_class .= isset( $navbar_items['right'] ) && !empty( $navbar_items['right'] ) ? ' right-element-exist' : '';
					echo '<ul class="nav navbar-ul'. esc_attr( $navbar_class ) .'">';
						foreach( $value as $element => $label ){
							switch( $element ){
								case "custom-text-1":
									if( $navbar_values['header_navbar_text_1'] != '' ) {
										echo '<li>'. do_shortcode( stripslashes( force_balance_tags( wp_kses_post( $navbar_values['header_navbar_text_1'] ) ) ) ) .'</li>';
									} else {
										echo '<li>'. do_shortcode( stripslashes( force_balance_tags( wp_kses_post( get_option( 'consultxp_options' )['navbar-custom-text-1'] ) ) ) ) .'</li>';
									}
								break;
								case "custom-text-2":
									if( $navbar_values['header_navbar_text_2'] != '' ) {
										echo '<li>'. do_shortcode( stripslashes( force_balance_tags( wp_kses_post( $navbar_values['header_navbar_text_2'] ) ) ) ) .'</li>';
									} else {
										echo '<li>'. do_shortcode( stripslashes( force_balance_tags( wp_kses_post( get_option( 'consultxp_options' )['navbar-custom-text-2'] ) ) ) ) .'</li>';
									}
								break;
								case "social":
									if( class_exists( 'Consultxp_Custom_Functions' ) ):
										echo '<li>';
										Consultxp_Custom_Functions::consultxp_social_links();
										echo '</li>';
									endif;
								break;
								case "search":
									$keys = array(
										'chk' => 'header-chk',
										'fields' => array(
											'post-type' => 'search-template',
											'search_type' => 'search-type'
										)			
									);
									$search_values = Consultxp_Wp_Elements::consultxp_get_meta_and_option_values( $keys );
									$search_type = $search_values['search_type'];
									echo '<li>';
									Consultxp_Wp_Framework::consultxp_search_modal( $search_type, 'navbar' );
									echo '</li>';
								break;
									case "logo": ?>
									<li class="header-titles-wrapper">
										<div class="header-titles">
											<?php
												// Site title or logo.
												Consultxp_Wp_Framework::consultxp_site_logo();
												// Sticky logo
												Consultxp_Wp_Framework::consultxp_sticky_logo();
												// Site description.
												Consultxp_Wp_Framework::consultxp_site_description();
											?>
										</div><!-- .header-titles -->
									</li><!-- .header-titles-wrapper -->
								<?php
								break;
								case "primary-menu": ?>
									<li class="header-navigation-wrapper">
										<?php
											$menu_name = '';
											$page_option = get_post_meta( get_the_ID(), 'consultxp_post_meta', true );
											if( isset( $page_option['header-one-page-menu'] ) && $page_option['header-one-page-menu'] != 'none' ) {
												$menu_name = $page_option['header-one-page-menu'];
											}
										?>
										<?php if ( has_nav_menu( 'primary' ) || !empty( $menu_name ) ) { ?>
											<nav class="primary-menu-wrapper" aria-label="<?php esc_attr_e( 'Horizontal', 'consultxp' ); ?>">
												<ul class="nav wp-menu primary-menu <?php echo ( class_exists( 'Consultxp_Wp_Bootstrap_Navwalker' ) ) ? 'clsass' : 'ss'; ?>">
													<?php
														wp_nav_menu(array(
															'container'      => false,
															'items_wrap'     => '%3$s',
															'theme_location' => 'primary',
															'menu'           => !empty($menu_name) ? $menu_name : '',
															'fallback_cb'    => false,
															'walker'         => ( class_exists( 'Consultxp_Wp_Bootstrap_Navwalker' ) ) ? new Consultxp_Wp_Bootstrap_Navwalker() : '',
														));
													?>
												</ul>
											</nav><!-- .primary-menu-wrapper -->
										<?php }  else { 
											echo sprintf( 
												'<a href="%1$s">%2$s</a>',
												admin_url( 'nav-menus.php' ),
												esc_html__( 'Add a menu', 'consultxp' )
											); }
										?>
									</li><!-- .header-navigation-wrapper -->
								<?php
								break;
								
								case "secondary-bar": 
									$secondary_sidebar_option = isset( get_option('consultxp_options')['secondary-sidebar-woocommerce'] ) ? get_option('consultxp_options')['secondary-sidebar-woocommerce'] : '';
									$sidebar_icon = isset( get_option('consultxp_options')['secondary-bar-span'] ) ? get_option('consultxp_options')['secondary-bar-span'] : '';
									if ( $secondary_sidebar_option === 'woocommerce-sidebar' ) :
									?>
									<li class="secondary-toggle-wrapper">
										<a href="#" class="secondary-menu-toggle consultxp-toggle" data-toggle-target="#woocommerce-secondary-cart">
											<span class="cart-icon">
												<?php if ( $sidebar_icon != '' ) {
													echo stripcslashes($sidebar_icon);
												} else {
													echo stripcslashes('<i class="bi bi-cart"></i>');
												} ?>
												<?php echo WC()->cart->get_cart_contents_count(); ?>
											</span>
										</a>
									</li>
									<?php 
										add_action( 'consultxp_footer_after', function() {
											$sidebar_layout = ! empty( Consultxp_Wp_Elements::consultxp_options('secondary-sidebar-layout') ) ? Consultxp_Wp_Elements::consultxp_options('secondary-sidebar-layout') : '';
											$close_icon = ! empty( Consultxp_Wp_Elements::consultxp_options('secondary-bar-cicon') ) && ( $sidebar_layout == 'custom-sicon' ) ? Consultxp_Wp_Elements::consultxp_options('secondary-bar-cicon') : '×';
											?>
												<div id="woocommerce-secondary-cart" class="secondary-bar-wrapper from-right">
												<div class="secondary-bar-inner">
													<a href="#" class="secondary-close"><?php echo stripcslashes( $close_icon ); ?></a>
													<h4 class="cart-title"><?php esc_html_e( 'Your Cart', 'woocommerce' ); ?></h4>
													<?php woocommerce_mini_cart(); ?>
												</div>
											</div>
											<?php
										}, 10 );
									else: ?>
									<li class="secondary-toggle-wrapper">
										<a href="<?php echo esc_url( home_url() ); ?>" class="secondary-menu-toggle consultxp-toggle">
											<?php if ( $sidebar_icon != '' ) {
												echo stripcslashes($sidebar_icon);
											} else {
												echo '<span></span><span></span><span></span><span></span>';
											} ?>
										</a>
									</li>
									<?php add_action( 'consultxp_footer_after', array( 'Consultxp_Wp_Elements', 'consultxp_secondary_bar' ), 10 );
									endif;
								break;
								case "navbar-html-1":
									if ( $navbar_values['header_navbar_html_1'] != '' ) {
										echo '<li>' . do_shortcode( stripslashes ( force_balance_tags( wp_kses_post ( $navbar_values['header_navbar_html_1'] ) ) ) ) . '</li>';
									} else {
										echo '<li>' . do_shortcode( stripslashes ( force_balance_tags( wp_kses_post ( get_option( 'consultxp_options' )['navbar_html_1'] ) ) ) ) . '</li>';
									}
								break;
								case "navbar-html-2":
									if ( $navbar_values['header_navbar_html_2'] != '' ) {
										echo '<li>' . do_shortcode( stripslashes ( force_balance_tags( wp_kses_post ( $navbar_values['header_navbar_html_2'] ) ) ) ) . '</li>';
									} else {
										echo '<li>' . do_shortcode( stripslashes( force_balance_tags( wp_kses_post( get_option( 'consultxp_options' )['navbar_html_2'] ) ) ) ) . '</li>';
									}
								break;
								case "navbar-html-3":
									if ( $navbar_values['header_navbar_html_3'] != '' ) {
										echo '<li>' . do_shortcode( stripslashes ( force_balance_tags( wp_kses_post ( $navbar_values['header_navbar_html_3'] ) ) ) ) . '</li>';
									} else {
										echo '<li>' . do_shortcode( stripslashes( force_balance_tags( wp_kses_post( get_option( 'consultxp_options' )['navbar_html_3'] ) ) ) ) . '</li>';
									}
								break;
								case "navbar-html-4":
									if ( $navbar_values['header_navbar_html_4'] != '' ) {
										echo '<li>' . do_shortcode( stripslashes ( force_balance_tags( wp_kses_post ( $navbar_values['header_navbar_html_4'] ) ) ) ) . '</li>';
									} else {
										echo '<li>' . do_shortcode( stripslashes( force_balance_tags( wp_kses_post( get_option( 'consultxp_options' )['navbar_html_4'] ) ) ) ) . '</li>';
									}
								break;
								case "navbar-html-5":
									if ( $navbar_values['header_navbar_html_5'] != '' ) {
										echo '<li>' . do_shortcode( stripslashes ( force_balance_tags( wp_kses_post ( $navbar_values['header_navbar_html_5'] ) ) ) ) . '</li>';
									} else {
										echo '<li>' . do_shortcode( stripslashes( force_balance_tags( wp_kses_post( get_option( 'consultxp_options' )['navbar_html_5'] ) ) ) ) . '</li>';
									}
								break;
								case "navbar-spacer-1":
									$spacer1_width = get_option('consultxp_options')['navbar_spacer_1_width']['width'];
									if ( $navbar_values['header_navbar_spacer_1']['width'] != '' ) {
										$spacer1_width = $navbar_values['header_navbar_spacer_1']['width'];
									}
									echo '<li><div class="header_spacer" style="width: '.$spacer1_width.'px;"></div></li>';
								break;
								case "navbar-spacer-2":
									$spacer2_width = get_option('consultxp_options')['navbar_spacer_2_width']['width'];
									echo '<li><div class="header_spacer" style="width: '.$spacer2_width.'px;"></div></li>';
								break;
								case "navbar-spacer-3":
									$spacer3_width = get_option('consultxp_options')['navbar_spacer_3_width']['width'];
									echo '<li><div class="header_spacer" style="width: '.$spacer3_width.'px;"></div></li>';
								break;
								case "navbar_delimiter1":
									$delimiter1_width = $navbar_values['header_navbar_delimit_1_width']['width'] ?? get_option('consultxp_options')['navbar_delimiter1_width']['width'];
									$delimiter1_height = $navbar_values['header_navbar_delimit_1_height']['height'] ?? get_option('consultxp_options')['navbar_delimiter1_height']['height'];
									$delimiter1_color = $navbar_values['header_navbar_delimit_1_color'] ?? get_option('consultxp_options')['navbar_delimiter1_color'];
									$delimiter1_margin_top = $navbar_values['header_navbar_delimit_1_margin']['top'] ?? get_option('consultxp_options')['navbar_delimiter1_margin']['top'];
									$delimiter1_margin_right = $navbar_values['header_navbar_delimit_1_margin']['right'] ?? get_option('consultxp_options')['navbar_delimiter1_margin']['right'];
									$delimiter1_margin_left = $navbar_values['header_navbar_delimit_1_margin']['left'] ?? get_option('consultxp_options')['navbar_delimiter1_margin']['left'];
									$delimiter1_margin_bottom = $navbar_values['header_navbar_delimit_1_margin']['bottom'] ?? get_option('consultxp_options')['navbar_delimiter1_margin']['bottom'];
									echo '<li><div class="delimiter" style="margin: '.$delimiter1_margin_top.'px '.$delimiter1_margin_right.'px '.$delimiter1_margin_bottom.'px '.$delimiter1_margin_left.'px; background-color:'.$delimiter1_color.';width: '.$delimiter1_width.'px;height: '.$delimiter1_height.'px "></div></li>';
								break;
								case "navbar_delimiter2":
									$delimiter2_width = $navbar_values['header_navbar_delimit_2_width']['width'] ?? get_option('consultxp_options')['navbar_delimiter2_width']['width'];
									$delimiter2_height = $navbar_values['header_navbar_delimit_2_height']['height'] ?? get_option('consultxp_options')['navbar_delimiter2_height']['height'];
									$delimiter2_color = $navbar_values['header_navbar_delimit_2_color'] ?? get_option('consultxp_options')['navbar_delimiter2_color'];
									$delimiter2_margin_top = $navbar_values['header_navbar_delimit_2_margin']['top'] ?? get_option('consultxp_options')['navbar_delimiter2_margin']['top'];
									$delimiter2_margin_right = $navbar_values['header_navbar_delimit_2_margin']['right'] ?? get_option('consultxp_options')['navbar_delimiter2_margin']['right'];
									$delimiter2_margin_left = $navbar_values['header_navbar_delimit_2_margin']['left'] ?? get_option('consultxp_options')['navbar_delimiter2_margin']['left'];
									$delimiter2_margin_bottom = $navbar_values['header_navbar_delimit_2_margin']['bottom'] ?? get_option('consultxp_options')['navbar_delimiter2_margin']['bottom'];
									echo '<li><div class="delimiter" style="margin: '.$delimiter2_margin_top.'px '.$delimiter2_margin_right.'px '.$delimiter2_margin_bottom.'px '.$delimiter2_margin_left.'px; background-color:'.$delimiter2_color.';width: '.$delimiter2_width.'px;height: '.$delimiter2_height.'px "></div></li>';
								break;
								case "navbar_delimiter3":
									$delimiter3_width = $navbar_values['header_navbar_delimit_3_width']['width'] ?? get_option('consultxp_options')['navbar_delimiter3_width']['width'];
									$delimiter3_height = $navbar_values['header_navbar_delimit_3_height']['height'] ?? get_option('consultxp_options')['navbar_delimiter3_height']['height'];
									$delimiter3_color = $navbar_values['header_navbar_delimit_3_color'] ?? get_option('consultxp_options')['navbar_delimiter3_color'];
									$delimiter3_margin_top = $navbar_values['header_navbar_delimit_3_margin']['top'] ?? get_option('consultxp_options')['navbar_delimiter3_margin']['top'];
									$delimiter3_margin_right = $navbar_values['header_navbar_delimit_3_margin']['right'] ?? get_option('consultxp_options')['navbar_delimiter3_margin']['right'];
									$delimiter3_margin_left = $navbar_values['header_navbar_delimit_3_margin']['left'] ?? get_option('consultxp_options')['navbar_delimiter3_margin']['left'];
									$delimiter3_margin_bottom = $navbar_values['header_navbar_delimit_3_margin']['bottom'] ?? get_option('consultxp_options')['navbar_delimiter3_margin']['bottom'];
									echo '<li><div class="delimiter" style="margin: '.$delimiter3_margin_top.'px '.$delimiter3_margin_right.'px '.$delimiter3_margin_bottom.'px '.$delimiter3_margin_left.'px; background-color:'.$delimiter3_color.';width: '.$delimiter3_width.'px;height: '.$delimiter3_height.'px "></div></li>';
								break;
								case "signin":
									$shortcode = stripslashes(force_balance_tags(wp_kses_post(get_option('consultxp_options')['signin-register-nav'])));
									if ( $navbar_values['header_navbar_sign_in'] != '' ) {
										$shortcode = stripslashes( force_balance_tags( wp_kses_post( $navbar_values['header_navbar_sign_in'] ) ) );
									}
									$login_button_text = get_option('consultxp_options')['signin-register-text-nav'];
									if ( $navbar_values['header_navbar_sign_in_text'] != '' ) {
										$login_button_text = $navbar_values['header_navbar_sign_in_text'];
									}
									if (empty($shortcode)) {
										$shortcode = wp_login_form([
											'echo'           => false,
											'redirect'       => home_url(), // Redirect to home after login
											'form_id'        => 'loginform',
											'label_username' => __('Username or Email', 'consultxp'),
											'label_password' => __('Password', 'consultxp'),
											'label_remember' => __('Remember Me', 'consultxp'),
											'label_log_in'   => __('Log In', 'consultxp'),
											'remember'       => true
										]);
									} else {
										$shortcode = do_shortcode($shortcode);
									}
								
									echo '<li>';
									echo '<button class="btn btn-primary login-button" data-shortcode="' . esc_attr($shortcode) . '">' . esc_attr__( $login_button_text, 'consultxp') . '</button>
									</li>';
									add_action( 'consultxp_footer_after', function() use ($shortcode) {
										?>
										<div id="login-popup" class="login-popup" style="display: none;">
											<div class="popup-content">
												<button class="close-popup">×</button>
												<?php echo $shortcode; ?>
											</div>
										</div>
										<?php
									});
								break;
								case "wpml_polylang":
									if ( defined( 'ICL_SITEPRESS_VERSION' ) ) {
										$current_language = apply_filters( 'wpml_current_language', NULL );
										echo '<li>'; 
											do_action('wpml_add_language_selector');
										echo '</li>'; 
									} else if ( function_exists( 'pll_the_languages' ) ) {
										echo '<li>';
										pll_the_languages( array( 'dropdown' => 0 ) );
										echo '</li>';
									}
								break;
								// Woocommerce cart icon Option
								case "woocommerce-cart":
									$options = get_option('consultxp_options');
									$icon_class = !empty( $options['navbar-cart-icon-class'] ) ? $options['navbar-cart-icon-class'] : 'fa fa-shopping-cart';
									$trigger_type = !empty( $options['navbar-cart-trigger'] ) ? $options['navbar-cart-trigger'] : 'click';
									$trigger_class = $trigger_type === 'hover' ? 'hover-cart' : 'click-cart';

									if ( class_exists('WooCommerce') ) {
										echo '<li class="woocommerce-cart-item ' . esc_attr( $trigger_class ) . '">';
										echo '<a href="javascript:void(0);" class="cart-trigger">';
											echo '<i class="' . esc_attr( $icon_class ) . '"></i>';
											echo '<span class="cart-count">' . esc_html( WC()->cart->get_cart_contents_count() ) . '</span>';
										echo '</a>';
										echo '<div class="mini-cart-dropdown">';
											the_widget( 'WC_Widget_Cart', 'title=' );
										echo '</div>';
										echo '</li>';
									}
								break;
							}
						}
					echo '</ul>';
				}
				?>
			</div><!-- .container -->
			<?php
				/*
				 * Consultxp navbar After Action 
				 * 10 - consultxp_fullbar_search_form
				 */
				do_action( 'consultxp_navbar_after' );
			?>
		</div><!-- .header-navbar -->
<?php endif; ?>