<?php 
	$class_array = array(
		'left'		=> ' element-left',
		'center'	=> ' pull-center justify-content-center',
		'right'		=> ' pull-right justify-content-end'
	);
	$header_keys = array(
		'chk' => 'header-chk',
		'fields' => array(
			'header_layout' => 'header-layout'
		)			
	);
	$header_values = Consultxp_Wp_Elements::consultxp_get_meta_and_option_values( $header_keys );
	$keys = array(
		'chk' => 'header-topbar-chk',
		'fields' => array(
			'header_topbar_items' => 'topbar-items',
			'header_topbar_text_1' => 'topbar-custom-text-1',
			'header_topbar_text_2' => 'topbar-custom-text-2',
			'header_topbar_html_1' => 'topbar_html_1',
			'header_topbar_html_2' => 'topbar_html_2',
			'header_topbar_html_3' => 'topbar_html_3',
			'header_topbar_html_4' => 'topbar_html_4',
			'header_topbar_html_5' => 'topbar_html_5',
			'header_topbar_spacer_1' => 'topbar_spacer_1_width',
			'header_topbar_spacer_2' => 'topbar_spacer_2_width',
			'header_topbar_spacer_3' => 'topbar_spacer_3_width',
			'header_topbar_delimit_1_width' => 'topbar_delimiter1_width',
			'header_topbar_delimit_1_height' => 'topbar_delimiter1_height',
			'header_topbar_delimit_1_color' => 'topbar_delimiter1_color',
			'header_topbar_delimit_1_margin' => 'topbar_delimiter1_margin',
			'header_topbar_delimit_2_width' => 'topbar_delimiter2_width',
			'header_topbar_delimit_2_height' => 'topbar_delimiter2_height',
			'header_topbar_delimit_2_color' => 'topbar_delimiter2_color',
			'header_topbar_delimit_2_margin' => 'topbar_delimiter2_margin',
			'header_topbar_delimit_3_width' => 'topbar_delimiter3_width',
			'header_topbar_delimit_3_height' => 'topbar_delimiter3_height',
			'header_topbar_delimit_3_color' => 'topbar_delimiter3_color',
			'header_topbar_delimit_3_margin' => 'topbar_delimiter3_margin',
			'header_topbar_sign_in'	=> 'signin-register-top',
			'header_topbar_sign_in_text' => 'signin-register-text-top',
		)			
	);
	$topbar_values = Consultxp_Wp_Elements::consultxp_get_meta_and_option_values( $keys );
	$topbar_items = $topbar_values['header_topbar_items'];

	if( !empty( $topbar_items ) ):
		if( isset( $topbar_items['disabled'] ) ) unset( $topbar_items['disabled'] );
		
		$layout = $header_values['header_layout'];
		$container_class = $layout == 'wider' ? 'container-fluid' : 'container';
		?>
		<div class="header-topbar navbar elements-<?php echo esc_attr( count( $topbar_items ) ); ?>">
			<?php
				/*
				* Consultxp Topbar Before Action 
				*/
				do_action( 'consultxp_topbar_before' );
			?>
			<div class="<?php echo esc_attr( $container_class ); ?>">
				<?php 
					foreach( $topbar_items as $key => $value ){
						$topbar_class = $class_array[$key];
						$topbar_class .= isset( $topbar_items['right'] ) && !empty( $topbar_items['right'] ) ? ' right-element-exist' : '';
						echo '<ul class="nav topbar-ul'. esc_attr( $topbar_class ) .'">';
							foreach( $value as $element => $label ){
								switch( $element ){
									case "custom-text-1":
										if( $topbar_values['header_topbar_text_1'] != '' ) {
											echo '<li>'. do_shortcode( stripslashes( force_balance_tags( wp_kses_post( $topbar_values['header_topbar_text_1'] ) ) ) ) .'</li>';
										} else {
											echo '<li>'. do_shortcode( stripslashes( force_balance_tags( wp_kses_post( get_option( 'consultxp_options' )['topbar-custom-text-1'] ) ) ) ) .'</li>';
										}
									break;
									case "custom-text-2":
										if( $topbar_values['header_topbar_text_2'] != '' ) {
											echo '<li>'. do_shortcode( stripslashes( force_balance_tags( wp_kses_post( $topbar_values['header_topbar_text_2'] ) ) ) ) .'</li>';
										} else {
											echo '<li>'. do_shortcode( stripslashes( force_balance_tags( wp_kses_post( get_option( 'consultxp_options' )['topbar-custom-text-2'] ) ) ) ) .'</li>';
										}
									break;
									case "social":
										if( class_exists( 'Consultxp_Custom_Functions' ) ):
											echo '<li>';
												Consultxp_Custom_Functions::consultxp_social_links();
											echo '</li>';
										endif;
									break;
									case "top-menu":
										echo '<li>';
										wp_nav_menu(
											array(
												'theme_location' => 'top-menu',
												'menu' => 'top-menu',
												'menu_class' => 'nav top-menu',
												'container'      => false,
												'fallback_cb'    => false,
											)
										);
										echo '</li>';
									break;
									case "search":
										echo '<li>';
											Consultxp_Wp_Framework::consultxp_search_modal( Consultxp_Wp_Elements::consultxp_options('search-type'), 'topbar' );
										echo '</li>';
									break;
									case "topbar-html-1":
										if ( $topbar_values['header_topbar_html_1'] != '' ) {
											echo '<li>' . do_shortcode( stripslashes ( force_balance_tags( wp_kses_post ( $topbar_values['header_topbar_html_1'] ) ) ) ) . '</li>';
										} else {
											echo '<li>' . do_shortcode( stripslashes ( force_balance_tags( wp_kses_post ( get_option( 'consultxp_options' )['topbar_html_1'] ) ) ) ) . '</li>';
										}
									break;
									case "topbar-html-2":
										if ( $topbar_values['header_topbar_html_1'] != '' ) {
											echo '<li>' . do_shortcode( stripslashes ( force_balance_tags( wp_kses_post ( $topbar_values['header_topbar_html_2'] ) ) ) ) . '</li>';
										} else {
											echo '<li>' . do_shortcode( stripslashes ( force_balance_tags( wp_kses_post ( get_option( 'consultxp_options' )['topbar_html_2'] ) ) ) ) . '</li>';
										}
									break;
									case "topbar-html-3":
										if ( $topbar_values['header_topbar_html_1'] != '' ) {
											echo '<li>' . do_shortcode( stripslashes ( force_balance_tags( wp_kses_post ( $topbar_values['header_topbar_html_3'] ) ) ) ) . '</li>';
										} else {
											echo '<li>' . do_shortcode( stripslashes ( force_balance_tags( wp_kses_post ( get_option( 'consultxp_options' )['topbar_html_3'] ) ) ) ) . '</li>';
										}
									break;
									case "topbar-html-4":
										if ( $topbar_values['header_topbar_html_1'] != '' ) {
											echo '<li>' . do_shortcode( stripslashes ( force_balance_tags( wp_kses_post ( $topbar_values['header_topbar_html_4'] ) ) ) ) . '</li>';
										} else {
											echo '<li>' . do_shortcode( stripslashes ( force_balance_tags( wp_kses_post ( get_option( 'consultxp_options' )['topbar_html_4'] ) ) ) ) . '</li>';
										}
									break;
									case "topbar-html-5":
										if ( $topbar_values['header_topbar_html_1'] != '' ) {
											echo '<li>' . do_shortcode( stripslashes ( force_balance_tags( wp_kses_post ( $topbar_values['header_topbar_html_5'] ) ) ) ) . '</li>';
										} else {
											echo '<li>' . do_shortcode( stripslashes ( force_balance_tags( wp_kses_post ( get_option( 'consultxp_options' )['topbar_html_5'] ) ) ) ) . '</li>';
										}
									break;
									case "topbar-spacer-1":
										$spacer1_width = get_option('consultxp_options')['topbar_spacer_1_width']['width'];
										if ( $topbar_values['header_topbar_spacer_1']['width'] != '' ) {
											$spacer1_width = $topbar_values['header_topbar_spacer_1']['width'];
										}
										echo '<li><div class="header_spacer" style="width: '.$spacer1_width.'px;"></div></li>';
									break;
									case "topbar-spacer-2":
										$spacer2_width = get_option('consultxp_options')['topbar_spacer_2_width']['width'];
										if ( $topbar_values['header_topbar_spacer_2']['width'] != '' ) {
											$spacer2_width = $topbar_values['header_topbar_spacer_2']['width'];
										}
										echo '<li><div class="header_spacer" style="width: '.$spacer2_width.'px;"></div></li>';
									break;
									case "topbar-spacer-3":
										$spacer3_width = get_option('consultxp_options')['topbar_spacer_3_width']['width'];
										if ( $topbar_values['header_topbar_spacer_3']['width'] != '' ) {
											$spacer3_width = $topbar_values['header_topbar_spacer_3']['width'];
										}
										echo '<li><div class="header_spacer" style="width: '.$spacer3_width.'px;"></div></li>';
									break;
									case "topbar_delimiter1":
										$delimiter1_width = $topbar_values['header_topbar_delimit_1_width']['width'] ?? get_option('consultxp_options')['topbar_delimiter1_width']['width'];
										$delimiter1_height = $topbar_values['header_topbar_delimit_1_height']['height'] ?? get_option('consultxp_options')['topbar_delimiter1_height']['height'];
										$delimiter1_color = $topbar_values['header_topbar_delimit_1_color'] ?? get_option('consultxp_options')['topbar_delimiter1_color'];
										$delimiter1_margin_top = $topbar_values['header_topbar_delimit_1_margin']['top'] ?? get_option('consultxp_options')['topbar_delimiter1_margin']['top'];
										$delimiter1_margin_right = $topbar_values['header_topbar_delimit_1_margin']['right'] ?? get_option('consultxp_options')['topbar_delimiter1_margin']['right'];
										$delimiter1_margin_left = $topbar_values['header_topbar_delimit_1_margin']['left'] ?? get_option('consultxp_options')['topbar_delimiter1_margin']['left'];
										$delimiter1_margin_bottom = $topbar_values['header_topbar_delimit_1_margin']['bottom'] ?? get_option('consultxp_options')['topbar_delimiter1_margin']['bottom'];
										echo '<li><div class="delimiter" style="margin: '.$delimiter1_margin_top.'px '.$delimiter1_margin_right.'px '.$delimiter1_margin_bottom.'px '.$delimiter1_margin_left.'px; background-color:'.$delimiter1_color.';width: '.$delimiter1_width.'px;height: '.$delimiter1_height.'px "></div></li>';
									break;
									case "topbar_delimiter2":
										$delimiter2_width = $topbar_values['header_topbar_delimit_2_width']['width'] ?? get_option('consultxp_options')['topbar_delimiter2_width']['width'];
										$delimiter2_height = $topbar_values['header_topbar_delimit_2_height']['height'] ?? get_option('consultxp_options')['topbar_delimiter2_height']['height'];
										$delimiter2_color = $topbar_values['header_topbar_delimit_2_color'] ?? get_option('consultxp_options')['topbar_delimiter2_color'];
										$delimiter2_margin_top = $topbar_values['header_topbar_delimit_2_margin']['top'] ?? get_option('consultxp_options')['topbar_delimiter2_margin']['top'];
										$delimiter2_margin_right = $topbar_values['header_topbar_delimit_2_margin']['right'] ?? get_option('consultxp_options')['topbar_delimiter2_margin']['right'];
										$delimiter2_margin_left = $topbar_values['header_topbar_delimit_2_margin']['left'] ?? get_option('consultxp_options')['topbar_delimiter2_margin']['left'];
										$delimiter2_margin_bottom = $topbar_values['header_topbar_delimit_2_margin']['bottom'] ?? get_option('consultxp_options')['topbar_delimiter2_margin']['bottom'];
										echo '<li><div class="delimiter" style="margin: '.$delimiter2_margin_top.'px '.$delimiter2_margin_right.'px '.$delimiter2_margin_bottom.'px '.$delimiter2_margin_left.'px; background-color:'.$delimiter2_color.';width: '.$delimiter2_width.'px;height: '.$delimiter2_height.'px "></div></li>';
									break;
									case "topbar_delimiter3":
										$delimiter3_width = $topbar_values['header_topbar_delimit_3_width']['width'] ?? get_option('consultxp_options')['topbar_delimiter3_width']['width'];
										$delimiter3_height = $topbar_values['header_topbar_delimit_3_height']['height'] ?? get_option('consultxp_options')['topbar_delimiter3_height']['height'];
										$delimiter3_color = $topbar_values['header_topbar_delimit_3_color'] ?? get_option('consultxp_options')['topbar_delimiter3_color'];
										$delimiter3_margin_top = $topbar_values['header_topbar_delimit_3_margin']['top'] ?? get_option('consultxp_options')['topbar_delimiter3_margin']['top'];
										$delimiter3_margin_right = $topbar_values['header_topbar_delimit_3_margin']['right'] ?? get_option('consultxp_options')['topbar_delimiter3_margin']['right'];
										$delimiter3_margin_left = $topbar_values['header_topbar_delimit_3_margin']['left'] ?? get_option('consultxp_options')['topbar_delimiter3_margin']['left'];
										$delimiter3_margin_bottom = $topbar_values['header_topbar_delimit_3_margin']['bottom'] ?? get_option('consultxp_options')['topbar_delimiter3_margin']['bottom'];
										echo '<li><div class="delimiter" style="margin: '.$delimiter3_margin_top.'px '.$delimiter3_margin_right.'px '.$delimiter3_margin_bottom.'px '.$delimiter3_margin_left.'px; background-color:'.$delimiter3_color.';width: '.$delimiter3_width.'px;height: '.$delimiter3_height.'px "></div></li>';
									break;
									case "signin":
										$shortcode = stripslashes(force_balance_tags(wp_kses_post(get_option('consultxp_options')['signin-register-top'])));
										if ( isset( $topbar_values['header_topbar_sign_in'] ) && $topbar_values['header_topbar_sign_in'] != '' ) {
											$shortcode = stripslashes(force_balance_tags(wp_kses_post($topbar_values['header_topbar_sign_in'])));
										}
										$login_button_text = get_option('consultxp_options')['signin-register-text-top'];
										if ( $topbar_values['header_topbar_sign_in_text'] != '' ) {
											$login_button_text = $topbar_values['header_topbar_sign_in_text'];
										}
										if (empty($shortcode)) {
											$shortcode = wp_login_form([
												'echo'           => false,
												'redirect'       => home_url(),
												'form_id'        => 'loginform',
												'label_username' => __('Username or Email', 'consultxp'),
												'label_password' => __('Password', 'consultxp'),
												'label_remember' => __('Remember Me', 'consultxp'),
												'label_log_in'   => __('Log In', 'consultxp'),
												'remember'       => true
											]);
										} else {
											$shortcode = do_shortcode($shortcode);
										}
									
										echo '<li>';
										echo '<button class="btn btn-primary login-button" data-shortcode="' . esc_attr($shortcode) . '">' . esc_attr__( $login_button_text, 'consultxp') . '</button>
										</li>';

										add_action( 'consultxp_footer_after', function() use ($shortcode) {
											?>
											<div id="login-popup" class="login-popup" style="display: none;">
												<div class="popup-content">
													<button class="close-popup">×</button>
													<?php echo $shortcode; ?>
												</div>
											</div>
											<?php
										});
									break;
									case "wpml_polylang":
										if ( defined( 'ICL_SITEPRESS_VERSION' ) ) {
											$current_language = apply_filters( 'wpml_current_language', NULL );
											echo '<li>'; 
												do_action('wpml_add_language_selector');
											echo '</li>'; 
										} else if ( function_exists( 'pll_the_languages' ) ) {
											echo '<li>';
											pll_the_languages( array( 'dropdown' => 0 ) );
											echo '</li>';
										}
									break;
									// Woocommerce cart icon Option
									case "woocommerce-cart":
										$options = get_option('consultxp_options');
										$icon_class = !empty( $options['navbar-cart-icon-class'] ) ? $options['navbar-cart-icon-class'] : 'fa fa-shopping-cart';
										$trigger_type = !empty( $options['navbar-cart-trigger'] ) ? $options['navbar-cart-trigger'] : 'click';
										$trigger_class = $trigger_type === 'hover' ? 'hover-cart' : 'click-cart';
										
										if ( class_exists('WooCommerce') ) {
											echo '<li class="woocommerce-cart-item ' . esc_attr( $trigger_class ) . '">';
											echo '<a href="javascript:void(0);" class="cart-trigger">';
												echo '<i class="' . esc_attr( $icon_class ) . '"></i>';
												echo '<span class="cart-count">' . esc_html( WC()->cart->get_cart_contents_count() ) . '</span>';
											echo '</a>';
											echo '<div class="mini-cart-dropdown">';
												the_widget( 'WC_Widget_Cart', 'title=' );
											echo '</div>';
											echo '</li>';
										}
									break;
								}
							}
						echo '</ul>';
					}
				?>
			</div><!-- .container -->
			<?php
				/*
					* Consultxp Topbar After Action 
					* 10 - consultxp_fullbar_search_form
					*/
				do_action( 'consultxp_topbar_after' );
			?>
		</div><!-- .header-topbar -->
<?php endif; ?>