<?php
	$class_array = array(
		'left'		=> ' element-left',
		'center'	=> ' pull-center justify-content-center',
		'right'		=> ' pull-right justify-content-end'
	);
	$mkeys = array(
		'chk' => 'header-mobile-chk',
		'fields' => array(
			'mobile_header_items' => 'mobilebar-items',
			'mobile_header_text_1' => 'mobile-menu-custom-text-1',
			'mobile_header_text_2' => 'mobile-menu-custom-text-2',
			'mobile_header_spacer_1' => 'mobilebar_spacer_1',
			'mobile_header_spacer_2' => 'mobilebar_spacer_2',
			'mobile_header_spacer_3' => 'mobilebar_spacer_3',
			'mobile_header_html_1' => 'mobilebar-html-1',
			'mobile_header_html_2' => 'mobilebar-html-2',
			'mobile_header_html_3' => 'mobilebar-html-3',
			'mobile_header_delimit_1_width' => 'mobilebar_delimiter1_width',
			'mobile_header_delimit_1_height' => 'mobilebar_delimiter1_height',
			'mobile_header_delimit_1_color' => 'mobilebar_delimiter1_color',
			'mobile_header_delimit_1_margin' => 'mobilebar_delimiter1_margin',
			'mobile_header_delimit_2_width' => 'mobilebar_delimiter2_width',
			'mobile_header_delimit_2_height' => 'mobilebar_delimiter2_height',
			'mobile_header_delimit_2_color' => 'mobilebar_delimiter2_color',
			'mobile_header_delimit_2_margin' => 'mobilebar_delimiter2_margin',
			'mobile_header_delimit_3_width' => 'mobilebar_delimiter3_width',
			'mobile_header_delimit_3_height' => 'mobilebar_delimiter3_height',
			'mobile_header_delimit_3_color' => 'mobilebar_delimiter3_color',
			'mobile_header_delimit_3_margin' => 'mobilebar_delimiter3_margin',
			
		)			
	);
	$skeys = array(
		'chk' => 'mobile-style-chk',
		'fields' => array(
			'mobile_header_sticky'	=> 'mobilebar-sticky',
		)
	);
	$mobilebar_styles = Consultxp_Wp_Elements::consultxp_get_meta_and_option_values( $skeys );
	$mobilebar_values = Consultxp_Wp_Elements::consultxp_get_meta_and_option_values( $mkeys );
	$mobilebar_items = $mobilebar_values['mobile_header_items'];
	if( !empty( $mobilebar_items ) ):
	
		if( isset( $mobilebar_items['disabled'] ) ) unset( $mobilebar_items['disabled'] );

		$sticky_opt = Consultxp_Wp_Elements::consultxp_options('mobilebar-sticky');
		if ( isset( $mobilebar_styles['mobile_header_sticky'] ) && $mobilebar_styles['mobile_header_sticky'] != '' ) {
			$sticky_opt = $mobilebar_styles['mobile_header_sticky'];
		}
		if( $sticky_opt != 'off' ): ?>
		<div class="sticky-outer" data-stickyup="<?php echo esc_attr( $sticky_opt == 'on_scrollup' ? "1" : "0" ); ?>"><div class="sticky-head">
		<?php endif; ?>
		<div class="header-mobilebar navbar">
			<div class="container">
				<?php 
					foreach( $mobilebar_items as $key => $value ){
						$mobilebar_class = $class_array[$key];
						$mobilebar_class .= isset( $mobilebar_items['right'] ) && !empty( $mobilebar_items['right'] ) ? ' right-element-exist' : '';
						
						echo '<ul class="nav mobilebar'. esc_attr( $mobilebar_class ) .'">'; 
						foreach( $value as $element => $label ){
							switch($element){
								case "logo": ?>
									<li class="header-titles-wrapper">
										<div class="header-titles">
											<?php
												// Site title or logo.
												Consultxp_Wp_Framework::consultxp_mobile_logo();
											?>
										</div><!-- .header-titles -->
									</li><!-- .header-titles-wrapper -->
								<?php
								break;
								case "menu-toggle": ?>
									<li class="header-mobile-toggle-wrapper">
										<a href="<?php echo esc_url( home_url() ); ?>" class="mobile-menu-toggle"><i class="bi bi-list"></i></a>
										<?php add_action( 'consultxp_footer_after', function(){ get_template_part( 'template-parts/mobile', 'menu' ); }, 20 ); ?>
									</li><!-- .header-navigation-wrapper -->
								<?php
								break;
								case "search": ?>
									<li class="header-search-wrapper">
										<?php Consultxp_Wp_Framework::consultxp_search_modal( '1', 'mobile_bar' ); ?>
									</li>
								<?php
								break;
								case "mobile-menu-custom-text-1":
									if ( isset( $mobilebar_values['mobile_header_text_1'] ) && $mobilebar_values['mobile_header_text_1'] != '' ) {
										echo '<li class="mobile-cutom-text-1">' . do_shortcode( stripslashes( force_balance_tags( wp_kses_post( $mobilebar_values['mobile_header_text_1'] ) ) ) ) . '</li>';
									} else {
										echo '<li class="mobile-cutom-text-1">' . do_shortcode( stripslashes( force_balance_tags( wp_kses_post( get_option( 'consultxp_options' )['mobile-menu-custom-text-1'] ) ) ) ) . '</li>';
									}
								break;
								case "mobile-menu-custom-text-2": 
									if ( isset( $mobilebar_values['mobile_header_text_2'] ) && $mobilebar_values['mobile_header_text_2'] != '' ) {
										echo '<li class="mobile-cutom-text-2">' . do_shortcode( stripslashes( force_balance_tags( wp_kses_post( $mobilebar_values['mobile_header_text_2'] ) ) ) ) . '</li>';
									} else {
										echo '<li class="mobile-cutom-text-2">' . do_shortcode( stripslashes( force_balance_tags( wp_kses_post( get_option( 'consultxp_options' )['mobile-menu-custom-text-2'] ) ) ) ) . '</li>';
									}
								break;
								case "mobilebar-spacer-1":
									$spacer1_width = get_option('consultxp_options')['mobilebar_spacer_1']['width'];
									if ( isset( $mobilebar_values['mobile_header_spacer_1'] ) && $mobilebar_values['mobile_header_spacer_1'] != '' ) {
										$spacer1_width = $mobilebar_values['mobile_header_spacer_1']['width'];
									}
									echo '<li><div class="mobile_header_spacer" style="width: '.$spacer1_width.'px;"></div></li>';
								break;
								case "mobilebar-spacer-2":
									$spacer2_width = get_option('consultxp_options')['mobilebar_spacer_2']['width'];
									if ( isset( $mobilebar_values['mobile_header_spacer_2'] ) && $mobilebar_values['mobile_header_spacer_2'] != '' ) {
										$spacer2_width = $mobilebar_values['mobile_header_spacer_2']['width'];
									}
									echo '<li><div class="mobile_header_spacer2" style="width: '.$spacer2_width.'px;"></div></li>';
								break;
								case "mobilebar-spacer-3":
									$spacer3_width = get_option('consultxp_options')['mobilebar_spacer_3']['width'];
									if ( isset( $mobilebar_values['mobile_header_spacer_3'] ) && $mobilebar_values['mobile_header_spacer_3'] != '' ) {
										$spacer3_width = $mobilebar_values['mobile_header_spacer_3']['width'];
									}
									echo '<li><div class="mobile_header_spacer3" style="width: '.$spacer3_width.'px;"></div></li>';
								break;
								case "mobilebar-html-1":
									if ( isset( $mobilebar_values['mobile_header_html_1'] ) && $mobilebar_values['mobile_header_html_1'] != '' ) {
										echo '<li>' . do_shortcode( stripslashes( force_balance_tags( wp_kses_post( $mobilebar_values['mobile_header_html_1'] ) ) ) ) . '</li>';
									} else {
										echo '<li>' . do_shortcode( stripslashes( force_balance_tags( wp_kses_post( get_option( 'consultxp_options' )['mobilebar-html-1'] ) ) ) ) . '</li>';
									}
								break;
								case "mobilebar-html-2":
									if ( isset( $mobilebar_values['mobile_header_html_2'] ) && $mobilebar_values['mobile_header_html_2'] != '' ) {
										echo '<li>' . do_shortcode( stripslashes( force_balance_tags( wp_kses_post( $mobilebar_values['mobile_header_html_2'] ) ) ) ) . '</li>';
									} else {
										echo '<li>' . do_shortcode( stripslashes( force_balance_tags( wp_kses_post( get_option( 'consultxp_options' )['mobilebar-html-2'] ) ) ) ) . '</li>';
									}
								break;
								case "mobilebar-html-3":
									if ( isset( $mobilebar_values['mobile_header_html_3'] ) && $mobilebar_values['mobile_header_html_3'] != '' ) {
										echo '<li>' . do_shortcode( stripslashes( force_balance_tags( wp_kses_post( $mobilebar_values['mobile_header_html_3'] ) ) ) ) . '</li>';
									} else {
										echo '<li>' . do_shortcode( stripslashes( force_balance_tags( wp_kses_post( get_option( 'consultxp_options' )['mobilebar-html-3'] ) ) ) ) . '</li>';
									}
								break;
								case "mobilebar_delimiter1":
									$delimiter1_width = $mobilebar_values['mobile_header_delimit_1_width']['width'] ?? get_option('consultxp_options')['mobilebar_delimiter1_width']['width'];
									$delimiter1_height = $mobilebar_values['mobile_header_delimit_1_height']['height'] ?? get_option('consultxp_options')['mobilebar_delimiter1_height']['height'];
									$delimiter1_color = $mobilebar_values['mobile_header_delimit_1_color'] ?? get_option('consultxp_options')['mobilebar_delimiter1_color'];
									$delimiter1_margin_top = $mobilebar_values['mobile_header_delimit_1_margin']['top'] ?? get_option('consultxp_options')['mobilebar_delimiter1_margin']['top'];
									$delimiter1_margin_right = $mobilebar_values['mobile_header_delimit_1_margin']['right'] ?? get_option('consultxp_options')['mobilebar_delimiter1_margin']['right'];
									$delimiter1_margin_left = $mobilebar_values['mobile_header_delimit_1_margin']['left'] ?? get_option('consultxp_options')['mobilebar_delimiter1_margin']['left'];
									$delimiter1_margin_bottom = $mobilebar_values['mobile_header_delimit_1_margin']['bottom'] ?? get_option('consultxp_options')['mobilebar_delimiter1_margin']['bottom'];
									echo '<li><div class="delimiter" style="margin: '.$delimiter1_margin_top.'px '.$delimiter1_margin_right.'px '.$delimiter1_margin_bottom.'px '.$delimiter1_margin_left.'px; background-color:'.$delimiter1_color.';width: '.$delimiter1_width.'px;height: '.$delimiter1_height.'px "></div></li>';
								break;
								case "mobilebar_delimiter2":
									$delimiter2_width = $mobilebar_values['mobile_header_delimit_2_width']['width'] ?? get_option('consultxp_options')['mobilebar_delimiter2_width']['width'];
									$delimiter2_height = $mobilebar_values['mobile_header_delimit_2_height']['height'] ?? get_option('consultxp_options')['mobilebar_delimiter2_height']['height'];
									$delimiter2_color = $mobilebar_values['mobile_header_delimit_2_color'] ?? get_option('consultxp_options')['mobilebar_delimiter2_color'];
									$delimiter2_margin_top = $mobilebar_values['mobile_header_delimit_2_margin']['top'] ?? get_option('consultxp_options')['mobilebar_delimiter2_margin']['top'];
									$delimiter2_margin_right = $mobilebar_values['mobile_header_delimit_2_margin']['right'] ?? get_option('consultxp_options')['mobilebar_delimiter2_margin']['right'];
									$delimiter2_margin_left = $mobilebar_values['mobile_header_delimit_2_margin']['left'] ?? get_option('consultxp_options')['mobilebar_delimiter2_margin']['left'];
									$delimiter2_margin_bottom = $mobilebar_values['mobile_header_delimit_2_margin']['bottom'] ?? get_option('consultxp_options')['mobilebar_delimiter2_margin']['bottom'];
									echo '<li><div class="delimiter" style="margin: '.$delimiter2_margin_top.'px '.$delimiter2_margin_right.'px '.$delimiter2_margin_bottom.'px '.$delimiter2_margin_left.'px; background-color:'.$delimiter2_color.';width: '.$delimiter2_width.'px;height: '.$delimiter2_height.'px "></div></li>';
								break;
								case "mobilebar_delimiter3":
									$delimiter3_width = $mobilebar_values['mobile_header_delimit_3_width']['width'] ?? get_option('consultxp_options')['mobilebar_delimiter3_width']['width'];
									$delimiter3_height = $mobilebar_values['mobile_header_delimit_3_height']['height'] ?? get_option('consultxp_options')['mobilebar_delimiter3_height']['height'];
									$delimiter3_color = $mobilebar_values['mobile_header_delimit_3_color'] ?? get_option('consultxp_options')['mobilebar_delimiter3_color'];
									$delimiter3_margin_top = $mobilebar_values['mobile_header_delimit_3_margin']['top'] ?? get_option('consultxp_options')['mobilebar_delimiter3_margin']['top'];
									$delimiter3_margin_right = $mobilebar_values['mobile_header_delimit_3_margin']['right'] ?? get_option('consultxp_options')['mobilebar_delimiter3_margin']['right'];
									$delimiter3_margin_left = $mobilebar_values['mobile_header_delimit_3_margin']['left'] ?? get_option('consultxp_options')['mobilebar_delimiter3_margin']['left'];
									$delimiter3_margin_bottom = $mobilebar_values['mobile_header_delimit_3_margin']['bottom'] ?? get_option('consultxp_options')['mobilebar_delimiter3_margin']['bottom'];
									echo '<li><div class="delimiter" style="margin: '.$delimiter3_margin_top.'px '.$delimiter3_margin_right.'px '.$delimiter3_margin_bottom.'px '.$delimiter3_margin_left.'px; background-color:'.$delimiter3_color.';width: '.$delimiter3_width.'px;height: '.$delimiter3_height.'px "></div></li>';
								break;
								case "wpml_polylang":
									if ( defined( 'ICL_SITEPRESS_VERSION' ) ) {
										$current_language = apply_filters( 'wpml_current_language', NULL );
										echo '<li>';
										echo sprintf( __('Current Language: %s', 'consultxp'), esc_html($current_language) );
										echo '</li>';
										do_action('wpml_add_language_selector');
									} else if ( function_exists( 'pll_the_languages' ) ) {
										echo '<li>';
										pll_the_languages( array( 'dropdown' => 0 ) );
										echo '</li>';
									}
								break;
								case "mobile-icon-email":
									$current_user = wp_get_current_user();
									$user_email   = $current_user->user_email;
									echo '<li>';
									if ( $user_email != '' ) {
										echo '<i class="bi bi-envelope-fill theme-color mr-2"></i><a href="mailto:'. $user_email .'">' . $user_email . '</a>';
									}
									echo '</li>';
								break;
							}
						}
						echo '</ul>';
					}?>
			</div><!-- .container -->
		</div><!-- .header-mobilebar --> <?php 
	if( $sticky_opt != 'off' ): ?>
	</div> <!-- .sticky-head --></div> <!-- .sticky-outer -->
	<?php endif; ?>	
<?php endif; ?>
