<?php
/*
 * Mobile Menu Template
 */
?>
<div class="mobile-menu-floating">
	<a href="<?php echo esc_url( home_url() ); ?>" class="mobile-menu-toggle"><i class="close-icon"></i></a>

	<?php
	do_action( 'consultxp_mobile_menu_before' );
	$mkeys = array(
		'chk' => 'mobile-bar-chk',
		'fields' => array(
			'mobilebar_menu_items' => 'mobilebar-menu-items',
			'mobile_menu_custom_text_1' => 'mobilebar-menu-custom-text-1',
			'mobile_menu_custom_text_2' => 'mobilebar-menu-custom-text-2',
			'mobile_menu_spacer_1' => 'mobile-spacer-1',
			'mobile_menu_spacer_2' => 'mobile-spacer-2',
			'mobile_menu_spacer_3' => 'mobile-spacer-3',
			'mobile_menu_delimiter_1_width' => 'mobile-delimiter-1-width',
			'mobile_menu_delimiter_1_height' => 'mobile-delimiter-1-height',
			'mobile_menu_delimiter_1_color' => 'mobile-delimiter-1-color',
			'mobile_menu_delimiter_1_margin' => 'mobile-delimiter-1-margin',
			'mobile_menu_delimiter_2_width' => 'mobile-delimiter-2-width',
			'mobile_menu_delimiter_2_height' => 'mobile-delimiter-2-height',
			'mobile_menu_delimiter_2_color' => 'mobile-delimiter-2-color',
			'mobile_menu_delimiter_2_margin' => 'mobile-delimiter-2-margin',
			'mobile_menu_delimiter_3_width' => 'mobile-delimiter-3-width',
			'mobile_menu_delimiter_3_height' => 'mobile-delimiter-3-height',
			'mobile_menu_delimiter_3_color' => 'mobile-delimiter-3-color',
			'mobile_menu_delimiter_3_margin' => 'mobile-delimiter-3-margin',
		)			
	);
	
	$mobile_menu_bar_values = Consultxp_Wp_Elements::consultxp_get_meta_and_option_values( $mkeys );
	$mobilebar_items = $mobile_menu_bar_values['mobilebar_menu_items'];
	if( !empty( $mobilebar_items ) && is_array( $mobilebar_items ) ):	
		
		foreach( $mobilebar_items['enabled'] as $element => $value ){
			switch($element){ 
				case "logo": ?>
				<div class="header-titles">
					<?php
						// Site title or logo.
						Consultxp_Wp_Framework::consultxp_mobile_logo( array(), 'div' );
					?>
				</div><!-- .header-titles --> <?php
				break;
				case "menu":
					$menu_name = '';
					$page_option = get_post_meta(get_the_ID(), 'consultxp_post_meta', true);
					if (isset($page_option['header-one-page-menu']) && $page_option['header-one-page-menu'] != 'none') {
						$menu_name = $page_option['header-one-page-menu'];
					}
					if (has_nav_menu('mobile') || !empty($menu_name)) { ?>
						<nav class="mobile-menu-wrapper">
							<ul class="wp-menu mobile-menu">
								<?php
									wp_nav_menu(array(
										'container'      => false,
										'items_wrap'     => '%3$s',
										'theme_location' => 'mobile', // Always include theme_location
										'menu'           => !empty($menu_name) ? $menu_name : '',
										'fallback_cb'    => false,
									));
								?>
							</ul>
						</nav><!-- .mobile-menu-wrapper -->
					<?php }
					break;
				case "search":
					echo get_search_form();
					break;
				

				case "social": 
					if( class_exists( 'Consultxp_Custom_Functions' ) ):
				?>
					<div class="mobile-menu-social-wrap">
						<?php
							Consultxp_Custom_Functions::consultxp_social_links();
						?>
					</div>
				<?php
					endif;
				break;
				case "mobilebar-menu-custom-text-1":					
					if( isset( $mobile_menu_bar_values['mobile_menu_custom_text_1'] ) && $mobile_menu_bar_values['mobile_menu_custom_text_1'] != '' ) {
						echo '<div class="custom-text-1">'. do_shortcode( stripslashes( force_balance_tags( wp_kses_post( $mobile_menu_bar_values['mobile_menu_custom_text_1'] ) ) ) ) .'</div>';
					} else {
						echo '<div class="custom-text-1">'. do_shortcode( stripslashes( force_balance_tags( wp_kses_post( get_option( 'consultxp_options' )['mobilebar-menu-custom-text-1'] ) ) ) ) .'</div>';
					}
				break;
				case "mobilebar-menu-custom-text-2":
					if( isset( $mobile_menu_bar_values['mobile_menu_custom_text_2'] ) && $mobile_menu_bar_values['mobile_menu_custom_text_2'] != '' ) {
						echo '<div class="custom-text-1">'. do_shortcode( stripslashes( force_balance_tags( wp_kses_post( $mobile_menu_bar_values['mobile_menu_custom_text_2'] ) ) ) ) .'</div>';
					} else {
						echo '<div class="custom-text-1">'. do_shortcode( stripslashes( force_balance_tags( wp_kses_post( get_option( 'consultxp_options' )['mobilebar-menu-custom-text-2'] ) ) ) ) .'</div>';
					}
				break;
				case "spacer-mobile-1":
					$spacer1_width = get_option('consultxp_options')['mobile-spacer-1']['width'];
					if ( isset( $mobile_menu_bar_values['mobile_menu_spacer_1'] ) && $mobile_menu_bar_values['mobile_menu_spacer_1'] != '' ) {
						$spacer1_width = $mobile_menu_bar_values['mobile_menu_spacer_1']['width'];
					}
					echo '<div class="mobilemenu_header_spacer" style="height: '.$spacer1_width.'px;"></div>';
				break;
				case "spacer-mobile-2":
					$spacer2_width = get_option('consultxp_options')['mobile-spacer-2']['width'];
					if ( isset( $mobile_menu_bar_values['mobile_menu_spacer_2'] ) && $mobile_menu_bar_values['mobile_menu_spacer_2'] != '' ) {
						$spacer2_width = $mobile_menu_bar_values['mobile_menu_spacer_2']['width'];
					}
					echo '<div class="mobilemenu_header_spacer2" style="height: '.$spacer2_width.'px;"></div>';
				break;
				case "spacer-mobile-3":
					$spacer3_width = get_option('consultxp_options')['mobile-spacer-3']['width'];
					if ( isset( $mobile_menu_bar_values['mobile_menu_spacer_3'] ) && $mobile_menu_bar_values['mobile_menu_spacer_3'] != '' ) {
						$spacer3_width = $mobile_menu_bar_values['mobile_menu_spacer_3']['width'];
					}
					echo '<div class="mobilemenu_header_spacer3" style="height: '.$spacer3_width.'px;"></div>';
				break;
				case "delimiter-mobile-1":
					$delimiter1_width = $mobile_menu_bar_values['mobile_menu_delimiter_1_width']['width'] ?? get_option('consultxp_options')['mobile-delimiter-1-width']['width'];
					$delimiter1_height = $mobile_menu_bar_values['mobile_menu_delimiter_1_height']['height'] ?? get_option('consultxp_options')['mobile-delimiter-1-height']['height'];
					$delimiter1_color = $mobile_menu_bar_values['mobile_menu_delimiter_1_color'] ?? get_option('consultxp_options')['mobile-delimiter-1-color'];
					$delimiter1_margin_top = $mobile_menu_bar_values['mobile_menu_delimiter_1_margin']['top'] ?? get_option('consultxp_options')['mobile-delimiter-1-margin']['top'];
					$delimiter1_margin_right = $mobile_menu_bar_values['mobile_menu_delimiter_1_margin']['right'] ?? get_option('consultxp_options')['mobile-delimiter-1-margin']['right'];
					$delimiter1_margin_left = $mobile_menu_bar_values['mobile_menu_delimiter_1_margin']['left'] ?? get_option('consultxp_options')['mobile-delimiter-1-margin']['left'];
					$delimiter1_margin_bottom = $mobile_menu_bar_values['mobile_menu_delimiter_1_margin']['bottom'] ?? get_option('consultxp_options')['mobile-delimiter-1-margin']['bottom'];
					echo '<div class="delimiter" style="margin: '.$delimiter1_margin_top.'px '.$delimiter1_margin_right.'px '.$delimiter1_margin_bottom.'px '.$delimiter1_margin_left.'px; background-color:'.$delimiter1_color.';width: '.$delimiter1_width.'px;height: '.$delimiter1_height.'px "></div>';
				break;
				case "delimiter-mobile-2":
					$delimiter2_width = $mobile_menu_bar_values['mobile_menu_delimiter_2_width']['width'] ?? get_option('consultxp_options')['mobile-delimiter-2-width']['width'];
					$delimiter2_height = $mobile_menu_bar_values['mobile_menu_delimiter_2_height']['height'] ?? get_option('consultxp_options')['mobile-delimiter-2-height']['height'];
					$delimiter2_color = $mobile_menu_bar_values['mobile_menu_delimiter_2_color'] ?? get_option('consultxp_options')['mobile-delimiter-2-color'];
					$delimiter2_margin_top = $mobile_menu_bar_values['mobile_menu_delimiter_2_margin']['top'] ?? get_option('consultxp_options')['mobile-delimiter-2-margin']['top'];
					$delimiter2_margin_right = $mobile_menu_bar_values['mobile_menu_delimiter_2_margin']['right'] ?? get_option('consultxp_options')['mobile-delimiter-2-margin']['right'];
					$delimiter2_margin_left = $mobile_menu_bar_values['mobile_menu_delimiter_2_margin']['left'] ?? get_option('consultxp_options')['mobile-delimiter-2-margin']['left'];
					$delimiter2_margin_bottom = $mobile_menu_bar_values['mobile_menu_delimiter_2_margin']['bottom'] ?? get_option('consultxp_options')['mobile-delimiter-2-margin']['bottom'];
					echo '<div class="delimiter" style="margin: '.$delimiter2_margin_top.'px '.$delimiter2_margin_right.'px '.$delimiter2_margin_bottom.'px '.$delimiter2_margin_left.'px; background-color:'.$delimiter2_color.';width: '.$delimiter2_width.'px;height: '.$delimiter2_height.'px "></div>';
				break;
				case "delimiter-mobile-3":
					$delimiter3_width = $mobile_menu_bar_values['mobile_menu_delimiter_3_width']['width'] ?? get_option('consultxp_options')['mobile-delimiter-3-width']['width'];
					$delimiter3_height = $mobile_menu_bar_values['mobile_menu_delimiter_3_height']['height'] ?? get_option('consultxp_options')['mobile-delimiter-3-height']['height'];
					$delimiter3_color = $mobile_menu_bar_values['mobile_menu_delimiter_3_color'] ?? get_option('consultxp_options')['mobile-delimiter-3-color'];
					$delimiter3_margin_top = $mobile_menu_bar_values['mobile_menu_delimiter_3_margin']['top'] ?? get_option('consultxp_options')['mobile-delimiter-3-margin']['top'];
					$delimiter3_margin_right = $mobile_menu_bar_values['mobile_menu_delimiter_3_margin']['right'] ?? get_option('consultxp_options')['mobile-delimiter-3-margin']['right'];
					$delimiter3_margin_left = $mobile_menu_bar_values['mobile_menu_delimiter_3_margin']['left'] ?? get_option('consultxp_options')['mobile-delimiter-3-margin']['left'];
					$delimiter3_margin_bottom = $mobile_menu_bar_values['mobile_menu_delimiter_3_margin']['bottom'] ?? get_option('consultxp_options')['mobile-delimiter-3-margin']['bottom'];
					echo '<div class="delimiter" style="margin: '.$delimiter3_margin_top.'px '.$delimiter3_margin_right.'px '.$delimiter3_margin_bottom.'px '.$delimiter3_margin_left.'px; background-color:'.$delimiter3_color.';width: '.$delimiter3_width.'px;height: '.$delimiter3_height.'px "></div>';
				break;
				case "wpml_polylang":
					if ( defined( 'ICL_SITEPRESS_VERSION' ) ) {
						$current_language = apply_filters( 'wpml_current_language', NULL );
						echo '<li>';
						echo sprintf( __('Current Language: %s', 'consultxp'), esc_html($current_language) );
						echo '</li>';
						do_action('wpml_add_language_selector');
					} else if ( function_exists( 'pll_the_languages' ) ) {
						echo '<li>';
						pll_the_languages( array( 'dropdown' => 0 ) );
						echo '</li>';
					}
				break;
			} //switch	
		} //foreach
	endif; 	
	do_action( 'consultxp_mobile_menu_after' ); 
	?>

</div><!-- .mobile-menu-floating -->
