<?php
/**
 * Template Name: WooCommerce Page Layout
 * This template is used for all WooCommerce pages to match the page.php structure.
 */
get_header();
Consultxp_Wp_Elements::$template = apply_filters( 'consultxp_define_page_template', 'page' );
Consultxp_Wp_Elements::$consultxp_page_options = get_post_meta( get_the_ID(), 'consultxp_post_meta', true );
?>
<main id="site-content">
	<?php 
		// Page title template (uses your existing template-parts/page-title.php)
		get_template_part( 'template-parts/page', 'title' );
	?>
	<div class="consultxp-content-wrap container page">
		<div class="row">
			<?php
				$content_col_class = Consultxp_Wp_Elements::consultxp_get_content_class();
			?>
			<div class="<?php echo esc_attr( $content_col_class ); ?>">
				<?php
					// WooCommerce content
					do_action( 'woocommerce_before_main_content' );
					woocommerce_content();
					do_action( 'woocommerce_after_main_content' );
				?>
			</div><!-- .col -->
			
			<?php get_template_part( 'template-parts/content-sidebar' ); ?>
		</div><!-- .row -->
	</div><!-- .container -->
</main><!-- #site-content -->
<?php get_footer(); ?>
