<?php
get_header();
Consultxp_Wp_Elements::$template = is_singular('post') ? 'single' : 'product';
Consultxp_Wp_Elements::$consultxp_page_options = get_post_meta( get_the_ID(), 'consultxp_post_meta', true );
?>
<main id="site-content">
	<?php 
		// Reuse your page title section
		get_template_part( 'template-parts/page', 'title' ); 
	?>
	<div class="consultxp-content-wrap container page">
		<div class="row">
			<div class="<?php echo esc_attr( Consultxp_Wp_Elements::consultxp_get_content_class() ); ?>">
				<?php
					global $product;
					if ( $product instanceof WC_Product ) {
						do_action( 'woocommerce_before_main_content' );
					} else {
						$product = wc_get_product( get_the_ID() );
						if ( $product instanceof WC_Product ) {
							do_action( 'woocommerce_before_main_content' );
						}
					}
					wc_get_template_part( 'content', 'single-product' );
					if ( $product instanceof WC_Product ) {
						do_action( 'woocommerce_after_main_content' );
					} else {
						$product = wc_get_product( get_the_ID() );
						if ( $product instanceof WC_Product ) {
							do_action( 'woocommerce_after_main_content' );
						}
					}
					do_action( 'woocommerce_after_main_content' );
				?>
			</div>
			<?php get_template_part( 'template-parts/content-sidebar' ); ?>
		</div>
	</div>
</main>
<?php get_footer(); ?>
